/*
 * Decompiled with CFR 0.152.
 */
package ventus.actions.importgeom;

import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.geom.AffineTransform;
import java.awt.image.AffineTransformOp;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.BufferedInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.util.UUID;
import javafx.stage.FileChooser;
import javax.imageio.ImageIO;
import javax.vecmath.Point2d;
import org.jscience.physics.units.NonSI;
import org.jscience.physics.units.SI;
import org.jscience.physics.units.Unit;
import thunderheadeng.geometry.AABox;
import thunderheadeng.gui.wizard.AWizardCard;
import thunderheadeng.image.Image;
import thunderheadeng.io.streamsrc.ByteArrayStreamSrc;
import thunderheadeng.units.UnitDouble;
import thunderheadeng.units.UnitPoint3D;
import thunderheadeng.util.FileFilters;
import thunderheadeng.util.IPropertySet;
import thunderheadeng.util.Pair;
import ventus.VentusApp;
import ventus.actions.importgeom.IImporter;
import ventus.data.GeomComposite;
import ventus.data.VentusData;
import ventus.data.image.BGImage;
import ventus.data.image.ImageGroup;
import ventus.geom.Geometry;
import ventus.io.contamx.PrjData;
import ventus.io.contamx.PrjParser;

public class ImportPrj
implements IImporter {
    private static final int[] EMPTY = new int[]{0, 0, 0, 0, 0, 0, 0, 0, 0};

    @Override
    public FileChooser.ExtensionFilter[] getFileFilters() {
        return new FileChooser.ExtensionFilter[]{FileFilters.EXT_FILTER_CONTAM};
    }

    @Override
    public void initDefaultOptions(VentusData md, String ext, IPropertySet options) {
    }

    @Override
    public AWizardCard<IPropertySet> getCard(IPropertySet options) {
        return null;
    }

    @Override
    public IImporter.Result read(VentusApp app, String fn, IPropertySet options) throws IOException {
        GeomComposite importedGeom = new GeomComposite(new File(fn).getName());
        ImageGroup images = new ImageGroup();
        PrjData data = null;
        try (BufferedInputStream strm = new BufferedInputStream(new FileInputStream(fn));){
            data = PrjParser.parse(strm);
        }
        if (data != null) {
            int ny = data.rows;
            int nx = data.cols;
            if (data.nlev > 0) {
                importedGeom.add(images);
            }
            AABox bounds = new AABox();
            for (PrjData.Level level : data.levelList) {
                int[][] sketchPad = new int[nx][ny];
                for (PrjData.Icon icon : level.icons) {
                    sketchPad[icon.colPos][icon.rowPos] = icon.iconType;
                }
                bounds.add(ImportPrj.getUsedSketchPadBounds(sketchPad));
            }
            bounds.add(new AABox(Math.max(0.0, bounds.getMinX() - 4.0), Math.max(0.0, bounds.getMinY() - 4.0), 0.0, Math.min((double)nx, bounds.getMaxX() + 4.0), Math.min((double)ny, bounds.getMaxY() + 4.0), 0.0));
            if (!bounds.isInfinite()) {
                return new IImporter.Result(importedGeom, new Pair[0]);
            }
            Unit uRef = null;
            Unit uDelta = null;
            for (PrjData.Level level : data.levelList) {
                if (uRef == null) {
                    uRef = ImportPrj.i2u(level.u_rfht);
                }
                if (uDelta == null) {
                    uDelta = ImportPrj.i2u(level.u_dlht);
                }
                BufferedImage memImg = new BufferedImage(nx * 3, ny * 3, 2);
                Color fill = new Color(74, 109, 229);
                Color line = new Color(206, 216, 247);
                Graphics2D g = memImg.createGraphics();
                g.setColor(fill);
                g.fillRect(0, 0, memImg.getWidth(), memImg.getHeight());
                int[][] sketchPad = new int[nx][ny];
                for (PrjData.Icon icon : level.icons) {
                    sketchPad[icon.colPos][icon.rowPos] = icon.iconType;
                }
                g.setColor(line);
                for (int x = 0; x < nx * 3; x += 3) {
                    for (int y = 0; y < ny * 3; y += 3) {
                        ImportPrj.renderSketchPadIcon(sketchPad, g, x, y, 3);
                    }
                }
                g.dispose();
                memImg = memImg.getSubimage((int)bounds.getMinX() * 3, (int)bounds.getMinY() * 3, (int)bounds.getWidth() * 3, (int)bounds.getDepth() * 3);
                AffineTransformOp scaleOp = new AffineTransformOp(AffineTransform.getScaleInstance(3.0, 3.0), 1);
                memImg = scaleOp.filter(memImg, null);
                ByteArrayOutputStream baos = new ByteArrayOutputStream();
                ImageIO.write((RenderedImage)memImg, "png", baos);
                byte[] bytes = baos.toByteArray();
                Image baseImage = Image.load(UUID.randomUUID().toString(), new ByteArrayStreamSrc(bytes));
                BGImage bgImage = new BGImage(level.levelName, baseImage);
                bgImage.setTransformInfo(new Point2d(0.0, 0.0), new UnitPoint3D(new double[]{0.0, 0.0, level.refHt}, uRef), new Point2d(0.0, 0.0), new Point2d(memImg.getWidth(), 0.0), new UnitDouble(data.scale * bounds.getWidth(), uDelta), new UnitDouble(0.0, Geometry.ANGLE_UNIT));
                bgImage.setOpacity(0.7f);
                images.add(bgImage);
            }
        }
        return new IImporter.Result(importedGeom, new Pair[0]);
    }

    private static void textBox(Graphics2D g, int x, int y, int padding, String str) {
        String[] lines = str.split("\n");
        int lineHt = g.getFontMetrics().getHeight();
        Color notesbg = new Color(48, 87, 225);
        Color notesfg = new Color(206, 216, 247);
        g.setColor(notesbg);
        g.fillRect(x - padding, y - padding, 100, lineHt * lines.length + 2 * padding);
        g.setColor(notesfg);
        int yy = y + lineHt;
        for (String line : lines) {
            g.drawString(line, x, yy);
            yy += lineHt;
        }
    }

    private static Unit i2u(int iu) {
        Unit sketchPadLenUnit;
        if (iu == 0) {
            sketchPadLenUnit = SI.METER;
        } else if (iu == 1) {
            sketchPadLenUnit = NonSI.FOOT;
        } else if (iu == 2) {
            sketchPadLenUnit = SI.CENTI(SI.METER);
        } else if (iu == 3) {
            sketchPadLenUnit = NonSI.INCH;
        } else if (iu == 4) {
            sketchPadLenUnit = SI.MILLI(SI.METER);
        } else if (iu == 5) {
            sketchPadLenUnit = SI.DECI(SI.METER);
        } else if (iu == 6) {
            sketchPadLenUnit = SI.MICRO(SI.METER);
        } else {
            assert (false) : "unknown sketchpad unit:" + iu;
            sketchPadLenUnit = SI.METER;
        }
        return sketchPadLenUnit;
    }

    private static AABox getUsedSketchPadBounds(int[][] sketchPad) {
        AABox bounds = new AABox();
        for (int x = 0; x < sketchPad.length; ++x) {
            for (int y = 0; y < sketchPad[x].length; ++y) {
                int[] pattern = ImportPrj.iconTo1d3x3Array(sketchPad[x][y]);
                if (pattern == EMPTY) continue;
                bounds.addPoint(x, y, 0.0);
            }
        }
        return bounds;
    }

    private static void renderSketchPadIcon(int[][] sketchPad, Graphics2D g, int x, int y, int ppp) {
        int[] padj;
        int iadj;
        int i;
        int icon = sketchPad[x / ppp][y / ppp];
        int[] pattern = ImportPrj.iconTo1d3x3Array(icon);
        ImportPrj.render3x3(x, y, pattern, g);
        if (pattern[5] != 0) {
            i = 1;
            iadj = sketchPad[x / ppp + i][y / ppp];
            padj = ImportPrj.iconTo1d3x3Array(iadj);
            int[] horiz = new int[]{0, 0, 0, 1, 1, 1, 0, 0, 0};
            while (padj == EMPTY) {
                ImportPrj.render3x3(x + i * ppp, y, horiz, g);
                iadj = sketchPad[x / ppp + ++i][y / ppp];
                padj = ImportPrj.iconTo1d3x3Array(iadj);
            }
        }
        if (pattern[7] != 0) {
            i = 1;
            iadj = sketchPad[x / ppp][y / ppp + i];
            padj = ImportPrj.iconTo1d3x3Array(iadj);
            int[] vert = new int[]{0, 1, 0, 0, 1, 0, 0, 1, 0};
            while (padj == EMPTY) {
                ImportPrj.render3x3(x, y + i * ppp, vert, g);
                iadj = sketchPad[x / ppp][y / ppp + ++i];
                padj = ImportPrj.iconTo1d3x3Array(iadj);
            }
        }
    }

    private static int[] iconTo1d3x3Array(int icon) {
        switch (icon) {
            case 14: {
                return new int[]{0, 0, 0, 0, 1, 1, 0, 1, 0};
            }
            case 15: {
                return new int[]{0, 0, 0, 1, 1, 0, 0, 1, 0};
            }
            case 16: {
                return new int[]{0, 1, 0, 1, 1, 0, 0, 0, 0};
            }
            case 17: {
                return new int[]{0, 1, 0, 0, 1, 1, 0, 0, 0};
            }
            case 18: {
                return new int[]{0, 1, 0, 0, 1, 1, 0, 1, 0};
            }
            case 19: {
                return new int[]{0, 0, 0, 1, 1, 1, 0, 1, 0};
            }
            case 20: {
                return new int[]{0, 1, 0, 1, 1, 0, 0, 1, 0};
            }
            case 21: {
                return new int[]{0, 1, 0, 1, 1, 1, 0, 0, 0};
            }
        }
        return EMPTY;
    }

    private static void render3x3(int x0, int y0, int[] ltr, Graphics2D g) {
        for (int i = 0; i < 9; ++i) {
            if (ltr[i] == 0) continue;
            g.fillRect(x0 + i % 3, y0 + i / 3, 1, 1);
        }
    }

    @Override
    public void cleanup(IPropertySet options) {
    }
}

