/*
 * Decompiled with CFR 0.152.
 */
package ventus.actions.geomops;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Set;
import javax.swing.JOptionPane;
import thunderheadeng.util.Events;
import thunderheadeng.util.IEventObserver;
import ventus.Intl;
import ventus.VentusApp;
import ventus.actions.AMerlinOp;
import ventus.actions.SelectionObserver;
import ventus.actions.UIHook;
import ventus.actions.Undo;
import ventus.data.Composite;
import ventus.data.IRestorable;
import ventus.data.VentusData;
import ventus.data.schematics.geom.SchematicRoom;

public class SubtractGeom
extends AMerlinOp
implements IEventObserver {
    public static final UIHook UI_HOOK = new UIHook(new SubtractGeom(), Intl.intl("&Subtract,T,Subtract the Selected Rooms...,Subtract the last selected rooms from the first in the selection."));

    public SubtractGeom() {
        SelectionObserver.add(this, SchematicRoom.class);
        this.update(null);
    }

    @Override
    public void update(Events events) {
        VentusData md = VentusApp.getApp().getData();
        Set rooms = md.selection.getDeepSelected(SchematicRoom.class);
        this.setEnabled(rooms.size() >= 2);
    }

    @Override
    public void run(VentusApp app, VentusData md) {
        Set<SchematicRoom> subtractFrom = md.selection.getDeepSelected(SchematicRoom.class);
        if (subtractFrom.size() < 2) {
            return;
        }
        int selOption = JOptionPane.showConfirmDialog(app.getMainFrame(), Intl.intl("Would you like to delete the subtracted rooms?"), Intl.intl("Delete subtracted rooms?"), 1);
        if (selOption != 0 && selOption != 1) {
            return;
        }
        boolean deleteSubtracted = selOption == 0;
        SchematicRoom first = (SchematicRoom)subtractFrom.iterator().next();
        subtractFrom.remove(first);
        this.subtract(md, Arrays.asList(first), subtractFrom, deleteSubtracted);
    }

    private void subtract(VentusData md, Collection<SchematicRoom> subtractFrom, Set<SchematicRoom> toSubtract, boolean deleteSubtracted) {
        toSubtract.removeAll(subtractFrom);
        if (toSubtract.isEmpty()) {
            return;
        }
        try (VentusData.WriteLock lock = md.lockWrite();){
            Undo.begin(Intl.intl("Subtract"));
            ArrayList<SchematicRoom> toClean = new ArrayList<SchematicRoom>();
            for (SchematicRoom subtract : subtractFrom) {
                if (!subtract.getModificationsAllowed()) continue;
                Object momento = subtract.getRestoreObj();
                Undo.insertUndoEntry_restore(md, (IRestorable)subtract, momento);
                boolean modified = false;
                for (SchematicRoom toSub : toSubtract) {
                    modified |= subtract.sub(toSub);
                }
                if (!modified) continue;
                toClean.add(subtract);
            }
            if (deleteSubtracted) {
                Undo.insertUndoEntry_add(md, toSubtract);
                for (SchematicRoom toSub : toSubtract) {
                    Composite parent = (Composite)md.hierarchy.getParent(toSub);
                    parent.remove(toSub);
                }
            }
            SchematicRoom.cleanup(md, toClean);
            Undo.end(md);
        }
    }
}

