/*
 * Decompiled with CFR 0.152.
 */
package ventus.actions.geomops;

import java.util.Collection;
import java.util.Iterator;
import java.util.Set;
import java.util.function.Consumer;
import thunderheadeng.util.LinkedIdentityHashSet;
import ventus.Intl;
import ventus.actions.ConvertToRoom;
import ventus.actions.UIHook;
import ventus.actions.geomops.ANewGeomBoolOp;
import ventus.data.schematics.geom.ISchematicComp;
import ventus.data.schematics.geom.ISchematicRoom;
import ventus.data.schematics.geom.SchematicRoom;
import ventus.geom.Geometry;

public class MergeGeom
extends ANewGeomBoolOp {
    public static final UIHook UI_HOOK = new UIHook(new MergeGeom(), Intl.intl("&Merge Rooms,M,Merge Selected Rooms,Merge the selected, touching rooms together."));

    @Override
    protected String getOpName() {
        return Intl.intl("Merge");
    }

    @Override
    protected boolean performOp(Set<? extends ISchematicRoom> selGeom, Collection<ISchematicComp> resultToAdd, Collection<ISchematicRoom> resultToRemove, Consumer<SchematicRoom> toClean) {
        LinkedIdentityHashSet open = new LinkedIdentityHashSet();
        for (ISchematicRoom iSchematicRoom : selGeom) {
            ConvertToRoom.ConvertedRoom cr = ConvertToRoom.convertToRoom(iSchematicRoom, true, selGeom);
            if (cr == null) continue;
            open.add(cr);
        }
        if (open.size() <= 1) {
            return false;
        }
        boolean overallModified = false;
        while (!open.isEmpty()) {
            ConvertToRoom.ConvertedRoom convertedRoom = (ConvertToRoom.ConvertedRoom)open.iterator().next();
            open.remove(convertedRoom);
            LinkedIdentityHashSet<ConvertToRoom.ConvertedRoom> merged = new LinkedIdentityHashSet<ConvertToRoom.ConvertedRoom>();
            merged.add(convertedRoom);
            boolean modified = true;
            while (modified) {
                modified = false;
                Iterator mergeIt = open.iterator();
                while (mergeIt.hasNext()) {
                    ConvertToRoom.ConvertedRoom nextMergeRoom = (ConvertToRoom.ConvertedRoom)mergeIt.next();
                    if (!convertedRoom.room.getModificationsAllowed() || !convertedRoom.room.add(nextMergeRoom.room)) continue;
                    modified = true;
                    mergeIt.remove();
                    merged.add(nextMergeRoom);
                }
            }
            if (merged.size() <= 1) continue;
            overallModified = true;
            MergeGeom.applyProps(convertedRoom.room, merged);
            resultToAdd.add(convertedRoom.room);
            toClean.accept(convertedRoom.room);
            for (ConvertToRoom.ConvertedRoom mergedRoom : merged) {
                resultToRemove.add(mergedRoom.source);
                resultToAdd.addAll(mergedRoom.doors);
            }
        }
        return overallModified;
    }

    private static void applyProps(ISchematicRoom room, Collection<ConvertToRoom.ConvertedRoom> merged) {
        ISchematicRoom baseGeom = MergeGeom.getBaseGeom(merged);
        room.setName(baseGeom.getName());
        room.setColor(baseGeom.getColor());
        room.setOpacity(baseGeom.getOpacity());
        room.setVisible(baseGeom.isVisible());
    }

    private static ISchematicRoom getBaseGeom(Collection<ConvertToRoom.ConvertedRoom> mergedGeoms) {
        ISchematicRoom largest = null;
        double maxArea = -1.7976931348623157E308;
        for (ConvertToRoom.ConvertedRoom cr : mergedGeoms) {
            double area;
            if (!(cr.source instanceof SchematicRoom) || !((area = ((SchematicRoom)cr.source).getArea().getValue(Geometry.AREA_UNIT)) > maxArea)) continue;
            maxArea = area;
            largest = cr.source;
        }
        if (largest != null) {
            return largest;
        }
        return mergedGeoms.iterator().next().source;
    }
}

