/*
 * Decompiled with CFR 0.152.
 */
package ventus.actions.geomops;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Set;
import java.util.function.Consumer;
import javax.swing.JOptionPane;
import thunderheadeng.util.Events;
import thunderheadeng.util.IEventObserver;
import thunderheadeng.util.LinkedIdentityHashSet;
import ventus.Intl;
import ventus.VentusApp;
import ventus.actions.AMerlinOp;
import ventus.actions.Delete;
import ventus.actions.SelectionObserver;
import ventus.actions.Undo;
import ventus.builders.NewCompUtil;
import ventus.data.Composite;
import ventus.data.VentusData;
import ventus.data.schematics.geom.ISchematicComp;
import ventus.data.schematics.geom.ISchematicRoom;
import ventus.data.schematics.geom.SchematicCorridor;
import ventus.data.schematics.geom.SchematicRoom;

public abstract class ANewGeomBoolOp
extends AMerlinOp
implements IEventObserver {
    public ANewGeomBoolOp() {
        SelectionObserver.add(this, ISchematicRoom.class);
        this.update(null);
    }

    @Override
    public void update(Events events) {
        VentusData md = VentusApp.getApp().getData();
        Set selGeom = md.selection.getDeepSelected(ISchematicRoom.class);
        this.setEnabled(selGeom.size() >= 2);
    }

    @Override
    public void run(VentusApp app, VentusData md) {
        Set selGeom = md.selection.getDeepSelected(ISchematicRoom.class);
        if (selGeom.size() < 2) {
            return;
        }
        if (!md.selection.isDeepEmpty(SchematicCorridor.class)) {
            String msg = Intl.intl("Merged stairs and ramps will be converted to rooms.\nWould you like to continue?");
            int option = JOptionPane.showConfirmDialog(app.getActiveFrame(), msg, Intl.intl("Convert Stairs and Ramps?"), 0, 3);
            if (option != 0) {
                return;
            }
        }
        LinkedIdentityHashSet<ISchematicComp> toAdd = new LinkedIdentityHashSet<ISchematicComp>();
        LinkedIdentityHashSet<ISchematicRoom> toRemove = new LinkedIdentityHashSet<ISchematicRoom>();
        ArrayList toClean = new ArrayList();
        boolean modified = this.performOp(selGeom, toAdd, toRemove, toClean::add);
        if (!modified) {
            return;
        }
        try (VentusData.WriteLock lock = md.lockWrite();){
            Undo.begin(this.getOpName());
            Undo.insertUndoEntry_add(md, toRemove);
            for (ISchematicRoom geom : toRemove) {
                Composite parent = (Composite)md.hierarchy.getParent(geom);
                parent.remove(geom);
            }
            Delete.deleteAll(md, toRemove);
            NewCompUtil.addSchematicComps(md, true, toAdd);
            SchematicRoom.cleanup(md, toClean);
            Undo.end(md);
        }
    }

    protected abstract String getOpName();

    protected abstract boolean performOp(Set<? extends ISchematicRoom> var1, Collection<ISchematicComp> var2, Collection<ISchematicRoom> var3, Consumer<SchematicRoom> var4);
}

