/*
 * Decompiled with CFR 0.152.
 */
package ventus.actions.copypaste;

import java.awt.datatransfer.DataFlavor;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.Serializable;
import java.util.Collection;
import java.util.Collections;
import java.util.Map;
import thunderheadeng.gui.IDomainObject;
import ventus.io.IInputStreamFeatureHandler;
import ventus.io.MerlinOOS;
import ventus.io.VentusOIS;

public class VentusCopyDataContainer
implements Serializable {
    private static final long serialVersionUID = 1L;
    public static final DataFlavor DATAFLAVOR_BINARY = new DataFlavor(VentusCopyDataContainer.class, "Copied Ventus Data");
    public static final DataFlavor DATAFLAVOR_STRING = DataFlavor.stringFlavor;
    private final int d_version;
    private final byte[] d_data;

    public VentusCopyDataContainer(int version, Map<IDomainObject, String> pasteObjMap) {
        this.d_version = version;
        this.d_data = this.serialize((Serializable)((Object)pasteObjMap));
    }

    public int getVersion() {
        return this.d_version;
    }

    public Map<IDomainObject, String> getObjs(Collection<IInputStreamFeatureHandler> featureUpdaters) {
        return (Map)((Object)VentusCopyDataContainer.deserialize(this.d_data, featureUpdaters));
    }

    /*
     * Enabled aggressive exception aggregation
     */
    private byte[] serialize(Serializable ser) {
        try (ByteArrayOutputStream baos = new ByteArrayOutputStream();){
            byte[] byArray;
            try (MerlinOOS serializer = new MerlinOOS(baos);){
                byte[] data;
                serializer.writeObject(ser);
                byArray = data = baos.toByteArray();
            }
            return byArray;
        }
        catch (IOException e) {
            e.printStackTrace();
            return new byte[0];
        }
    }

    /*
     * Enabled aggressive exception aggregation
     */
    private static Serializable deserialize(byte[] bytes, Collection<IInputStreamFeatureHandler> featureUpdaters) {
        try (ByteArrayInputStream bais = new ByteArrayInputStream(bytes);){
            Serializable serializable;
            try (VentusOIS reader = new VentusOIS(bais, true, featureUpdaters);){
                Object obj = reader.readObject();
                serializable = (Serializable)obj;
            }
            return serializable;
        }
        catch (IOException | ClassNotFoundException e) {
            e.printStackTrace();
            return (Serializable)((Object)Collections.EMPTY_MAP);
        }
    }

    public String toString() {
        return String.format("VentusCopyDataContainer[d_version=%d,d_data=%s]", this.d_version, this.d_data);
    }
}

