/*
 * Decompiled with CFR 0.152.
 */
package ventus.actions.copypaste;

import java.awt.Toolkit;
import java.awt.Window;
import java.awt.datatransfer.Clipboard;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.Callable;
import javax.swing.Icon;
import javax.swing.JOptionPane;
import javax.vecmath.Point3d;
import org.jscience.physics.units.SI;
import thunderheadeng.dependencies.DLink;
import thunderheadeng.dependencies.DepSnapshot;
import thunderheadeng.dependencies.Dependency;
import thunderheadeng.geometry.objs.transform.ITransform;
import thunderheadeng.geometry.objs.transform.TransformInfo;
import thunderheadeng.geometry.objs.transform.TransformUtil;
import thunderheadeng.gui.IDomainObject;
import thunderheadeng.gui.WarningDlg;
import thunderheadeng.gui.guiDialog;
import thunderheadeng.units.UnitPoint3D;
import thunderheadeng.util.IFilteredCollection;
import thunderheadeng.util.LinkedIdentityHashSet;
import thunderheadeng.util.Pair;
import thunderheadeng.util.Warning;
import thunderheadeng.util.WarningReport;
import thunderheadeng.util.theUtil;
import ventus.EntryPoint;
import ventus.EntryPointFactory;
import ventus.Intl;
import ventus.VentusApp;
import ventus.actions.AMerlinOp;
import ventus.actions.MerlinOp;
import ventus.actions.UIHook;
import ventus.actions.Undo;
import ventus.actions.copypaste.CopyPasteUtil;
import ventus.actions.copypaste.DefaultPasteHandler;
import ventus.actions.copypaste.FloorPasteHandler;
import ventus.actions.copypaste.GeomPasteHandler;
import ventus.actions.copypaste.PasteHandler;
import ventus.actions.copypaste.PasteHints;
import ventus.actions.copypaste.VentusCopyDataContainer;
import ventus.data.Composite;
import ventus.data.IMerlinObj;
import ventus.data.VentusData;
import ventus.data.camera.CameraList;
import ventus.data.material.MaterialDB;
import ventus.data.schematics.FloorComposite;
import ventus.io.IInputStreamFeatureHandler;
import ventus.io.VentusIO;
import ventus.mv.gui.LocationPanel;
import ventus.util.VentusDepSnapshot;

public class Paste
extends AMerlinOp {
    public static final Icon ICON = UIHook.loadIcon("thunderheadeng/gui/graphics/Paste16.gif");
    public static final UIHook UI_HOOK = new UIHook((MerlinOp)new Paste(), Intl.intl("&Paste...,V,Paste selected objects"), ICON);

    public boolean canPaste(Collection<PasteHandler> handlers, Map<IDomainObject, String> payload) {
        return !payload.isEmpty() && !payload.entrySet().stream().allMatch(entry -> Paste.isUnsupported(handlers, (IDomainObject)entry.getKey(), (String)entry.getValue()));
    }

    public static boolean isUnsupported(Collection<PasteHandler> handlers, IDomainObject obj, String mdRootClassName) {
        for (PasteHandler handler : handlers) {
            if (!handler.isHandlerFor(obj, mdRootClassName)) continue;
            return false;
        }
        return true;
    }

    private Map<IDomainObject, String> getClipboardPayload(VentusApp app, VentusData md) {
        block5: {
            Toolkit defaultToolkit = Toolkit.getDefaultToolkit();
            Clipboard systemClipboard = defaultToolkit.getSystemClipboard();
            try {
                if (!systemClipboard.isDataFlavorAvailable(VentusCopyDataContainer.DATAFLAVOR_BINARY)) break block5;
                try {
                    VentusCopyDataContainer pasteData = (VentusCopyDataContainer)systemClipboard.getData(VentusCopyDataContainer.DATAFLAVOR_BINARY);
                    if (pasteData.getVersion() == VentusIO.Version.curr().num) {
                        return pasteData.getObjs(app.getComponents(IInputStreamFeatureHandler.class));
                    }
                }
                catch (UnsupportedFlavorException | IOException e) {
                    e.printStackTrace();
                }
            }
            catch (IllegalStateException e) {
                if ("cannot open system clipboard".equals(e.getMessage())) break block5;
                e.printStackTrace();
            }
        }
        return Collections.emptyMap();
    }

    public static Collection<PasteHandler> getPasteHandlers(VentusApp app) {
        ArrayList<PasteHandler> handlers = new ArrayList<PasteHandler>();
        handlers.add(new GeomPasteHandler());
        handlers.add(new FloorPasteHandler());
        handlers.add(new DefaultPasteHandler(CameraList.class));
        handlers.add(new DefaultPasteHandler(MaterialDB.class));
        handlers.addAll(app.getComponents(PasteHandler.class));
        return handlers;
    }

    public Collection<Warning> performPaste(VentusData md, VentusApp app, Map<IDomainObject, String> payload) {
        Collection<PasteHandler> handlers = Paste.getPasteHandlers(app);
        ArrayList<Warning> warnings = new ArrayList<Warning>();
        VentusDepSnapshot pasteDeps = new VentusDepSnapshot();
        payload.keySet().forEach(obj -> pasteDeps.takeSnapshot(obj));
        Paste.processUnsupportedDependencies(md, handlers, pasteDeps, warnings);
        Paste.processFloorPasteDependencies(md, app.getMainFrame(), payload, pasteDeps);
        Paste.resolvePasteDependencies(md, handlers, payload, pasteDeps, warnings);
        Map<IDomainObject, Pair<PasteHandler, PasteHints>> handlerMap = Paste.preparePasteHandlers(md, app.getMainFrame(), handlers, payload, warnings);
        try (VentusData.WriteLock lock = md.lockWrite();){
            Undo.begin(Intl.intl("Paste"));
            Paste.processPasteObjs(md, app, handlerMap, payload, warnings);
            Undo.end(md);
        }
        return warnings;
    }

    @Override
    public void run(VentusApp app, VentusData md) {
        Map<IDomainObject, String> payload = this.getClipboardPayload(app, md);
        if (!this.canPaste(Paste.getPasteHandlers(app), payload)) {
            Toolkit.getDefaultToolkit().beep();
            return;
        }
        Collection<Warning> warnings = this.performPaste(md, app, payload);
        Paste.showWarnings(app, warnings);
    }

    public static void showWarnings(VentusApp app, Collection<Warning> warnings) {
        if (warnings.isEmpty()) {
            return;
        }
        WarningReport<Warning> rpt = new WarningReport<Warning>(Warning.class, Warning.getWarningInfoTypes(), Warning.getWarningInfoDescriptions(), 0);
        warnings.forEach(rpt::addWarning);
        WarningDlg warnDlg = WarningDlg.create(app.getMainFrame(), Intl.intl("Warnings"), "", rpt);
        warnDlg.doModal();
    }

    public static Map<IDomainObject, Pair<PasteHandler, PasteHints>> preparePasteHandlers(VentusData md, Window dlgParent, Collection<PasteHandler> handlers, Map<IDomainObject, String> pasteObjMap, Collection<Warning> warnings) {
        boolean shouldPromptForTransform = false;
        HashMap<IDomainObject, Pair<PasteHandler, PasteHints>> handlerMap = new HashMap<IDomainObject, Pair<PasteHandler, PasteHints>>();
        for (Map.Entry<IDomainObject, String> mapEntry : pasteObjMap.entrySet()) {
            String mdRootClassName;
            IDomainObject obj = mapEntry.getKey();
            if (Paste.isUnsupported(handlers, obj, mdRootClassName = mapEntry.getValue())) {
                warnings.add(CopyPasteUtil.getPasteSupportWarning(obj, false));
                continue;
            }
            Optional<Object> result = Optional.empty();
            for (PasteHandler ph : handlers) {
                if (!ph.isHandlerFor(obj, mdRootClassName)) continue;
                result = Optional.of(ph);
                break;
            }
            if (result.isPresent()) {
                PasteHandler ph = (PasteHandler)result.get();
                PasteHints hints = ph.getPasteHints(md, pasteObjMap, obj);
                shouldPromptForTransform |= hints.geomTransformShouldPrompt;
                handlerMap.put(obj, new Pair<PasteHandler, PasteHints>(ph, hints));
                continue;
            }
            warnings.add(CopyPasteUtil.getPasteSupportWarning(obj, false));
        }
        if (shouldPromptForTransform) {
            TransformInfo moveInfo = Paste.promptForTransformParameter(dlgParent, md);
            handlerMap.values().forEach(pair -> {
                ((PasteHints)pair.v2).geomTransform = moveInfo;
            });
        }
        return handlerMap;
    }

    public static void processPasteObjs(VentusData md, VentusApp app, Map<IDomainObject, Pair<PasteHandler, PasteHints>> handlerMap, Map<IDomainObject, String> pasteObjMap, Collection<Warning> warnings) {
        LinkedIdentityHashSet pastedObjs = new LinkedIdentityHashSet();
        Set selectedCompositesIntenseGenerics = md.selection.getSelected(Composite.class);
        Collection selectedComposites = selectedCompositesIntenseGenerics;
        Set<IMerlinObj> selectedLeaves = md.selection.getSelected(IMerlinObj.class);
        for (Map.Entry<IDomainObject, String> pasteObjMapEntry : pasteObjMap.entrySet()) {
            Pair<PasteHandler, PasteHints> handlerPair = handlerMap.get(pasteObjMapEntry.getKey());
            if (handlerPair == null) continue;
            PasteHandler handler = (PasteHandler)handlerPair.v1;
            PasteHints hints = (PasteHints)handlerPair.v2;
            handler.pasteApply(md, app, pasteObjMap, pasteObjMapEntry, hints, selectedComposites, selectedLeaves, pastedObjs::add, warnings::add);
        }
        Undo.insertUndoEntry_restoreSelection(md);
        md.selection.set(pastedObjs);
    }

    private static boolean promptForPasteFloorDeps(VentusData md, Window dlgParent) {
        Callable<Boolean> uiFunc = () -> {
            int option = JOptionPane.showConfirmDialog(dlgParent, Intl.intl("Geometry is referenced by pasted objects. Include the geometry in the paste?\n \"No\" will remove references of the geometry from paste objects."), Intl.intl("Paste Geometry"), 0);
            return option == 0;
        };
        return md.ui(uiFunc);
    }

    private static void processFloorPasteDependencies(VentusData md, Window dlgParent, Map<IDomainObject, String> pasteMap, DepSnapshot pasteDeps) {
        ArrayList<DepPasteEntry> floorDeps = new ArrayList<DepPasteEntry>();
        IFilteredCollection<IDomainObject> floorDependencies = theUtil.filter(pasteDeps.getAllDirectDependedOn(), d -> CopyPasteUtil.getRootString(md, d).equals(FloorComposite.class.getName()));
        for (IDomainObject floorDep : floorDependencies) {
            EntryPoint<IDomainObject> ep = EntryPointFactory.get(floorDep);
            IDomainObject existing = ep.getConflict(md, floorDep);
            String mdRootClassName = FloorComposite.class.getName();
            if (existing != null) continue;
            for (Dependency dep : pasteDeps.getDependents(floorDep)) {
                floorDeps.add(new DepPasteEntry(dep, floorDep, mdRootClassName));
            }
        }
        boolean pasteFloorDeps = floorDeps.size() > 0 && Paste.promptForPasteFloorDeps(md, dlgParent);
        for (DepPasteEntry entry : floorDeps) {
            if (!pasteFloorDeps && entry.dep.link == DLink.WEAK) {
                entry.dep.source.replaceDependency(md, entry.dependency, null);
                continue;
            }
            pasteMap.put(entry.dependency, entry.mdRootClassName);
        }
    }

    private static void processUnsupportedDependencies(VentusData md, Collection<PasteHandler> handlers, DepSnapshot pasteDeps, List<Warning> warnings) {
        IFilteredCollection<IDomainObject> unsupportedDeps = theUtil.filter(pasteDeps.getAllDirectDependedOn(), d -> Paste.isUnsupported(handlers, d, CopyPasteUtil.getRootString(md, d)));
        for (IDomainObject unsupportedDep : unsupportedDeps) {
            for (Dependency dep : pasteDeps.getDependents(unsupportedDep)) {
                warnings.add(CopyPasteUtil.getPasteDependencySupportWarning(dep.source, unsupportedDep));
                dep.source.replaceDependency(md, unsupportedDep, null);
            }
        }
    }

    private static void resolvePasteDependencies(VentusData md, Collection<PasteHandler> handlers, Map<IDomainObject, String> pasteMap, DepSnapshot pasteDeps, List<Warning> warnings) {
        for (IDomainObject dependedOn : pasteDeps.getAllDirectDependedOn()) {
            EntryPoint<IDomainObject> ep = EntryPointFactory.get(dependedOn);
            IDomainObject existing = ep.getConflict(md, dependedOn);
            if (existing == null) {
                String mdRootClassName = CopyPasteUtil.getRootString(md, dependedOn);
                if (mdRootClassName.equals(FloorComposite.class.getName())) continue;
                if (!Paste.isUnsupported(handlers, dependedOn, mdRootClassName)) {
                    pasteMap.put(dependedOn, mdRootClassName);
                    continue;
                }
            }
            for (Dependency dep : pasteDeps.getDependents(dependedOn)) {
                if (existing == null && dep.link != DLink.WEAK) continue;
                dep.source.replaceDependency(md, dependedOn, existing);
            }
        }
    }

    private static TransformInfo promptForTransformParameter(Window dlgParent, VentusData md) {
        Callable<TransformInfo> uiFunc = () -> {
            int option = JOptionPane.showConfirmDialog(dlgParent, Intl.intl("Geometry intersection detected.\nOffset pasted geometry?"), Intl.intl("Paste Offset"), 0);
            if (option != 0) {
                return TransformUtil.IDENTITY_INFO;
            }
            guiDialog dlg = new guiDialog(dlgParent, Intl.intl("Offset"), 1);
            LocationPanel panel = new LocationPanel();
            dlg.getDialogPane().add(panel, "Center");
            if (dlg.doModal() == 1) {
                UnitPoint3D xformUpt3d = panel.getValue();
                Point3d xformMeters = xformUpt3d.getValue(SI.METER);
                ITransform xform = TransformUtil.translate(xformMeters.x, xformMeters.y, xformMeters.z);
                return xform.getInfo();
            }
            return TransformUtil.IDENTITY_INFO;
        };
        return md.ui(uiFunc);
    }

    private static class DepPasteEntry {
        Dependency dep;
        IDomainObject dependency;
        String mdRootClassName;

        DepPasteEntry(Dependency dependency, IDomainObject dependent, String mdRootClassName) {
            this.dep = dependency;
            this.dependency = dependent;
            this.mdRootClassName = mdRootClassName;
        }
    }
}

