/*
 * Decompiled with CFR 0.152.
 */
package ventus.actions.copypaste;

import java.util.Collection;
import java.util.Map;
import java.util.function.Consumer;
import thunderheadeng.gui.IDomainObject;
import thunderheadeng.util.Warning;
import ventus.VentusApp;
import ventus.actions.copypaste.CopyPasteUtil;
import ventus.actions.copypaste.PasteHandler;
import ventus.actions.copypaste.PasteHints;
import ventus.data.Composite;
import ventus.data.GeomComposite;
import ventus.data.ICompElement;
import ventus.data.IMerlinObj;
import ventus.data.VentusData;

public class GeomPasteHandler
implements PasteHandler {
    @Override
    public boolean isHandlerFor(IDomainObject obj, String mdRootClassName) {
        return GeomComposite.class.getName().equals(mdRootClassName);
    }

    public boolean shouldRename(String mdRootClassName) {
        return false;
    }

    @Override
    public PasteHints getPasteHints(VentusData md, Map<IDomainObject, String> pasteObjMap, IDomainObject pasteObj) {
        return CopyPasteUtil.getGeomPasteHints(md, pasteObjMap, pasteObj);
    }

    @Override
    public void pasteApply(VentusData md, VentusApp app, Map<IDomainObject, String> pasteObjMap, Map.Entry<IDomainObject, String> pasteEntry, PasteHints hints, Collection<Composite<ICompElement>> selectedComposites, Collection<IMerlinObj> selectedLeaves, Consumer<? super IDomainObject> allPastedObjs, Consumer<? super Warning> warnings) {
        IDomainObject pasteObj = pasteEntry.getKey();
        Composite<ICompElement> defaultRoot = CopyPasteUtil.getDefaultRoot(md, pasteEntry);
        Composite insertRoot = CopyPasteUtil.getBestPasteTarget(md, pasteObj, defaultRoot, selectedComposites, selectedLeaves);
        if (!CopyPasteUtil.validInsertRoot(this.getClass(), pasteObj, insertRoot, warnings)) {
            return;
        }
        boolean shouldRename = this.shouldRename(insertRoot.getClass().getName());
        CopyPasteUtil.pasteIntoAndTransform(md, app, pasteObj, hints, allPastedObjs, insertRoot, shouldRename);
    }
}

