/*
 * Decompiled with CFR 0.152.
 */
package ventus.actions.copypaste;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import org.jscience.physics.units.SI;
import thunderheadeng.geometry.objs.transform.TransformInfo;
import thunderheadeng.gui.IDomainObject;
import thunderheadeng.units.UnitDouble;
import thunderheadeng.util.Warning;
import ventus.Intl;
import ventus.VentusApp;
import ventus.actions.FloorSortActions;
import ventus.actions.SubtractAction;
import ventus.actions.TransformAction;
import ventus.actions.Undo;
import ventus.actions.copypaste.CopyPasteUtil;
import ventus.actions.copypaste.PasteHandler;
import ventus.actions.copypaste.PasteHints;
import ventus.data.Composite;
import ventus.data.GeomComposite;
import ventus.data.ICompElement;
import ventus.data.IMerlinObj;
import ventus.data.VentusData;
import ventus.data.schematics.Floor;
import ventus.data.schematics.FloorComposite;
import ventus.data.schematics.geom.SchematicRoom;
import ventus.geom.IMerlinGeomSrc;

public class FloorPasteHandler
implements PasteHandler {
    @Override
    public boolean isHandlerFor(IDomainObject obj, String mdRootClassName) {
        return FloorComposite.class.getName().equals(mdRootClassName);
    }

    @Override
    public PasteHints getPasteHints(VentusData md, Map<IDomainObject, String> pasteObjMap, IDomainObject pasteObj) {
        return CopyPasteUtil.getGeomPasteHints(md, pasteObjMap, pasteObj);
    }

    private boolean isFloor(IDomainObject<VentusData> pasteObj) {
        return pasteObj.getClass().equals(Floor.class);
    }

    private boolean isGeomComposite(IDomainObject<VentusData> pasteObj) {
        return pasteObj.getClass().equals(GeomComposite.class);
    }

    private HashMap<Floor, List<IMerlinGeomSrc>> transformPasteObjs(VentusApp app, VentusData md, Collection<IMerlinObj> geomObjs, TransformInfo xform) {
        ArrayList<SchematicRoom> subtractors = new ArrayList<SchematicRoom>();
        HashMap<Floor, List<IMerlinGeomSrc>> floorMap = new HashMap<Floor, List<IMerlinGeomSrc>>();
        for (IMerlinGeomSrc obj : TransformAction.getGeom(md, geomObjs)) {
            double minZ;
            Floor floor;
            obj.transform(xform);
            if (obj instanceof SchematicRoom) {
                subtractors.add((SchematicRoom)obj);
            }
            if (floorMap.get(floor = FloorSortActions.chooseFloor(md, new UnitDouble(minZ = obj.getBounds().getMinZ(), SI.METER))) == null) {
                floorMap.put(floor, new ArrayList());
            }
            floorMap.get(floor).add(obj);
        }
        int subtractOptions = TransformAction.getSubtractOptions(xform);
        ArrayList toClean = new ArrayList();
        SubtractAction.subtract(app, md, subtractOptions, toClean::add, subtractors);
        SchematicRoom.cleanup(md, toClean);
        return floorMap;
    }

    private void geomGroupPaste(VentusData md, GeomComposite geomGroup, HashMap<Floor, List<IMerlinGeomSrc>> floorMap, Floor floor, Consumer<? super IDomainObject> allPastedObjs) {
        for (IMerlinGeomSrc obj : floorMap.get(floor)) {
            Undo.AddOp op = new Undo.AddOp(geomGroup, Arrays.asList(obj));
            Undo.insertEntry(md, op.perform());
            md.selection.select(obj);
        }
        Undo.AddOp op = new Undo.AddOp(floor, Arrays.asList(geomGroup));
        Undo.insertEntry(md, op.perform());
        md.selection.select(geomGroup);
        allPastedObjs.accept(geomGroup);
    }

    private void floorPaste(VentusData md, HashMap<Floor, List<IMerlinGeomSrc>> floorMap, Floor floor, IDomainObject<VentusData> pasteObj, Map<IDomainObject, String> pasteObjMap, Consumer<? super IDomainObject> allPastedObjs) {
        for (IMerlinGeomSrc obj : floorMap.get(floor)) {
            Undo.AddOp op = new Undo.AddOp(floor, Arrays.asList(obj));
            Undo.insertEntry(md, op.perform());
            md.selection.select(obj);
            allPastedObjs.accept((IDomainObject)((Object)obj));
        }
        if (this.isFloor(pasteObj)) {
            allPastedObjs.accept(floor);
        }
    }

    private void floorMapPasteApply(VentusData md, HashMap<Floor, List<IMerlinGeomSrc>> floorMap, IDomainObject<VentusData> pasteObj, Map<IDomainObject, String> pasteObjMap, Consumer<? super IDomainObject> allPastedObjs) {
        for (Floor floor : floorMap.keySet()) {
            if (this.isGeomComposite(pasteObj)) {
                GeomComposite geomGroup = (GeomComposite)((GeomComposite)pasteObj).clone();
                this.geomGroupPaste(md, geomGroup, floorMap, floor, allPastedObjs);
                continue;
            }
            this.floorPaste(md, floorMap, floor, pasteObj, pasteObjMap, allPastedObjs);
        }
    }

    @Override
    public void pasteApply(VentusData md, VentusApp app, Map<IDomainObject, String> pasteObjMap, Map.Entry<IDomainObject, String> pasteEntry, PasteHints hints, Collection<Composite<ICompElement>> selectedComposites, Collection<IMerlinObj> selectedLeaves, Consumer<? super IDomainObject> allPastedObjs, Consumer<? super Warning> warnings) {
        IDomainObject pasteObj = pasteEntry.getKey();
        Collection<IMerlinObj> geomObjs = CopyPasteUtil.flattenToType(pasteObj, IMerlinObj.class);
        try (VentusData.WriteLock lock = md.lockWrite();){
            Undo.begin(Intl.intl("Set Offset"));
            Undo.insertUndoEntry_restoreSelection(md);
            HashMap<Floor, List<IMerlinGeomSrc>> floorMap = this.transformPasteObjs(app, md, geomObjs.stream().filter(o -> !(o instanceof Composite)).collect(Collectors.toList()), hints.geomTransform);
            this.floorMapPasteApply(md, floorMap, pasteObj, pasteObjMap, allPastedObjs);
            Undo.end(md);
        }
    }
}

