/*
 * Decompiled with CFR 0.152.
 */
package ventus.actions;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Stack;
import javafx.scene.input.KeyCode;
import javax.swing.Icon;
import javax.swing.JMenu;
import javax.swing.KeyStroke;
import thunderheadeng.gui.DropDownButton;
import thunderheadeng.util.Events;
import thunderheadeng.util.IEventObserver;
import thunderheadeng.util.LinkedIdentityHashMap;
import thunderheadeng.util.MajorMinorBoundedStack;
import ventus.Intl;
import ventus.MerlinPrefs;
import ventus.VentusApp;
import ventus.actions.AMerlinOp;
import ventus.actions.CompositeUndo;
import ventus.actions.UIHook;
import ventus.data.Composite;
import ventus.data.ICompElement;
import ventus.data.IRestorable;
import ventus.data.MerlinSelectionModel;
import ventus.data.VentusData;

public class Undo {
    private static final MajorMinorBoundedStack<CompositeUndo> STACK_UNDO = new MajorMinorBoundedStack<CompositeUndo>(1, 1, UndoOp::isMajor);
    private static final MajorMinorBoundedStack<CompositeUndo> STACK_REDO = new MajorMinorBoundedStack<CompositeUndo>(1, 1, UndoOp::isMajor);
    private static CompositeUndo CURRENT_OP = null;
    private static final Stack<Integer> CURRENT_OP_MARKERS = new Stack();
    private static boolean ACCEPTING = true;
    public static final Object UNDO_REDO = "Undo.UNDO_REDO";
    private static final ArrayList<UIHook> UNDO_ACTIONS = new ArrayList();
    private static final ArrayList<UIHook> REDO_ACTIONS = new ArrayList();
    public static final UndoStatus UNDO_STATUS = new UndoStatus();
    public static final Icon ICON_UNDO = UIHook.loadIcon("thunderheadeng/gui/graphics/Undo16.gif");
    public static final UIHook UI_HOOK_UNDO = new UIHook(new UndoAction(), Intl.intl("&Undo,Z,Undo last action,Undo last action"), ICON_UNDO, 16);
    public static final UIHook UI_HOOK_UNDO_MAJOR = new UIHook(new UndoThroughMajorAction(), Intl.intl("&Undo Edit,-,Undo last edit,Undo last edit"), ICON_UNDO, 16);
    public static final Icon ICON_REDO;
    public static final UIHook UI_HOOK_REDO;
    public static final UIHook UI_HOOK_REDO_MAJOR;

    public static boolean canUndo() {
        return STACK_UNDO.size() > 0;
    }

    public static String getUndoName(boolean prefix) {
        if (!Undo.canUndo()) {
            return Intl.intl("Undo");
        }
        String actionName = STACK_UNDO.peek().getName();
        return prefix ? String.format(Intl.intl("Undo %s"), actionName) : actionName;
    }

    public static boolean canRedo() {
        return STACK_REDO.size() > 0;
    }

    public static String getRedoName(boolean prefix) {
        if (!Undo.canRedo()) {
            return Intl.intl("Redo");
        }
        String actionName = STACK_REDO.peek().getName();
        return prefix ? String.format(Intl.intl("Redo %s"), actionName) : actionName;
    }

    private static void fireChangeEvt(VentusData md) {
        md.getEvents().changed(UNDO_STATUS, UNDO_REDO);
    }

    public static void undo(VentusData md) {
        try (VentusData.WriteLock lock = md.lockWrite();){
            if (!Undo.canUndo()) {
                return;
            }
            UndoOp undoTo = STACK_UNDO.pop();
            UndoOp currentState = undoTo.perform();
            STACK_REDO.push((CompositeUndo)currentState);
            Undo.fireChangeEvt(md);
        }
    }

    public static void undoThrough(VentusData md, UndoOp op) {
        try (VentusData.WriteLock lock = md.lockWrite();){
            UndoOp lastUndone = null;
            while (Undo.canUndo() && lastUndone != op) {
                lastUndone = STACK_UNDO.pop();
                UndoOp currentState = lastUndone.perform();
                STACK_REDO.push((CompositeUndo)currentState);
            }
            Undo.fireChangeEvt(md);
        }
    }

    public static void redo(VentusData md) {
        try (VentusData.WriteLock lock = md.lockWrite();){
            if (!Undo.canRedo()) {
                return;
            }
            UndoOp redoTo = STACK_REDO.pop();
            UndoOp currentState = redoTo.perform();
            STACK_UNDO.push((CompositeUndo)currentState);
            Undo.fireChangeEvt(md);
        }
    }

    public static void redoThrough(VentusData md, UndoOp op) {
        try (VentusData.WriteLock lock = md.lockWrite();){
            UndoOp lastRedone = null;
            while (Undo.canRedo() && lastRedone != op) {
                lastRedone = STACK_REDO.pop();
                UndoOp currentState = lastRedone.perform();
                STACK_UNDO.push((CompositeUndo)currentState);
            }
            Undo.fireChangeEvt(md);
        }
    }

    private static void pushNewOp(CompositeUndo op) {
        STACK_UNDO.push(op);
        if (op.isMajor()) {
            STACK_REDO.clear();
        }
    }

    public static void insertEntry_breakChain(VentusData md) {
        if (Undo.accepting()) {
            ACCEPTING = false;
        }
        STACK_UNDO.clear();
        STACK_REDO.clear();
        CURRENT_OP = null;
        Undo.fireChangeEvt(md);
    }

    private static void print(String s) {
    }

    public static boolean accepting() {
        return ACCEPTING && CURRENT_OP != null;
    }

    public static void insertEntry(VentusData md, UndoOp op) {
        if (!Undo.accepting()) {
            return;
        }
        Undo.print("insertEntry: " + op.toString());
        CURRENT_OP.insertEntry(op);
    }

    public static void clearCurrentOp() {
        if (!Undo.accepting()) {
            return;
        }
        CURRENT_OP.clear();
    }

    public static void begin(String actionName) {
        if (CURRENT_OP == null && ACCEPTING) {
            CURRENT_OP = new CompositeUndo(actionName);
        }
        int marker = CURRENT_OP == null ? 0 : CURRENT_OP.marker();
        CURRENT_OP_MARKERS.push(marker);
        if (Undo.accepting()) {
            Undo.print("begin()");
        }
    }

    public static void end(VentusData md) {
        Undo.end(md, true);
    }

    public static void end(VentusData md, boolean keepLast) {
        int lastMarker = CURRENT_OP_MARKERS.pop();
        if (CURRENT_OP_MARKERS.isEmpty()) {
            ACCEPTING = true;
        }
        if (!Undo.accepting()) {
            return;
        }
        Undo.print("end()");
        if (!keepLast) {
            try (VentusData.WriteLock lock = md.lockWrite();){
                CURRENT_OP.cancel(lastMarker);
            }
        }
        if (CURRENT_OP_MARKERS.isEmpty()) {
            CompositeUndo op = CURRENT_OP;
            CURRENT_OP = null;
            if (!op.isEmpty()) {
                op.complete();
                Undo.pushNewOp(op);
                Undo.fireChangeEvt(md);
            }
        }
    }

    public static void insertUndoEntry_delete(VentusData md, Composite<?> parent, Collection<?> objs) {
        if (!Undo.accepting()) {
            return;
        }
        Undo.insertEntry(md, new DelOp(parent, objs));
    }

    public static void insertUndoEntry_delete(VentusData md, Composite<?> parent, Object ... objs) {
        if (!Undo.accepting()) {
            return;
        }
        Undo.insertUndoEntry_delete(md, parent, Arrays.asList(objs));
    }

    public static void insertUndoEntry_add(VentusData md, Object ... objs) {
        if (!Undo.accepting()) {
            return;
        }
        Undo.insertUndoEntry_add(md, Arrays.asList(objs));
    }

    public static void insertUndoEntry_add(VentusData md, Collection<?> objs) {
        if (!Undo.accepting()) {
            return;
        }
        for (Object child : objs) {
            Object parent = md.hierarchy.getParent(child);
            if (!(parent instanceof Composite)) continue;
            Undo.insertEntry(md, new AddOp((Composite)parent, Arrays.asList(child)));
        }
    }

    public static void insertUndoEntry_insert(VentusData md, Object obj) {
        if (!Undo.accepting()) {
            return;
        }
        Object parent = md.hierarchy.getParent(obj);
        if (parent instanceof Composite) {
            Composite cparent = (Composite)parent;
            Undo.insertEntry(md, new InsertOp(cparent, Arrays.asList(obj), cparent.indexOf((ICompElement)obj)));
        }
    }

    public static void insertUndoEntry_restore(VentusData md, Collection<? extends IRestorable> objs) {
        if (!Undo.accepting()) {
            return;
        }
        for (IRestorable iRestorable : objs) {
            Undo.insertUndoEntry_restore(md, iRestorable);
        }
    }

    public static void insertUndoEntry_restore(VentusData md, IRestorable obj) {
        if (!Undo.accepting()) {
            return;
        }
        Undo.insertEntry(md, new RestoreOp(obj, obj.getRestoreObj()));
    }

    public static void insertUndoEntry_restore(VentusData md, IRestorable obj, boolean select) {
        if (!Undo.accepting()) {
            return;
        }
        Undo.insertEntry(md, new RestoreOp(obj, obj.getRestoreObj()));
    }

    public static void insertUndoEntry_restore(VentusData md, IRestorable obj, Object momento) {
        if (!Undo.accepting()) {
            return;
        }
        Undo.insertEntry(md, new RestoreOp(obj, momento));
    }

    public static void insertUndoEntry_propRestore(VentusData md, Collection<? extends ICompElement> objs, Object prop) {
        if (!Undo.accepting()) {
            return;
        }
        Undo.insertEntry(md, new PropRestoreOp(prop, objs));
    }

    public static void insertUndoEntry_restoreSelection(VentusData md) {
        if (!Undo.accepting()) {
            return;
        }
        Undo.insertEntry(md, new RestoreOp(md.selection, md.selection.getRestoreObj()));
    }

    private static byte[] getBytesForObject(Serializable s) {
        ByteArrayOutputStream osMemState = new ByteArrayOutputStream();
        ObjectOutputStream oos = null;
        try {
            oos = new ObjectOutputStream(osMemState);
            oos.writeObject(s);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return osMemState.toByteArray();
    }

    public static Serializable getObjectFromBytes(byte[] bytes) {
        ByteArrayInputStream isMemState = new ByteArrayInputStream(bytes);
        ObjectInputStream ois = null;
        try {
            ois = new ObjectInputStream(isMemState);
            return (Serializable)ois.readObject();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        catch (ClassNotFoundException e) {
            e.printStackTrace();
        }
        return null;
    }

    static {
        UI_HOOK_UNDO_MAJOR.setKeyStroke(KeyStroke.getKeyStroke(KeyCode.Z.getCode(), 192));
        ICON_REDO = UIHook.loadIcon("thunderheadeng/gui/graphics/Redo16.gif");
        UI_HOOK_REDO = new UIHook(new RedoAction(), Intl.intl("&Redo,Y,Redo last action,Redo last action"), ICON_REDO, 16);
        UI_HOOK_REDO_MAJOR = new UIHook(new RedoThroughMajorAction(), Intl.intl("&Redo Edit,-,Redo last edit,Redo last edit"), ICON_REDO, 16);
        UI_HOOK_REDO_MAJOR.setKeyStroke(KeyStroke.getKeyStroke(KeyCode.Y.getCode(), 192));
    }

    public static class UndoStatus {
    }

    public static interface UndoOp {
        public UndoOp perform();

        public boolean isMajor();
    }

    public static class DelOp
    implements UndoOp {
        private final Composite<?> d_delFrom;
        private final Collection<?> d_objs;

        public DelOp(Composite<?> delFrom, Collection<?> objs) {
            this.d_delFrom = delFrom;
            this.d_objs = objs;
        }

        @Override
        public UndoOp perform() {
            this.d_delFrom.removeAll(this.d_objs);
            return new AddOp(this.d_delFrom, this.d_objs);
        }

        @Override
        public boolean isMajor() {
            return true;
        }

        public String toString() {
            return this.getClass().getName() + "[delFrom=" + this.d_delFrom.getName() + ",|objs|=" + this.d_objs.size() + "]";
        }
    }

    public static class AddOp
    implements UndoOp {
        private final Composite<?> d_addTo;
        private final Collection<?> d_objs;

        public AddOp(Composite<?> addTo, Collection<?> objs) {
            this.d_addTo = addTo;
            this.d_objs = objs;
        }

        @Override
        public UndoOp perform() {
            DelOp undo = new DelOp(this.d_addTo, this.d_objs);
            this.d_addTo.addAll(this.d_objs);
            return undo;
        }

        @Override
        public boolean isMajor() {
            return true;
        }

        public String toString() {
            return this.getClass().getName() + "[addTo=" + this.d_addTo.getName() + ",|objs|=" + this.d_objs.size() + "]";
        }
    }

    public static class InsertOp<T extends ICompElement>
    implements UndoOp {
        private final Composite<? super T> d_parent;
        private final Object d_objects;
        private final int d_ix;

        public InsertOp(Composite<? super T> parent, Collection<? extends ICompElement> objs, int ix) {
            assert (objs.stream().allMatch(o -> parent.getFilter().test((ICompElement)o)));
            this.d_parent = parent;
            this.d_objects = objs.size() == 1 ? objs.iterator().next() : objs;
            this.d_ix = ix;
        }

        protected Collection<? extends ICompElement> getObjs() {
            return this.d_objects instanceof Collection ? (List<ICompElement>)this.d_objects : Collections.singletonList((ICompElement)this.d_objects);
        }

        @Override
        public UndoOp perform() {
            InsertOp<? super T> undo = new InsertOp<T>(this.d_parent, this.getObjs(), this.d_ix);
            Collection<ICompElement> objs = this.getObjs();
            if (objs.isEmpty()) {
                return undo;
            }
            ICompElement first = objs.iterator().next();
            if (this.d_parent.contains(first)) {
                this.d_parent.removeAll(objs);
            } else {
                this.d_parent.insert(objs, this.d_ix);
            }
            return undo;
        }

        @Override
        public boolean isMajor() {
            return true;
        }
    }

    public static class RestoreOp
    implements UndoOp {
        private final IRestorable d_obj;
        private final Object d_momento;

        public RestoreOp(IRestorable obj, Object momento) {
            this.d_obj = obj;
            this.d_momento = momento;
        }

        public IRestorable getObj() {
            return this.d_obj;
        }

        public Object getMomento() {
            return this.d_momento;
        }

        @Override
        public RestoreOp perform() {
            RestoreOp undo = new RestoreOp(this.d_obj, this.d_obj.getRestoreObj());
            this.d_obj.restoreFrom(this.d_momento);
            return undo;
        }

        @Override
        public boolean isMajor() {
            return !(this.d_obj instanceof MerlinSelectionModel);
        }

        public String toString() {
            return this.getClass().getName() + "[obj=" + this.d_obj.getClass().getName() + ",momento=" + this.d_momento.getClass().getName() + "]";
        }
    }

    public static class PropRestoreOp
    implements UndoOp {
        private final Object d_prop;
        private final Collection<? extends ICompElement> d_objs;
        private final Map<ICompElement, Object> d_vals;

        public PropRestoreOp(Object prop, Collection<? extends ICompElement> objs) {
            this.d_prop = prop;
            this.d_objs = objs;
            this.d_vals = new LinkedIdentityHashMap<ICompElement, Object>();
            for (ICompElement iCompElement : this.d_objs) {
                this.d_vals.put(iCompElement, iCompElement.getProperty(this.d_prop));
            }
        }

        @Override
        public UndoOp perform() {
            PropRestoreOp undo = new PropRestoreOp(this.d_prop, this.d_objs);
            for (ICompElement iCompElement : this.d_objs) {
                iCompElement.setProperty(this.d_prop, this.d_vals.get(iCompElement));
            }
            return undo;
        }

        @Override
        public boolean isMajor() {
            return true;
        }
    }

    private static class UndoAction
    extends AMerlinOp
    implements IEventObserver {
        public UndoAction() {
            VentusApp.getApp().getData().getEvents().addObserver(this);
            this.setEnabled(Undo.canUndo());
        }

        @Override
        public void run(VentusApp app, VentusData md) {
            Undo.undo(md);
        }

        @Override
        public void update(Events events) {
            if (events.isAffected(UndoStatus.class)) {
                this.setEnabled(Undo.canUndo());
                UI_HOOK_UNDO.setName(Undo.getUndoName(false));
                String desc = Undo.getUndoName(true);
                UI_HOOK_UNDO.setShortDesc(desc);
                UI_HOOK_UNDO.setLongDesc(desc);
            }
        }
    }

    private static class UndoThroughMajorAction
    extends AMerlinOp
    implements IEventObserver {
        public UndoThroughMajorAction() {
            VentusApp.getApp().getData().getEvents().addObserver(this);
        }

        @Override
        public void run(VentusApp app, VentusData vd) {
            Undo.undoThrough(vd, UndoThroughMajorAction.lastMajor());
        }

        @Override
        public void update(Events events) {
            if (events.isAffected(UndoStatus.class)) {
                CompositeUndo op = UndoThroughMajorAction.lastMajor();
                this.setEnabled(op != null);
                if (op != null) {
                    String newName = String.format(Intl.intl("Undo %s"), op.getName());
                    UI_HOOK_UNDO_MAJOR.setName(newName);
                    UI_HOOK_UNDO_MAJOR.setShortDesc(newName);
                    UI_HOOK_UNDO_MAJOR.setLongDesc(newName);
                } else {
                    UI_HOOK_UNDO_MAJOR.setName(Intl.intl("Undo Edit"));
                    UI_HOOK_UNDO_MAJOR.setShortDesc(Intl.intl("Undo last edit"));
                    UI_HOOK_UNDO_MAJOR.setLongDesc(Intl.intl("Undo last edit"));
                }
            }
        }

        private static CompositeUndo lastMajor() {
            List<CompositeUndo> ops = STACK_UNDO.toList();
            for (int i = ops.size() - 1; i >= 0; --i) {
                CompositeUndo op = ops.get(i);
                if (!op.isMajor()) continue;
                return op;
            }
            return null;
        }
    }

    private static class RedoAction
    extends AMerlinOp
    implements IEventObserver {
        public RedoAction() {
            VentusApp.getApp().getData().getEvents().addObserver(this);
            this.setEnabled(Undo.canRedo());
        }

        @Override
        public void run(VentusApp app, VentusData md) {
            Undo.redo(md);
        }

        @Override
        public void update(Events events) {
            if (events.isAffected(UndoStatus.class)) {
                this.setEnabled(Undo.canRedo());
                UI_HOOK_REDO.setName(Undo.getRedoName(false));
                String desc = Undo.getRedoName(true);
                UI_HOOK_REDO.setShortDesc(desc);
                UI_HOOK_REDO.setLongDesc(desc);
            }
        }
    }

    private static class RedoThroughMajorAction
    extends AMerlinOp
    implements IEventObserver {
        public RedoThroughMajorAction() {
            VentusApp.getApp().getData().getEvents().addObserver(this);
        }

        @Override
        public void run(VentusApp app, VentusData vd) {
            Undo.redoThrough(vd, RedoThroughMajorAction.lastMajor());
        }

        @Override
        public void update(Events events) {
            if (events.isAffected(UndoStatus.class)) {
                CompositeUndo op = RedoThroughMajorAction.lastMajor();
                this.setEnabled(op != null);
                if (op != null) {
                    String newName = String.format(Intl.intl("Redo %s"), op.getName());
                    UI_HOOK_REDO_MAJOR.setName(newName);
                    UI_HOOK_REDO_MAJOR.setShortDesc(newName);
                    UI_HOOK_REDO_MAJOR.setLongDesc(newName);
                } else {
                    UI_HOOK_REDO_MAJOR.setName(Intl.intl("Redo Edit"));
                    UI_HOOK_REDO_MAJOR.setShortDesc(Intl.intl("Redo last edit"));
                    UI_HOOK_REDO_MAJOR.setLongDesc(Intl.intl("Redo last edit"));
                }
            }
        }

        private static CompositeUndo lastMajor() {
            List<CompositeUndo> ops = STACK_REDO.toList();
            for (int i = ops.size() - 1; i >= 0; --i) {
                CompositeUndo op = ops.get(i);
                if (!op.isMajor()) continue;
                return op;
            }
            return null;
        }
    }

    public static class RecentRedosAction
    implements IEventObserver {
        private final JMenu d_topMenu = new JMenu(Intl.intl("Redo"));

        public RecentRedosAction(VentusData vd) {
            vd.getEvents().addObserver(this);
        }

        public JMenu getMenu() {
            return this.d_topMenu;
        }

        @Override
        public void update(Events events) {
            if (events.isAffected(UndoStatus.class)) {
                this.updateMenu();
            }
        }

        private void updateMenu() {
            this.d_topMenu.removeAll();
            List<CompositeUndo> redoList = STACK_REDO.toList();
            if (!redoList.isEmpty()) {
                this.d_topMenu.add(UI_HOOK_REDO);
            }
            for (int i = redoList.size() - 2; i >= 0; --i) {
                CompositeUndo op = redoList.get(i);
                UIHook hook = new UIHook(new RedoThroughOp(op), op.getName(), ICON_REDO, 16);
                String desc = String.format(Intl.intl("Redo %s"), op.getName());
                hook.setShortDesc(desc);
                hook.setLongDesc(desc);
                this.d_topMenu.add(hook);
            }
            this.d_topMenu.setEnabled(!redoList.isEmpty());
        }
    }

    public static class RecentUndosAction
    implements IEventObserver {
        private final JMenu d_topMenu = new JMenu(Intl.intl("Undo"));

        public RecentUndosAction(VentusData vd) {
            vd.getEvents().addObserver(this);
        }

        public JMenu getMenu() {
            return this.d_topMenu;
        }

        @Override
        public void update(Events events) {
            if (events.isAffected(UndoStatus.class)) {
                this.updateMenu();
            }
        }

        private void updateMenu() {
            this.d_topMenu.removeAll();
            List<CompositeUndo> undoList = STACK_UNDO.toList();
            if (!undoList.isEmpty()) {
                this.d_topMenu.add(UI_HOOK_UNDO);
            }
            for (int i = undoList.size() - 2; i >= 0; --i) {
                CompositeUndo op = undoList.get(i);
                UIHook hook = new UIHook(new UndoThroughOp(op), op.getName(), ICON_UNDO, 16);
                String desc = String.format(Intl.intl("Undo %s"), op.getName());
                hook.setShortDesc(desc);
                hook.setLongDesc(desc);
                this.d_topMenu.add(hook);
            }
            this.d_topMenu.setEnabled(!undoList.isEmpty());
        }
    }

    public static class RedoDropdownButton
    extends DropDownButton
    implements IEventObserver {
        public RedoDropdownButton(VentusData vd) {
            super(Collections.singleton(UI_HOOK_REDO), 3);
            vd.getEvents().addObserver(this);
        }

        @Override
        public void update(Events events) {
            if (events.isAffected(UndoStatus.class)) {
                List<CompositeUndo> redoList = STACK_REDO.toList();
                ArrayList<UIHook> hooks = new ArrayList<UIHook>(redoList.size());
                hooks.add(UI_HOOK_REDO);
                for (int i = redoList.size() - 2; i >= 0; --i) {
                    CompositeUndo op = redoList.get(i);
                    UIHook hook = new UIHook(new RedoThroughOp(op), op.getName(), ICON_REDO, 16);
                    String desc = String.format(Intl.intl("Redo %s"), op.getName());
                    hook.setShortDesc(desc);
                    hook.setLongDesc(desc);
                    hooks.add(hook);
                }
                this.setAvailableActions(hooks);
            }
        }
    }

    private static class RedoThroughOp
    extends AMerlinOp {
        private final UndoOp d_op;

        public RedoThroughOp(UndoOp op) {
            this.d_op = op;
        }

        @Override
        public void run(VentusApp app, VentusData vd) {
            Undo.redoThrough(vd, this.d_op);
        }
    }

    public static class UndoDropdownButton
    extends DropDownButton
    implements IEventObserver {
        public UndoDropdownButton(VentusData vd) {
            super(Collections.singleton(UI_HOOK_UNDO), 3);
            vd.getEvents().addObserver(this);
        }

        @Override
        public void update(Events events) {
            if (events.isAffected(UndoStatus.class)) {
                List<CompositeUndo> undoList = STACK_UNDO.toList();
                ArrayList<UIHook> hooks = new ArrayList<UIHook>(undoList.size());
                hooks.add(UI_HOOK_UNDO);
                for (int i = undoList.size() - 2; i >= 0; --i) {
                    CompositeUndo op = undoList.get(i);
                    UIHook hook = new UIHook(new UndoThroughOp(op), op.getName(), ICON_UNDO, 16);
                    String desc = String.format(Intl.intl("Undo %s"), op.getName());
                    hook.setShortDesc(desc);
                    hook.setLongDesc(desc);
                    hooks.add(hook);
                }
                this.setAvailableActions(hooks);
            }
        }
    }

    private static class UndoThroughOp
    extends AMerlinOp {
        private final UndoOp d_op;

        public UndoThroughOp(UndoOp op) {
            this.d_op = op;
        }

        @Override
        public void run(VentusApp app, VentusData vd) {
            Undo.undoThrough(vd, this.d_op);
        }
    }

    public static class StackSizePrefObserver
    implements IEventObserver {
        private final VentusApp d_app;

        public StackSizePrefObserver(VentusApp app) {
            this.d_app = app;
            this.applyStackSize();
        }

        @Override
        public void update(Events events) {
            if (events.getEvents(VentusData.class, new Class[0]).containsChange(VentusData.PREFS_CHANGED)) {
                this.applyStackSize();
            }
        }

        private void applyStackSize() {
            int stackSize = this.d_app.getPrefs().get(MerlinPrefs.UNDO_STACK_SIZE);
            STACK_UNDO.setLimit(stackSize, stackSize * 2);
            STACK_REDO.setLimit(stackSize, stackSize * 2);
            Undo.fireChangeEvt(this.d_app.getData());
        }
    }
}

