/*
 * Decompiled with CFR 0.152.
 */
package ventus.actions;

import java.util.Collection;
import java.util.Set;
import thunderheadeng.util.Events;
import thunderheadeng.util.IEventObserver;
import ventus.Intl;
import ventus.VentusApp;
import ventus.actions.AMerlinOp;
import ventus.actions.FloorSortActions;
import ventus.actions.SelectionObserver;
import ventus.actions.UIHook;
import ventus.actions.Undo;
import ventus.data.Composite;
import ventus.data.VentusData;
import ventus.data.schematics.FloorOptions;
import ventus.data.schematics.geom.ISchematicComp;

public class SortByFloor
extends AMerlinOp
implements IEventObserver {
    public static final UIHook UI_HOOK = new UIHook(new SortByFloor(), Intl.intl("&Sort into Levels,-,Sort schematics components into appropriate levels."));

    public SortByFloor() {
        SelectionObserver.add(this, ISchematicComp.class, Composite.class);
        this.update(null);
    }

    @Override
    public void update(Events events) {
        VentusApp app = VentusApp.getApp();
        VentusData data = app.getData();
        this.setEnabled(!SortByFloor.getSortableObjs(data).isEmpty());
    }

    private static Collection<ISchematicComp> getSortableObjs(VentusData md) {
        Set selObjs = md.selection.getDeepSelected(ISchematicComp.class);
        return FloorSortActions.getSortableObjs(md, selObjs);
    }

    @Override
    public void run(VentusApp app, VentusData md) {
        try (VentusData.WriteLock lock = md.lockWrite();){
            Collection<ISchematicComp> comps = SortByFloor.getSortableObjs(md);
            Undo.begin(Intl.intl("Sort by Level"));
            boolean oldAuto = md.floorOptions.get(FloorOptions.AUTO_SELECT_FLOOR);
            md.floorOptions.set(FloorOptions.AUTO_SELECT_FLOOR, true);
            FloorSortActions.updateComponentFloors(md, comps);
            md.floorOptions.set(FloorOptions.AUTO_SELECT_FLOOR, oldAuto);
            Undo.end(md);
        }
    }
}

