/*
 * Decompiled with CFR 0.152.
 */
package ventus.actions;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Set;
import thunderheadeng.util.Events;
import thunderheadeng.util.IEventObserver;
import ventus.Intl;
import ventus.VentusApp;
import ventus.actions.AMerlinOp;
import ventus.actions.ReorderGroupOp;
import ventus.actions.SelectionObserver;
import ventus.actions.UIHook;
import ventus.actions.Undo;
import ventus.data.Composite;
import ventus.data.ICompElement;
import ventus.data.MerlinSelectionModel;
import ventus.data.VentusData;

public class SortAlphaAction
extends AMerlinOp
implements IEventObserver {
    public static final UIHook UI_HOOK = new UIHook(new SortAlphaAction(), Intl.intl("&Sort Alphabetically"));

    public SortAlphaAction() {
        SelectionObserver.add(this, Composite.class);
        this.update(null);
    }

    @Override
    public void run(VentusApp app, VentusData md) {
        MerlinSelectionModel sel = md.selection;
        assert (!sel.isEmpty());
        Set comps = sel.getSelected(Composite.class);
        try (VentusData.WriteLock lock = md.lockWrite();){
            Undo.begin(Intl.intl("Sort Groups"));
            for (Composite comp : comps) {
                ArrayList<ICompElement> oldOrder = new ArrayList<ICompElement>(comp.getMembers());
                List<ICompElement> newOrder = SortAlphaAction.sort(oldOrder);
                ReorderGroupOp op = new ReorderGroupOp(comp, oldOrder, newOrder);
                Undo.insertEntry(md, op.perform());
            }
            Undo.end(md);
        }
    }

    private static List<ICompElement> sort(Collection<? extends ICompElement> objs) {
        ArrayList<ICompElement> toSort = new ArrayList<ICompElement>(objs);
        Collections.sort(toSort, new Comparator<ICompElement>(){

            @Override
            public int compare(ICompElement ice1, ICompElement ice2) {
                if (ice1 instanceof Composite && !(ice2 instanceof Composite)) {
                    return -1;
                }
                if (!(ice1 instanceof Composite) && ice2 instanceof Composite) {
                    return 1;
                }
                String name1 = ice1.getName();
                String name2 = ice2.getName();
                return name1.compareTo(name2);
            }
        });
        return toSort;
    }

    @Override
    public void update(Events events) {
        VentusApp app = VentusApp.getApp();
        VentusData data = app.getData();
        MerlinSelectionModel sel = data.selection;
        this.setEnabled(!sel.isEmpty(Composite.class));
    }
}

