/*
 * Decompiled with CFR 0.152.
 */
package ventus.actions;

import java.awt.Color;
import java.util.Collection;
import java.util.HashSet;
import java.util.LinkedHashSet;
import thunderheadeng.util.Events;
import thunderheadeng.util.IEventObserver;
import thunderheadeng.util.Pair;
import ventus.Intl;
import ventus.VentusApp;
import ventus.actions.AMerlinOp;
import ventus.actions.SelectionObserver;
import ventus.actions.UIHook;
import ventus.actions.Undo;
import ventus.data.IOpacity;
import ventus.data.ImportedGeom;
import ventus.data.VentusData;

public class SelectByColor
extends AMerlinOp
implements IEventObserver {
    public static final UIHook UI_HOOK = new UIHook(new SelectByColor(), Intl.intl("Select All by Color"));

    public SelectByColor() {
        SelectionObserver.add(this, ImportedGeom.class);
        this.update(null);
    }

    protected Collection<ImportedGeom> getObjs(VentusData md) {
        return md.selection.getDeepSelected(ImportedGeom.class);
    }

    @Override
    public void update(Events events) {
        this.setEnabled(!this.getObjs(VentusApp.getApp().getData()).isEmpty());
    }

    @Override
    public void run(VentusApp app, VentusData md) {
        HashSet<Pair<Color, Float>> selColors = new HashSet<Pair<Color, Float>>();
        LinkedHashSet<ImportedGeom> selObjects = new LinkedHashSet<ImportedGeom>();
        for (ImportedGeom ig : this.getObjs(md)) {
            selColors.add(SelectByColor.getColor(ig));
        }
        for (ImportedGeom ig : md.sceneGeom.getDeepMembers(ImportedGeom.class)) {
            Pair<Color, Float> objColor = SelectByColor.getColor(ig);
            if (!selColors.contains(objColor)) continue;
            selObjects.add(ig);
        }
        if (selObjects.isEmpty()) {
            assert (false);
            return;
        }
        try (VentusData.WriteLock lock = md.lockWrite();){
            Undo.begin(Intl.intl("Select All by Color"));
            Undo.insertUndoEntry_restoreSelection(md);
            md.selection.set(selObjects);
            Undo.end(md);
        }
    }

    private static Pair<Color, Float> getColor(ImportedGeom ig) {
        Color color = (Color)ig.getProperty(VentusData.COLOR);
        IOpacity opacity = (IOpacity)ig.getProperty(VentusData.OPACITY);
        return new Pair<Color, Float>(color, Float.valueOf(opacity.getValue()));
    }
}

