/*
 * Decompiled with CFR 0.152.
 */
package ventus.actions;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Map;
import thunderheadeng.geometry.objs.node.IGeomNode;
import thunderheadeng.util.Events;
import thunderheadeng.util.IEventObserver;
import thunderheadeng.util.LinkedIdentityHashMap;
import ventus.Intl;
import ventus.VentusApp;
import ventus.actions.AMerlinOp;
import ventus.actions.SelectionObserver;
import ventus.actions.UIHook;
import ventus.actions.Undo;
import ventus.data.ImportedGeom;
import ventus.data.VentusData;
import ventus.geom.GeomUtil;

public class RemoveImportedUVAction
extends AMerlinOp
implements IEventObserver {
    public static final UIHook UI_HOOK = new UIHook(new RemoveImportedUVAction(), Intl.intl("Remove Imported Texture Coordinates,-,Removes the imported texture coordinates attached to the object and uses default texture coordinates instead."));

    public RemoveImportedUVAction() {
        SelectionObserver.add(this, ImportedGeom.class);
        this.update(null);
    }

    protected Collection<ImportedGeom> getObjs(VentusData md) {
        return md.selection.getDeepSelected(ImportedGeom.class);
    }

    @Override
    public void update(Events events) {
        this.setEnabled(!this.getObjs(VentusApp.getApp().getData()).isEmpty());
    }

    @Override
    public void run(VentusApp app, VentusData md) {
        try (VentusData.WriteLock lock = md.lockWrite();){
            Undo.begin(Intl.intl("Remove Imported Texture Coordinates"));
            Collection<ImportedGeom> geoms = this.getObjs(md);
            LinkedIdentityHashMap<ImportedGeom, IGeomNode> changes = new LinkedIdentityHashMap<ImportedGeom, IGeomNode>();
            for (ImportedGeom importedGeom : geoms) {
                IGeomNode newGeom;
                IGeomNode geom = importedGeom.getGeom();
                if (geom == (newGeom = geom.initUVElements(GeomUtil.DEFUV))) continue;
                changes.put(importedGeom, newGeom);
            }
            if (!changes.isEmpty()) {
                Undo.insertUndoEntry_propRestore(md, new ArrayList(changes.keySet()), ImportedGeom.PROP_GEOM);
                for (Map.Entry entry : changes.entrySet()) {
                    ((ImportedGeom)entry.getKey()).setGeom((IGeomNode)entry.getValue());
                }
            }
            Undo.end(md);
        }
    }
}

