/*
 * Decompiled with CFR 0.152.
 */
package ventus.actions;

import java.util.List;
import java.util.Properties;
import java.util.Set;
import java.util.Vector;
import javax.swing.JMenu;
import thunderheadeng.io.FilenameManager;
import thunderheadeng.util.EventChannel;
import thunderheadeng.util.Events;
import thunderheadeng.util.IEventObserver;
import ventus.Intl;
import ventus.MerlinPrefs;
import ventus.VentusApp;
import ventus.actions.AMerlinOp;
import ventus.actions.MerlinOp;
import ventus.actions.Open;
import ventus.actions.UIHook;
import ventus.data.RecentFilesEntry;
import ventus.data.VentusData;

public class RecentFilesAction
implements IEventObserver {
    private static final int SZ_LIST = 10;
    private static final String PREFIX = "MRU.";
    private final VentusData d_md;
    private final JMenu d_topMenu = new JMenu(Intl.intl("Recent Files"));
    private final List<String> d_fileList = new Vector<String>(10);

    public RecentFilesAction(VentusData md) {
        this.d_md = md;
        this.d_md.getEvents().addObserver(this);
    }

    @Override
    public void update(Events events) {
        Set<EventChannel<RecentFilesEntry>> channels = events.getAffectedChannels(RecentFilesEntry.class, new Class[0]);
        for (EventChannel<RecentFilesEntry> channel : channels) {
            Set<RecentFilesEntry> added = channel.getAddedObjs();
            for (RecentFilesEntry e : added) {
                this.handleAdd(e);
            }
            Set<RecentFilesEntry> rem = channel.getRemovedObjs();
            for (RecentFilesEntry e : rem) {
                this.handleRem(e);
            }
        }
    }

    private void handleAdd(RecentFilesEntry e) {
        String fn = e.fn;
        assert (fn != null);
        this.d_fileList.remove(fn);
        this.d_fileList.add(0, fn);
        RecentFilesAction.updateMenu(this.d_topMenu, this.d_fileList);
    }

    private void handleRem(RecentFilesEntry e) {
        String fn = e.fn;
        assert (fn != null);
        this.d_fileList.remove(fn);
        RecentFilesAction.updateMenu(this.d_topMenu, this.d_fileList);
    }

    public void init(Properties p) {
        for (int i = 1; i <= 10; ++i) {
            String key = PREFIX + i;
            if (!p.containsKey(key)) continue;
            String fn = p.getProperty(key);
            this.d_fileList.add(fn);
        }
        RecentFilesAction.updateMenu(this.d_topMenu, this.d_fileList);
    }

    private static void updateMenu(JMenu topMenu, List<String> fileList) {
        topMenu.removeAll();
        for (String fn : fileList) {
            UIHook hook = new UIHook((MerlinOp)new MRUEntry(fn), RecentFilesAction.getMRUString(fn), 8);
            topMenu.add(hook);
        }
        topMenu.setEnabled(!fileList.isEmpty());
    }

    public void store(Properties p) {
        for (int ix = 1; ix <= 10; ++ix) {
            String key = PREFIX + ix;
            if (this.d_fileList.size() >= ix) {
                String fn = this.d_fileList.get(ix - 1);
                p.setProperty(key, fn);
                continue;
            }
            p.remove(key);
        }
    }

    public JMenu getMenu() {
        return this.d_topMenu;
    }

    private static String getMRUString(String fn) {
        int ix1 = fn.indexOf(92);
        if (ix1 == -1) {
            return fn;
        }
        if (fn.charAt(ix1 + 1) == '\\') {
            ix1 = fn.indexOf(92, ix1 + 2);
        }
        int ix2 = ix1;
        int ix3 = ix1;
        int ix = ix1;
        do {
            ix2 = ix3;
            ix3 = ix;
        } while ((ix = fn.indexOf(92, ix + 1)) != -1);
        if (ix1 == ix2 || fn.length() < 25) {
            return fn;
        }
        StringBuffer sb = new StringBuffer(fn.substring(0, ix1 + 1));
        sb.append("...");
        sb.append(fn.substring(ix2));
        return sb.toString();
    }

    private static class MRUEntry
    extends AMerlinOp {
        private final String d_fn;

        public MRUEntry(String fn) {
            this.d_fn = fn;
        }

        @Override
        public void run(VentusApp app, VentusData md) {
            assert (FilenameManager.getExtension(this.d_fn).equalsIgnoreCase("vnts"));
            if (!app.promptSaveIfModified()) {
                return;
            }
            if (Open.open(app, md, this.d_fn)) {
                MerlinPrefs.set(MerlinPrefs.OPEN_DIR_PREF, this.d_fn);
            } else {
                md.getEvents().removed((Object)new RecentFilesEntry(this.d_fn));
            }
        }
    }
}

