/*
 * Decompiled with CFR 0.152.
 */
package ventus.actions;

import java.io.File;
import java.io.IOException;
import java.io.Serializable;
import java.util.concurrent.ExecutionException;
import java.util.function.BiConsumer;
import javafx.stage.FileChooser;
import javax.swing.Icon;
import javax.swing.JFrame;
import javax.swing.JOptionPane;
import thunderheadeng.geometry.AABox;
import thunderheadeng.geometry.Box3d;
import thunderheadeng.geometry.search.Containment;
import thunderheadeng.geometry.search.IResult;
import thunderheadeng.geometry.search.ITest;
import thunderheadeng.gui.ModelBackup;
import thunderheadeng.gui.WarningDlg;
import thunderheadeng.gui.guiDialog;
import thunderheadeng.gui.guiJFXFileChooser;
import thunderheadeng.gui.guiProgressMonitor;
import thunderheadeng.scene3d.geom.IDisplayableGeomSrc;
import thunderheadeng.util.CancelledException;
import thunderheadeng.util.TaskProgress;
import ventus.Intl;
import ventus.MerlinPrefs;
import ventus.VentusApp;
import ventus.actions.AMerlinOp;
import ventus.actions.MerlinOp;
import ventus.actions.Save;
import ventus.actions.UIHook;
import ventus.actions.Undo;
import ventus.data.RecentFilesEntry;
import ventus.data.VentusData;
import ventus.gui.guiUtil;
import ventus.io.IInputStreamFeatureHandler;
import ventus.io.VentusIO;
import ventus.io.VentusOIS;

public class Open
extends AMerlinOp {
    public static final Icon ICON = UIHook.loadIcon("thunderheadeng/gui/graphics/Open16.gif");
    public static final UIHook UI_HOOK = new UIHook((MerlinOp)new Open(), Intl.intl("&Open...,O,Open File,Open a model file"), ICON);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run(VentusApp app, VentusData md) {
        try {
            app.beginWaitCursor();
            if (!app.promptSaveIfModified()) {
                return;
            }
            guiJFXFileChooser chooser = new guiJFXFileChooser(null, MerlinPrefs.get(MerlinPrefs.OPEN_DIR_PREF), null, (Boolean)false, (Boolean)false, (Boolean)false, new FileChooser.ExtensionFilter(String.format(Intl.intl("%s File"), "Ventus"), "*.vnts"));
            File f = chooser.showOpenDialog();
            if (f == null) {
                return;
            }
            MerlinPrefs.set(MerlinPrefs.OPEN_DIR_PREF, f.getParent());
            Open.open(app, md, f.getAbsolutePath());
        }
        finally {
            app.endWaitCursor();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean open(VentusApp app, VentusData md, String fn) {
        app.setWorkingDir(fn);
        app.beginWaitCursor();
        try {
            VentusIO io = new VentusIO();
            VentusData mdLoad = Open.openModel(app, io, md.backup, fn);
            if (mdLoad == null) {
                boolean bl = false;
                return bl;
            }
            boolean isBackup = md.backup.isReservedPath(mdLoad.filename);
            Save.setForceSavePrompt(isBackup);
            mdLoad.modified |= isBackup;
            try (VentusData.WriteLock writeLock = md.lockWrite();){
                Undo.insertEntry_breakChain(md);
                md.loadFrom(mdLoad);
                md.filename = mdLoad.filename;
                if (!isBackup) {
                    md.getEvents().added((Object)new RecentFilesEntry(md.filename));
                } else {
                    md.getEvents().changed(md, VentusData.MODEL_BACKUP_RESTORED);
                }
                System.gc();
            }
            Open.printImportedGeomFaceCount(md);
            boolean bl = true;
            return bl;
        }
        finally {
            app.endWaitCursor();
        }
    }

    private static void printImportedGeomFaceCount(VentusData md) {
        final int[] n = new int[]{0};
        AABox bounds = md.geomLocation.getLocator().getBounds();
        Box3d finder = new Box3d(bounds);
        md.geomLocation.getLocator().find((ITest<AABox>)finder, (IResult<? super IDisplayableGeomSrc>)new IResult<IDisplayableGeomSrc>(){

            @Override
            public void mark(IDisplayableGeomSrc obj, Containment ctmt) {
                n[0] = n[0] + obj.getDisplayGeom(null).node.getNumPrims(1);
            }
        }, 0);
        System.out.printf("Imported geometry contains %s FACE primitives.%n", n[0]);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static VentusData openModel(VentusApp app, VentusIO io, ModelBackup backup, String filename) {
        JFrame parent = app.getActiveFrame();
        try {
            Serializable dlg;
            BiConsumer<TaskProgress, guiProgressMonitor.PMRunnable> execSkippableTask = (progress, task) -> {
                guiProgressMonitor monitor = new guiProgressMonitor(VentusApp.getApp().getMainFrame(), Intl.intl("Opening model..."), true, (TaskProgress)progress);
                monitor.setCancelText(Intl.intl("Skip"));
                monitor.setPopupDelay(2000);
                try {
                    monitor.exec((guiProgressMonitor.PMRunnable)task);
                }
                catch (ExecutionException e) {
                    throw new RuntimeException(e.getCause());
                }
            };
            VentusOIS.DecisionMaker decisions = new VentusOIS.DecisionMaker();
            VentusIO.OpenResult result = io.openModel(parent, filename, execSkippableTask, decisions, app.getComponents(IInputStreamFeatureHandler.class));
            if (!backup.createBackupFile(filename)) {
                JOptionPane.showMessageDialog(parent, Intl.intl("Failed to create backup on open."), Intl.intl("Error Creating Backup"), 2);
            }
            if (result.warnings != null && !result.warnings.isEmpty()) {
                dlg = WarningDlg.create(parent, Intl.intl("File Open Warnings"), "", result.warnings);
                ((guiDialog)dlg).doModal();
            }
            result.data.filename = filename;
            dlg = result.data;
            return dlg;
        }
        catch (CancelledException e) {
            VentusData decisions = null;
            return decisions;
        }
        catch (VentusIO.BadVersionException e) {
            String msg = String.format(Intl.intl("Could not open file: %s"), filename);
            guiUtil.showError(parent, Intl.intl("File Error"), msg, (Throwable)e);
            VentusData result = null;
            return result;
        }
        catch (IOException e) {
            Object msg = String.format(Intl.intl("Could not open file: %s"), filename);
            File bakFile = backup.getBackupFile(filename);
            if (bakFile == null) {
                guiUtil.showError(parent, Intl.intl("File Error"), (String)msg, (Throwable)e);
            } else {
                msg = guiUtil.formatError((String)msg, e);
                msg = (String)msg + "\n";
                int option = JOptionPane.showConfirmDialog(parent, msg = (String)msg + String.format(Intl.intl("Would you like to open the backup file, %s?"), bakFile.getAbsolutePath()), Intl.intl("Open Backup File?"), 0);
                if (option == 0) {
                    VentusData ventusData = Open.openModel(app, io, backup, bakFile.getAbsolutePath());
                    return ventusData;
                }
            }
            VentusData ventusData = null;
            return ventusData;
        }
        finally {
            System.gc();
        }
    }
}

