/*
 * Decompiled with CFR 0.152.
 */
package ventus.actions;

import java.awt.Window;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.TreeSet;
import java.util.function.Consumer;
import java.util.function.Predicate;
import javax.swing.Icon;
import javax.swing.JOptionPane;
import javax.vecmath.Point3d;
import javax.vecmath.Tuple3d;
import javax.vecmath.Vector3d;
import org.jscience.physics.units.NonSI;
import org.jscience.physics.units.SI;
import thunderheadeng.geometry.AABox;
import thunderheadeng.geometry.AABoxTest;
import thunderheadeng.geometry.IParametric3D;
import thunderheadeng.geometry.Inter3D;
import thunderheadeng.geometry.LineSeg3D;
import thunderheadeng.geometry.Plane3d;
import thunderheadeng.geometry.Util;
import thunderheadeng.geometry.Util3D;
import thunderheadeng.geometry.nmt.Edge;
import thunderheadeng.geometry.nmt.EdgeUse;
import thunderheadeng.geometry.nmt.Face;
import thunderheadeng.geometry.nmt.FaceLoop;
import thunderheadeng.geometry.nmt.Model;
import thunderheadeng.geometry.objs.node.IGeomNode;
import thunderheadeng.geometry.objs.transform.TransformInfo;
import thunderheadeng.geometry.objs.transform.TransformUtil;
import thunderheadeng.geometry.search.Containment;
import thunderheadeng.geometry.search.IResult;
import thunderheadeng.geometry.search.ITest;
import thunderheadeng.scene3d.geom.IDisplayableGeomSrc;
import thunderheadeng.units.UnitDouble;
import thunderheadeng.util.Events;
import thunderheadeng.util.IEventObserver;
import thunderheadeng.util.LinkedIdentityHashSet;
import thunderheadeng.util.Pair;
import thunderheadeng.util.theUtil;
import ventus.Intl;
import ventus.VentusApp;
import ventus.actions.AMerlinOp;
import ventus.actions.AddObject;
import ventus.actions.Delete;
import ventus.actions.MerlinOp;
import ventus.actions.SelectionObserver;
import ventus.actions.UIHook;
import ventus.actions.Undo;
import ventus.data.Composite;
import ventus.data.ICompElement;
import ventus.data.IMerlinObj;
import ventus.data.IRestorable;
import ventus.data.VentusData;
import ventus.data.schematics.Floor;
import ventus.data.schematics.ISchematicObj;
import ventus.data.schematics.elevators.Elevator;
import ventus.data.schematics.elevators.ElevatorDoor;
import ventus.data.schematics.elevators.ElevatorRoom;
import ventus.data.schematics.elevators.ElevatorUtil;
import ventus.data.schematics.elevators.ITimingModel;
import ventus.data.schematics.geom.ISchematicConnector;
import ventus.data.schematics.geom.ISchematicRoom;
import ventus.data.schematics.geom.SchematicCorridor;
import ventus.data.schematics.geom.SchematicDoor;
import ventus.data.schematics.geom.SchematicRoom;
import ventus.geom.Geometry;
import ventus.geom.IMerlinGeomSrc;
import ventus.gui.NewElevatorDlg;

public class CreateElevator
extends AMerlinOp
implements IEventObserver {
    public static final Icon ICON = UIHook.loadIcon("ventus/icons/elevator16.png");
    public static final UIHook UI_HOOK = new UIHook((MerlinOp)new CreateElevator(), Intl.intl("Create Elevator...,-,Create an Elevator based on the selected room."), ICON);
    private static NewElevatorDlg s_elevatorDlg = null;

    public CreateElevator() {
        SelectionObserver.add(this, SchematicRoom.class);
        this.update(null);
    }

    @Override
    public void update(Events events) {
        VentusData md = VentusApp.getApp().getData();
        this.setEnabled(md.selection.isExclusive(SchematicRoom.class) && !md.selection.isExclusive(ElevatorRoom.class) && md.selection.getSelectionCount(SchematicRoom.class) == 1);
    }

    public static ITimingModel getLastTimingModel() {
        return s_elevatorDlg == null ? ITimingModel.DEF_MODEL : s_elevatorDlg.getTimingModel();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run(VentusApp app, VentusData md) {
        Set sel = md.selection.getSelected(SchematicRoom.class);
        if (sel.size() != 1 || sel.iterator().next() instanceof ElevatorRoom) {
            return;
        }
        NewElevatorInfo createInfo = null;
        boolean selectDeletes = false;
        if (s_elevatorDlg == null) {
            s_elevatorDlg = new NewElevatorDlg((Window)app.getActiveFrame(), md);
        }
        SchematicRoom initBaseRoom = (SchematicRoom)sel.iterator().next();
        s_elevatorDlg.load(md, md.elevators.getNameGen().getCurrentName(), initBaseRoom);
        if (s_elevatorDlg.doModal() != 1) {
            return;
        }
        SchematicRoom baseRoom = s_elevatorDlg.getBaseRoom();
        createInfo = CreateElevator.getNewElevatorInfo(md, baseRoom, s_elevatorDlg.getTravelDir(), s_elevatorDlg.getFloorBounds());
        int numDeletes = createInfo.deletes.size() - 1 - baseRoom.getDoors().size();
        if (numDeletes > 0) {
            String msg = String.format(Intl.intl("Creation of the elevator shaft requires %d objects to be deleted.\nWould you like to continue (Click No to highlight the deletion objects)?"), createInfo.deletes.size());
            int option = JOptionPane.showConfirmDialog(app.getActiveFrame(), msg, Intl.intl("Delete Objects in Elevator Shaft?"), 1, 3);
            if (option == 1) {
                selectDeletes = true;
            } else if (option != 0) {
                return;
            }
        }
        Exception exc = null;
        try (VentusData.WriteLock lock = md.lockWrite();){
            if (selectDeletes) {
                Undo.begin(Intl.intl("Select Deletion Objects"));
                Undo.insertUndoEntry_restoreSelection(md);
                md.selection.set(createInfo.deletes);
                Undo.end(md);
                return;
            }
            Undo.begin(Intl.intl("Create Elevator"));
            try {
                CreateElevator.createElevator(md, s_elevatorDlg.getName(), s_elevatorDlg.getNominalLoad(), createInfo, s_elevatorDlg.getBaseRoom(), s_elevatorDlg.getTimingModel(), s_elevatorDlg.getCallDistance(), s_elevatorDlg.isDoubleDeck());
                md.elevators.getNameGen().nextName();
                SchematicRoom.cleanup(md, createInfo.toClean);
                Undo.end(md, exc == null);
            }
            catch (Exception e) {
                try {
                    exc = e;
                    Undo.end(md, exc == null);
                }
                catch (Throwable throwable) {
                    Undo.end(md, exc == null);
                    throw throwable;
                }
            }
        }
        if (exc != null) {
            exc.printStackTrace();
            app.error(Intl.intl("Elevator Create Error"), String.format(Intl.intl("The elevator could not be created:%n%s"), exc.getLocalizedMessage()));
        }
    }

    public static NewElevatorInfo getNewElevatorInfo(final VentusData md, final SchematicRoom baseRoom, Vector3d travelDir, Floor[] floorBounds) {
        Vector3d[] extrudeVecs = CreateElevator.getExtrusionVecs(md, baseRoom, travelDir, floorBounds);
        Model[] shafts = CreateElevator.getElevatorShafts(md, baseRoom, extrudeVecs[0], extrudeVecs[1]);
        final UnitDouble minz = floorBounds[0] != null ? floorBounds[0].getWorkingZ() : new UnitDouble(Double.NEGATIVE_INFINITY, SI.METER);
        final UnitDouble maxz = floorBounds[1] != null ? floorBounds[1].getWorkingZ() : new UnitDouble(Double.POSITIVE_INFINITY, SI.METER);
        LinkedIdentityHashSet<IMerlinObj> delComponents = new LinkedIdentityHashSet<IMerlinObj>();
        Predicate<SchematicRoom> roomFilter = new Predicate<SchematicRoom>(){

            @Override
            public boolean test(SchematicRoom o) {
                if (o instanceof ElevatorRoom || o == baseRoom) {
                    return false;
                }
                UnitDouble floorz = ElevatorUtil.getFloor(md, o).getWorkingZ();
                return floorz.compareTo(minz) >= 0 && floorz.compareTo(maxz) <= 0;
            }
        };
        ArrayList<Pair<SchematicRoom, IGeomNode>> roomChanges = new ArrayList<Pair<SchematicRoom, IGeomNode>>();
        ArrayList<SchematicRoom> toClean = new ArrayList<SchematicRoom>();
        for (Model shaft : shafts) {
            CreateElevator.subtractShaft(md, shaft, roomFilter, roomChanges, delComponents, toClean::add);
        }
        Set<ISchematicConnector> baseDoors = baseRoom.getDoors();
        delComponents.add(baseRoom);
        delComponents.addAll(baseDoors);
        delComponents.addAll(Delete.collectObjs(md, delComponents));
        return new NewElevatorInfo(roomChanges, delComponents, extrudeVecs, roomFilter, toClean);
    }

    public static void createElevator(VentusData md, String name, UnitDouble nominalLoad, NewElevatorInfo elevatorChanges, SchematicRoom baseRoom, ITimingModel timing, UnitDouble callDistance, boolean isDoubleDeck) throws Exception {
        for (Pair<SchematicRoom, IGeomNode> roomChange : elevatorChanges.roomChanges) {
            Undo.insertUndoEntry_restore(md, (IRestorable)roomChange.v1);
            ((SchematicRoom)roomChange.v1).setGeom((IGeomNode)roomChange.v2);
        }
        Delete.deleteAll(md, elevatorChanges.deletes);
        List<Vector3d> offsets = CreateElevator.findConnectionOffsets(md, baseRoom, elevatorChanges.extrudeVecs[0], elevatorChanges.extrudeVecs[1], elevatorChanges.roomFilter);
        List<ElevatorRoom> erooms = CreateElevator.createElevatorRooms(baseRoom, offsets);
        if (erooms.isEmpty()) {
            throw new Exception(Intl.intl("Resulting elevator did not connect to any floor geometry."));
        }
        assert (erooms.size() == offsets.size());
        Elevator elevator = new Elevator(name);
        elevator.addAll(erooms);
        elevator.setDoubleDeck(isDoubleDeck);
        ElevatorRoom dischargeRoom = erooms.get(0);
        for (int m = 0; m < offsets.size(); ++m) {
            Vector3d offset = offsets.get(m);
            ElevatorRoom er = erooms.get(m);
            double offsetDist = offset.length();
            if (theUtil.eq0(offsetDist, 1.0E-6)) {
                dischargeRoom = er;
            }
            er.setName(null);
            double travelTime = timing.getTime(offsetDist);
            UnitDouble travelTimeUD = new UnitDouble(travelTime, SI.SECOND);
            Elevator.LevelData ld = new Elevator.LevelData(new UnitDouble(timing.getOpenCloseTimes()[0], SI.SECOND), new UnitDouble(timing.getOpenCloseTimes()[1], SI.SECOND), travelTimeUD, travelTimeUD, new UnitDouble(0.0, SI.SECOND));
            elevator.setLevelData(erooms.get(m), ld);
        }
        elevator.setDischargeRoom(dischargeRoom);
        elevator.setInitRoom(dischargeRoom);
        elevator.setNominalLoad(nominalLoad);
        elevator.setCallDistance(callDistance);
        AddObject.add((VentusData)md, (Composite)md.elevators, (int)md.elevators.getMembers().size(), (ICompElement[])new Elevator[]{elevator});
    }

    private static Vector3d[] getExtrusionVecs(VentusData md, SchematicRoom baseRoom, Vector3d travelDir, Floor[] floorBounds) {
        Floor topFloor;
        Floor nextFloor;
        AABox modelBounds = floorBounds[0] == null || floorBounds[1] == null ? CreateElevator.getBounds(md.floors) : null;
        AABox baseBox = baseRoom.getBounds();
        AABox bottomBounds = floorBounds[0] != null ? CreateElevator.getBounds(floorBounds[0]) : modelBounds;
        AABox topBounds = floorBounds[1] != null ? CreateElevator.getBounds(floorBounds[1]) : modelBounds;
        double minz = bottomBounds.getMinZ() - baseBox.getHeight();
        double maxz = topBounds.getMaxZ();
        if (floorBounds[1] != null && maxz > floorBounds[1].getWorkingZ().getValue(Geometry.LENGTH_UNIT) && (nextFloor = CreateElevator.getNextFloorUp(md, topFloor = floorBounds[1])) != null) {
            double topz = topFloor.getWorkingZ().getValue(Geometry.LENGTH_UNIT);
            double nextz = nextFloor.getWorkingZ().getValue(Geometry.LENGTH_UNIT);
            double maxz1 = nextz - UnitDouble.convert(6.0, NonSI.INCH, Geometry.LENGTH_UNIT);
            if (maxz1 < topz) {
                maxz1 = (topz + nextz) * 0.5;
            }
            if (maxz > maxz1) {
                maxz = maxz1;
            }
        }
        double distTop = Inter3D.linePlaneIntersectionT(baseBox.getMin(), travelDir, new Plane3d(0.0, 0.0, 1.0, -maxz), 1.0E-6);
        double distBottom = Inter3D.linePlaneIntersectionT(baseBox.getMin(), travelDir, new Plane3d(0.0, 0.0, 1.0, -minz), 1.0E-6);
        return new Vector3d[]{Util3D.scale(travelDir, distBottom), Util3D.scale(travelDir, distTop)};
    }

    private static Floor getNextFloorUp(VentusData md, Floor topFloor) {
        UnitDouble topFloorLoc = topFloor.getWorkingZ();
        Floor nextFloor = null;
        UnitDouble nextFloorDiff = new UnitDouble(Double.POSITIVE_INFINITY, SI.METER);
        for (Floor floor : md.floors.getDeepMembers(Floor.class)) {
            UnitDouble diff;
            if (floor == topFloor || !theUtil.gt0((diff = floor.getWorkingZ().sub(topFloorLoc)).getValueNoUnit(), 1.0E-6) || diff.compareTo(nextFloorDiff) >= 0) continue;
            nextFloor = floor;
            nextFloorDiff = diff;
        }
        return nextFloor;
    }

    private static boolean isInternalDoor(ISchematicConnector door) {
        ISchematicRoom[] rooms = door.getConnectedComps();
        return rooms[0] == rooms[1];
    }

    private static Model[] getElevatorShafts(VentusData md, SchematicRoom baseRoom, Vector3d translateBottom, Vector3d translateTop) {
        ArrayList<Model> extrudeModels = new ArrayList<Model>();
        extrudeModels.add(baseRoom.getModel().clone());
        for (ISchematicConnector door : baseRoom.getDoors()) {
            if (CreateElevator.isInternalDoor(door) || !(door instanceof SchematicDoor) || ((SchematicDoor)door).isThin()) continue;
            SchematicDoor ed = (SchematicDoor)door;
            Model doorModel = ed.getDoorGeom().asModel();
            int[] groupid = new int[]{1};
            for (Edge edge : doorModel.getEdges()) {
                edge.groups = groupid;
            }
            extrudeModels.add(doorModel);
        }
        TransformInfo tbottom = TransformUtil.translate(translateBottom.x, translateBottom.y, translateBottom.z).getInfo();
        TransformInfo ttop = TransformUtil.translate(translateTop.x, translateTop.y, translateTop.z).getInfo();
        ArrayList<Model> shafts = new ArrayList<Model>(extrudeModels.size());
        Iterator iterator = extrudeModels.iterator();
        while (iterator.hasNext()) {
            Model model;
            Model bottom = model = (Model)iterator.next();
            Model top = model.clone();
            bottom.transform(tbottom.xform, tbottom.getMatrix());
            top.transform(ttop.xform, ttop.getMatrix());
            ArrayList<IParametric3D> extrudeWalls = new ArrayList<IParametric3D>();
            for (Face face : model.getFaces()) {
                for (FaceLoop loop : face.edgeLoops) {
                    for (EdgeUse eu : loop.edges) {
                        if (!eu.edge.partOfGroup(1) || face.isInternalEdge(eu.edge)) continue;
                        extrudeWalls.add(eu.edge.curve);
                    }
                }
            }
            if (extrudeWalls.isEmpty()) continue;
            Vector3d translateVec = Util3D.sub(translateTop, (Tuple3d)translateBottom);
            for (IParametric3D wall : extrudeWalls) {
                Point3d p4;
                Point3d p3;
                Point3d p2;
                Point3d p1 = wall.get(0.0);
                if (model.addFace(0, new Plane3d(true, p1, p2 = wall.get(1.0), p3 = Util3D.add(p2, (Tuple3d)translateVec), p4 = Util3D.add(p1, (Tuple3d)translateVec)), Arrays.asList(new LineSeg3D(p1, p2), new LineSeg3D(p2, p3), new LineSeg3D(p3, p4), new LineSeg3D(p4, p1)))) continue;
            }
            model.merge(top);
            shafts.add(model);
        }
        return shafts.toArray(new Model[shafts.size()]);
    }

    private static AABox getBounds(Composite<?> group) {
        AABox bounds = new AABox();
        for (IMerlinGeomSrc geom : group.getDeepMembers(IMerlinGeomSrc.class)) {
            bounds.add(geom.getBounds());
        }
        return bounds;
    }

    private static <T extends ISchematicObj> List<T> findObjs(VentusData md, AABox testBox, Class<T> clazz, Predicate<SchematicRoom> roomFilter) {
        return CreateElevator.findObjs(md, new AABoxTest(testBox, 1.0E-6), clazz, roomFilter);
    }

    private static <T extends ISchematicObj> List<T> findObjs(VentusData md, ITest<AABox> test, final Class<T> clazz, final Predicate<SchematicRoom> roomFilter) {
        final ArrayList rooms = new ArrayList();
        IResult<IDisplayableGeomSrc> potGeomResult = new IResult<IDisplayableGeomSrc>(){

            @Override
            public void mark(IDisplayableGeomSrc obj, Containment ctmt) {
                if (obj instanceof SchematicRoom && !roomFilter.test((SchematicRoom)obj)) {
                    return;
                }
                if (clazz.isInstance(obj)) {
                    rooms.add((ISchematicObj)obj);
                }
            }
        };
        md.geomLocation.getLocator().find(test, (IResult<? super IDisplayableGeomSrc>)potGeomResult, 1);
        return rooms;
    }

    private static void subtractShaft(VentusData md, Model shaft, Predicate<SchematicRoom> subtractFilter, List<Pair<SchematicRoom, IGeomNode>> roomChanges, Collection<? super ISchematicObj> delObjs, Consumer<SchematicRoom> toClean) {
        AABox shaftBounds = shaft.getBoundingBox();
        List<ISchematicObj> subGeom = CreateElevator.findObjs(md, shaftBounds, ISchematicObj.class, subtractFilter);
        for (ISchematicObj obj : subGeom) {
            SchematicCorridor corridor;
            if (obj instanceof SchematicRoom) {
                SchematicRoom room = (SchematicRoom)obj;
                SchematicRoom modRoom = room.clone();
                if (!modRoom.subVolume(shaft)) continue;
                if (modRoom.getModel().getFaces().isEmpty()) {
                    delObjs.add(room);
                    continue;
                }
                roomChanges.add(new Pair<SchematicRoom, IGeomNode>(room, modRoom.getGeom()));
                toClean.accept(room);
                continue;
            }
            if (obj instanceof SchematicDoor) {
                SchematicDoor door = (SchematicDoor)obj;
                Point3d[] boundary = door.getDoorGeom().getBoundary();
                if (!shaft.contains(Util3D.getMidPoint(boundary[0], boundary[1])) && (boundary.length != 4 || !shaft.contains(Util3D.getMidPoint(boundary[2], boundary[3])))) continue;
                delObjs.add(door);
                continue;
            }
            if (!(obj instanceof SchematicCorridor) || !shaft.contains((corridor = (SchematicCorridor)obj).getDoor1().getEdge().evaluate(0.5)) && !shaft.contains(corridor.getDoor2().getEdge().evaluate(0.5))) continue;
            delObjs.add(corridor);
        }
    }

    private static List<Vector3d> findConnectionOffsets(VentusData md, SchematicRoom baseRoom, Vector3d extrudeBottom, Vector3d extrudeTop, Predicate<SchematicRoom> connectionFilter) {
        TreeSet<Vector3d> offsets = new TreeSet<Vector3d>(new Comparator<Vector3d>(){

            @Override
            public int compare(Vector3d o1, Vector3d o2) {
                return theUtil.compare(o1.z, o2.z, 0.001);
            }
        });
        Vector3d extrudeDir = extrudeBottom.lengthSquared() == 0.0 ? extrudeTop : extrudeBottom;
        for (ISchematicConnector door : baseRoom.getDoors()) {
            ISchematicRoom[] rooms;
            if (CreateElevator.isInternalDoor(door) || !(door instanceof SchematicDoor)) continue;
            SchematicDoor ed = (SchematicDoor)door;
            Point3d[] boundary = ed.getDoorGeom().getBoundary();
            LineSeg3D extrudeEdge = boundary.length == 2 ? new LineSeg3D(boundary[0], boundary[1]) : ((rooms = door.getConnectedComps())[0] != baseRoom ? new LineSeg3D(boundary[0], boundary[1]) : new LineSeg3D(boundary[2], boundary[3]));
            LineSeg3D bottom = extrudeEdge.transform(Util.translateMat(extrudeBottom.x, extrudeBottom.y, extrudeBottom.z));
            LineSeg3D top = extrudeEdge.transform(Util.translateMat(extrudeTop.x, extrudeTop.y, extrudeTop.z));
            LineSeg3D side1 = new LineSeg3D(bottom.p1, top.p1);
            LineSeg3D side2 = new LineSeg3D(bottom.p2, top.p2);
            Model model = new Model();
            model.addFace(Integer.MAX_VALUE, new Plane3d(true, bottom.p1, bottom.p2, top.p2, top.p1), Arrays.asList(bottom, side2, top, side1));
            AABox testBounds = model.getBoundingBox();
            List<SchematicRoom> potConnectRooms = CreateElevator.findObjs(md, testBounds, SchematicRoom.class, connectionFilter);
            for (SchematicRoom potRoom : potConnectRooms) {
                LineSeg3D isectEdge = CreateElevator.findIntersectEdge(potRoom.getModel(), model);
                if (isectEdge == null || !theUtil.eq(isectEdge.lengthSq(), bottom.lengthSq(), 1.0E-12)) continue;
                Point3d closePt = Inter3D.distSqToNearestPtOnLine(extrudeEdge.p1, extrudeDir, isectEdge.p1) < Inter3D.distSqToNearestPtOnLine(extrudeEdge.p1, extrudeDir, isectEdge.p2) ? isectEdge.p1 : isectEdge.p2;
                Vector3d offset = Util3D.vector(extrudeEdge.p1, closePt);
                offsets.add(offset);
            }
        }
        return new ArrayList<Vector3d>(offsets);
    }

    private static LineSeg3D findIntersectEdge(Model model, Model extrudedEdgeModel) {
        model = model.clone();
        extrudedEdgeModel = extrudedEdgeModel.clone();
        model.merge(extrudedEdgeModel);
        ArrayList<LineSeg3D> isectEdges = new ArrayList<LineSeg3D>();
        for (Edge edge : model.getEdges()) {
            if (edge.groups.length <= 1 || !edge.partOfGroup(Integer.MAX_VALUE)) continue;
            isectEdges.add(new LineSeg3D(edge.curve.get(0.0), edge.curve.get(1.0)));
        }
        return isectEdges.size() == 1 ? (LineSeg3D)isectEdges.get(0) : null;
    }

    private static List<ElevatorRoom> createElevatorRooms(SchematicRoom baseRoom, List<Vector3d> offsets) {
        Set<ISchematicConnector> baseDoors = baseRoom.getDoors();
        ArrayList<ElevatorRoom> erooms = new ArrayList<ElevatorRoom>(offsets.size());
        for (Vector3d offset : offsets) {
            TransformInfo ti = TransformUtil.translate(offset.x, offset.y, offset.z).getInfo();
            ArrayList<ElevatorDoor> edoors = new ArrayList<ElevatorDoor>(baseDoors.size());
            for (ISchematicConnector door : baseDoors) {
                if (!(door instanceof SchematicDoor)) continue;
                ElevatorDoor ed = new ElevatorDoor((SchematicDoor)door);
                ed.transform(ti);
                edoors.add(ed);
            }
            ElevatorRoom er = new ElevatorRoom(baseRoom, edoors);
            er.transform(ti);
            erooms.add(er);
        }
        return erooms;
    }

    public static void distributeFloorTimes(VentusData md, Elevator elevator, ITimingModel timing) {
        Undo.insertUndoEntry_propRestore(md, Arrays.asList(elevator), Elevator.PROP_LEVEL_DATA);
        ElevatorRoom discharge = elevator.getDischargeRoom();
        Point3d basePt = discharge.getBounds().getMin();
        for (ElevatorRoom er : elevator.getDeepMembers(ElevatorRoom.class)) {
            Point3d erPt = er.getBounds().getMin();
            double dist = erPt.distance(basePt);
            UnitDouble time = new UnitDouble(timing.getTime(dist), SI.SECOND);
            Elevator.LevelData oldData = elevator.getLevelData(er);
            elevator.setLevelData(er, new Elevator.LevelData(new UnitDouble(timing.getOpenCloseTimes()[0], SI.SECOND), new UnitDouble(timing.getOpenCloseTimes()[1], SI.SECOND), time, time, oldData.delay));
        }
    }

    private static class NewElevatorInfo {
        public final List<Pair<SchematicRoom, IGeomNode>> roomChanges;
        public final Set<IMerlinObj> deletes;
        public final Vector3d[] extrudeVecs;
        public final Predicate<SchematicRoom> roomFilter;
        public final Collection<SchematicRoom> toClean;

        public NewElevatorInfo(List<Pair<SchematicRoom, IGeomNode>> roomChanges, Set<IMerlinObj> deletes, Vector3d[] extrudeVecs, Predicate<SchematicRoom> roomFilter, Collection<SchematicRoom> toClean) {
            this.roomChanges = roomChanges;
            this.deletes = deletes;
            this.extrudeVecs = extrudeVecs;
            this.roomFilter = roomFilter;
            this.toClean = toClean;
        }
    }
}

