/*
 * Decompiled with CFR 0.152.
 */
package ventus.actions;

import java.awt.Window;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.function.Predicate;
import javax.swing.AbstractButton;
import javax.vecmath.Point3d;
import org.jscience.physics.units.NonSI;
import org.jscience.physics.units.SI;
import thunderheadeng.geometry.LineSeg3D;
import thunderheadeng.geometry.nmt.Edge;
import thunderheadeng.geometry.nmt.Model;
import thunderheadeng.gui.GridBagHelper;
import thunderheadeng.gui.LinkStatus;
import thunderheadeng.gui.guiCheckBox;
import thunderheadeng.gui.guiDialog;
import thunderheadeng.units.UnitDouble;
import thunderheadeng.units.UnitDoubleVR;
import thunderheadeng.util.Events;
import thunderheadeng.util.IEventObserver;
import thunderheadeng.util.LinkedIdentityHashMap;
import thunderheadeng.util.LinkedIdentityHashSet;
import thunderheadeng.util.Nullable;
import thunderheadeng.util.TaskProgress;
import thunderheadeng.util.theUtil;
import ventus.Intl;
import ventus.VentusApp;
import ventus.actions.AMerlinOp;
import ventus.actions.Delete;
import ventus.actions.SelectionObserver;
import ventus.actions.UIHook;
import ventus.actions.Undo;
import ventus.actions.geomops.SeparateGeom;
import ventus.data.GeomComposite;
import ventus.data.VentusData;
import ventus.data.schematics.FloorComposite;
import ventus.data.schematics.geom.SchematicModelGeom;
import ventus.data.schematics.geom.SchematicRoom;
import ventus.geom.Geometry;
import ventus.geom.ModelConstrictor;
import ventus.gui.MerlinUDF;
import ventus.unitsystem.SIUS;

public class CloseGapsAction
extends AMerlinOp
implements IEventObserver {
    public static final UIHook UI_HOOK = new UIHook(new CloseGapsAction(), Intl.intl("Close Gaps...,-,Close small gaps in the room by adding boundary edges."));
    private UnitDouble d_gapTol = new UnitDouble(6.0, NonSI.INCH);
    private UnitDouble d_minRoomArea = CloseGapsAction.mulArea(this.d_gapTol, this.d_gapTol);

    public CloseGapsAction() {
        SelectionObserver.add(this, Object.class);
        this.update(null);
    }

    protected Set<SchematicRoom> getValidRooms(VentusData md) {
        return theUtil.filter(md.selection.getDeepSelected(SchematicRoom.class), new Predicate<SchematicRoom>(this){

            @Override
            public boolean test(SchematicRoom o) {
                return o.getModificationsAllowed();
            }
        });
    }

    @Override
    public void update(Events events) {
        this.setEnabled(VentusApp.getApp().getData().selection.isExclusive(SchematicRoom.class, FloorComposite.class, GeomComposite.class));
    }

    @Override
    public void run(VentusApp app, VentusData md) {
        MerlinUDF tolFld = new MerlinUDF(4);
        tolFld.setValueRange(UnitDoubleVR.above(0.0, SI.METER, false));
        tolFld.setValue(this.d_gapTol);
        guiCheckBox keepLargeRoomsCB = new guiCheckBox(Intl.intl("Delete small, split-off rooms"), this.d_minRoomArea != null);
        MerlinUDF minRoomAreaFld = new MerlinUDF(2);
        minRoomAreaFld.setValueRange(UnitDoubleVR.above(0.0, SIUS.unit(2), false));
        minRoomAreaFld.setValue(this.d_minRoomArea == null ? CloseGapsAction.mulArea(this.d_gapTol, this.d_gapTol) : this.d_minRoomArea);
        LinkStatus.link((AbstractButton)keepLargeRoomsCB, minRoomAreaFld);
        guiDialog dlg = new guiDialog((Window)app.getActiveFrame(), Intl.intl("Close Gaps"), 9);
        GridBagHelper gb = new GridBagHelper(dlg.getDialogPane());
        gb.addRow(Intl.intl("Close gaps smaller than:"), tolFld);
        gb.addRow(keepLargeRoomsCB, 0);
        gb.addIdentRow(Intl.intl("Minimum room area:"), minRoomAreaFld);
        gb.finalizeRows();
        if (dlg.doModal() != 1) {
            return;
        }
        this.d_gapTol = (UnitDouble)tolFld.getValue();
        this.d_minRoomArea = !keepLargeRoomsCB.isSelected() ? null : (UnitDouble)minRoomAreaFld.getValue();
        TaskProgress progress = new TaskProgress();
        Optional<Nullable<Map>> optNewRoomGeom = this.execLongReadTaskNoThrow(app, md, Intl.intl("Closing Gaps"), progress, () -> {
            LinkedIdentityHashMap<SchematicRoom, Model> result = new LinkedIdentityHashMap<SchematicRoom, Model>();
            for (SchematicRoom room : this.getValidRooms(md)) {
                progress.check();
                Model model = room.getModel();
                Model newModel = CloseGapsAction.closeGaps(model, this.d_gapTol.getValue(Geometry.LENGTH_UNIT));
                if (newModel == model) continue;
                result.put(room, newModel);
            }
            progress.check();
            return result;
        });
        if (optNewRoomGeom.isEmpty()) {
            return;
        }
        Map newRoomGeom = (Map)optNewRoomGeom.get().val;
        try (VentusData.WriteLock lock = md.lockWrite();){
            Undo.begin(Intl.intl("Close Gaps"));
            for (Map.Entry entry : newRoomGeom.entrySet()) {
                SchematicRoom room = (SchematicRoom)entry.getKey();
                Model newModel = (Model)entry.getValue();
                Undo.insertUndoEntry_restore(md, room);
                room.setGeom(new SchematicModelGeom(newModel));
            }
            LinkedIdentityHashSet toClean = new LinkedIdentityHashSet();
            Map<SchematicRoom, List<SchematicRoom>> splitRooms = SeparateGeom.separate(md, newRoomGeom.keySet(), toClean::add);
            if (this.d_minRoomArea != null) {
                LinkedIdentityHashSet toDelete = new LinkedIdentityHashSet();
                for (Map.Entry<SchematicRoom, List<SchematicRoom>> entry : splitRooms.entrySet()) {
                    if (entry.getValue().size() <= 1) continue;
                    for (SchematicRoom room : entry.getValue()) {
                        UnitDouble area = room.getArea();
                        if (area.compareTo(this.d_minRoomArea) > 0) continue;
                        toDelete.add(room);
                    }
                }
                if (!toDelete.isEmpty()) {
                    toClean.removeAll(toDelete);
                    Delete.deleteAll(md, toDelete);
                }
            }
            SchematicRoom.cleanup(md, toClean);
            Undo.end(md);
        }
    }

    private static UnitDouble mulArea(UnitDouble a1, UnitDouble a2) {
        double d1 = a1.getValueNoUnit();
        double d2 = a2.getValue(a1.getUnit());
        double result = d1 * d2;
        return new UnitDouble(result, a1.getUnit().multiply(a1.getUnit()));
    }

    public static Model closeGaps(Model model, double gapSize) {
        return CloseGapsAction.closeGaps(model, gapSize, new ModelConstrictor.IEdgeClassifier(){

            @Override
            public boolean isBoundary(Edge edge) {
                return edge.partOfGroup(1);
            }

            @Override
            public boolean isInternal(Edge edge) {
                return !edge.partOfGroup(1);
            }

            @Override
            public boolean canSplit(Edge edge) {
                return true;
            }

            @Override
            public boolean isSplitTarget(Edge edge) {
                return this.isBoundary(edge);
            }
        });
    }

    public static Model closeGaps(Model model, double gapSize, ModelConstrictor.IEdgeClassifier ecfr) {
        if (gapSize <= 0.0) {
            return model;
        }
        Model result = model;
        try {
            List<List<Point3d>> constEdges = ModelConstrictor.findConstrictionEdges(model, ecfr, gapSize);
            for (List<Point3d> constEdge : constEdges) {
                for (int m = 0; m < constEdge.size() - 1; ++m) {
                    Point3d p1 = constEdge.get(m);
                    Point3d p2 = constEdge.get(m + 1);
                    if (result == model) {
                        result = model.clone();
                    }
                    result.addEdge(1, new LineSeg3D(p1, p2));
                }
            }
        }
        catch (Throwable t) {
            t.printStackTrace();
            return model;
        }
        return result;
    }
}

