/*
 * Decompiled with CFR 0.152.
 */
package ventus;

import java.util.Collection;
import java.util.Set;
import java.util.function.Consumer;
import java.util.function.Predicate;
import ventus.data.Composite;
import ventus.data.ICompElement;
import ventus.data.IMerlinObj;
import ventus.data.INameGenerator;
import ventus.data.VentusData;
import ventus.treeview.TVEntryPoint;

public class EntryPoint<T> {
    public final Class<T> clazz;
    public final TVEntryPoint<T> tvEntryPoint;
    private final Getter<T, Collection<? extends IMerlinObj>> getOtherDeleteObjs;
    private final Getter<T, T> getConflict;
    private final Action<T, Boolean, Object> delete;
    private final Action<T, Exception, Set<? extends IMerlinObj>> checkDelete;
    private final Getter<T, Boolean> isAutoDeleteGroup;
    private final Getter<T, Boolean> isVisible;
    private final Setter<T, Boolean> setVisible;
    private final Getter<T, Composite<? extends ICompElement>> getRootComposite;
    private final Getter<T, INameGenerator> getNameGenerator;
    private final Getter<T, Boolean> isIndexed;
    private final Getter<T, Boolean> isMovable;
    private final Getter<T, String> typeString;
    private final Getter<T, INameGroup> getUniqueNameGroup;
    private final Getter<T, Predicate<String>> getNameFormat;

    public EntryPoint(Class<T> clazz, TVEntryPoint<T> tvEntryPoint, Action<T, Exception, Set<? extends IMerlinObj>> checkDelete, Getter<T, Collection<? extends IMerlinObj>> getOtherDeleteObjs, Getter<T, T> getConflict, Action<T, Boolean, Object> delete, Getter<T, Boolean> isAutoDeleteGroup, Getter<T, Boolean> isVisible, Setter<T, Boolean> setVisible, Getter<T, Composite<? extends ICompElement>> getRootComposite, Getter<T, INameGenerator> getNameGenerator, Getter<T, Boolean> isIndexed, Getter<T, Boolean> isMovable, Getter<T, String> typeString, Getter<T, INameGroup> getUniqueNameGroup, Getter<T, Predicate<String>> getNameFormat) {
        this.clazz = clazz;
        this.tvEntryPoint = tvEntryPoint;
        this.checkDelete = checkDelete;
        this.getOtherDeleteObjs = getOtherDeleteObjs;
        this.getConflict = getConflict;
        this.delete = delete;
        this.isAutoDeleteGroup = isAutoDeleteGroup;
        this.isVisible = isVisible;
        this.setVisible = setVisible;
        this.getRootComposite = getRootComposite;
        this.getNameGenerator = getNameGenerator;
        this.isIndexed = isIndexed;
        this.isMovable = isMovable;
        this.typeString = typeString;
        this.getUniqueNameGroup = getUniqueNameGroup;
        this.getNameFormat = getNameFormat;
    }

    public void checkDelete(VentusData md, T obj, Set<? extends IMerlinObj> delObjs) throws Exception {
        Exception exp = this.checkDelete.perform(md, obj, delObjs);
        if (exp != null) {
            throw exp;
        }
    }

    public void getOtherDeleteObjs(VentusData md, Set<IMerlinObj> otherObjs, T obj) {
        Collection<? extends IMerlinObj> others = this.getOtherDeleteObjs.get(md, obj);
        otherObjs.addAll(others);
    }

    public T getConflict(VentusData md, T comparable) {
        return this.getConflict.get(md, comparable);
    }

    public boolean delete(VentusData md, T obj) {
        return this.delete.perform(md, obj, null);
    }

    public boolean isAutoDeleteGroup(VentusData md, T obj) {
        return this.isAutoDeleteGroup.get(md, obj);
    }

    public boolean isIndexed(VentusData md, T obj) {
        return this.isIndexed.get(md, obj);
    }

    public boolean isMovable(VentusData md, T obj) {
        return this.isMovable.get(md, obj);
    }

    public String getTypeString(VentusData md, T obj) {
        return this.typeString.get(md, obj);
    }

    public INameGroup getUniqueNameGroup(VentusData vd, T obj) {
        return this.getUniqueNameGroup.get(vd, obj);
    }

    public Predicate<String> getNameFormat(VentusData vd, T obj) {
        return this.getNameFormat.get(vd, obj);
    }

    public boolean isVisible(VentusData md, T obj) {
        return this.isVisible.get(md, obj);
    }

    public void setVisible(VentusData md, T obj, boolean visible) {
        this.setVisible.set(md, obj, visible);
    }

    public Composite<? extends ICompElement> getRootComposite(VentusData md, T obj) {
        return this.getRootComposite.get(md, obj);
    }

    public INameGenerator getNameGenerator(VentusData md, T obj) {
        return this.getNameGenerator.get(md, obj);
    }

    public static interface Action<T, ReturnT, ArgT>
    extends Func<T> {
        public ReturnT perform(VentusData var1, T var2, ArgT var3);
    }

    public static interface Getter<T, ReturnT>
    extends Func<T> {
        public ReturnT get(VentusData var1, T var2);
    }

    public static interface Setter<T, ArgT>
    extends Func<T> {
        public void set(VentusData var1, T var2, ArgT var3);
    }

    public static interface INameGroup {
        public Collection<?> getSharedNameGroupObjs(VentusData var1);
    }

    public static interface AsyncGetter<T, ReturnT>
    extends Func<T> {
        public ReturnT get(VentusData var1, T var2, Consumer<ReturnT> var3);
    }

    public static interface Func<T> {
    }
}

