/*
 * Decompiled with CFR 0.152.
 */
package ventus.util;

import java.awt.Color;
import java.util.AbstractCollection;
import java.util.ArrayDeque;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.Random;
import java.util.Set;
import java.util.Stack;
import java.util.function.Predicate;
import javax.vecmath.Point3d;
import org.jscience.physics.units.Unit;
import thunderheadeng.units.IUnitSrc;
import thunderheadeng.units.UnitDouble;
import thunderheadeng.units.UnitPoint3D;
import thunderheadeng.util.Filters;
import thunderheadeng.util.Global;
import thunderheadeng.util.IdentityHashSet;
import thunderheadeng.util.theUtil;
import ventus.EntryPointFactory;
import ventus.VentusApp;
import ventus.data.Composite;
import ventus.data.ICompElement;
import ventus.data.IMerlinObj;
import ventus.data.INamed;
import ventus.data.MerlinHierarchy;
import ventus.data.VentusData;
import ventus.data.schematics.ISchematicObj;
import ventus.data.schematics.geom.ASchematicComp;
import ventus.data.schematics.geom.ISchematicComp;
import ventus.geom.Geometry;

public class MerlinUtil
extends theUtil {
    public static final boolean USE_ASTAR_SEARCH = false;

    public static UnitPoint3D getUPoint3D(Point3d p) {
        Unit curlu = VentusApp.getApp().getUnitSystem().getLength();
        return UnitPoint3D.convert(p, Geometry.LENGTH_UNIT, curlu);
    }

    public static String format(double v, Unit from, Unit to) {
        return Global.format(UnitDouble.convert(v, from, to), to);
    }

    public static String format(double v, Unit from, IUnitSrc unitType) {
        return MerlinUtil.format(v, from, unitType.getUnit());
    }

    public static String format(double v, Unit from, int unitType) {
        return MerlinUtil.format(v, from, VentusApp.getApp().getUnitSystem().getUnit(unitType));
    }

    public static String format(UnitDouble v, Unit to) {
        return MerlinUtil.format(v.getValueNoUnit(), v.getUnit(), to);
    }

    public static String format(UnitDouble v, IUnitSrc unitType) {
        return MerlinUtil.format(v.getValueNoUnit(), v.getUnit(), unitType.getUnit());
    }

    public static String format(UnitDouble v, int unitType) {
        return MerlinUtil.format(v.getValueNoUnit(), v.getUnit(), unitType);
    }

    public static String getName(IMerlinObj obj) {
        if (obj == null) {
            return "";
        }
        VentusData domain = (VentusData)obj.getDomain();
        if (domain == null && (domain = VentusApp.getAppData()) == null) {
            if (obj instanceof INamed) {
                return ((INamed)((Object)obj)).getName();
            }
            return obj.toString();
        }
        return EntryPointFactory.get(obj).tvEntryPoint.getName(domain, obj);
    }

    public static String getName(Object obj) {
        if (obj instanceof IMerlinObj) {
            return MerlinUtil.getName((IMerlinObj)obj);
        }
        if (obj instanceof INamed) {
            return ((INamed)obj).getName();
        }
        return obj == null ? "" : obj.toString();
    }

    public static String getNameWithBreadcrumbs(Object root, IMerlinObj mobj) {
        VentusData md = VentusApp.getApp().getData();
        Object[] path = md.hierarchy.getPath(mobj, root, false);
        StringBuilder desc = new StringBuilder();
        for (int m = 0; m < path.length; ++m) {
            String name;
            Object obj = path[m];
            if (!(obj instanceof IMerlinObj) || (name = MerlinUtil.getName((IMerlinObj)obj)) == null || name.isEmpty()) continue;
            if (desc.length() != 0) {
                desc.append("->");
            }
            desc.append(name);
        }
        return desc.toString();
    }

    public static <T> Collection<T> getEnabledMembers(VentusData md, Composite<? extends ICompElement> root, Class<T> type, boolean deep) {
        Collection<T> base = deep ? root.getDeepMembers(type) : root.getMembers(type);
        return MerlinUtil.getEnabledMembers(md, base, type);
    }

    public static <T> Collection<T> getEnabledMembers(VentusData md, Collection<?> objs, Class<T> type) {
        return theUtil.filter(objs, type, o -> EntryPointFactory.get(o).tvEntryPoint.isEnabled(md, o));
    }

    public static Collection<Object> flatten(Collection<?> objs) {
        return new DeepCollection<Object>(objs, Object.class, Filters.acceptAll());
    }

    public static <T> Collection<T> flatten(Collection<?> objs, Class<T> type) {
        return new DeepCollection<T>(objs, type, Filters.acceptAll());
    }

    public static <T> Collection<T> flatten(Collection<?> objs, Class<T> type, Predicate<? super T> filter) {
        return new DeepCollection<T>(objs, type, filter);
    }

    public static Collection<ICompElement> flattenComposites(Collection<? extends IMerlinObj> objs) {
        return MerlinUtil.flatten(objs, ICompElement.class, CompositeFilter.INSTANCE);
    }

    public static boolean test(int options, int option) {
        return (options & option) == option;
    }

    public static boolean isConnected(ISchematicComp source, ISchematicObj ... targets) {
        return MerlinUtil.isConnected(source, Arrays.asList(targets));
    }

    public static boolean isConnected(ISchematicComp source, Collection<? extends ISchematicObj> targets) {
        return MerlinUtil.isConnectedBruteForce(source, targets);
    }

    private static Set<? extends ISchematicObj> toSet(Collection<? extends ISchematicObj> objs) {
        if (objs instanceof Set) {
            return (Set)objs;
        }
        if (objs.isEmpty()) {
            return Collections.emptySet();
        }
        if (objs.size() == 1) {
            return Collections.singleton(objs.iterator().next());
        }
        return new IdentityHashSet<ISchematicObj>(objs);
    }

    private static boolean isConnectedBruteForce(ISchematicComp obj1, Collection<? extends ISchematicObj> targets) {
        for (ISchematicObj iSchematicObj : targets) {
            if (!MerlinUtil.isConnectedBruteForce(obj1, iSchematicObj)) continue;
            return true;
        }
        return false;
    }

    private static boolean isConnectedBruteForce(ISchematicComp obj1, ISchematicObj obj2) {
        if (obj1 == obj2) {
            return true;
        }
        IdentityHashSet closed = new IdentityHashSet();
        ArrayDeque<ISchematicObj> open = new ArrayDeque<ISchematicObj>();
        open.push(obj1);
        closed.add(obj1);
        while (!open.isEmpty()) {
            ISchematicObj comp = (ISchematicObj)open.pop();
            for (ISchematicObj iSchematicObj : comp.getConnections()) {
                if (iSchematicObj instanceof ASchematicComp && !((ASchematicComp)iSchematicObj).isEnabled()) continue;
                if (iSchematicObj == obj2) {
                    return true;
                }
                if (!(iSchematicObj instanceof ISchematicComp) || !closed.add(iSchematicObj)) continue;
                open.push(iSchematicObj);
            }
        }
        return false;
    }

    public static Color newRandomOccColor() {
        return MerlinUtil.newRandomOccColor(new Random());
    }

    public static Color newRandomOccColor(Random r) {
        return new Color(r.nextInt(256), r.nextInt(256), r.nextInt(256));
    }

    public static <T extends IMerlinObj> Comparator<T> getSorter(VentusData md, Collection<? extends T> items) {
        Set<Object> itemSet = items instanceof Set ? (Set<Object>)items : new IdentityHashSet<T>(items);
        boolean containsHierarchy = items.stream().anyMatch(item -> {
            Object o = item;
            while (o != null) {
                Object parent = md.hierarchy.getParent(o);
                if (itemSet.contains(parent)) {
                    return true;
                }
                o = parent;
            }
            return false;
        });
        if (containsHierarchy) {
            return new MerlinHierarchy.FlattenedComparator(md.hierarchy);
        }
        return new SortByName();
    }

    public static boolean isNonRoot(IMerlinObj obj) {
        return obj.getDomain() == null || obj.getParent() != obj.getDomain();
    }

    public static boolean containsAll(Collection<Double> items, double tol, double ... xs) {
        return Arrays.stream(xs).allMatch(x -> MerlinUtil.contains(items, tol, x));
    }

    public static boolean contains(Collection<Double> items, double tol, double x) {
        return items.stream().anyMatch(value -> Math.abs(x - value) < tol);
    }

    public static class DeepCollection<T>
    extends AbstractCollection<T> {
        private int d_size = -1;
        private final Class<T> d_typeFilter;
        private final Predicate<? super T> d_filter;
        private final Collection<?> d_objs;

        public DeepCollection(Object root, Class<T> typeFilter, Predicate<? super T> filter) {
            this(Collections.singleton(root), typeFilter, filter);
        }

        public DeepCollection(Collection<?> objs, Class<T> typeFilter, Predicate<? super T> filter) {
            this.d_typeFilter = typeFilter;
            this.d_filter = filter;
            this.d_objs = objs;
        }

        @Override
        public Iterator<T> iterator() {
            return new DeepIterator<T>(this.d_objs, this.d_typeFilter, this.d_filter);
        }

        @Override
        public int size() {
            if (this.d_size == -1) {
                this.d_size = 0;
                Iterator<T> it = this.iterator();
                while (it.hasNext()) {
                    ++this.d_size;
                    it.next();
                }
            }
            return this.d_size;
        }

        @Override
        public boolean isEmpty() {
            return !this.iterator().hasNext();
        }
    }

    public static class CompositeFilter<T>
    implements Predicate<T> {
        public static final CompositeFilter<Object> INSTANCE = new CompositeFilter();

        @Override
        public boolean test(T o) {
            return !(o instanceof Composite);
        }
    }

    public static class SortByName<T extends IMerlinObj>
    implements Comparator<T> {
        @Override
        public int compare(T o1, T o2) {
            String name1 = MerlinUtil.getName(o1);
            String name2 = MerlinUtil.getName(o2);
            return name1.compareToIgnoreCase(name2);
        }
    }

    private static class DeepIterator<T>
    implements Iterator<T> {
        private final Class<T> d_typeFilter;
        private final Predicate<? super T> d_filter;
        private final Stack<Iterator<?>> d_iteratorStack;
        private T d_nextObj;

        public DeepIterator(Collection<?> objs, Class<T> typeFilter, Predicate<? super T> filter) {
            this.d_typeFilter = typeFilter;
            this.d_filter = filter;
            this.d_iteratorStack = new Stack();
            this.d_iteratorStack.push(objs.iterator());
            this.prefetchNext();
        }

        private void prefetchNext() {
            while (!this.d_iteratorStack.isEmpty()) {
                Iterator<Object> curIt = this.d_iteratorStack.peek();
                while (curIt.hasNext()) {
                    Collection<? extends IMerlinObj> children;
                    boolean found = false;
                    Object next = curIt.next();
                    if (this.d_typeFilter.isInstance(next) && this.d_filter.test(next)) {
                        this.d_nextObj = next;
                        found = true;
                    }
                    if (next instanceof IMerlinObj && !(children = ((IMerlinObj)next).getChildren()).isEmpty()) {
                        curIt = children.iterator();
                        this.d_iteratorStack.push(curIt);
                    }
                    if (!found) continue;
                    return;
                }
                this.d_iteratorStack.pop();
            }
        }

        @Override
        public boolean hasNext() {
            return !this.d_iteratorStack.isEmpty();
        }

        @Override
        public T next() {
            T next = this.d_nextObj;
            this.prefetchNext();
            return next;
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }
    }
}

