/*
 * Decompiled with CFR 0.152.
 */
package ventus.mv.tools;

import javax.vecmath.Point2d;
import javax.vecmath.Point3d;
import thunderheadeng.geometry.Box3d;
import thunderheadeng.scene3d.nativebuffered.View;

public class ToolUtil {
    public static Box3d getCamFrustum(View view, Point2d center, double radius) {
        return ToolUtil.getCamFrustum(view, center, radius, radius);
    }

    public static Box3d getCamFrustum(View view, Point2d min, Point2d max) {
        double halfWidth = (max.x - min.x) * 0.5;
        double halfHeight = (max.y - min.y) * 0.5;
        Point2d center = new Point2d(min.x + halfWidth, min.y + halfHeight);
        return ToolUtil.getCamFrustum(view, center, halfWidth, halfHeight);
    }

    private static Box3d getCamFrustum(View view, Point2d center, double halfWidth, double halfHeight) {
        Point3d p1 = new Point3d(center.x - halfWidth, center.y - halfHeight, 0.0);
        Point3d p2 = new Point3d(center.x + halfWidth, center.y - halfHeight, 0.0);
        Point3d p3 = new Point3d(center.x + halfWidth, center.y + halfHeight, 0.0);
        Point3d p4 = new Point3d(center.x - halfWidth, center.y + halfHeight, 0.0);
        Point3d p5 = new Point3d(p1.x, p1.y, 1.0);
        Point3d p6 = new Point3d(p2.x, p2.y, 1.0);
        Point3d p7 = new Point3d(p3.x, p3.y, 1.0);
        Point3d p8 = new Point3d(p4.x, p4.y, 1.0);
        p1 = view.screenToWorld(p1);
        p2 = view.screenToWorld(p2);
        p3 = view.screenToWorld(p3);
        p4 = view.screenToWorld(p4);
        p5 = view.screenToWorld(p5);
        p6 = view.screenToWorld(p6);
        p7 = view.screenToWorld(p7);
        p8 = view.screenToWorld(p8);
        return new Box3d(p1, p2, p3, p4, p5, p6, p7, p8);
    }
}

