/*
 * Decompiled with CFR 0.152.
 */
package ventus.mv.gui;

import com.formdev.flatlaf.FlatLightLaf;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.EventQueue;
import java.awt.Insets;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import javax.swing.BorderFactory;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JSeparator;
import javax.swing.JTabbedPane;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import net.miginfocom.swing.MigLayout;
import thunderheadeng.gui.VerticalLabel;
import thunderheadeng.util.GroupedSequence;
import ventus.VentusApp;
import ventus.data.Composite;
import ventus.data.ICompElement;
import ventus.data.VentusData;
import ventus.feature.comps.ISelectionTab;
import ventus.mv.gui.SelectionEditorPanel;

public class SelectionPropertyEditorPanel
extends SelectionEditorPanel<ISelectionTab> {
    private static final long serialVersionUID = 1L;
    public static final String TAB_SHOWN = "tab-shown";
    private final JTabbedPane d_tabs;
    private final List<Component> d_tabPanes = new ArrayList<Component>();
    private final List<Component> d_fakeTabPanes = new ArrayList<Component>();
    int d_previousSelectionIx = -1;

    public static GroupedSequence getSelectionTabSeq() {
        GroupedSequence seq = new GroupedSequence("tabsRoot", 0, null);
        VentusApp.getApp().getComponents(ISelectionTab.class).forEach(tab -> tab.addToTabbedPane(seq));
        return seq;
    }

    public SelectionPropertyEditorPanel(VentusData vd) {
        super(vd, SelectionPropertyEditorPanel.getSelectionTabSeq());
        this.setLayout(new MigLayout("insets 0, gap 0, fill", "", ""));
        this.d_tabs = new JTabbedPane(4);
        this.d_tabs.putClientProperty("JTabbedPane.tabInsets", new Insets(12, 8, 12, 8));
        this.d_tabs.addChangeListener(e -> this.setTabPanelVis(this.d_tabs.getSelectedIndex() >= 0));
        this.d_tabs.addMouseListener(this.getCustomTabListener());
        this.setBorder(BorderFactory.createEmptyBorder());
        this.add((Component)this.d_tabs, "top, span, grow");
        this.updatePanels();
        this.updateLayout();
    }

    private MouseListener getCustomTabListener() {
        return new MouseListener(){

            @Override
            public void mouseClicked(MouseEvent e) {
                for (int i = 0; i < SelectionPropertyEditorPanel.this.d_tabs.getTabCount(); ++i) {
                    if (!SelectionPropertyEditorPanel.this.d_tabs.getBoundsAt(i).contains(e.getPoint()) || i != SelectionPropertyEditorPanel.this.d_previousSelectionIx) continue;
                    SelectionPropertyEditorPanel.this.d_tabs.setSelectedIndex(-1);
                }
                SelectionPropertyEditorPanel.this.d_previousSelectionIx = SelectionPropertyEditorPanel.this.d_tabs.getSelectedIndex();
            }

            @Override
            public void mousePressed(MouseEvent e) {
            }

            @Override
            public void mouseReleased(MouseEvent e) {
            }

            @Override
            public void mouseEntered(MouseEvent e) {
            }

            @Override
            public void mouseExited(MouseEvent e) {
            }
        };
    }

    private void setTabPanelVis(boolean show) {
        if (this.d_tabs.getTabCount() != this.d_tabPanes.size()) {
            return;
        }
        boolean wasShown = this.d_tabs.getComponentAt(0).equals(this.d_tabPanes.get(0));
        for (int i = 0; i < this.d_tabs.getTabCount(); ++i) {
            if (show) {
                this.d_tabs.setComponentAt(i, this.d_tabPanes.get(i));
                continue;
            }
            this.d_tabs.setComponentAt(i, this.d_fakeTabPanes.get(i));
        }
        SwingUtilities.updateComponentTreeUI(this);
        this.firePropertyChange(TAB_SHOWN, wasShown, show);
    }

    @Override
    protected List<SelectionEditorPanel.EditorPanel> getActivePanels(Set<ICompElement> objs) {
        Set<Object> propTypes = Composite.getPropTypes(2, objs);
        Set<Object> unshared = Composite.getPropTypes(0, objs);
        return new ArrayList<SelectionEditorPanel.EditorPanel>(this.loadEditorsFromRibbons(propTypes, unshared));
    }

    @Override
    protected void updateLayout() {
        EventQueue.invokeLater(() -> {
            this.d_previousSelectionIx = this.d_tabs.getSelectedIndex();
            this.d_fakeTabPanes.clear();
            this.d_tabPanes.clear();
            this.d_tabs.removeAll();
            for (SelectionEditorPanel.EditorPanel panel : this.d_activePanels) {
                this.addTab(panel);
            }
            this.d_tabs.setSelectedIndex(this.d_previousSelectionIx);
            SwingUtilities.updateComponentTreeUI(this);
        });
    }

    private void addTab(SelectionEditorPanel.EditorPanel panel) {
        Component styledPanel = this.appendHeader(panel);
        styledPanel.setName(panel.getTitle());
        this.d_tabPanes.add(styledPanel);
        JPanel proxyHidden = new JPanel();
        proxyHidden.setPreferredSize(new Dimension(0, 0));
        proxyHidden.setName(panel.getTitle() + " [proxy]");
        this.d_fakeTabPanes.add(proxyHidden);
        int currCount = this.d_tabs.getTabCount();
        this.d_tabs.addTab(null, styledPanel);
        this.d_tabs.setTabComponentAt(currCount, new VerticalLabel(panel.getTitle()));
    }

    private Component appendHeader(SelectionEditorPanel.EditorPanel panel) {
        JPanel wrapperPanel = new JPanel(new MigLayout("fillx, insets 6 6 6 0", "[][grow]", "[][]"));
        wrapperPanel.add(new JLabel(panel.getTitle()));
        wrapperPanel.add((Component)new JSeparator(), "growx, wrap");
        wrapperPanel.add((Component)panel, "grow, spanx");
        return wrapperPanel;
    }

    public JPanel getThemeAdjustedContainer() {
        JPanel wrapper = new JPanel(new BorderLayout());
        if (UIManager.getLookAndFeel().getClass().getName().equals("com.sun.java.swing.plaf.windows.WindowsLookAndFeel")) {
            wrapper.setBorder(BorderFactory.createEmptyBorder(0, 0, -1, 0));
        } else if (UIManager.getLookAndFeel().getClass().getName().equals(FlatLightLaf.class.getName())) {
            wrapper.setBorder(BorderFactory.createEmptyBorder(-1, 0, -1, 0));
        }
        wrapper.add((Component)new JSeparator(0), "North");
        wrapper.add((Component)this, "Center");
        wrapper.add((Component)new JSeparator(0), "South");
        return wrapper;
    }
}

