/*
 * Decompiled with CFR 0.152.
 */
package ventus.mv.gui;

import java.awt.Container;
import java.awt.LayoutManager;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import java.util.function.Supplier;
import thunderheadeng.gui.guiPanel;
import thunderheadeng.util.EventChannel;
import thunderheadeng.util.Events;
import thunderheadeng.util.GroupedSequence;
import thunderheadeng.util.IEventObserver;
import thunderheadeng.util.LinkedIdentityHashSet;
import thunderheadeng.util.theUtil;
import ventus.VentusApp;
import ventus.actions.CompElementActions;
import ventus.actions.Undo;
import ventus.data.ICompElement;
import ventus.data.MerlinSelectionModel;
import ventus.data.VentusData;
import ventus.feature.comps.ISelectionPanelProvider;
import ventus.gui.APropEditPanel;
import ventus.mv.gui.PropConnections;
import ventus.util.MerlinProps;

public abstract class SelectionEditorPanel<T extends ISelectionPanelProvider>
extends APropEditPanel<MerlinProps>
implements IEventObserver {
    private static final long serialVersionUID = 9219945208404511010L;
    protected VentusData d_md;
    protected List<EditorPanel> d_activePanels;
    protected Collection<T> d_ribbons = new LinkedIdentityHashSet<T>();

    public SelectionEditorPanel(VentusData md, GroupedSequence tabRoot) {
        super(new Object[0]);
        this.d_md = md;
        this.d_activePanels = Collections.EMPTY_LIST;
        this.d_md.getEvents().addObserver(this);
        tabRoot.traverse(obj -> {
            if (obj.current.data != null) {
                this.d_ribbons.add((ISelectionPanelProvider)obj.current.data);
            }
        });
    }

    public SelectionEditorPanel(VentusData md, Supplier<Collection<T>> panelProviders) {
        super(new Object[0]);
        this.d_md = md;
        this.d_activePanels = Collections.EMPTY_LIST;
        this.d_md.getEvents().addObserver(this);
        this.d_ribbons.addAll(panelProviders.get());
    }

    @Override
    public void commit() {
        for (EditorPanel panel : this.d_activePanels) {
            panel.commit();
        }
    }

    protected abstract List<EditorPanel> getActivePanels(Set<ICompElement> var1);

    protected Collection<EditorPanel> loadEditorsFromRibbons(Set<Object> sharedProps, Set<Object> unsharedProps) {
        ArrayList<EditorPanel> activeRibbonPanels = new ArrayList<EditorPanel>();
        for (ISelectionPanelProvider panelSrc : this.d_ribbons) {
            if (!panelSrc.isEnabled(sharedProps, unsharedProps)) continue;
            activeRibbonPanels.addAll(panelSrc.getSections());
        }
        return activeRibbonPanels;
    }

    protected void updatePanels() {
        MerlinSelectionModel sel = this.d_md.selection;
        for (EditorPanel panel : this.d_activePanels) {
            panel.release();
        }
        Set<ICompElement> objs = sel.getSelected(ICompElement.class);
        this.d_activePanels = this.getActivePanels(objs);
        for (EditorPanel pp : this.d_activePanels) {
            pp.bind(objs);
        }
    }

    protected abstract void updateLayout();

    @Override
    public void update(Events events) {
        for (EventChannel channel : events.getChannels()) {
            if (!channel.containsChange(VentusData.SELECTION_CHANGED) && !channel.containsChange(VentusData.CHILD_ADDED) && !channel.containsChange(VentusData.CHILD_REMOVED) && !channel.getChangedObjs(VentusData.SUPPORTED_PROPS_CHANGED).stream().anyMatch(o -> this.d_md.selection.isSelected(o))) continue;
            this.updatePanels();
            this.updateLayout();
            break;
        }
        for (EditorPanel panel : this.d_activePanels) {
            panel.update(events);
        }
    }

    protected static <T> Collection<T> filter(Collection<?> objs, Class<T> clazz) {
        return theUtil.filter(objs, clazz);
    }

    public static <ObjT extends ICompElement, PropT> void setPropRecursive(String actionName, CompElementActions.IObjectProp<ObjT, PropT> prop, Collection<? extends ObjT> objs, PropT newVal) {
        Undo.begin(actionName);
        VentusData md = VentusApp.getApp().getData();
        prop.set(md, objs, newVal);
        Undo.end(VentusApp.getApp().getData());
    }

    public static <ObjT extends ICompElement, PropT> void setPropRecursive(String actionName, Object prop, Collection<? extends ObjT> objs, PropT newVal) {
        SelectionEditorPanel.setPropRecursive(actionName, (CompElementActions.IObjectProp)prop, objs, newVal);
    }

    public static class EditorPanel
    extends guiPanel
    implements PropConnections.IPropConnection {
        private static final long serialVersionUID = 475979557780107511L;
        private final List<PropConnections.IPropConnection> d_conns = new LinkedList<PropConnections.IPropConnection>();
        private Collection<ICompElement> d_objs = Collections.EMPTY_LIST;
        private final String d_title;

        public EditorPanel() {
            this.d_title = "";
        }

        public EditorPanel(LayoutManager layoutManager) {
            super(layoutManager);
            this.d_title = "";
        }

        public EditorPanel(String panelDesc) {
            this.d_title = panelDesc;
        }

        @Override
        public void setVisible(boolean visible) {
            super.setVisible(visible);
            Container parent = this.getParent();
            if (parent instanceof APropEditPanel) {
                ((APropEditPanel)parent).setPriorSeparatorVisible(this, visible);
            }
        }

        @Override
        public void update(Events events) {
            for (PropConnections.IPropConnection conn : this.d_conns) {
                conn.update(events);
            }
        }

        @Override
        public void commit() {
            for (PropConnections.IPropConnection conn : this.d_conns) {
                conn.commit();
            }
        }

        public void addConnection(PropConnections.IPropConnection conn) {
            this.d_conns.add(conn);
        }

        @Override
        public void bind(Collection<ICompElement> objs) {
            this.d_objs = objs;
            for (PropConnections.IPropConnection conn : this.d_conns) {
                conn.bind(objs);
            }
        }

        @Override
        public void release() {
            for (PropConnections.IPropConnection conn : this.d_conns) {
                conn.release();
            }
            this.d_objs = Collections.EMPTY_LIST;
        }

        public Collection<ICompElement> getObjects() {
            return this.d_objs;
        }

        public String getTitle() {
            return this.d_title;
        }
    }
}

