/*
 * Decompiled with CFR 0.152.
 */
package ventus.mv.gui;

import org.jscience.physics.units.SI;
import thunderheadeng.gui.GridBagUtil;
import thunderheadeng.gui.guiLabel;
import thunderheadeng.gui.guiUnitDoubleField;
import thunderheadeng.units.UnitDouble;
import ventus.Intl;
import ventus.builders.WallSubBuilder;
import ventus.data.VentusData;
import ventus.geom.Geometry;
import ventus.gui.APropEditPanel;
import ventus.gui.IPropEditCommand;
import ventus.gui.MerlinUDF;
import ventus.mv.gui.NewPlanarGeomPanel;

public class NewWallPanel
extends NewPlanarGeomPanel<WallSubBuilder> {
    private static final long serialVersionUID = 1989501070929835832L;
    private final ThicknessPanel d_tPan;

    public NewWallPanel(VentusData data) {
        super(data, 1);
        this.addSeparator();
        this.d_tPan = new ThicknessPanel();
        this.add(this.d_tPan);
    }

    @Override
    public void setProps(WallSubBuilder props) {
        super.setProps(props);
        this.d_tPan.setProps(props);
    }

    private static class ThicknessPanel
    extends APropEditPanel<WallSubBuilder> {
        private static final long serialVersionUID = -2882096448722248174L;
        public guiUnitDoubleField d_thicknessFld;

        public ThicknessPanel() {
            super(WallSubBuilder.WIDTH);
            guiLabel thicknessLbl = new guiLabel(Intl.intl("Thickness:"));
            this.d_thicknessFld = this.initValueField(new MerlinUDF(0.0, SI.METER), new IPropEditCommand[0]);
            GridBagUtil.add(this, thicknessLbl, 0, 0, 1, 1, 0, 6, 0, 0, 0, 0.0, 0.0, 17);
            GridBagUtil.add(this, this.d_thicknessFld, 1, 0, 1, 1, 0, 6, 0, 0, 0, 0.0, 0.0, 17);
        }

        @Override
        protected void updateFromProps(WallSubBuilder props) {
            double width = props.getWidth();
            UnitDouble value = new UnitDouble(width, SI.METER).convert(Geometry.LENGTH_UNIT);
            this.d_thicknessFld.setValue(value);
        }

        @Override
        protected void updateToProps(WallSubBuilder props) {
            double width = ((UnitDouble)this.d_thicknessFld.getValue()).convert(SI.METER).getValueNoUnit();
            ((WallSubBuilder)this.props()).setWidth(width);
        }
    }
}

