/*
 * Decompiled with CFR 0.152.
 */
package ventus.mv.gui;

import java.util.Arrays;
import javax.swing.AbstractButton;
import org.jscience.physics.units.NonSI;
import thunderheadeng.gui.GridBagHelper;
import thunderheadeng.gui.LinkStatus;
import thunderheadeng.gui.guiButtonGroup;
import thunderheadeng.gui.guiDoubleField;
import thunderheadeng.gui.guiRadioButton;
import thunderheadeng.gui.guiUnitDoubleField;
import thunderheadeng.units.UnitDouble;
import thunderheadeng.util.DoubleVR;
import ventus.Intl;
import ventus.builders.CorridorBuilder;
import ventus.builders.RampBuilder;
import ventus.gui.APropEditPanel;
import ventus.gui.IPropEditCommand;
import ventus.gui.MerlinUDF;
import ventus.mv.gui.NewCorridorPanel;

public class NewRampPanel
extends NewCorridorPanel<RampBuilder> {
    private static final long serialVersionUID = 471294793243822709L;

    public NewRampPanel(CorridorBuilder.Mode mode) {
        super(mode, Arrays.asList(new SlopePanel()), Arrays.asList(new NewCorridorPanel.RunTerm(), new NewCorridorPanel.RiseTerm(), new NewCorridorPanel.LengthTerm()));
    }

    private static class SlopePanel
    extends APropEditPanel<RampBuilder> {
        private static final long serialVersionUID = -1897801566420627737L;
        private final guiRadioButton d_slopeDegBtn = this.initButton(new guiRadioButton(Intl.intl("Incline Angle:")), new IPropEditCommand[0]);
        private final guiRadioButton d_slopeBtn = this.initButton(new guiRadioButton(Intl.intl("Incline (rise/run):")), new IPropEditCommand[0]);
        private final guiUnitDoubleField d_slopeDeg = this.initValueField(new MerlinUDF(5.0, DoubleVR.between(-90.0, 90.0, false, false), NonSI.DEGREE_ANGLE), new IPropEditCommand[0]);
        private final guiDoubleField d_slope = this.initValueField(new guiDoubleField(0.08), new IPropEditCommand[0]);

        public SlopePanel() {
            super(RampBuilder.SLOPE);
            LinkStatus.link((AbstractButton)this.d_slopeDegBtn, this.d_slopeDeg);
            LinkStatus.link((AbstractButton)this.d_slopeBtn, this.d_slope);
            new guiButtonGroup(this.d_slopeDegBtn, this.d_slopeBtn);
            GridBagHelper gb = new GridBagHelper(this);
            gb.addRow(this.d_slopeDegBtn, this.d_slopeDeg);
            gb.addRow(this.d_slopeBtn, this.d_slope);
        }

        @Override
        protected void updateToProps(RampBuilder props) {
            if (this.d_slopeDegBtn.isSelected()) {
                props.setSlopeAngle((UnitDouble)this.d_slopeDeg.getValue());
            } else {
                props.setSlope((Double)this.d_slope.getValue());
            }
        }

        @Override
        protected void updateFromProps(RampBuilder props) {
            if (props.isUsingSlopeAngle()) {
                this.d_slopeDegBtn.setSelected(true);
                this.d_slopeDeg.setValue(props.getSlopeAngle());
            } else {
                this.d_slopeBtn.setSelected(true);
                this.d_slope.setValue(props.getSlope());
            }
        }
    }
}

