/*
 * Decompiled with CFR 0.152.
 */
package ventus.mv.displays;

import java.text.DecimalFormat;
import java.text.NumberFormat;
import java.util.ArrayList;
import javax.vecmath.Point2d;
import javax.vecmath.Point3d;
import org.jscience.physics.units.Unit;
import thunderheadeng.scene3d.nativebuffered.StringRenderer;
import ventus.VentusApp;
import ventus.builders.PlanarGeomBuilder;
import ventus.mv.displays.AEdgeLengthDisplay;
import ventus.mv.displays.IMerlinDisplay;

public class RoomToolEdgeDisplay
extends AEdgeLengthDisplay
implements IMerlinDisplay {
    private ArrayList<Point2d> d_pointsList = new ArrayList();
    private Unit d_unit;
    private PlanarGeomBuilder d_props;
    private double d_zLocation = 0.0;

    public RoomToolEdgeDisplay(IMerlinDisplay d) {
        super(d);
        this.update();
    }

    public void setProps(PlanarGeomBuilder props) {
        this.d_props = props;
    }

    @Override
    public ArrayList<String> getLabelTexts(int n) {
        NumberFormat nf = DecimalFormat.getNumberInstance();
        nf.setMaximumFractionDigits(1);
        ArrayList<String> texts = new ArrayList<String>();
        VentusApp va = VentusApp.getApp();
        if (va == null) {
            return texts;
        }
        Unit u = va.getUnitSystem().getLength();
        if (this.d_pointsList.isEmpty() || this.d_pointsList.contains(null)) {
            for (int i = 0; i < n; ++i) {
                texts.add("");
            }
            return texts;
        }
        return this.d_props.getPointsAsStrings(u);
    }

    @Override
    public void updateTextLocation(int ix) {
        if (this.d_pointsList.isEmpty() || this.d_pointsList.contains(null)) {
            return;
        }
        Point2d mid = this.d_props.getMidpointLocation(ix);
        ((StringRenderer)this.d_texts.get(ix)).setLocation(new Point3d(mid.x, mid.y, this.d_zLocation), null);
    }

    public void updatePoints(ArrayList<Point2d> points, Unit u, double zLoc) {
        this.d_unit = u;
        this.d_pointsList = points;
        this.d_zLocation = zLoc;
    }
}

