/*
 * Decompiled with CFR 0.152.
 */
package ventus.mv.displays;

import java.util.Collection;
import java.util.function.Consumer;
import java.util.function.Predicate;
import thunderheadeng.scene3d.IDisplayMgr;
import thunderheadeng.scene3d.nativebuffered.ModelScene;
import thunderheadeng.scene3d.transformpreview.EmptyTransformPreview;
import thunderheadeng.scene3d.transformpreview.ITransformPreview;
import thunderheadeng.util.EventChannel;
import thunderheadeng.util.Events;
import thunderheadeng.util.Filters;
import thunderheadeng.util.IdentityHashSet;
import thunderheadeng.util.Sets;
import ventus.data.IMerlinObj;
import ventus.data.VentusData;
import ventus.data.schematics.geom.ISchematicComp;
import ventus.mv.displays.IMerlinDispMgr;
import ventus.mv.displays.NavMeshTriDisplay;

public class NavMeshTriDispMgr
implements IMerlinDispMgr<Object> {
    private final VentusData d_data;
    private final NavMeshTriDisplay d_display;
    private boolean d_visible = false;
    private boolean d_dirty = true;

    public NavMeshTriDispMgr(VentusData data, ModelScene scene) {
        this.d_data = data;
        this.d_display = new NavMeshTriDisplay();
        this.d_display.setVisible(this.d_visible);
        scene.addRenderableObjects(this.d_display);
    }

    public void setVisible(boolean visible) {
        if (visible == this.d_visible) {
            return;
        }
        this.d_visible = visible;
        this.update();
        this.d_display.setVisible(this.d_visible);
    }

    public void setSelected(boolean selected) {
    }

    @Override
    public void update(Events events) {
        for (EventChannel<VentusData> eventChannel : events.getAffectedChannels(VentusData.class, new Class[0])) {
            if (!eventChannel.containsChange(VentusData.MESH_CHANGED)) continue;
            this.d_dirty = true;
            break;
        }
        for (EventChannel<IMerlinObj> eventChannel : events.getAffectedChannels(ISchematicComp.class, new Class[0])) {
            if (!eventChannel.getAddedObjs().isEmpty() || !eventChannel.getRemovedObjs().isEmpty()) {
                this.d_dirty = true;
                continue;
            }
            IdentityHashSet<Object> irrChanges = Sets.fromArrayIHS(VentusData.SELECTION_CHANGED);
            if (eventChannel.areChangesExclusiveTo(irrChanges)) continue;
            this.d_dirty = true;
        }
        this.update();
    }

    @Override
    public void updateVisibility(Collection<?> objs) {
    }

    @Override
    public void updateAll() {
        this.d_dirty = true;
        this.update();
    }

    public void update() {
        if (this.d_dirty) {
            if (this.d_visible) {
                this.regenerateDisplay();
            } else {
                this.d_display.resetData();
            }
        }
    }

    private void regenerateDisplay() {
        this.d_display.regenerateDisplay(this.d_data);
        this.d_dirty = false;
    }

    public Object getSelectionObj() {
        return null;
    }

    @Override
    public Predicate<Object> getFilter() {
        return Filters.rejectAll();
    }

    @Override
    public Class<Object> getType() {
        return Object.class;
    }

    @Override
    public ITransformPreview getTransformPreview(IDisplayMgr<? super Object> copyMgr, Collection<?> objs, boolean copyMode) {
        return EmptyTransformPreview.INSTANCE;
    }

    @Override
    public void getScenes(Consumer<ModelScene> scenes) {
    }

    @Override
    public void getScenes(Object obj, Consumer<ModelScene> scenes) {
    }

    @Override
    public void removeAll() {
    }

    @Override
    public void addDisplays(Collection<?> objs) {
    }

    @Override
    public void updateDisplays(Collection<?> objs) {
    }

    @Override
    public void removeDisplays(Collection<?> objs) {
    }

    @Override
    public void removeFromScene(Collection<?> obj) {
    }

    @Override
    public void addToScene(Collection<?> obj) {
    }
}

