/*
 * Decompiled with CFR 0.152.
 */
package ventus.mv.displays;

import java.awt.Color;
import java.util.function.Predicate;
import thunderheadeng.scene3d.geom.IMaterial;
import thunderheadeng.scene3d.geom.IPrimProps;
import thunderheadeng.scene3d.nativebuffered.DefNativeDisplayProps;
import thunderheadeng.util.Events;
import thunderheadeng.util.IEventObserver;
import thunderheadeng.util.IEventRecord;
import ventus.Intl;
import ventus.MerlinPrefs;
import ventus.data.IMerlinObj;
import ventus.data.VentusData;
import ventus.data.material.Material;
import ventus.geom.IMerlinDispProps;
import ventus.mv.MerlinColors;

public class MerlinDispProps
extends DefNativeDisplayProps
implements IMerlinDispProps,
IEventObserver {
    private static final long serialVersionUID = 1L;
    public static final Color DOORWAY_COLOR = new Color(0.9f, 0.7f, 0.0f, 1.0f);
    public static final Color CORRIDOR_COLOR = new Color(0.9f, 0.7f, 0.6f, 1.0f);
    public static final Color STAIR_EDGE_COLOR = Color.BLACK;
    public static final Color GOAL_COLOR = new Color(50, 255, 50);
    public static final Color FLOOR_COLOR = new Color(0.7f, 0.7f, 0.9f, 1.0f);
    private final MerlinColors d_colors;
    private ColorRoomsBy d_colorRoomsByType;
    private int d_stairDrawOptions;
    private int d_doorDrawOptions;

    public MerlinDispProps(VentusData md, MerlinColors colors, Predicate<Object> isWireframe) {
        super(isWireframe);
        this.d_colors = colors;
        this.d_colorRoomsByType = ColorRoomsBy.SET_COLOR;
        this.d_stairDrawOptions = 3;
        this.d_doorDrawOptions = 1;
        this.updateDisplayError();
    }

    private void updateDisplayError() {
        this.setCurveError(MerlinPrefs.getDouble(MerlinPrefs.DISPLAY_EDGE_ERROR));
        this.setFaceError(MerlinPrefs.getDouble(MerlinPrefs.DISPLAY_FACE_ERROR));
    }

    public void setColorRoomsBy(ColorRoomsBy cb) {
        this.d_colorRoomsByType = cb;
    }

    public ColorRoomsBy getColorRoomsBy() {
        return this.d_colorRoomsByType;
    }

    @Override
    public IPrimProps getEdgeProps(IMerlinObj obj, IMerlinDispProps.SchematicType primType, Color setColor, float opacity) {
        double lineWidth = MerlinDispProps.getLineWidth(primType);
        Color c = this.getLineColor(primType, setColor);
        int stipple = MerlinDispProps.getLineStipple(primType);
        c = MerlinDispProps.applyAlpha(c, opacity);
        return new IPrimProps.Edge(c, lineWidth, stipple, 0);
    }

    private static int getLineStipple(IMerlinDispProps.SchematicType primType) {
        return IPrimProps.DEF_STIPPLE;
    }

    private static double getLineWidth(IMerlinDispProps.SchematicType primType) {
        switch (primType) {
            case BOUNDARY: {
                return 2.0;
            }
            case EXIT_DOOR: {
                return 5.0;
            }
            case THIN_DOOR: {
                return 3.0;
            }
        }
        return 1.0;
    }

    private Color getLineColor(IMerlinDispProps.SchematicType primType, Color setColor) {
        switch (primType) {
            case BOUNDARY: {
                return this.d_colors.getColor(MerlinColors.BOUNDARY_COLOR);
            }
            case EXIT_DOOR: {
                return setColor != null ? setColor : GOAL_COLOR;
            }
            case THIN_DOOR: {
                return setColor != null ? setColor : DOORWAY_COLOR;
            }
            case CORRIDOR: {
                return STAIR_EDGE_COLOR;
            }
        }
        return Color.WHITE;
    }

    private int getFaceOptions(IMerlinObj obj, IMerlinDispProps.SchematicType primType) {
        return 0;
    }

    @Override
    public IPrimProps getFaceProps(IMerlinObj obj, IMerlinDispProps.SchematicType primType, IMaterial material, Color setColor, float opacity) {
        Color c = this.getFaceColor(obj, primType, setColor);
        c = MerlinDispProps.applyAlpha(c, opacity);
        return new IPrimProps.Face(c, material, this.getFaceOptions(obj, primType));
    }

    private Color getFaceColor(IMerlinObj obj, IMerlinDispProps.SchematicType primType, Color setColor) {
        switch (primType) {
            case EXIT_DOOR: {
                return setColor != null ? setColor : GOAL_COLOR;
            }
            case THICK_DOOR: {
                return setColor != null ? setColor : DOORWAY_COLOR;
            }
            case CORRIDOR: {
                return setColor != null ? setColor : CORRIDOR_COLOR;
            }
            case ROOM: {
                return setColor != null ? setColor : FLOOR_COLOR;
            }
        }
        return Color.WHITE;
    }

    public static Color applyAlpha(Color c, float opacity) {
        int alpha = (int)(opacity * 255.0f);
        if (alpha != c.getAlpha()) {
            c = new Color(c.getRed(), c.getGreen(), c.getBlue(), alpha);
        }
        return c;
    }

    public void setStairDrawOptions(int options, boolean enabled) {
        this.d_stairDrawOptions = enabled ? (this.d_stairDrawOptions |= options) : (this.d_stairDrawOptions &= ~options);
    }

    @Override
    public int getCorridorDrawOptions() {
        return this.d_stairDrawOptions;
    }

    public void setDoorDrawOptions(int options, boolean enabled) {
        this.d_doorDrawOptions = enabled ? (this.d_doorDrawOptions |= options) : (this.d_doorDrawOptions &= ~options);
    }

    @Override
    public int getDoorDrawOptions() {
        return this.d_doorDrawOptions;
    }

    @Override
    public void update(Events events) {
        if (events.getEvents(VentusData.class, new Class[0]).containsChange(VentusData.PREFS_CHANGED)) {
            this.updateDisplayError();
        }
        IEventRecord<Material> texEvts = events.getEvents(Material.class, new Class[0]);
        for (Material tadded : texEvts.getAddedObjs()) {
            this.registerMat(tadded);
        }
        for (Material tremoved : texEvts.getRemovedObjs()) {
            this.removeMat(tremoved);
        }
        for (Material tchanged : texEvts.getChangedObjs(new Object[0])) {
            this.updateMat(tchanged);
        }
    }

    public static enum ColorRoomsBy {
        SET_COLOR(1, Intl.intl("Default"), Intl.intl("Show the color set on each room."));

        public final String desc;
        public final String longDesc;
        public final int prefId;

        private ColorRoomsBy(int prefId, String desc, String longDesc) {
            this.desc = desc;
            this.longDesc = longDesc;
            this.prefId = prefId;
        }
    }
}

