/*
 * Decompiled with CFR 0.152.
 */
package ventus.mv;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.EventQueue;
import java.awt.GridBagLayout;
import java.awt.Window;
import java.awt.event.ComponentEvent;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Observable;
import java.util.Observer;
import java.util.Optional;
import java.util.Set;
import java.util.WeakHashMap;
import java.util.concurrent.Semaphore;
import java.util.function.Consumer;
import java.util.function.Predicate;
import java.util.stream.Stream;
import javax.swing.AbstractButton;
import javax.swing.Action;
import javax.swing.Box;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JComponent;
import javax.swing.JMenu;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JSeparator;
import javax.swing.JSplitPane;
import javax.swing.JToolBar;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;
import javax.vecmath.Point3d;
import javax.vecmath.Vector3d;
import org.jscience.physics.units.SI;
import org.jscience.physics.units.Unit;
import thunderheadeng.animate.IAnimSession;
import thunderheadeng.animate.IAnimator;
import thunderheadeng.animate.TimeAnimator;
import thunderheadeng.geometry.AABox;
import thunderheadeng.geometry.GeomConstants;
import thunderheadeng.geometry.Plane3d;
import thunderheadeng.geometry.Util3D;
import thunderheadeng.gui.AbstractComponentListener;
import thunderheadeng.gui.Application;
import thunderheadeng.gui.BooleanAction;
import thunderheadeng.gui.GridBagHelper;
import thunderheadeng.gui.ThemeChooserMenu;
import thunderheadeng.gui.Utils;
import thunderheadeng.gui.ValueField;
import thunderheadeng.gui.animate.IAnimView;
import thunderheadeng.gui.animate.StatusView;
import thunderheadeng.gui.animate.TimeView;
import thunderheadeng.gui.colorscheme.ColorChangedEvent;
import thunderheadeng.gui.colorscheme.ColorChangedListener;
import thunderheadeng.gui.colorscheme.ColorMgrMenu;
import thunderheadeng.gui.guiComboBox;
import thunderheadeng.gui.guiDialog;
import thunderheadeng.gui.guiInputDlg;
import thunderheadeng.gui.guiLabel;
import thunderheadeng.gui.guiMenu;
import thunderheadeng.gui.guiResponder;
import thunderheadeng.gui.guiSliderVal;
import thunderheadeng.gui.guiStatusBar;
import thunderheadeng.gui.guiStatusMessage;
import thunderheadeng.gui.guiToolBar;
import thunderheadeng.gui.guiUtil;
import thunderheadeng.gui.tool.IDeviceManager;
import thunderheadeng.gui.tool.Tool;
import thunderheadeng.gui.tool.ToolManager;
import thunderheadeng.gui.tool.ToolToggleButton;
import thunderheadeng.io.nativexfer.Native;
import thunderheadeng.scene3d.gui.RenderPrefs;
import thunderheadeng.scene3d.manip.ManipMgr;
import thunderheadeng.scene3d.nativebuffered.AxesScene;
import thunderheadeng.scene3d.nativebuffered.Camera;
import thunderheadeng.scene3d.nativebuffered.CameraRecord;
import thunderheadeng.scene3d.nativebuffered.GradientBG;
import thunderheadeng.scene3d.nativebuffered.GridSnapperDisp;
import thunderheadeng.scene3d.nativebuffered.IRenderSurface;
import thunderheadeng.scene3d.nativebuffered.ISceneRenderOptions;
import thunderheadeng.scene3d.nativebuffered.ModelScene;
import thunderheadeng.scene3d.nativebuffered.OriginDisp;
import thunderheadeng.scene3d.nativebuffered.OrthoCamera;
import thunderheadeng.scene3d.nativebuffered.OverlayLayout;
import thunderheadeng.scene3d.nativebuffered.PerspectiveCamera;
import thunderheadeng.scene3d.nativebuffered.RenderComponent;
import thunderheadeng.scene3d.nativebuffered.RenderFile;
import thunderheadeng.scene3d.nativebuffered.RenderPanel;
import thunderheadeng.scene3d.nativebuffered.SceneRenderOptions;
import thunderheadeng.scene3d.nativebuffered.SceneRenderer;
import thunderheadeng.scene3d.nativebuffered.SurfaceProps;
import thunderheadeng.scene3d.nativebuffered.View;
import thunderheadeng.scene3d.navtools.CompositeFunc;
import thunderheadeng.scene3d.navtools.CursorTool;
import thunderheadeng.scene3d.navtools.DragFunc;
import thunderheadeng.scene3d.navtools.IToolController;
import thunderheadeng.scene3d.navtools.ManipFunc;
import thunderheadeng.scene3d.navtools.MultiFunc;
import thunderheadeng.scene3d.navtools.NavtoolUtil;
import thunderheadeng.scene3d.navtools.OrbitFunc;
import thunderheadeng.scene3d.navtools.RoamFunc;
import thunderheadeng.scene3d.navtools.SelectionFunc;
import thunderheadeng.scene3d.navtools.ZoomBoxFunc;
import thunderheadeng.scene3d.navtools.ZoomFunc;
import thunderheadeng.scene3d.picking.GeomPicker;
import thunderheadeng.units.UnitDouble;
import thunderheadeng.units.UnitDoubleVR;
import thunderheadeng.util.BitOptions;
import thunderheadeng.util.BooleanConsumer;
import thunderheadeng.util.Events;
import thunderheadeng.util.Filters;
import thunderheadeng.util.Global;
import thunderheadeng.util.GroupedSequence;
import thunderheadeng.util.IEventObserver;
import thunderheadeng.util.IEventRecord;
import thunderheadeng.util.IFilteredCollection;
import thunderheadeng.util.LinkedIdentityHashSet;
import thunderheadeng.util.Pair;
import thunderheadeng.util.Predicates;
import thunderheadeng.util.TeciProps;
import thunderheadeng.util.TypedProp;
import thunderheadeng.util.theUtil;
import ventus.Intl;
import ventus.MerlinPrefs;
import ventus.VentusApp;
import ventus.actions.AMerlinBoolAction;
import ventus.actions.AMerlinOp;
import ventus.actions.MerlinOp;
import ventus.actions.MerlinOpImpl;
import ventus.actions.TransformAction;
import ventus.actions.UIHook;
import ventus.actions.Undo;
import ventus.actions.UnitsAction;
import ventus.actions.VentusShortcuts;
import ventus.actions.importgeom.Import;
import ventus.builders.FloorExtractor3D;
import ventus.builders.PolyBuilder;
import ventus.builders.RectBuilder;
import ventus.builders.RoomGeomBuilder;
import ventus.builders.ToolName;
import ventus.builders.WallSubBuilder;
import ventus.builders.WorkingPlane;
import ventus.data.IMerlinObj;
import ventus.data.ImportedGeom;
import ventus.data.VentusData;
import ventus.data.ViewProps;
import ventus.data.schematics.geom.ISchematicComp;
import ventus.data.schematics.geom.ISchematicConnector;
import ventus.data.schematics.geom.SchematicCorridor;
import ventus.feature.comps.IFeatureAnimator;
import ventus.feature.comps.IPropEditor;
import ventus.feature.comps.ISceneItem;
import ventus.feature.comps.ITool;
import ventus.geom.Geometry;
import ventus.geom.IMerlinGeomSrc;
import ventus.gui.MerlinValueFields;
import ventus.gui.PropPanel;
import ventus.gui.guiUtil;
import ventus.manip.ATransformManip;
import ventus.manip.MirrorManip;
import ventus.manip.RotateManip;
import ventus.manip.TranslateManip;
import ventus.mv.FilterAction;
import ventus.mv.MerlinColors;
import ventus.mv.animate.session.MVAnimSession;
import ventus.mv.displays.GlobalDisplayMgr;
import ventus.mv.displays.IMerlinDispMgr;
import ventus.mv.displays.IMerlinDisplay;
import ventus.mv.displays.IPropsDisplay;
import ventus.mv.displays.MerlinDispProps;
import ventus.mv.displays.NavMeshTriDispMgr;
import ventus.mv.displays.PlanarGeomBuilderDisplay;
import ventus.mv.gui.FloorExtractor3DPanel;
import ventus.mv.gui.MirrorPanel;
import ventus.mv.gui.NewPolyPanel;
import ventus.mv.gui.NewRectPanel;
import ventus.mv.gui.NewWallPanel;
import ventus.mv.gui.RoomTypePanel;
import ventus.mv.gui.RotatePanel;
import ventus.mv.gui.SelectionEditorPanel;
import ventus.mv.gui.SelectionPropertyEditorPanel;
import ventus.mv.gui.SelectionRibbonEditorPanel;
import ventus.mv.gui.TranslatePanel;
import ventus.mv.manip.ManipHook;
import ventus.mv.snappers.GridSnapper;
import ventus.mv.tools.DeveloperTool;
import ventus.mv.tools.FloorExtractionTool;
import ventus.mv.tools.IConditionallyEnabledTool;
import ventus.mv.tools.IPointPickListener;
import ventus.mv.tools.MeasureTool;
import ventus.mv.tools.Merlin3DSelector;
import ventus.mv.tools.MerlinPickRoot;
import ventus.mv.tools.MerlinTool;
import ventus.mv.tools.MerlinToolHooks;
import ventus.mv.tools.MirrorTool;
import ventus.mv.tools.NewPolyTool;
import ventus.mv.tools.NewRectTool;
import ventus.mv.tools.NewWallSubTool;
import ventus.mv.tools.PointPicker;
import ventus.mv.tools.RotateTool;
import ventus.mv.tools.ThinWallTool;
import ventus.mv.tools.TranslateTool;
import ventus.unitsystem.UnitSystem;
import ventus.util.MerlinProps;

public class ModelView
implements ColorChangedListener,
IEventObserver,
IToolController {
    public static final Object EVT_RESET_CAMERAS = "ModelView.EVT_RESET_CAMERAS";
    public static final Object EVT_ANIMATION = "ModelView.EVT_ANIMATION";
    private final VentusData d_data;
    private final JComponent d_panel;
    private final GroupedSequence d_menu;
    private final AxesScene d_axes = new AxesScene();
    private final GradientBG d_background = new GradientBG(1, 0, 0.15f);
    private final SceneRenderer d_toolLayer = new SceneRenderer();
    private final RenderComponent d_renderComp;
    private final RenderFile d_renderFile;
    private final View d_mainView;
    private final OriginDisp d_origin = new OriginDisp();
    private final MerlinColors d_colors;
    private final MerlinDispProps d_dispProps;
    private final BooleanAction d_realisticAction;
    private final BooleanAction d_realisticOutlinesAction;
    private final BooleanAction d_solidOutlinesAction;
    private final BooleanAction d_showGuidesAction;
    private final BooleanAction d_showPointerAction;
    private final BooleanAction d_wireframeAction;
    private final BooleanAction d_solidAction;
    private final BooleanAction d_xrayAction;
    private final BooleanAction d_showNavMeshTrisAction;
    private final GroupedSequence d_filterActions;
    private final BooleanAction d_showSnapGridAction;
    private final BooleanAction d_showOriginAction;
    private final BooleanAction d_showStairDirArrowAction;
    private final BooleanAction d_showOnewayAction;
    private final JToolBar d_viewOptionsToolbar;
    private final JToolBar d_viewToolbar;
    private final JToolBar d_navToolbar;
    private final JToolBar d_creationToolbar;
    private final JToolBar d_editToolbar;
    private final JToolBar d_utilityToolbar;
    private final guiStatusMessage d_statusMessage;
    private final guiStatusBar d_statusBar;
    private final guiComboBox<Action> d_appearanceBox;
    private final SelectionFunc d_selFunc;
    private final ToolManager d_tools;
    private final CursorTool d_selectionTool3D;
    private final CursorTool d_selectionTool2D;
    private final CursorTool d_pointPickerTool;
    private final CursorTool d_compositeViewTool3d;
    private final CursorTool d_orbitTool;
    private final CursorTool d_modGameRoamTool;
    private final CursorTool d_dragTool;
    private final CursorTool d_zoomTool;
    private final CursorTool d_zoomBoxTool;
    private final FloorExtractionTool d_floorExtractTool;
    private final MeasureTool d_measureTool;
    private final DeveloperTool d_developerTool;
    private final ManipHook d_manipListener;
    private final GeomPicker d_manipSnapper;
    private final GeomPicker d_snapper;
    private final PropPanel d_toolPropsPanel;
    private final NewPolyTool d_openSpacePolyTool;
    private final NewRectTool<?> d_openSpaceRectTool;
    private final NewWallSubTool d_wallTool;
    private final ThinWallTool d_thinWallTool;
    private final TranslateTool d_translateTool;
    private final RotateTool d_rotateTool;
    private final MirrorTool d_mirrorTool;
    private final GridSnapper d_gridSnapper;
    private final GridSnapperDisp d_gridSnapperDisp;
    public static final int CAM_TOP = 0;
    public static final int CAM_FRONT = 1;
    public static final int CAM_LEFT = 2;
    public static final int CAM_PERSP = 3;
    private final Camera[] d_cameras = new Camera[4];
    private final Pair<Vector3d, Vector3d>[] d_camResetDirs = new Pair[4];
    private DrawMode d_drawMode;
    private final DrawMode d_drawMode3d;
    private final DrawMode d_drawMode2d;
    private final GlobalDisplayMgr d_dispMgr;
    private final GlobalDisplayMgr d_xformDispMgr;
    private final NavMeshTriDispMgr d_navMeshTris;
    private final SelectionEditorPanel d_ribbonEditorPanel;
    private final SelectionPropertyEditorPanel d_tablePropsEditorPanel;
    private Optional<TimeAnimInfo> d_animInfo = Optional.empty();
    private final MVAnimSession d_animSession = new MVAnimSession();
    private final Collection<ITool<?>> d_featureTools = new LinkedIdentityHashSet();
    private JPanel d_middlePanel;
    private final UIHook d_snapGridHook = new UIHook((MerlinOp)new EditSketchGridSpacingOp(), Intl.intl("Edit Snap Grid..."), 4);
    private final UIHook d_xrayOpacHook = new UIHook((MerlinOp)new EditXrayOpacityOp(), Intl.intl("Edit X-ray Opacity..."), 4);
    public static final int ANIMOPT_REPEAT = 1;
    public static final int ANIMOPT_START_IMMEDIATELY = 2;
    public static final int ANIMOPT_CONTROL_TIME = 4;
    private final UIHook d_resetAllHook = new UIHook((MerlinOp)new ResetToAllObjectsAction(), Intl.intl("Reset View to All Objects,R,Reset All,Reset view to all visible objects"), thunderheadeng.gui.guiUtil.loadTeciIcon("ZoomFit16.gif"));
    private final UIHook d_resetToSelectedHook = new UIHook((MerlinOp)new ResetToSelectedObjectsAction(), Intl.intl("Reset View to Selected Objects,E,Reset To Selection,Reset view to selected, visible objects"), guiUtil.loadMerlinIcon("ZoomSelectedObjs16.gif"));
    private final UIHook d_fillViewHook = new UIHook((MerlinOp)new FillViewAction(), Intl.intl("&Fill View,-,Fill view without resetting view angle"), guiUtil.loadMerlinIcon("fillview16.gif"));
    private final Map<Runnable, MerlinOpImpl> d_backgroundOps = Collections.synchronizedMap(new WeakHashMap());

    public ModelView(VentusData data, MerlinColors colors) {
        final VentusApp app = VentusApp.getApp();
        this.upgradePrefs();
        this.d_dispMgr = new GlobalDisplayMgr(data, this);
        this.d_xformDispMgr = new GlobalDisplayMgr(data, this);
        SurfaceProps sprops = RenderPrefs.getDefaultSurfaceProps(MerlinPrefs.instance());
        this.d_renderComp = new RenderComponent(sprops);
        this.d_renderComp.getRootPanel().setOptions(this.d_renderComp.getRootPanel().getOptions() | RenderPanel.OPT_GAMMA_CORRECT);
        this.d_renderFile = new RenderFile(this.d_renderComp);
        this.d_mainView = new View((IRenderSurface)this.d_renderComp, this.d_dispMgr.mainScene.scene);
        this.d_data = data;
        this.d_colors = colors;
        this.d_dispProps = new MerlinDispProps(data, colors, this.d_dispMgr.getWireframeTester());
        this.d_dispMgr.handleScene.scene.getDrawProps().setLightModel(ISceneRenderOptions.LightModel.DISABLED);
        this.d_dispMgr.handleScene.scene.getDrawProps().setDepthTestEnabled(false);
        this.d_dispMgr.handleScene.scene.getDrawProps().setAutoClip(false);
        this.d_dispMgr.toolScene.scene.getDrawProps().setLightModel(ISceneRenderOptions.LightModel.DISABLED);
        this.d_dispMgr.toolScene.scene.getDrawProps().setDrawOutlines(false);
        this.d_dispMgr.toolScene.scene.getDrawProps().setDepthTestEnabled(false);
        this.d_dispMgr.toolScene.scene.getDrawProps().setAutoClip(false);
        this.d_dispMgr.gridScene.scene.getDrawProps().setDepthTestEnabled(false);
        this.d_dispMgr.gridScene.scene.getDrawProps().setAutoClip(false);
        this.d_dispMgr.originScene.scene.getDrawProps().setDepthTestEnabled(false);
        this.d_dispMgr.originScene.scene.getDrawProps().setAutoClip(false);
        this.d_navMeshTris = new NavMeshTriDispMgr(this.d_data, this.d_dispMgr.mainScene.scene);
        this.d_drawMode3d = new DrawMode();
        this.d_drawMode3d.props = new SceneRenderOptions();
        this.d_drawMode3d.props.setAutoClip(false);
        this.d_drawMode3d.props.setDrawWireframe(app.getPrefs().getBoolean(MerlinPrefs.DrawWireframeProp3d));
        this.d_drawMode3d.props.setShowMaterials(app.getPrefs().getBoolean(MerlinPrefs.ShowTexturesProp3d));
        this.d_drawMode3d.props.setDrawOutlines(app.getPrefs().getBoolean(MerlinPrefs.ShowOutlinesProp3d));
        this.d_drawMode3d.props.set(ISceneRenderOptions.OPACITY_FACTOR, Float.valueOf(app.getPrefs().getFloat(MerlinPrefs.OpacityProp3d)));
        this.d_drawMode3d.props.setLightModel(ISceneRenderOptions.LightModel.LOCAL_CAMERA);
        this.d_drawMode2d = new DrawMode();
        this.d_drawMode2d.props = new SceneRenderOptions();
        this.d_drawMode2d.props.setAutoClip(false);
        this.d_drawMode2d.props.setDrawWireframe(app.getPrefs().getBoolean(MerlinPrefs.DrawWireframeProp2d));
        this.d_drawMode2d.props.setShowMaterials(app.getPrefs().getBoolean(MerlinPrefs.ShowTexturesProp2d));
        this.d_drawMode2d.props.setDrawOutlines(app.getPrefs().getBoolean(MerlinPrefs.ShowOutlinesProp2d));
        this.d_drawMode2d.props.set(ISceneRenderOptions.OPACITY_FACTOR, Float.valueOf(app.getPrefs().getFloat(MerlinPrefs.OpacityProp2d)));
        this.d_drawMode2d.props.setLightModel(ISceneRenderOptions.LightModel.LOCAL_CAMERA);
        this.d_drawMode = this.d_drawMode3d;
        this.d_realisticAction = new ShowRealisticAction(false);
        this.d_realisticOutlinesAction = new ShowRealisticOutlinesAction(false);
        this.d_solidOutlinesAction = new ShowOutlinesAction(false);
        this.d_xrayAction = new ShowXrayAction(false);
        this.d_wireframeAction = new UseWireframeAction(Intl.intl("Wireframe"), Intl.intl("Show geometry as outlines only"), false, "ventus/icons/wireframe.png", true);
        this.d_solidAction = new UseWireframeAction(Intl.intl("Solid"), Intl.intl("Show geometry as solids"), false, "ventus/icons/solid.png", false);
        this.d_showGuidesAction = new ToolUpdateBoolAction(Intl.intl("Show Cursor Guides"), app.getPrefs().getBoolean(MerlinPrefs.ShowGuidesProp));
        this.d_showPointerAction = new ToolUpdateBoolAction(Intl.intl("Show System Mouse"), app.getPrefs().getBoolean(MerlinPrefs.ShowSystemMouseProp));
        this.d_filterActions = new GroupedSequence("modelview.filters", 0, null);
        this.d_filterActions.add(new FilterAction<ISchematicComp>(Intl.intl("Show Zones"), guiUtil.loadMerlinIcon("mesh16.png"), true, ISchematicComp.class, Filters.alwaysFalse()));
        this.d_filterActions.add(new FilterAction<ImportedGeom>(Intl.intl("Show Imported Geometry"), guiUtil.loadMerlinIcon("composite16.png"), true, ImportedGeom.class, new DescendentFilter(data, data.sceneGeom)));
        VentusApp.getApp().getComponents(ISceneItem.class).forEach(i -> i.addFilterItems(this, this.d_filterActions));
        this.d_showNavMeshTrisAction = new DisplayVisToggleAction();
        this.d_showSnapGridAction = new UpdateSnapGridAction(Intl.intl("Show Snap Grid"), true);
        this.d_showOriginAction = new UpdateSnapGridAction(Intl.intl("Show Origin"), true);
        this.d_showStairDirArrowAction = new CorrDrawOptionsAction(Intl.intl("Show Stair/Ramp Direction"), 2, true);
        this.d_showOnewayAction = new DoorDrawOptionsAction(Intl.intl("Show One-way Door Direction"), 1, true);
        this.d_statusBar = new guiStatusBar();
        this.d_statusMessage = new guiStatusMessage();
        this.d_statusBar.setStatusMessage(this.d_statusMessage);
        this.d_appearanceBox = new guiComboBox<Action>((T[])new Action[]{this.d_wireframeAction, this.d_solidAction, this.d_solidOutlinesAction, this.d_realisticAction, this.d_realisticOutlinesAction, this.d_xrayAction});
        this.d_appearanceBox.setToolTipText(Intl.intl("Change how geometry is rendered"));
        this.d_appearanceBox.addActionListener(e -> this.d_appearanceBox.getSelectedItem().actionPerformed(e));
        this.d_appearanceBox.setRenderer(new guiUtil.ActionCellRenderer());
        this.d_toolPropsPanel = new PropPanel();
        guiResponder responder = new guiResponder(this.d_renderComp);
        MerlinPickRoot pickRoot = new MerlinPickRoot(this.d_data, this);
        this.d_snapper = new GeomPicker(pickRoot, this.d_mainView);
        this.d_manipSnapper = new GeomPicker(pickRoot, this.d_mainView);
        this.d_manipSnapper.setOcclusionFilteringEnabled(false);
        this.d_tools = new ToolManager(this.d_renderComp);
        this.d_measureTool = new MeasureTool(this);
        this.d_measureTool.setListener(new MeasureTool.IMeasureListener(){

            @Override
            public void measurementMade(UnitDouble length) {
                length = length.convert(app.getUnitSystem().getLength());
                String msg = String.format(Intl.intl("Total measurement = %s"), Global.format(length));
                JOptionPane.showMessageDialog(app.getMainFrame(), msg, Intl.intl("Measurement Result"), 1);
            }
        });
        this.addModalTool(this.d_measureTool, ToolName.MEASURE.get(), Intl.intl("Take a measurement"), guiUtil.loadMerlinIcon("ruler16.png"), new ToolPropsInfo(this.getMainScene(), this.getToolPropsPanel(), this.d_measureTool, null, this.d_measureTool.getDisplay()));
        this.d_developerTool = new DeveloperTool(this, this.d_data);
        this.d_tools.addTool(this.d_developerTool, "Dev", "Dev", null);
        this.d_thinWallTool = new ThinWallTool(this, this.d_data);
        this.addModalTool(this.d_thinWallTool, ToolName.ADD_THIN_WALL.get(), Intl.intl("Add a Thin Wall"), guiUtil.loadMerlinIcon("asplit16.png"), new ToolPropsInfo(this.getMainScene(), this.getToolPropsPanel(), this.d_thinWallTool, null, null));
        this.d_manipListener = new ManipHook(this.d_data, this, this.d_dispMgr, this.d_dispMgr.handleScene.scene);
        OrbitFunc orbitFunc = new OrbitFunc();
        DragFunc<CursorTool> dragFunc = new DragFunc<CursorTool>();
        ManipFunc manipFunc = new ManipFunc(this, this.d_manipListener.getManager(), this.d_manipSnapper, 10.0, UnitSystem.getType(0, true));
        this.d_selFunc = new SelectionFunc(this.d_snapper, new Merlin3DSelector(this.d_snapper));
        MultiFunc generalSelFunc3d = new MultiFunc(manipFunc, this.d_selFunc, orbitFunc, dragFunc);
        this.d_selectionTool3D = new CursorTool(this, generalSelFunc3d);
        this.d_tools.addTool(this.d_selectionTool3D, ToolName.SELECT.get(), Intl.intl("Select/Edit Objects"), thunderheadeng.gui.guiUtil.loadTeciIcon("pointer16.gif"));
        MultiFunc generalSelFunc2d = new MultiFunc(manipFunc, this.d_selFunc, dragFunc, dragFunc);
        this.d_selectionTool2D = new CursorTool(this, generalSelFunc2d);
        this.d_tools.addTool(this.d_selectionTool2D, ToolName.SELECT.get(), Intl.intl("Select/Edit Objects"), thunderheadeng.gui.guiUtil.loadTeciIcon("pointer16.gif"));
        PointPicker pointPickFunc = new PointPicker(this.d_data, this.d_renderComp);
        this.d_pointPickerTool = new CursorTool(this, NavtoolUtil.newPannableDrawTool(pointPickFunc));
        this.addModalTool(this.d_pointPickerTool, Intl.intl("Select Point"), Intl.intl("Select Point"), guiUtil.loadTeciIcon("pointer16.gif"), new ToolPropsInfo(this.getMainScene(), this.getToolPropsPanel(), this.d_pointPickerTool, null, null));
        this.d_orbitTool = new CursorTool(this, orbitFunc);
        this.d_tools.addTool(this.d_orbitTool, Intl.intl("Rotate"), Intl.intl("Rotate View"), OrbitFunc.ICON);
        this.d_modGameRoamTool = new CursorTool(this, new RoamFunc<CursorTool>(this.d_selFunc));
        this.d_tools.addTool(this.d_modGameRoamTool, ToolName.ROAM.get(), Intl.intl("Roam"), RoamFunc.ICON);
        this.d_dragTool = new CursorTool(this, dragFunc);
        this.d_tools.addTool(this.d_dragTool, ToolName.PAN.get(), Intl.intl("Pan View"), DragFunc.ICON);
        ZoomFunc zoomFunc = new ZoomFunc();
        this.d_zoomTool = new CursorTool(this, zoomFunc);
        this.d_tools.addTool(this.d_zoomTool, ToolName.ZOOM.get(), Intl.intl("Zoom"), ZoomFunc.ICON);
        ZoomBoxFunc zoomBoxFunc = new ZoomBoxFunc();
        this.d_zoomBoxTool = new CursorTool(this, zoomBoxFunc);
        this.d_tools.addTool(this.d_zoomBoxTool, ToolName.ZOOM_BOX.get(), Intl.intl("Zoom Box"), ZoomBoxFunc.ICON);
        this.d_compositeViewTool3d = new CursorTool(this, this.create3DCompositeTool());
        this.d_tools.addTool(this.d_compositeViewTool3d, ToolName.ORBIT.get(), Intl.intl("3D Orbit Navigation"), OrbitFunc.ICON);
        PlanarGeomBuilderDisplay d_planarGeomBuilderDisp = new PlanarGeomBuilderDisplay(this);
        this.d_ribbonEditorPanel = new SelectionRibbonEditorPanel(this.d_data);
        this.d_toolPropsPanel.addEditor(this.d_ribbonEditorPanel);
        this.d_tablePropsEditorPanel = new SelectionPropertyEditorPanel(this.d_data);
        WorkingPlane workingPlane = new WorkingPlane(this.d_data);
        MerlinToolHooks toolHooks = new MerlinToolHooks(this.d_data);
        TranslateManip transManip = new TranslateManip(this, this.d_dispMgr, this.d_xformDispMgr);
        this.d_translateTool = new TranslateTool(this.d_data, this, transManip, this.d_dispMgr.toolScene.scene, this.d_dispProps, toolHooks);
        TranslatePanel transPnl = new TranslatePanel(this.d_data);
        this.addModalTool(this.d_translateTool, ToolName.MOVE.get(), Intl.intl("Copy/Move Objects"), guiUtil.loadMerlinIcon("moveObj16.gif"), new MerlinToolPropsInfo(this.getToolScene(), this.getToolPropsPanel(), null, transPnl, null, transManip, false));
        RotateManip rotManip = new RotateManip(this.d_data, this, this.d_dispMgr, this.d_xformDispMgr);
        this.d_rotateTool = new RotateTool(this.d_data, this, rotManip, this.d_dispMgr.toolScene.scene, this.d_dispProps, toolHooks);
        RotatePanel rotPnl = new RotatePanel(this.d_data);
        this.addModalTool(this.d_rotateTool, ToolName.ROTATE.get(), Intl.intl("Rotate Objects"), guiUtil.loadMerlinIcon("rotateObj16.gif"), new MerlinToolPropsInfo(this.getToolScene(), this.getToolPropsPanel(), null, rotPnl, null, rotManip, false));
        MirrorManip mirrorManip = new MirrorManip(this, this.d_dispMgr, this.d_xformDispMgr);
        this.d_mirrorTool = new MirrorTool(this.d_data, this, mirrorManip, this.d_dispMgr.toolScene.scene, this.d_dispProps, toolHooks);
        MirrorPanel mirrorPnl = new MirrorPanel(this.d_data);
        this.addModalTool(this.d_mirrorTool, ToolName.MIRROR.get(), Intl.intl("Mirror Objects"), guiUtil.loadMerlinIcon("mirror16.png"), new MerlinToolPropsInfo(this.getToolScene(), this.getToolPropsPanel(), null, mirrorPnl, null, mirrorManip, false));
        VentusApp.getApp().getComponents(ITool.class).forEach(item -> {
            item.init(this);
            this.d_featureTools.add((ITool<?>)item);
            MerlinToolPropsInfo info = new MerlinToolPropsInfo(item.getScene(), this.getToolPropsPanel(), item.getTool(), item.getPanel(), item.getDisplay(), (MerlinProps)item.getBuilder(), true);
            this.addModalTool(item.getTool(), item.getName(), item.getTooltip(), item.getIcon(), info);
        });
        PolyBuilder geomPolyAdder = new PolyBuilder(this.d_data, workingPlane, new RoomGeomBuilder(RoomGeomBuilder.BooleanOp.ADD, responder));
        NewPolyPanel geomPolyPanel = new NewPolyPanel(this.d_data, 9, new RoomTypePanel());
        this.d_openSpacePolyTool = new NewPolyTool(this);
        this.addModalTool(this.d_openSpacePolyTool, ToolName.NEW_POLY_ROOM.get(), Intl.intl("Add a Polygonal Room"), guiUtil.loadMerlinIcon("openpoly16.png"), new MerlinToolPropsInfo(this.getMainScene(), this.getToolPropsPanel(), this.d_openSpacePolyTool, geomPolyPanel, d_planarGeomBuilderDisp, geomPolyAdder, true));
        RectBuilder geomRectAdder = new RectBuilder(this.d_data, workingPlane, new RoomGeomBuilder(RoomGeomBuilder.BooleanOp.ADD, responder));
        NewRectPanel geomRectPanel = new NewRectPanel(this.d_data, new RoomTypePanel());
        this.d_openSpaceRectTool = new NewRectTool(this);
        this.addModalTool(this.d_openSpaceRectTool, ToolName.NEW_RECT_ROOM.get(), Intl.intl("Add a Rectangular Room"), guiUtil.loadMerlinIcon("openrect16.png"), new MerlinToolPropsInfo(this.getMainScene(), this.getToolPropsPanel(), this.d_openSpaceRectTool, geomRectPanel, d_planarGeomBuilderDisp, geomRectAdder, true));
        WallSubBuilder d_wallBuilder = new WallSubBuilder(this.d_data, responder, workingPlane);
        NewWallPanel d_wallPanel = new NewWallPanel(this.d_data);
        this.d_wallTool = new NewWallSubTool(this);
        this.addModalTool(this.d_wallTool, ToolName.ADD_THICK_WALL.get(), Intl.intl("Add a Thick Wall"), guiUtil.loadMerlinIcon("block16.gif"), new MerlinToolPropsInfo(this.getMainScene(), this.getToolPropsPanel(), this.d_wallTool, d_wallPanel, d_planarGeomBuilderDisp, d_wallBuilder, true));
        FloorExtractor3D floorExtractor = new FloorExtractor3D();
        this.d_floorExtractTool = new FloorExtractionTool(this);
        FloorExtractor3DPanel floorExtPnl = new FloorExtractor3DPanel();
        this.d_tools.addToolChangeListener((oldTool, newTool) -> {
            Object meta;
            this.updateCurrentTool(oldTool, newTool);
            if (oldTool != null && (meta = this.d_tools.getProps((Tool)oldTool).meta) instanceof ToolPropsInfo) {
                ((ToolPropsInfo)meta).deactivate();
            }
            if (newTool != null) {
                meta = this.d_tools.getProps((Tool)newTool).meta;
                if (meta instanceof ToolPropsInfo) {
                    ToolPropsInfo propsInfo = (ToolPropsInfo)meta;
                    propsInfo.activate();
                    if (propsInfo.d_clearSelOnActivate) {
                        AMerlinOp op = new AMerlinOp(this){

                            @Override
                            public void run(VentusApp app1, VentusData md) {
                                try (VentusData.WriteLock lock = md.lockWrite();){
                                    Undo.begin("Clear Selection");
                                    Undo.insertUndoEntry_restoreSelection(md);
                                    boolean modified = !md.selection.isEmpty();
                                    md.selection.clear();
                                    Undo.end(md, modified);
                                }
                            }
                        };
                        UIHook.run(null, "ModelView.ToolChangeListener.toolWillChanged", op, 4);
                    }
                } else {
                    this.d_toolPropsPanel.setEditor(this.d_ribbonEditorPanel);
                }
            }
        });
        this.initPredefCameras();
        this.d_gridSnapper = new GridSnapper(new UnitDouble(0.5, SI.METER));
        this.d_gridSnapperDisp = new GridSnapperDisp(0.0);
        this.d_gridSnapper.addObserver(new Observer(){

            @Override
            public void update(Observable o, Object arg) {
                ModelView.this.d_gridSnapperDisp.setSpacing(ModelView.this.d_gridSnapper.getSpacing().getValue(Geometry.LENGTH_UNIT));
            }
        });
        this.updateGridSnapperDisplay();
        this.d_viewToolbar = this.createViewToolbar();
        this.d_viewOptionsToolbar = this.createViewOptionsToolbar();
        this.d_navToolbar = this.createNavToolbar();
        this.d_creationToolbar = this.createCreationToolbar();
        this.d_editToolbar = this.createEditToolbar();
        this.d_utilityToolbar = this.createUtilityToolBar();
        this.d_panel = this.createMainPanel();
        this.d_menu = this.createMainMenu();
        this.d_drawMode2d.currentTool = this.d_selectionTool2D;
        this.d_drawMode3d.currentTool = this.d_selectionTool3D;
        this.d_drawMode = this.d_drawMode3d;
        this.updateColors(null);
        this.setMainCamera(this.d_cameras[3]);
        this.d_tools.setCurrentTool(this.d_drawMode.currentTool);
        this.updateDrawProps();
        this.updatePrefs();
        this.d_renderComp.addComponentListener(new AbstractComponentListener(){

            @Override
            public void componentResized(ComponentEvent e) {
                ModelView.this.d_renderComp.removeComponentListener(this);
                ModelView.this.resetCameras(ModelView.this.d_cameras);
                ModelView.this.d_renderComp.repaint();
            }
        });
        this.d_colors.addColorChangedListener(this);
        this.applyPrefs();
        int colorBy = app.getPrefs().getInt(MerlinPrefs.ColorRoomsByProp);
        Stream.of(MerlinDispProps.ColorRoomsBy.values()).filter(cb -> cb.prefId == colorBy).findFirst().ifPresent(cb -> this.d_dispProps.setColorRoomsBy((MerlinDispProps.ColorRoomsBy)((Object)cb)));
        this.updateTransformToolEnabled();
        this.updateResetToSelectedEnabled();
        this.d_data.getEvents().addObserver(this);
        this.reset();
        this.d_renderComp.addKeyListener(new GCListener());
        this.d_renderComp.addResourceInitListener(rend -> this.detectVideoAdapter());
    }

    public VentusData getData() {
        return this.d_data;
    }

    public Camera getPredefCamera(int cam) {
        return this.d_cameras[cam];
    }

    @Override
    public boolean endTool(Tool tool, boolean cancelled) {
        return this.d_tools.endTool(tool, cancelled);
    }

    @Override
    public <T> T getPreference(TypedProp<T> pref) {
        return MerlinPrefs.instance().getSystemOverLocal(pref);
    }

    public PropPanel getToolPropsPanel() {
        return this.d_toolPropsPanel;
    }

    public ToolManager getTools() {
        return this.d_tools;
    }

    public ToolToggleButton getToolbarButton(Tool tool) {
        return this.d_tools.getToolbarButton(tool);
    }

    public boolean validateEditor(boolean showWarnings, boolean commitData) {
        return this.d_toolPropsPanel.validateData(showWarnings, commitData);
    }

    public MerlinDispProps getDisplayProps() {
        return this.d_dispProps;
    }

    public GlobalDisplayMgr getDisplayManager() {
        return this.d_dispMgr;
    }

    public ManipMgr getManipMgr() {
        return this.d_manipListener.getManager();
    }

    public ManipHook getManipListener() {
        return this.d_manipListener;
    }

    private CompositeFunc<?> create3DCompositeTool() {
        CompositeFunc tool = NavtoolUtil.newCompositeNav3DTool(this.d_orbitTool.getFunction(), this.d_zoomTool.getFunction(), this.d_dragTool.getFunction(), this.d_selFunc);
        return tool;
    }

    @Override
    public Unit[] getLengthUnits() {
        return new Unit[]{Geometry.LENGTH_UNIT, VentusApp.getApp().getUnitSystem().getLength()};
    }

    @Override
    public ModelScene[] getToolScenes() {
        return new ModelScene[]{this.d_dispMgr.mainScene.scene, null};
    }

    private static <T> void updatePref(TypedProp<T> oldPref, TypedProp<T> newPref) {
        TeciProps props = MerlinPrefs.instance();
        if (props.isDefined(oldPref)) {
            if (!props.isDefined(newPref)) {
                T oldVal = props.get(oldPref);
                VentusApp.setPref(newPref, oldVal);
            }
            VentusApp.removePref(oldPref);
        }
    }

    private void upgradePrefs() {
        this.setPrefs(() -> {
            ModelView.updatePref(MerlinPrefs.KEY_USEVERTEXBUFFERS, RenderPrefs.PREF_USEVERTEXBUFFERS);
            ModelView.updatePref(MerlinPrefs.SCENE_SHADERS, RenderPrefs.PREF_SCENESHADERS);
            ModelView.updatePref(MerlinPrefs.SCENE_MULTISAMPLES, RenderPrefs.PREF_MULTISAMPLES);
            ModelView.updatePref(MerlinPrefs.SCENE_ANISOTROPIC_FILTERING, RenderPrefs.PREF_ANISOTROPIC_FILTERING);
        });
    }

    private static <T> boolean test(TypedProp<T> prop) {
        return MerlinPrefs.instance().containsKey(prop.key);
    }

    private static boolean getRetestGraphics() {
        return !ModelView.test(MerlinPrefs.KEY_HARDWARE_SKINNING_VP10) || !ModelView.test(MerlinPrefs.KEY_HARDWARE_SKINNING_GLSL140) || !ModelView.test(RenderPrefs.PREF_USEVERTEXBUFFERS) || !ModelView.test(RenderPrefs.PREF_SCENESHADERS);
    }

    private void setPrefs(final Runnable prefs) {
        AMerlinOp op = new AMerlinOp(this){

            @Override
            public void run(VentusApp app, VentusData md) {
                try (VentusData.WriteLock lock = md.lockWrite();){
                    prefs.run();
                }
            }
        };
        UIHook.run((Component)this.d_renderComp, null, op, 20);
    }

    private static void getLocalDefaultPrefs(TeciProps props, IRenderSurface.SurfPrefs caps) {
        props.set(MerlinPrefs.KEY_HARDWARE_SKINNING_VP10, Boolean.valueOf(false));
        props.set(MerlinPrefs.KEY_HARDWARE_SKINNING_GLSL140, Boolean.valueOf(caps.shaders));
    }

    public TeciProps getDefaultPrefs() {
        return RenderPrefs.getDefaultPrefs(this.d_renderComp, ModelView::getLocalDefaultPrefs);
    }

    public TeciProps getPreferredPrefs() {
        TeciProps props = RenderPrefs.getPreferredPrefs();
        props.set(MerlinPrefs.KEY_HARDWARE_SKINNING_VP10, Boolean.valueOf(false));
        props.set(MerlinPrefs.KEY_HARDWARE_SKINNING_GLSL140, Boolean.valueOf(true));
        return props;
    }

    public TeciProps getCompatibilityPrefs() {
        TeciProps props = RenderPrefs.getCompatibilityPrefs();
        props.set(MerlinPrefs.KEY_HARDWARE_SKINNING_VP10, Boolean.valueOf(false));
        props.set(MerlinPrefs.KEY_HARDWARE_SKINNING_GLSL140, Boolean.valueOf(false));
        return props;
    }

    private void detectVideoAdapter() {
        if (VentusApp.getApp().isSafeMode()) {
            return;
        }
        IRenderSurface.Adapter adapter = this.d_renderComp.getAdapter();
        MerlinPrefs.Version ver = MerlinPrefs.getVersion();
        boolean forceRedetect = ver.ordinal() < MerlinPrefs.Version.VER_0001.ordinal() || ModelView.getRetestGraphics() || ver.ordinal() < MerlinPrefs.Version.VER_0002.ordinal() && adapter != IRenderSurface.Adapter.NVIDIA || ver.ordinal() < MerlinPrefs.Version.VER_0003.ordinal() && adapter == IRenderSurface.Adapter.INTEL;
        TeciProps tprops = (TeciProps)MerlinPrefs.instance().clone();
        if (RenderPrefs.detectVideoAdapter(tprops, VentusApp.getApp().isSafeMode(), this.d_renderComp, forceRedetect, ModelView::getLocalDefaultPrefs)) {
            this.setPrefs(() -> VentusApp.setPrefs(tprops));
        }
    }

    public void showIntelWarning() {
        this.d_renderComp.addResourceInitListener(rc -> {
            if (this.d_renderComp.getAdapter() != IRenderSurface.Adapter.INTEL) {
                return;
            }
            MerlinOpImpl op = new MerlinOpImpl((app, md) -> {
                if (MerlinPrefs.getBoolean(RenderPrefs.INTEL_WARNING_SHOWN)) {
                    return;
                }
                md.uiLater(() -> {
                    Consumer<Boolean> setRemember = remember -> this.setPrefs(() -> VentusApp.setPref(RenderPrefs.INTEL_WARNING_SHOWN, remember));
                    RenderPrefs.showIntelWarning(this.d_renderComp, "Ventus", () -> this.d_renderComp.getOpenGLInfo(), setRemember, MerlinPrefs.getBoolean(RenderPrefs.INTEL_SAFE_MODE));
                });
            });
            UIHook.run((Component)this.d_renderComp, null, op, 20);
        });
    }

    public void applyPrefs() {
        this.forceImmediate(!MerlinPrefs.getBoolean(RenderPrefs.PREF_USEVERTEXBUFFERS));
        this.useHardwareSkinning(MerlinPrefs.getBoolean(MerlinPrefs.KEY_HARDWARE_SKINNING_VP10), MerlinPrefs.getBoolean(MerlinPrefs.KEY_HARDWARE_SKINNING_GLSL140));
        this.setMaxVBSize(MerlinPrefs.getLong(MerlinPrefs.KEY_RFIXED_MAX_VB_SIZE));
        Stream.Builder<SceneRenderOptions> ropts = Stream.builder();
        ropts.add(this.d_drawMode2d.props);
        ropts.add(this.d_drawMode3d.props);
        ropts.add(this.d_drawMode.props);
        RenderPrefs.applyPrefs(MerlinPrefs.instance(), Stream.of(this.d_renderComp), Stream.empty(), ropts.build());
    }

    public void forceImmediate(boolean immediateMode) {
        this.d_dispMgr.getScenes(scene -> scene.forceImmediate(immediateMode));
        this.d_xformDispMgr.getScenes(scene -> scene.forceImmediate(immediateMode));
        this.repaint();
    }

    public void useHardwareSkinning(boolean enabledVP10, boolean enabledGLSL140) {
        this.repaint();
    }

    public void setMaxVBSize(long maxSize) {
    }

    private void updateLayout() {
        OverlayLayout mainLayout = new OverlayLayout();
        OverlayLayout screenshotLayout = new OverlayLayout();
        if (this.d_mainView.getCamera() instanceof PerspectiveCamera) {
            this.initLayout3D(mainLayout);
            this.initLayout3D(screenshotLayout);
        } else {
            this.initLayout2D(mainLayout);
            this.initLayout2D(screenshotLayout);
        }
        mainLayout.add(this.d_axes, 13, 0.15f, 0.15f);
        mainLayout.add(this.d_toolLayer);
        this.d_renderComp.getRootPanel().setLayoutManager(mainLayout);
        this.d_renderFile.getRootPanel().setLayoutManager(screenshotLayout);
    }

    private void initLayout3D(OverlayLayout layout) {
        layout.add(this.d_background);
        GlobalDisplayMgr.initLayout3D(layout, Arrays.asList(this.d_dispMgr, this.d_xformDispMgr));
    }

    private void initLayout2D(OverlayLayout layout) {
        layout.add(this.d_background);
        GlobalDisplayMgr.initLayout2D(layout, Arrays.asList(this.d_dispMgr, this.d_xformDispMgr));
    }

    private void addModalTool(Tool tool, String name, String toolTip, Icon icon, ToolPropsInfo toolProps) {
        this.addModalTool(tool, name, toolTip, icon, toolProps, null);
    }

    private void addModalTool(Tool tool, String name, String toolTip, Icon icon, ToolPropsInfo toolProps, KeyStroke accelerator) {
        this.d_tools.addTool(tool, name, toolTip, icon, true, toolProps, accelerator);
        if (toolProps != null && toolProps.d_editor != null) {
            this.d_toolPropsPanel.addEditor(toolProps.d_editor);
        }
    }

    private void initPredefCameras() {
        this.d_cameras[0] = new OrthoCamera(new Point3d(0.0, 0.0, 1.0), new Point3d(0.0, 0.0, 0.0), new Vector3d(0.0, 1.0, 0.0), 0.0, 10000.0, 1.0);
        this.d_camResetDirs[0] = new Pair<Vector3d, Vector3d>(GeomConstants.VEC3D_YPOS, GeomConstants.VEC3D_ZNEG);
        this.d_cameras[1] = new OrthoCamera(new Point3d(0.0, -1.0, 0.0), new Point3d(0.0, 0.0, 0.0), new Vector3d(0.0, 0.0, 1.0), 0.0, 10000.0, 1.0);
        this.d_camResetDirs[1] = new Pair<Vector3d, Vector3d>(GeomConstants.VEC3D_ZPOS, GeomConstants.VEC3D_YPOS);
        this.d_cameras[2] = new OrthoCamera(new Point3d(-1.0, 0.0, 0.0), new Point3d(0.0, 0.0, 0.0), new Vector3d(0.0, 0.0, 1.0), 0.0, 10000.0, 1.0);
        this.d_camResetDirs[2] = new Pair<Vector3d, Vector3d>(GeomConstants.VEC3D_ZPOS, GeomConstants.VEC3D_XPOS);
        this.d_cameras[3] = new PerspectiveCamera(new Point3d(0.0, 0.0, 1.0), new Point3d(0.0, 0.0, 0.0), new Vector3d(0.0, 1.0, 0.0), 0.1, 10000.0, 65.0);
        this.d_camResetDirs[3] = new Pair<Vector3d, Vector3d>(GeomConstants.VEC3D_YPOS, GeomConstants.VEC3D_ZNEG);
    }

    private JToolBar createViewToolbar() {
        JToolBar toolbar = new JToolBar();
        toolbar.setFloatable(false);
        KeyStroke view1ks = KeyStroke.getKeyStroke(49, 128);
        KeyStroke view2ks = KeyStroke.getKeyStroke(50, 128);
        KeyStroke view3ks = KeyStroke.getKeyStroke(51, 128);
        KeyStroke view4ks = KeyStroke.getKeyStroke(52, 128);
        ChangeViewListener perspListener = this.createChangeViewListener(ToolName.PERSPECTIVE_VIEW.get(), Intl.intl("Switch to the Perspective View"), "ventus/icons/perspective16.png", 3, toolbar, view1ks);
        ChangeViewListener topListener = this.createChangeViewListener(ToolName.TOP_VIEW.get(), Intl.intl("Switch to the Top View"), "thunderheadeng/gui/graphics/ViewXY.gif", 0, toolbar, view2ks);
        ChangeViewListener frontListener = this.createChangeViewListener(ToolName.FRONT_VIEW.get(), Intl.intl("Switch to the Front View"), "thunderheadeng/gui/graphics/ViewXZ.gif", 1, toolbar, view3ks);
        ChangeViewListener leftListener = this.createChangeViewListener(ToolName.LEFT_VIEW.get(), Intl.intl("Switch to the Left View"), "thunderheadeng/gui/graphics/ViewYZ.gif", 2, toolbar, view4ks);
        guiUtil.addMEToolbarItems(toolbar, perspListener, topListener, frontListener, leftListener);
        perspListener.setSelected(true);
        Utils.noToolBarFocus(toolbar);
        return toolbar;
    }

    private ChangeViewListener createChangeViewListener(String name, String desc, String iconLocation, int c, JToolBar toolbar, KeyStroke accelerator) {
        ChangeViewListener listener = new ChangeViewListener(name, desc, iconLocation, c);
        toolbar.getInputMap(2).put(accelerator, name);
        toolbar.getActionMap().put(name, listener);
        return listener;
    }

    private JToolBar createViewOptionsToolbar() {
        JToolBar toolbar = new JToolBar();
        toolbar.setFloatable(false);
        toolbar.add(this.d_appearanceBox);
        toolbar.add(Box.createHorizontalStrut(2));
        this.d_filterActions.traverseByType(BooleanAction.class, (t, filterAction) -> toolbar.add(guiUtil.createToolbarToggleButton(filterAction)));
        Utils.noToolBarFocus(toolbar);
        this.d_appearanceBox.setMaximumSize(this.d_appearanceBox.getPreferredSize());
        return toolbar;
    }

    private JToolBar createNavToolbar() {
        JToolBar tb = new JToolBar();
        tb.setFloatable(false);
        Utils.noToolBarFocus(tb);
        this.updateNavToolbar(tb);
        return tb;
    }

    private void updateNavToolbar(JToolBar tb) {
        if (tb == null) {
            return;
        }
        tb.removeAll();
        if (this.getMainScene().getCamera() instanceof OrthoCamera) {
            tb.add(this.getToolbarButton(this.d_selectionTool2D));
        } else {
            tb.add(this.getToolbarButton(this.d_selectionTool3D));
            tb.add(this.getToolbarButton(this.d_compositeViewTool3d));
            tb.add(this.getToolbarButton(this.d_modGameRoamTool));
        }
        tb.add(this.getToolbarButton(this.d_dragTool));
        tb.add(this.getToolbarButton(this.d_zoomTool));
        tb.add(this.getToolbarButton(this.d_zoomBoxTool));
        tb.addSeparator();
        tb.add(this.d_resetAllHook);
        tb.add(this.d_resetToSelectedHook);
        tb.add(this.d_fillViewHook);
        Utils.noToolBarFocus(tb);
    }

    private JToolBar createCreationToolbar() {
        JToolBar tb = new JToolBar();
        tb.setLayout(new GridBagLayout());
        tb.setFloatable(false);
        GroupedSequence root = new GroupedSequence("", 0, tb);
        root.add("create", 0, new JToolBar()).addAll(0, this.d_translateTool, this.d_rotateTool, this.d_mirrorTool).addAll(5, new JToolBar.Separator(), this.d_openSpacePolyTool, this.d_openSpaceRectTool, this.d_thinWallTool, this.d_wallTool);
        this.d_featureTools.forEach(t -> t.addToolbarItem(root));
        if (VentusApp.isDev()) {
            root.getNode("create").add(this.d_developerTool);
        }
        GridBagHelper gbh = new GridBagHelper(tb, false, 1, 1);
        root.traverse(obj -> {
            int column;
            if (obj.parent == null) {
                return;
            }
            if (obj.current.data instanceof JToolBar.Separator) {
                gbh.nextRow();
                gbh.addSeparator();
                return;
            }
            if (obj.current.data instanceof Tool) {
                gbh.addCol((Component)this.getToolbarButton((Tool)obj.current.data), new Object[0]);
            }
            if ((column = gbh.getCurrentCol() + 1) % 2 != 0) {
                gbh.nextRow();
            }
        });
        tb.setFloatable(false);
        Utils.noToolBarFocus(tb);
        return tb;
    }

    private JToolBar createEditToolbar() {
        JToolBar tb = new JToolBar();
        tb.setFloatable(false);
        GridBagHelper gbh = new GridBagHelper(tb, false, 1, 1);
        gbh.addRow(this.d_tools.getToolbarButton(this.d_floorExtractTool));
        gbh.finalizeRows();
        Utils.noToolBarFocus(tb);
        return tb;
    }

    private JToolBar createUtilityToolBar() {
        JToolBar tb = new JToolBar();
        tb.setFloatable(false);
        GridBagHelper gbh = new GridBagHelper(tb, false, 1, 1);
        gbh.addRow(this.d_tools.getToolbarButton(this.d_measureTool));
        gbh.finalizeRows();
        Utils.noToolBarFocus(tb);
        return tb;
    }

    private JToolBar get3DToolToolBar() {
        JToolBar tb = new JToolBar();
        tb.setLayout(new GridBagLayout());
        GridBagHelper gbh = new GridBagHelper(tb, false, 1, 1);
        gbh.addRow(this.d_creationToolbar);
        gbh.addSeparator();
        gbh.addRow(this.d_utilityToolbar);
        gbh.finalizeRows();
        return tb;
    }

    private JToolBar getViewOptionsToolBar() {
        guiToolBar viewOptions = new guiToolBar();
        ((Container)viewOptions).add(this.d_viewToolbar);
        viewOptions.addSeparator();
        ((Container)viewOptions).add(this.d_viewOptionsToolbar);
        viewOptions.addSeparator();
        ((Container)viewOptions).add(this.d_navToolbar);
        Utils.noToolBarFocus(viewOptions);
        return viewOptions;
    }

    private JPanel createMainPanel() {
        JToolBar viewToolBar = this.getViewOptionsToolBar();
        VentusApp.getAppOpt().ifPresent(app -> app.registerHorizontalViewToolbar(viewToolBar));
        JToolBar toolsToolBar = this.get3DToolToolBar();
        toolsToolBar.setOrientation(1);
        toolsToolBar.setFloatable(false);
        viewToolBar.setFloatable(false);
        JPanel panel = new JPanel(new BorderLayout());
        JPanel viewPanel = new JPanel(new BorderLayout());
        viewPanel.add((Component)viewToolBar, "North");
        viewPanel.add((Component)new JSeparator(0), "South");
        JPanel toolsPanel = new JPanel(new BorderLayout());
        JPanel renderPanel = new JPanel(new BorderLayout());
        this.d_middlePanel = new JPanel(new BorderLayout());
        this.d_middlePanel.add((Component)this.d_renderComp, "Center");
        renderPanel.add((Component)this.d_middlePanel, "Center");
        final JSplitPane tableRenderSplit = new JSplitPane(1, true, renderPanel, this.d_tablePropsEditorPanel.getThemeAdjustedContainer());
        tableRenderSplit.setResizeWeight(1.0);
        this.d_tablePropsEditorPanel.addPropertyChangeListener("tab-shown", new PropertyChangeListener(){
            private int d_rememberedLoc = -1;

            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                if (!evt.getOldValue().equals(evt.getNewValue())) {
                    if (((Boolean)evt.getNewValue()).booleanValue()) {
                        tableRenderSplit.setDividerLocation(this.d_rememberedLoc);
                    } else {
                        if (tableRenderSplit.getDividerLocation() < tableRenderSplit.getMaximumDividerLocation()) {
                            this.d_rememberedLoc = tableRenderSplit.getDividerLocation();
                        }
                        tableRenderSplit.resetToPreferredSizes();
                    }
                }
                tableRenderSplit.setEnabled((Boolean)evt.getNewValue());
            }
        });
        JPanel compPanel = new JPanel(new BorderLayout());
        compPanel.add((Component)toolsToolBar, "West");
        compPanel.add((Component)tableRenderSplit, "Center");
        toolsPanel.add((Component)this.d_toolPropsPanel, "North");
        toolsPanel.add((Component)compPanel, "Center");
        panel.add((Component)viewPanel, "North");
        panel.add((Component)toolsPanel, "Center");
        panel.add((Component)this.d_statusBar, "South");
        return panel;
    }

    private GroupedSequence createMainMenu() {
        GroupedSequence viewGroup = new GroupedSequence("view", 50, new guiMenu(Intl.intl("&View")));
        viewGroup.addAll(10, guiUtil.createSelectableMenuItem(this.d_showOriginAction), guiUtil.createSelectableMenuItem(this.d_showSnapGridAction), this.d_snapGridHook.getMenuItem(), this.d_xrayOpacHook.getMenuItem());
        ArrayList filters = new ArrayList();
        this.d_filterActions.traverseByType(BooleanAction.class, (trip, fAction) -> filters.add(guiUtil.createSelectableMenuItem(fAction)));
        viewGroup.add("objectTypeFilters", 20, new JMenu(Intl.intl("Show Object Types"))).addAll(10, theUtil.toArray(filters, Object.class));
        viewGroup.addAll(40, new JPopupMenu.Separator(), guiUtil.createSelectableMenuItem(this.d_showGuidesAction), guiUtil.createSelectableMenuItem(this.d_showPointerAction), new JPopupMenu.Separator());
        viewGroup.add("ui-theme", 50, new ThemeChooserMenu(Intl.intl("Theme")));
        viewGroup.add("colorSchemes", 51, new ColorMgrMenu(Intl.intl("Color Scheme"), this.d_colors));
        viewGroup.add("units", 70, new JMenu(Intl.intl("Units"))).addAll(10, guiUtil.createRbMenuItemMutexGroup(UnitsAction.SI_ACTION, UnitsAction.ENGLISH_ACTION));
        viewGroup.addAll(80, new JPopupMenu.Separator(), this.d_resetAllHook.getMenuItem(), this.d_resetToSelectedHook.getMenuItem(), this.d_fillViewHook.getMenuItem());
        return viewGroup;
    }

    public void repaint() {
        this.d_renderComp.repaint();
    }

    private void updateAnimationTime() {
        double minStart = Double.POSITIVE_INFINITY;
        double maxEnd = Double.NEGATIVE_INFINITY;
        for (IFeatureAnimator anim : VentusApp.getApp().getComponents(IFeatureAnimator.class)) {
            Pair<Double, Double> timeRange = anim.getTimeRange();
            minStart = Math.min((Double)timeRange.v1, minStart);
            maxEnd = Math.max((Double)timeRange.v2, maxEnd);
        }
        if (maxEnd > minStart) {
            this.startAnimation(new double[]{minStart, maxEnd}, 0.0, 4);
        } else {
            this.stopAnimation();
        }
    }

    public void startAnimation(double[] tRange, double tInit, int options) {
        if (this.d_animInfo.isPresent()) {
            return;
        }
        this.stopAnimation();
        BitOptions opts = new BitOptions(options);
        MVAnimSession session = this.d_animSession;
        session.set(IAnimSession.TIME_RANGE, tRange);
        session.set(IAnimSession.TIME, tInit);
        session.set(IAnimSession.STATE, opts.get(2L) ? IAnimSession.State.PLAYING : IAnimSession.State.PAUSED);
        ArrayList<IAnimator> animators = new ArrayList<IAnimator>();
        animators.add(new TimeAnimator(this.d_animSession, opts.get(1L)));
        this.d_animSession.viewport.getAnimators(animators, this, this.d_animSession);
        animators.addAll(VentusApp.getApp().getComponents(IFeatureAnimator.class));
        Camera cam = this.d_animSession.viewport.getCamera(this);
        SwingUtilities.invokeLater(() -> {
            ChangeViewListener action = this.findChangeViewAction(cam);
            action.setSelected(true);
            this.setMainCamera(cam);
        });
        ArrayList<IAnimView> views = new ArrayList<IAnimView>();
        ArrayList<IEventObserver> observers = new ArrayList<IEventObserver>();
        IEventObserver repainter = events -> this.d_renderComp.render();
        observers.add(repainter);
        Optional<Component> tv = Optional.empty();
        ArrayList<Integer> status = new ArrayList<Integer>();
        if (opts.get(4L)) {
            TimeView timeView = new TimeView(this.d_animSession, this.d_animSession, 0);
            JPanel panel = new JPanel(new BorderLayout());
            panel.add((Component)timeView.getViewUI(), "Center");
            panel.add((Component)new JSeparator(), "South");
            SwingUtilities.invokeLater(() -> this.d_middlePanel.add((Component)panel, "South"));
            tv = Optional.of(panel);
            views.add(timeView);
            int statusIx = this.d_statusBar.addPane(new guiLabel(), 0.0);
            int timeIx = this.d_statusBar.addPane(new guiLabel(), 0.0);
            int speedIx = this.d_statusBar.addPane(new guiLabel(), 0.0);
            int fpsIx = this.d_statusBar.addPane(new guiLabel(), 0.0);
            status.add(statusIx);
            status.add(timeIx);
            status.add(speedIx);
            status.add(fpsIx);
            StatusView statusBarTimeView = new StatusView(this.d_animSession, this.d_animSession, new StatusView.BarInfo(this.d_statusBar, statusIx, timeIx, speedIx, fpsIx));
            views.add(statusBarTimeView);
        }
        this.d_animInfo = Optional.of(new TimeAnimInfo(this.d_animSession, tv, observers, views, status, animators));
        this.d_animInfo.get().start();
    }

    public Optional<MVAnimSession> getAnimation() {
        return this.d_animInfo.flatMap(ai -> Optional.of(ai.session));
    }

    public void stopAnimation() {
        this.d_animInfo.ifPresent(ai -> {
            ai.stop();
            ai.timeView.ifPresent(tv -> this.d_middlePanel.remove((Component)tv));
            ai.status.stream().sorted((i1, i2) -> i2 - i1).forEach(i -> this.d_statusBar.removePane((int)i));
            this.d_animInfo = Optional.empty();
        });
    }

    public ModelScene getMainScene() {
        return this.d_dispMgr.mainScene.scene;
    }

    public ModelScene getToolScene() {
        return this.d_dispMgr.toolScene.scene;
    }

    public ModelScene getElevatorScene() {
        return this.d_dispMgr.elevatorScene.scene;
    }

    public ModelScene getImportedGeomScene() {
        return this.d_dispMgr.importedGeomScene.scene;
    }

    public ModelScene getBGImageScene() {
        return this.d_dispMgr.bgimageScene.scene;
    }

    public RenderFile getScreenshotGenerator() {
        return this.d_renderFile;
    }

    public boolean isImportWireframe() {
        return this.d_drawMode.props.drawWireframe();
    }

    public void startChoosingPoints(final IPointPickListener listener) {
        Runnable runner = new Runnable(){

            @Override
            public void run() {
                Optional<PointPicker> opicker = ModelView.this.d_pointPickerTool.findFunc(PointPicker.class);
                assert (opicker.isPresent());
                opicker.ifPresent(picker -> {
                    picker.setListener(listener);
                    ModelView.this.beginTempTool(ModelView.this.d_pointPickerTool);
                });
            }
        };
        if (EventQueue.isDispatchThread()) {
            runner.run();
        } else {
            EventQueue.invokeLater(runner);
        }
    }

    public void stopChoosingPoints() {
        if (EventQueue.isDispatchThread()) {
            this.endTempTool();
        } else {
            EventQueue.invokeLater(new Runnable(){

                @Override
                public void run() {
                    ModelView.this.endTempTool();
                }
            });
        }
    }

    private void beginTempTool(Tool tool) {
        this.d_tools.setCurrentTool(tool, true);
    }

    private void endTempTool() {
        this.d_tools.cancelCurrentTool();
    }

    private void updateTransformToolEnabled() {
        Tool[] xformTools;
        Set<IMerlinObj> objs = TransformAction.getValidObjs(this.d_data);
        boolean xformEnabled = !objs.isEmpty();
        for (Tool tool : xformTools = new Tool[]{this.d_translateTool, this.d_rotateTool, this.d_mirrorTool}) {
            this.d_tools.getToolAction(tool).setEnabled(xformEnabled);
        }
        Tool currentTool = this.d_tools.getCurrentTool();
        if (currentTool != null) {
            Optional<ATransformManip> xform = this.findToolProps(currentTool, ATransformManip.class);
            xform.ifPresent(props -> props.setSelection(objs));
        }
    }

    private void updateResetToSelectedEnabled() {
        VentusData md = Objects.requireNonNull(VentusApp.getApp()).getData();
        IFilteredCollection<IMerlinGeomSrc> selObjs = md.selection.flatten(IMerlinGeomSrc.class);
        this.d_resetToSelectedHook.setEnabled(!selObjs.isEmpty());
    }

    private void updateConditionalToolsEnabled() {
        for (Tool tool : this.d_tools.getTools()) {
            if (!(tool instanceof IConditionallyEnabledTool)) continue;
            IConditionallyEnabledTool conditional = (IConditionallyEnabledTool)((Object)tool);
            this.setToolEnabled(tool, conditional.isEnabled(this.d_data));
        }
    }

    public <T extends MerlinProps> Optional<T> findToolProps(Tool tool, Class<T> expectedType) {
        ToolManager.ToolProps props = this.d_tools.getProps(tool);
        if (props.meta instanceof MerlinToolPropsInfo) {
            MerlinToolPropsInfo tpi = (MerlinToolPropsInfo)props.meta;
            return expectedType.isInstance(tpi.d_props) ? Optional.of((MerlinProps)expectedType.cast(tpi.d_props)) : Optional.empty();
        }
        return Optional.empty();
    }

    public void reset() {
        Consumer<FilterAction> updateAction = action -> action.update(this.d_data);
        this.d_filterActions.traverseByType(FilterAction.class, (trip, a) -> updateAction.accept((FilterAction)a));
        this.updateViewProps();
        this.updateCurrentTool();
        this.resetCameras(this.d_cameras);
    }

    @Override
    public void update(Events events) {
        IEventRecord<VentusData> mdRec;
        boolean reset;
        IEventRecord<IMerlinObj> genericRec;
        IEventRecord<IMerlinGeomSrc> geomRec;
        if (events.getEvents(VentusData.class, new Class[0]).containsChange(VentusData.PREFS_CHANGED)) {
            this.applyPrefs();
        }
        if ((geomRec = events.getEvents(IMerlinGeomSrc.class, new Class[0])).hasAddedObjs() || geomRec.hasRemovedObjs() || geomRec.containsChange(VentusData.SELECTION_CHANGED)) {
            this.updateTransformToolEnabled();
            this.updateResetToSelectedEnabled();
        }
        if ((genericRec = events.getEvents(IMerlinObj.class, new Class[0])).hasAddedObjs() || genericRec.hasRemovedObjs() || genericRec.containsChange(VentusData.SELECTION_CHANGED)) {
            this.updateConditionalToolsEnabled();
        }
        boolean cancelModalTool = false;
        IEventRecord<Object> objEvts = events.getEvents(Object.class, new Class[0]);
        if (objEvts.areChangesOnly() && objEvts.areChangesExclusiveTo(VentusData.SELECTION_CHANGED)) {
            cancelModalTool = !this.d_data.selection.isEmpty();
        }
        boolean bl = reset = (mdRec = events.getEvents(VentusData.class, new Class[0])).containsChange(Import.MODEL_IMPORTED) || mdRec.containsChange(VentusData.MODEL_LOADED);
        if (mdRec.containsChange(IFeatureAnimator.ANIMATION_CHANGED)) {
            this.updateAnimationTime();
        }
        this.d_dispProps.update(events);
        this.d_dispMgr.update(events);
        this.d_navMeshTris.update(events);
        if (cancelModalTool) {
            this.stopCurrentTool();
        }
        if (reset) {
            this.reset();
        } else {
            if (mdRec.containsChange(EVT_RESET_CAMERAS)) {
                this.resetCameras(this.d_cameras);
            }
            if (events.getEvents(ViewProps.class, new Class[0]).hasChangedObjs()) {
                this.updateViewProps();
            }
        }
        this.d_renderComp.repaint();
    }

    private void updateViewProps() {
        this.d_gridSnapper.setSpacing(this.d_data.viewProps.get(ViewProps.SKETCH_GRID_SPACING));
        if (this.d_appearanceBox.getSelectedItem() == this.d_xrayAction) {
            Consumer<DrawMode> applyTo = mode -> {
                if (mode.props.get(ISceneRenderOptions.OPACITY_FACTOR).floatValue() < 1.0f) {
                    mode.props.set(ISceneRenderOptions.OPACITY_FACTOR, this.d_data.viewProps.get(ViewProps.XRAY_OPACITY));
                }
            };
            applyTo.accept(this.d_drawMode2d);
            applyTo.accept(this.d_drawMode3d);
        }
    }

    public void applyCamera(CameraRecord state) {
        this.d_cameras[3].apply(state);
        ChangeViewListener action = this.findChangeViewAction(this.d_cameras[3]);
        action.setSelected(true);
        this.setMainCamera(this.d_cameras[3]);
        this.repaint();
    }

    private ChangeViewListener findChangeViewAction(Camera cam) {
        if (this.d_viewToolbar != null) {
            for (int m = 0; m < this.d_viewToolbar.getComponentCount(); ++m) {
                Component c = this.d_viewToolbar.getComponentAtIndex(m);
                if (!(c instanceof AbstractButton) || !(((AbstractButton)c).getAction() instanceof ChangeViewListener) || this.d_cameras[((ChangeViewListener)((AbstractButton)c).getAction()).d_camera] != cam) continue;
                return (ChangeViewListener)((AbstractButton)c).getAction();
            }
        }
        return null;
    }

    public JComponent getMainPanel() {
        return this.d_panel;
    }

    public GroupedSequence getMainMenu() {
        return this.d_menu;
    }

    @Override
    public RenderComponent getRenderComp() {
        return this.d_renderComp;
    }

    @Override
    public MerlinColors getColors() {
        return this.d_colors;
    }

    @Override
    public guiStatusMessage getStatusMessage() {
        return this.d_statusMessage;
    }

    @Override
    public GeomPicker getSnapper() {
        return this.d_snapper;
    }

    @Override
    public MVAnimSession getAnimSession() {
        return this.d_animSession;
    }

    @Override
    public IDeviceManager getDevices() {
        return this.d_tools.getDevices();
    }

    public View getMainView() {
        return this.d_mainView;
    }

    private void updateDrawProps() {
        this.d_drawMode.props.deleteObservers();
        this.d_dispMgr.updateDrawProps(this.d_mainView.getCamera(), this.d_drawMode.props);
        this.d_xformDispMgr.updateDrawProps(this.d_mainView.getCamera(), this.d_drawMode.props);
        boolean wireframe = this.d_drawMode.props.drawWireframe();
        boolean outline = this.d_drawMode.props.drawOutlines();
        boolean materials = this.d_drawMode.props.showMaterials();
        float opacity = this.d_drawMode.props.get(ISceneRenderOptions.OPACITY_FACTOR).floatValue();
        BooleanAction item = opacity != 1.0f ? this.d_xrayAction : (!wireframe && !outline && !materials ? this.d_solidAction : (!wireframe && outline && !materials ? this.d_solidOutlinesAction : (!wireframe && !outline && materials ? this.d_realisticAction : (!wireframe && outline && materials ? this.d_realisticOutlinesAction : (wireframe && !outline && !materials ? this.d_wireframeAction : this.d_realisticOutlinesAction)))));
        this.d_appearanceBox.setSelectedItem(item);
    }

    private void updatePrefs() {
    }

    public void savePreferences() {
        TeciProps prefs = VentusApp.getApp().getPrefs();
        prefs.set(MerlinPrefs.ShowSystemMouseProp, Boolean.valueOf(this.d_showPointerAction.isSelected()));
        prefs.set(MerlinPrefs.ShowGuidesProp, Boolean.valueOf(this.d_showGuidesAction.isSelected()));
        prefs.set(MerlinPrefs.DrawWireframeProp3d, Boolean.valueOf(this.d_drawMode3d.props.drawWireframe()));
        prefs.set(MerlinPrefs.ShowTexturesProp3d, Boolean.valueOf(this.d_drawMode3d.props.showMaterials()));
        prefs.set(MerlinPrefs.ShowOutlinesProp3d, Boolean.valueOf(this.d_drawMode3d.props.drawOutlines()));
        prefs.set(MerlinPrefs.UseSmoothLightingProp3d, Boolean.valueOf(this.d_drawMode3d.props.getLightModel() == ISceneRenderOptions.LightModel.LOCAL_CAMERA));
        prefs.set(MerlinPrefs.OpacityProp3d, this.d_drawMode3d.props.get(ISceneRenderOptions.OPACITY_FACTOR));
        prefs.set(MerlinPrefs.DrawWireframeProp2d, Boolean.valueOf(this.d_drawMode2d.props.drawWireframe()));
        prefs.set(MerlinPrefs.ShowTexturesProp2d, Boolean.valueOf(this.d_drawMode2d.props.showMaterials()));
        prefs.set(MerlinPrefs.ShowOutlinesProp2d, Boolean.valueOf(this.d_drawMode2d.props.drawOutlines()));
        prefs.set(MerlinPrefs.UseSmoothLightingProp2d, Boolean.valueOf(this.d_drawMode2d.props.getLightModel() == ISceneRenderOptions.LightModel.LOCAL_CAMERA));
        prefs.set(MerlinPrefs.OpacityProp2d, this.d_drawMode2d.props.get(ISceneRenderOptions.OPACITY_FACTOR));
        int colorBy = this.d_dispProps.getColorRoomsBy().prefId;
        prefs.set(MerlinPrefs.ColorRoomsByProp, Integer.valueOf(colorBy));
    }

    public void updateColors(ColorChangedEvent evt) {
        Color bgColor1 = this.d_colors.getColor(MerlinColors.BACKGROUND_COLOR);
        Color bgColor2 = this.d_colors.getColor(MerlinColors.BACKGROUND_COLOR2);
        this.d_background.setColors(bgColor1, bgColor2);
        float[] bgColorComps = bgColor1.getComponents(new float[4]);
        this.d_axes.setBackgroundColor(new Color(bgColorComps[0], bgColorComps[1], bgColorComps[2], 0.9f));
        this.d_axes.setAxisColor(this.d_colors.getColor(MerlinColors.AXIS_COLOR));
        this.d_axes.setBoxColor(this.d_colors.getColor(MerlinColors.AXIS_BOX_COLOR));
        this.d_axes.setTextColor(this.d_colors.getColor(MerlinColors.AXIS_TEXT_COLOR));
        this.d_origin.setColor(this.d_colors.getColor(MerlinColors.ORIGIN2D_COLOR));
        this.d_gridSnapperDisp.setColors(this.d_colors.getColor(MerlinColors.SNAP_TO_GRID_COLOR), this.d_colors.getColor(MerlinColors.SNAP_TO_POINTS_COLOR));
        this.updateAll();
    }

    private void updateAll() {
        this.d_dispMgr.updateAll();
        this.d_xformDispMgr.updateAll();
    }

    private void updateAll(Class<?> type) {
        Consumer<GlobalDisplayMgr> update = dispMgr -> {
            for (IMerlinDispMgr<?> mgr : dispMgr.getManagers()) {
                if (!mgr.getType().isAssignableFrom(type)) continue;
                mgr.updateAll();
            }
        };
        update.accept(this.d_dispMgr);
        update.accept(this.d_xformDispMgr);
    }

    private void setToolEnabled(Tool tool, boolean enable) {
        this.d_tools.getToolAction(tool).setEnabled(enable);
    }

    public Camera getCamera(int camId) {
        return this.d_cameras[camId];
    }

    public void setMainCamera(Camera camera) {
        this.stopCurrentTool();
        this.d_dispMgr.setMainCamera(camera);
        this.d_xformDispMgr.setMainCamera(camera);
        this.d_axes.setBaseCamera(camera);
        boolean ortho = camera instanceof OrthoCamera;
        this.d_drawMode = ortho ? this.d_drawMode2d : this.d_drawMode3d;
        this.d_tools.setCurrentTool(this.d_drawMode.currentTool);
        Plane3d zplane = new Plane3d(0.0, 0.0, 1.0, 0.0);
        boolean drawToolsEnabled = !ortho || !Util3D.areParallel(zplane, camera.getViewVector(), 1.0E-6);
        this.setToolEnabled(this.d_openSpacePolyTool, drawToolsEnabled);
        this.setToolEnabled(this.d_openSpaceRectTool, drawToolsEnabled);
        this.setToolEnabled(this.d_thinWallTool, drawToolsEnabled);
        this.setToolEnabled(this.d_wallTool, drawToolsEnabled);
        this.d_featureTools.forEach(t -> this.setToolEnabled(t.getTool(), drawToolsEnabled));
        this.updateLayout();
        this.updateDrawProps();
        this.updateCurrentTool();
        this.updateGridSnapperDisplay();
        this.updateNavToolbar(this.d_navToolbar);
    }

    private void stopCurrentTool() {
        this.d_tools.cancelCurrentTool();
    }

    private void updateCurrentTool() {
        this.updateCurrentTool(this.d_tools.getCurrentTool(), this.d_tools.getCurrentTool());
    }

    private void updateCurrentTool(Tool oldTool, Tool newTool) {
        if (newTool == this.d_modGameRoamTool) {
            AABox modelBounds = this.getModelSceneBounds();
            this.d_modGameRoamTool.findFunc(RoamFunc.class).ifPresent(rf -> rf.setModelBounds(modelBounds));
        }
        if (newTool instanceof CursorTool) {
            CursorTool ctool = (CursorTool)newTool;
            ctool.setGuidesVisible(this.d_showGuidesAction.isSelected());
            ctool.setPointerVisible(this.d_showPointerAction.isSelected());
            ctool.setView(this.d_mainView);
            this.d_toolLayer.clear();
            this.d_toolLayer.add(ctool);
        }
        this.d_drawMode.currentTool = newTool;
    }

    @Override
    public void colorChanged(final ColorChangedEvent e) {
        AMerlinOp op = new AMerlinOp(){

            @Override
            public void run(VentusApp app, VentusData md) {
                ModelView.this.updateColors(e);
                ModelView.this.d_renderComp.repaint();
            }
        };
        UIHook.run(null, "ModelView.colorChanged", op, 4);
    }

    private AABox getModelSceneBounds() {
        return this.getModelSceneBounds(true);
    }

    private AABox getModelSceneBounds(boolean useExcluded) {
        AABox bounds = new AABox(this.d_dispMgr.getModelSceneBounds(useExcluded));
        bounds.add(this.d_xformDispMgr.getModelSceneBounds(useExcluded));
        return bounds;
    }

    public void resetCurrentCamera() {
        this.resetCameras(this.d_mainView.getCamera());
    }

    public void resetCameras(Camera ... cams) {
        AABox bounds = this.getModelSceneBounds(false);
        this.resetCameras(bounds, cams);
    }

    public void resetCurrentCamera(Collection<?> objs) {
        this.resetCameras(objs, this.d_mainView.getCamera());
    }

    public void resetCameras(Collection<?> objs, Camera ... cams) {
        if (objs.isEmpty()) {
            this.resetCameras(cams);
            return;
        }
        AABox bb = new AABox();
        for (IMerlinGeomSrc geom : theUtil.filter(objs, IMerlinGeomSrc.class)) {
            bb.add(geom.getBounds());
        }
        this.resetCameras(bb, cams);
    }

    private void resetCameras(AABox bb, Camera ... cams) {
        bb = new AABox(bb.getMinX(), bb.getMinY(), bb.getMinZ(), bb.getMaxX(), bb.getMaxY(), bb.getMaxZ());
        for (Camera c : cams) {
            AABox box = new AABox(bb);
            c.ensureValidForReset(box, 5.0);
            Pair<Vector3d, Vector3d> resetDirs = this.getResetDirs(c);
            c.reset((Vector3d)resetDirs.v2, (Vector3d)resetDirs.v1, box, this.d_renderComp.getWidth(), this.d_renderComp.getHeight());
        }
    }

    private Pair<Vector3d, Vector3d> getResetDirs(Camera c) {
        int index = -1;
        for (int m = 0; m < this.d_cameras.length; ++m) {
            if (c != this.d_cameras[m]) continue;
            index = m;
            break;
        }
        if (index != -1) {
            if (index == 3) {
                Vector3d upDir;
                Vector3d viewDir;
                if (this.d_tools.getCurrentTool() == this.d_modGameRoamTool) {
                    viewDir = new Vector3d(0.0, 1.0, 0.0);
                    upDir = new Vector3d(0.0, 0.0, 1.0);
                } else {
                    viewDir = new Vector3d(0.0, 0.0, -1.0);
                    upDir = new Vector3d(0.0, 1.0, 0.0);
                }
                return new Pair<Vector3d, Vector3d>(upDir, viewDir);
            }
            return this.d_camResetDirs[index];
        }
        return new Pair<Vector3d, Vector3d>(GeomConstants.VEC3D_YPOS, GeomConstants.VEC3D_ZNEG);
    }

    public void fillCamera() {
        AABox bounds = this.getModelSceneBounds(false);
        this.fillCameras(bounds, this.d_mainView.getCamera());
    }

    public void fillCameras(AABox bb, Camera ... cameras) {
        for (Camera c : cameras) {
            AABox box = new AABox(bb);
            c.ensureValidForReset(box, 5.0);
            c.fillView(box, this.d_renderComp.getWidth(), this.d_renderComp.getHeight());
        }
    }

    public static <T> void setVisible(VentusApp app, VentusData data, Class<T> type, Predicate<T> filter, boolean visible) {
        app.beginWaitCursor();
        try (VentusData.WriteLock lock = data.lockWrite();){
            if (!visible) {
                data.displayFilter.registerFilter(type, filter);
            } else {
                data.displayFilter.removeFilter(type, filter);
            }
        }
        app.endWaitCursor();
    }

    public <T> void setVisible(Class<T> type, boolean visible) {
        MerlinOpImpl op = new MerlinOpImpl((app, data) -> ModelView.setVisible(app, data, type, Predicates.alwaysFalse(), visible));
        int options = 20;
        UIHook.run((Component)VentusApp.getApp().getActiveFrame(), "ModelView.setVisible", op, options);
    }

    public <T> boolean isVisible(Class<T> type) {
        return !this.d_data.displayFilter.isFilteringAllOf(type);
    }

    public UIHook getResetViewToSelOp() {
        return this.d_resetToSelectedHook;
    }

    public void mapShortcuts() {
        VentusShortcuts.RESET_VIEW.setOperator(this.d_resetAllHook);
        VentusShortcuts.FILL_VIEW.setOperator(this.d_fillViewHook);
        VentusShortcuts.RESET_TO_SELECTION.setOperator(this.d_resetToSelectedHook);
        VentusShortcuts.EDIT_SNAP_GRID.setOperator(this.d_snapGridHook);
        VentusShortcuts.EDIT_XRAY_OPACITY.setOperator(this.d_xrayOpacHook);
    }

    public JToolBar getViewsToolbar() {
        return this.d_viewToolbar;
    }

    @Override
    public void backgroundTaskStarted(Runnable cancel) {
        MerlinOpImpl op = new MerlinOpImpl((app, md) -> cancel.run());
        this.d_backgroundOps.put(cancel, op);
        UIHook.addPreOp(op);
    }

    @Override
    public void backgroundTaskEnded(Runnable cancelOp) {
        MerlinOpImpl op = this.d_backgroundOps.remove(cancelOp);
        if (op != null) {
            UIHook.removePreOp(op);
        }
    }

    public void updateSchematicColors() {
        this.updateAll(ISchematicComp.class);
    }

    private void updateGridSnapperDisplay() {
        boolean snap;
        boolean ortho = this.d_mainView.getCamera() instanceof OrthoCamera;
        boolean showGrid = ortho && this.d_showSnapGridAction.isSelected();
        boolean showOrigin = ortho && this.d_showOriginAction.isSelected();
        boolean bl = snap = showGrid || showOrigin;
        if (showGrid) {
            this.d_dispMgr.gridScene.scene.addRenderableObjects(this.d_gridSnapperDisp);
        } else {
            this.d_dispMgr.gridScene.scene.removeRenderableObjects(this.d_gridSnapperDisp);
        }
        if (showOrigin) {
            this.d_dispMgr.originScene.scene.addRenderableObjects(this.d_origin);
        } else {
            this.d_dispMgr.originScene.scene.removeRenderableObjects(this.d_origin);
        }
        if (snap) {
            this.d_data.geomLocation.getLocator().add(this.d_gridSnapper);
        } else {
            this.d_data.geomLocation.getLocator().remove(this.d_gridSnapper);
        }
        this.d_gridSnapper.setOriginOnly(showOrigin && !showGrid);
        this.d_gridSnapperDisp.setSpacing(this.d_gridSnapper.getSpacing().getValue(Geometry.LENGTH_UNIT));
    }

    private static class EditSketchGridSpacingOp
    extends AMerlinOp {
        private EditSketchGridSpacingOp() {
        }

        @Override
        public void run(VentusApp app, VentusData md) {
            UnitDouble spacing = md.viewProps.get(ViewProps.SKETCH_GRID_SPACING);
            ValueField<UnitDouble> field = MerlinValueFields.udFld(UnitDoubleVR.above(0.0, SI.METER, false), 0);
            guiInputDlg<UnitDouble> dlg = new guiInputDlg<UnitDouble>((Window)VentusApp.getApp().getMainFrame(), Intl.intl("Edit Snap Grid"), Intl.intl("Snap grid spacing:"), field, spacing, UnitDouble.class);
            if (dlg.doModal() != 1) {
                return;
            }
            UnitDouble newSpacing = dlg.getValue();
            if (newSpacing == null) {
                return;
            }
            try (VentusData.WriteLock lock = md.lockWrite();){
                Undo.begin(Intl.intl("Edit Snap Grid"));
                Undo.insertUndoEntry_restore(md, md.viewProps);
                md.viewProps.setIfNotDefault(ViewProps.SKETCH_GRID_SPACING, newSpacing);
                Undo.end(md);
            }
        }
    }

    private static class EditXrayOpacityOp
    extends AMerlinOp {
        private EditXrayOpacityOp() {
        }

        @Override
        public void run(VentusApp app, final VentusData md) {
            float opacity = md.viewProps.get(ViewProps.XRAY_OPACITY).floatValue();
            final guiSliderVal slider = new guiSliderVal(1, 99);
            slider.setValue(opacity);
            guiDialog dlg = new guiDialog((Window)app.getActiveFrame(), Intl.intl("X-ray Opacity"), 16);
            GridBagHelper gb = new GridBagHelper(dlg.getDialogPane());
            gb.addRow(Intl.intl("X-ray opacity:"), slider);
            gb.finalizeRows();
            Semaphore counter = new Semaphore(1);
            float[] undoRestoreValue = new float[]{opacity};
            final BooleanConsumer saveValue = saveState -> {
                float value = slider.getValue();
                MerlinOpImpl op = new MerlinOpImpl((va, vd) -> {
                    if (!counter.tryAcquire()) {
                        return;
                    }
                    try (VentusData.WriteLock lock = md.lockWrite();){
                        if (theUtil.eq(value, vd.viewProps.get(ViewProps.XRAY_OPACITY).floatValue(), 1.0E-6) && (!saveState || theUtil.eq(undoRestoreValue[0], vd.viewProps.get(ViewProps.XRAY_OPACITY).floatValue(), 1.0E-6))) {
                            return;
                        }
                        if (saveState) {
                            Undo.begin(Intl.intl("Edit X-Ray Opacity"));
                            md.viewProps.setIfNotDefault(ViewProps.XRAY_OPACITY, Float.valueOf(undoRestoreValue[0]));
                            Undo.insertUndoEntry_restore(md, md.viewProps);
                        }
                        md.viewProps.setIfNotDefault(ViewProps.XRAY_OPACITY, Float.valueOf(value));
                        if (saveState) {
                            Undo.end(md);
                            undoRestoreValue[0] = value;
                        }
                    }
                    finally {
                        counter.release();
                    }
                });
                UIHook.run((Component)app.getActiveFrame(), "EditXrayOpacityOp.run", op, 4);
            };
            slider.addValueChangeListener(e -> saveValue.accept(!slider.isAdjusting()));
            slider.addPropertyChangeListener("SLIDER_FINISHED", e -> saveValue.accept(true));
            final IEventObserver[] observer = new IEventObserver[]{events -> {
                if (events.getEvents(ViewProps.class, new Class[0]).isModified()) {
                    float opac;
                    if (!counter.tryAcquire()) {
                        return;
                    }
                    undoRestoreValue[0] = opac = md.viewProps.get(ViewProps.XRAY_OPACITY).floatValue();
                    slider.setValue(opac);
                    counter.release();
                }
                if (events.getEvents(VentusData.class, new Class[0]).hasChangedObjs(VentusData.MODEL_LOADED, VentusData.MODEL_RESET)) {
                    dlg.setVisible(false);
                }
            }};
            md.getEvents().addObserver(observer[0]);
            dlg.addWindowListener(new WindowAdapter(this){

                @Override
                public void windowClosed(WindowEvent e) {
                    if (slider.isAdjusting()) {
                        saveValue.accept(true);
                    }
                    md.getEvents().removeObserver(observer[0]);
                    observer[0] = null;
                }
            });
            dlg.doModeless();
        }
    }

    private class ResetToAllObjectsAction
    extends AMerlinOp {
        @Override
        public void run(VentusApp app, VentusData md) {
            ModelView.this.resetCurrentCamera();
            ModelView.this.updateCurrentTool();
            ModelView.this.d_renderComp.repaint();
        }
    }

    private class ResetToSelectedObjectsAction
    extends AMerlinOp {
        @Override
        public void run(VentusApp app, VentusData md) {
            ModelView.this.resetCurrentCamera(md.selection.getDeepSelected(IMerlinGeomSrc.class));
            ModelView.this.updateCurrentTool();
            ModelView.this.d_renderComp.repaint();
        }
    }

    private class FillViewAction
    extends AMerlinOp {
        private FillViewAction() {
        }

        @Override
        public void run(VentusApp app, VentusData md) {
            ModelView.this.fillCamera();
            ModelView.this.d_renderComp.repaint();
        }
    }

    private static class DrawMode {
        public Tool currentTool;
        public SceneRenderOptions props = new SceneRenderOptions();

        private DrawMode() {
        }
    }

    private class ShowRealisticAction
    extends DrawModeAction {
        private static final long serialVersionUID = 1L;

        public ShowRealisticAction(boolean initValue) {
            super(initValue, Intl.intl("Realistic"), Intl.intl("Show geometry using surface appearances"), "ventus/icons/textures.png", false, false, true, 1.0f);
        }
    }

    private class ShowRealisticOutlinesAction
    extends DrawModeAction {
        private static final long serialVersionUID = 1L;

        public ShowRealisticOutlinesAction(boolean initValue) {
            super(initValue, Intl.intl("Realistic with Outlines"), Intl.intl("Show geometry using surface appearances with outlines"), "ventus/icons/texturesOutline.png", false, true, true, 1.0f);
        }
    }

    private class ShowOutlinesAction
    extends DrawModeAction {
        private static final long serialVersionUID = 1L;

        public ShowOutlinesAction(boolean initValue) {
            super(initValue, Intl.intl("Solid with Outlines"), Intl.intl("Show geometry as solids with outlines"), "ventus/icons/outlines.png", false, true, false, 1.0f);
        }
    }

    private class ShowXrayAction
    extends SetPropAction {
        private static final long serialVersionUID = 1L;

        public ShowXrayAction(boolean initValue) {
            super(initValue, Intl.intl("X-Ray"), Intl.intl("Show geometry as translucent."), "ventus/icons/xray16.png");
        }

        @Override
        protected void setProp(boolean selected) {
            ModelView.this.d_drawMode.props.setDrawWireframe(false);
            ModelView.this.d_drawMode.props.setDrawOutlines(true);
            ModelView.this.d_drawMode.props.setShowMaterials(true);
            ModelView.this.d_drawMode.props.set(ISceneRenderOptions.OPACITY_FACTOR, ModelView.this.d_data.viewProps.get(ViewProps.XRAY_OPACITY));
        }
    }

    private class UseWireframeAction
    extends DrawModeAction {
        private static final long serialVersionUID = 1L;

        public UseWireframeAction(String name, String desc, boolean selected, String iconLocation, boolean wireframe) {
            super(selected, name, desc, iconLocation, wireframe, false, false, 1.0f);
        }
    }

    private class ToolUpdateBoolAction
    extends AMerlinBoolAction {
        private static final long serialVersionUID = 1L;

        public ToolUpdateBoolAction(String desc, boolean initValue) {
            super(desc, initValue);
        }

        @Override
        protected void work(VentusData data, boolean selected) {
            ModelView.this.updateCurrentTool();
            ModelView.this.d_renderComp.repaint();
        }
    }

    private static class DescendentFilter<T extends IMerlinObj>
    implements Predicate<T> {
        private final VentusData d_data;
        private final IMerlinObj d_root;

        public DescendentFilter(VentusData data, IMerlinObj root) {
            this.d_data = data;
            this.d_root = root;
        }

        @Override
        public boolean test(IMerlinObj o) {
            return !this.d_data.hierarchy.isDescendent(this.d_root, o);
        }
    }

    private class DisplayVisToggleAction
    extends AMerlinBoolAction {
        private static final long serialVersionUID = 1L;

        public DisplayVisToggleAction() {
            super(Intl.intl("Show Mesh Triangles"), false);
            ModelView.this.d_navMeshTris.setVisible(false);
        }

        @Override
        protected void work(VentusData data, boolean selected) {
            ModelView.this.d_navMeshTris.setVisible(selected);
            ModelView.this.repaint();
        }
    }

    private class UpdateSnapGridAction
    extends AMerlinBoolAction {
        private static final long serialVersionUID = 1L;

        public UpdateSnapGridAction(String name, boolean initValue) {
            super(name, initValue);
        }

        @Override
        protected void work(VentusData md, boolean selected) {
            try (VentusData.WriteLock lock = md.lockWrite();){
                ModelView.this.updateGridSnapperDisplay();
            }
            md.ui(() -> ModelView.this.repaint());
        }
    }

    private class CorrDrawOptionsAction
    extends AMerlinBoolAction {
        private static final long serialVersionUID = 1L;
        private final int d_options;

        public CorrDrawOptionsAction(String name, int options, boolean initValue) {
            super(name, initValue, null);
            this.d_options = options;
        }

        @Override
        protected void work(VentusData data, boolean selected) {
            ModelView.this.d_dispProps.setStairDrawOptions(this.d_options, selected);
            ModelView.this.updateAll(SchematicCorridor.class);
            ModelView.this.repaint();
        }
    }

    private class DoorDrawOptionsAction
    extends AMerlinBoolAction {
        private static final long serialVersionUID = 1L;
        private final int d_options;

        public DoorDrawOptionsAction(String name, int options, boolean initValue) {
            super(name, initValue, null);
            this.d_options = options;
        }

        @Override
        protected void work(VentusData data, boolean selected) {
            ModelView.this.d_dispProps.setDoorDrawOptions(this.d_options, selected);
            ModelView.this.updateAll(SchematicCorridor.class);
            ModelView.this.updateAll(ISchematicConnector.class);
            ModelView.this.repaint();
        }
    }

    public static class ToolPropsInfo {
        public final ModelScene d_scene;
        public final Tool d_tool;
        public final ventus.gui.IPropEditor d_editor;
        public final IMerlinDisplay d_display;
        public final boolean d_clearSelOnActivate;
        public final PropPanel d_toolPropsPanel;

        public ToolPropsInfo(ModelScene scene, PropPanel toolPropsPanel, Tool tool, ventus.gui.IPropEditor editor, IMerlinDisplay display) {
            this(scene, toolPropsPanel, tool, editor, display, true);
        }

        public ToolPropsInfo(ModelScene scene, PropPanel toolPropsPanel, Tool tool, ventus.gui.IPropEditor editor, IMerlinDisplay display, boolean clearSelOnActivate) {
            this.d_scene = scene;
            this.d_toolPropsPanel = toolPropsPanel;
            this.d_tool = tool;
            this.d_editor = editor;
            this.d_display = display;
            this.d_clearSelOnActivate = clearSelOnActivate;
        }

        public void activate() {
            this.d_toolPropsPanel.setEditor(this.d_editor);
            if (this.d_display != null) {
                this.d_scene.addObjects(this.d_display.getDisplayObjs());
            }
            if (this.d_editor != null) {
                SwingUtilities.invokeLater(() -> this.d_editor.activate());
            }
        }

        public void deactivate() {
            if (this.d_display != null) {
                this.d_scene.removeObjects(this.d_display.getDisplayObjs());
            }
        }
    }

    public static class MerlinToolPropsInfo
    extends ToolPropsInfo {
        public final MerlinProps d_props;
        public final IPropsDisplay<MerlinProps> d_propDisp;

        public MerlinToolPropsInfo(ModelScene scene, PropPanel toolPropsPanel, MerlinTool<? extends MerlinProps> tool, IPropEditor<? extends MerlinProps> panel, IPropsDisplay propsDisp, MerlinProps props, boolean clearSelOnActivate) {
            super(scene, toolPropsPanel, tool, panel, propsDisp != null ? propsDisp.getDisplay() : null, clearSelOnActivate);
            this.d_props = props;
            this.d_propDisp = propsDisp;
        }

        public void setProps() {
            if (this.d_tool != null) {
                ((MerlinTool)this.d_tool).setProps(this.d_props);
            }
            if (this.d_editor != null) {
                ((IPropEditor)this.d_editor).setProps(this.d_props);
            }
            if (this.d_propDisp != null) {
                this.d_propDisp.setProps(this.d_props);
            }
        }

        @Override
        public void activate() {
            this.setProps();
            super.activate();
        }

        @Override
        public void deactivate() {
            super.deactivate();
        }
    }

    private static class GCListener
    extends KeyAdapter {
        private GCListener() {
        }

        @Override
        public void keyPressed(KeyEvent evt) {
            if (evt.getKeyCode() == 123) {
                long total = Runtime.getRuntime().totalMemory() / 1024L / 1024L;
                long freemem = Runtime.getRuntime().freeMemory() / 1024L / 1024L;
                long inuse = total - freemem;
                System.out.printf("in use before: %d MB%n", inuse);
                System.gc();
                System.runFinalization();
                long totalnow = Runtime.getRuntime().totalMemory() / 1024L / 1024L;
                long freenow = Runtime.getRuntime().freeMemory() / 1024L / 1024L;
                long inusenow = totalnow - freenow;
                long delta = inuse - inusenow;
                System.out.printf("in use after: %d MB (freed %d MB)%n", inusenow, delta);
                System.out.printf("total: %d (%d) MB%n", totalnow, freenow);
            }
        }
    }

    private class ChangeViewListener
    extends AMerlinBoolAction {
        private static final long serialVersionUID = 1L;
        private final int d_camera;

        public ChangeViewListener(String name, String desc, String iconLocation, int c) {
            super(name, false, new ImageIcon(ClassLoader.getSystemResource(iconLocation)));
            this.putValue("ShortDescription", desc);
            this.d_camera = c;
        }

        @Override
        protected void work(VentusData data, boolean selected) {
            if (!selected) {
                return;
            }
            ModelView.this.setMainCamera(ModelView.this.d_cameras[this.d_camera]);
            ModelView.this.d_renderComp.repaint();
        }
    }

    private static class TimeAnimInfo {
        public final MVAnimSession session;
        public final Optional<Component> timeView;
        public final List<IEventObserver> observers;
        public final List<IAnimView> views;
        public final List<Integer> status;
        public final List<IAnimator> animators;

        public TimeAnimInfo(MVAnimSession session, Optional<Component> timeView, List<IEventObserver> observers, List<IAnimView> views, List<Integer> status, List<IAnimator> animators) {
            this.session = session;
            this.timeView = timeView;
            this.observers = observers;
            this.views = views;
            this.status = status;
            this.animators = animators;
        }

        private void start() {
            this.animators.forEach(this.session::addAnimator);
            this.observers.forEach(this.session.getEvents()::addObserver);
            this.views.forEach(IAnimView::connect);
            this.session.start();
        }

        private void stop() {
            this.session.stop();
            this.views.forEach(IAnimView::disconnect);
            this.observers.forEach(this.session.getEvents()::removeObserver);
            this.animators.forEach(this.session::removeAnimator);
        }
    }

    private class ColorRoomsByAction
    extends AMerlinBoolAction {
        private static final long serialVersionUID = 1L;
        private final MerlinDispProps.ColorRoomsBy d_colorByType;

        public ColorRoomsByAction(MerlinDispProps.ColorRoomsBy colorByType) {
            super(colorByType.desc, false);
            this.putValue("ShortDescription", colorByType.longDesc);
            this.d_colorByType = colorByType;
        }

        @Override
        protected void work(VentusData data, boolean selected) {
            if (!selected) {
                return;
            }
            this.setMode();
            ModelView.this.repaint();
        }

        private void setMode() {
            ModelView.this.d_dispProps.setColorRoomsBy(this.d_colorByType);
            ModelView.this.updateSchematicColors();
        }
    }

    private class DrawModeAction
    extends SetPropAction {
        private static final long serialVersionUID = 1L;
        private final boolean d_wireframe;
        private final boolean d_outlines;
        private final boolean d_materials;
        private final float d_opacity;

        public DrawModeAction(boolean initValue, String name, String tooltip, String icon, boolean wireframe, boolean outlines, boolean materials, float opacity) {
            super(initValue, name, tooltip, icon);
            this.d_wireframe = wireframe;
            this.d_outlines = outlines;
            this.d_materials = materials;
            this.d_opacity = opacity;
        }

        @Override
        protected void setProp(boolean selected) {
            ModelView.this.d_drawMode.props.setDrawWireframe(this.d_wireframe);
            ModelView.this.d_drawMode.props.setDrawOutlines(this.d_outlines);
            ModelView.this.d_drawMode.props.setShowMaterials(this.d_materials);
            ModelView.this.d_drawMode.props.set(ISceneRenderOptions.OPACITY_FACTOR, Float.valueOf(this.d_opacity));
        }
    }

    private abstract class SetPropAction
    extends AMerlinBoolAction {
        private static final long serialVersionUID = 1L;

        public SetPropAction(boolean initValue, String name, String icon) {
            super(name, initValue, icon == null ? null : new ImageIcon(ClassLoader.getSystemResource(icon)));
        }

        public SetPropAction(boolean initValue, String name, String desc, String icon) {
            this(initValue, name, icon);
            this.putValue("ShortDescription", desc);
        }

        @Override
        protected void work(VentusData data, boolean selected) {
            Application.getApp().beginWaitCursor();
            try {
                this.setProp(selected);
                ModelView.this.repaint();
            }
            finally {
                Native.manager.flush();
                Application.getApp().endWaitCursor();
            }
        }

        protected abstract void setProp(boolean var1);
    }
}

