/*
 * Decompiled with CFR 0.152.
 */
package ventus.io.contamx;

import java.util.Arrays;
import org.jscience.physics.units.SI;
import org.jscience.physics.units.Unit;
import thunderheadeng.units.UnitDouble;
import ventus.data.value.Schedule;
import ventus.io.contamx.PrjData;

public class PrjUtil {
    public static String convertTimeDuration(UnitDouble time) {
        double duration = time.getValue(SI.SECOND);
        long seconds = Math.round(duration);
        long hours = seconds / 3600L;
        long minutes = (seconds -= hours * 3600L) / 60L;
        return String.format("%02d:%02d:%02d", hours, minutes, seconds -= minutes * 60L);
    }

    public static int addSchedule(PrjData prjData, Schedule schedule, Unit unit) {
        UnitDouble initVal = schedule.getInitialValue();
        Schedule.Entry[] entries = schedule.getEntries();
        int utyp = -1;
        int ucnv = -1;
        if (unit.equals(SI.KELVIN)) {
            utyp = 5;
            ucnv = 2;
        } else if (unit.equals(Unit.ONE)) {
            utyp = 1;
            ucnv = 0;
        } else assert (false);
        PrjData.DaySchedule daySchedule = new PrjData.DaySchedule();
        prjData.dayScheduleList.add(daySchedule);
        prjData.ndsch = prjData.dayScheduleList.size();
        daySchedule.nr = prjData.dayScheduleList.size();
        daySchedule.utyp = utyp;
        daySchedule.ucnv = ucnv;
        daySchedule.npts = 2 + schedule.getEntries().length;
        daySchedule.shape = switch (schedule.type) {
            default -> throw new MatchException(null, null);
            case Schedule.ScheduleType.CONSTANT, Schedule.ScheduleType.RECTANGULAR -> 0;
            case Schedule.ScheduleType.TRAPEZOIDAL -> 1;
        };
        daySchedule.name = "DaySchedule" + daySchedule.nr;
        daySchedule.desc = "";
        daySchedule.pts.add(new PrjData.SchedulePoint("00:00:00", initVal.get(unit)));
        for (Schedule.Entry entry : entries) {
            daySchedule.pts.add(new PrjData.SchedulePoint(PrjUtil.convertTimeDuration(entry.t), entry.val.get(unit)));
        }
        double finalValue = entries.length > 0 ? entries[entries.length - 1].val.get(unit) : initVal.get(unit);
        daySchedule.pts.add(new PrjData.SchedulePoint("24:00:00", finalValue));
        PrjData.WeekSchedule weekSchedule = new PrjData.WeekSchedule();
        prjData.weekScheduleList.add(weekSchedule);
        prjData.nwsch = prjData.weekScheduleList.size();
        weekSchedule.nr = prjData.weekScheduleList.size();
        weekSchedule.utyp = utyp;
        weekSchedule.ucnv = ucnv;
        weekSchedule.name = "WeekSchedule" + weekSchedule.nr;
        weekSchedule.desc = "";
        Arrays.fill(weekSchedule.j, daySchedule.nr);
        return weekSchedule.nr;
    }
}

