/*
 * Decompiled with CFR 0.152.
 */
package ventus.io;

import java.awt.Component;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.Collection;
import java.util.concurrent.CancellationException;
import java.util.function.BiConsumer;
import javax.swing.JOptionPane;
import thunderheadeng.gui.guiProgressMonitor;
import thunderheadeng.util.CancelledException;
import thunderheadeng.util.IWarning;
import thunderheadeng.util.TaskProgress;
import thunderheadeng.util.WarningReport;
import ventus.Intl;
import ventus.data.VentusData;
import ventus.io.IInputStreamFeatureHandler;
import ventus.io.MerlinOOS;
import ventus.io.VentusOIS;

public class VentusIO {
    public static final int FS_OPTIONS = 3;
    public static final int TECI_VERSION = 19;

    public static void writeModel(String filename, VentusData md) throws IOException {
        try (MerlinOOS oos = new MerlinOOS(new BufferedOutputStream(new FileOutputStream(filename)));){
            oos.writeModel(md);
        }
    }

    public OpenResult openModel(Component parent, String filename, BiConsumer<TaskProgress, guiProgressMonitor.PMRunnable> execSkippableTask, VentusOIS.DecisionMaker decisions, Collection<IInputStreamFeatureHandler> featureUpdaters) throws IOException, CancelledException, BadVersionException {
        VentusOIS ois = null;
        try {
            int option;
            FileInputStream fis = new FileInputStream(filename);
            BufferedInputStream bis = new BufferedInputStream(fis);
            ois = new VentusOIS(bis, false, featureUpdaters);
            if (!ois.canOpenVersion()) {
                String msg = String.format(Intl.intl("The file was made with an old version of %s."), "Ventus");
                throw new BadVersionException(msg, false);
            }
            if (ois.isNewer() && (option = JOptionPane.showConfirmDialog(parent, String.format(Intl.intl("This file was created with %s, which is newer\nthan this version.  Would you like to try to open it anyway?\nNOTE: Some newer features may be lost if the file is resaved."), "Ventus " + ois.getRevision()), String.format(Intl.intl("Newer %s File"), "Ventus"), 0)) != 0) {
                throw new CancellationException();
            }
            VentusData md = ois.readModel(decisions);
            OpenResult openResult = new OpenResult(md, ois.getWarnings());
            return openResult;
        }
        catch (CancellationException e) {
            throw new CancelledException();
        }
        catch (Throwable t) {
            if (ois != null && ois.isNewer()) {
                String msg = String.format(Intl.intl("The file was made with a newer version of %s."), "Ventus");
                throw new BadVersionException(msg, true);
            }
            if (t instanceof IOException) {
                throw (IOException)t;
            }
            throw new IOException(t);
        }
        finally {
            if (ois != null) {
                try {
                    ois.close();
                }
                catch (Throwable t) {
                    t.printStackTrace();
                }
            }
        }
    }

    public static class BadVersionException
    extends Exception {
        private static final long serialVersionUID = 1L;
        public final boolean tooNew;

        public BadVersionException(String msg, boolean tooNew) {
            super(msg);
            this.tooNew = tooNew;
        }
    }

    public static class OpenResult {
        public final VentusData data;
        public final WarningReport<? extends IWarning> warnings;

        public OpenResult(VentusData data, WarningReport<? extends IWarning> warnings) {
            this.data = data;
            this.warnings = warnings;
        }
    }

    public static final class Version
    extends Enum<Version> {
        public static final /* enum */ Version VER_PRE_ALPHA_00 = new Version(0);
        public static final /* enum */ Version VER_ALPHA = new Version(1);
        public static final /* enum */ Version VER_0200 = new Version(200);
        public static final /* enum */ Version VER_0201 = new Version(201);
        public static final /* enum */ Version VER_0202 = new Version(202);
        public static final /* enum */ Version VER_204 = new Version(204);
        public static final /* enum */ Version VER_205 = new Version(205);
        public static final /* enum */ Version VER_206 = new Version(206);
        public static final /* enum */ Version VER_207 = new Version(207);
        public static final /* enum */ Version VER_208 = new Version(208);
        public static final /* enum */ Version VER_209 = new Version(209);
        public static final /* enum */ Version VER_210 = new Version(210);
        public static final /* enum */ Version VER_211 = new Version(211);
        public static final /* enum */ Version VER_212 = new Version(212);
        public static final /* enum */ Version VER_213 = new Version(213);
        public final int num;
        private static final /* synthetic */ Version[] $VALUES;

        public static Version[] values() {
            return (Version[])$VALUES.clone();
        }

        public static Version valueOf(String name) {
            return Enum.valueOf(Version.class, name);
        }

        private Version(int num) {
            assert (0 <= num);
            this.num = num;
        }

        public static Version curr() {
            return Version.values()[Version.values().length - 1];
        }

        public boolean isPrior(Version version) {
            return this.num < version.num;
        }

        public boolean isPrior(int version) {
            return this.num < version;
        }

        public boolean isVersion(Version version) {
            return this.num == version.num;
        }

        public boolean isVersion(int version) {
            return this.num == version;
        }

        public boolean isLater(Version version) {
            return this.num > version.num;
        }

        public boolean isLater(int version) {
            return this.num > version;
        }

        public static Version getVersion(int num) {
            for (Version ver : Version.values()) {
                if (ver.num != num) continue;
                return ver;
            }
            return null;
        }

        private static /* synthetic */ Version[] $values() {
            return new Version[]{VER_PRE_ALPHA_00, VER_ALPHA, VER_0200, VER_0201, VER_0202, VER_204, VER_205, VER_206, VER_207, VER_208, VER_209, VER_210, VER_211, VER_212, VER_213};
        }

        static {
            $VALUES = Version.$values();
        }
    }
}

