/*
 * Decompiled with CFR 0.152.
 */
package ventus.gui.value;

import java.awt.Component;
import java.util.ArrayList;
import java.util.List;
import java.util.function.BooleanSupplier;
import java.util.function.Function;
import java.util.function.Supplier;
import thunderheadeng.gui.value.AValEditor;
import thunderheadeng.gui.value.IValEditor;
import ventus.Intl;
import ventus.data.property.Function1dProp;
import ventus.data.value.ConstFunction1d;
import ventus.data.value.IFunction1d;
import ventus.data.value.PiecewiseFunction1d;
import ventus.gui.value.ConstFunction1dEditor;
import ventus.gui.value.FixedValEditor;
import ventus.gui.value.MultiValEditor;
import ventus.gui.value.PiecewiseFunction1dEditor;
import ventus.gui.value.PopupValEditor;
import ventus.unitsystem.SIUS;
import ventus.util.BitOptions;

public class Function1dEditorFactory {
    public static final int TYPE_CONSTANT = 1;
    public static final int TYPE_VARYING = 2;
    public static final int TYPE_PREDEF = 4;
    public static final int ALL_TYPES = 7;

    public static IValEditor<IFunction1d> nonNullable(Function1dProp prop, boolean verbose, Supplier<IFunction1d> nullConverter, int types) {
        return new MultiValEditor(IFunction1d.class, Function1dEditorFactory.getEntries(prop, verbose, nullConverter, types), false);
    }

    public static IValEditor<IFunction1d> nullable(Function1dProp prop, boolean verbose, String nullName, String nullDesc, Supplier<IFunction1d> nullConverter, int types) {
        ArrayList entries = new ArrayList();
        FixedValEditor<Object> nullEditor = new FixedValEditor<Object>(IFunction1d.class, null);
        entries.add(new MultiValEditor.Entry<IFunction1d, IFunction1d>(nullName, nullDesc, nullEditor, o -> o == null, () -> true, o -> null));
        entries.addAll(Function1dEditorFactory.getEntries(prop, verbose, nullConverter, types));
        return new MultiValEditor(IFunction1d.class, entries, false);
    }

    public static List<MultiValEditor.Entry<IFunction1d, ? extends IFunction1d>> getEntries(Function1dProp prop, boolean verbose, Supplier<IFunction1d> nullSupplier, int types) {
        ArrayList<MultiValEditor.Entry<IFunction1d, ? extends IFunction1d>> entries = new ArrayList<MultiValEditor.Entry<IFunction1d, ? extends IFunction1d>>();
        BitOptions btypes = new BitOptions(types);
        if (btypes.get(4L)) {
            Function1dEditorFactory.getPredefEntries(prop, entries);
        }
        if (btypes.get(1L)) {
            entries.add(Function1dEditorFactory.getConstEntry(prop, nullSupplier));
        }
        if (btypes.get(2L)) {
            entries.add(Function1dEditorFactory.getPiecewiseEntry(prop, !verbose, nullSupplier));
        }
        return entries;
    }

    private static void getPredefEntries(Function1dProp prop, List<MultiValEditor.Entry<IFunction1d, ? extends IFunction1d>> entries) {
        for (Function1dProp.PredefFunction predef : prop.predef) {
            FixedValEditor<IFunction1d> editor = new FixedValEditor<IFunction1d>(IFunction1d.class, predef.func.apply(null));
            MultiValEditor.Entry<IFunction1d, IFunction1d> entry = new MultiValEditor.Entry<IFunction1d, IFunction1d>(predef.shortDesc, predef.longDesc, editor, f -> Function1dEditorFactory.safeEquals(predef.func, f), () -> true, f -> predef.func.apply(null));
            entries.add(entry);
        }
    }

    private static boolean safeEquals(Function<Component, IFunction1d> func, IFunction1d f) {
        IFunction1d other = func.apply(null);
        if (other == null) {
            return f == null;
        }
        return other.equals(f);
    }

    private static MultiValEditor.Entry<IFunction1d, PiecewiseFunction1d> getPiecewiseEntry(Function1dProp prop, boolean popup, Supplier<IFunction1d> nullSupplier) {
        AValEditor editor;
        BooleanSupplier edit;
        if (popup) {
            PopupValEditor<PiecewiseFunction1d> popupEditor = new PopupValEditor<PiecewiseFunction1d>(PopupValEditor.Mode.HTML, PiecewiseFunction1d.class, prop.desc, () -> new PiecewiseFunction1dEditor(prop), f -> Function1dEditorFactory.format(prop, f));
            edit = () -> popupEditor.editValue();
            editor = popupEditor;
        } else {
            editor = new PiecewiseFunction1dEditor(prop);
            edit = () -> true;
        }
        return new MultiValEditor.Entry<IFunction1d, PiecewiseFunction1d>(Intl.intl("From Table"), "<html>" + String.format(Intl.intl("Enter <b>%1$s</b> as a function of <b>%2$s</b>."), prop.y.desc, prop.x.desc), editor, v -> v != null, edit, f -> {
            if (f == null) {
                f = (IFunction1d)nullSupplier.get();
            }
            if (f instanceof PiecewiseFunction1d) {
                return (PiecewiseFunction1d)f;
            }
            if (f instanceof ConstFunction1d) {
                ConstFunction1d cfunc = (ConstFunction1d)f;
                return PiecewiseFunction1d.newFunction(SIUS.newud(0.0, prop.x.unitType), cfunc.val, SIUS.newud(1.0, prop.x.unitType), cfunc.val);
            }
            assert (false);
            return null;
        });
    }

    private static MultiValEditor.Entry<IFunction1d, ConstFunction1d> getConstEntry(Function1dProp prop, Supplier<IFunction1d> nullSupplier) {
        ConstFunction1dEditor editor = new ConstFunction1dEditor(prop);
        return new MultiValEditor.Entry<IFunction1d, ConstFunction1d>(Intl.intl("Constant"), "<html>" + String.format(Intl.intl("Enter <b>%s</b> as a constant value."), prop.y.desc), editor, v -> v != null, () -> true, f -> {
            if (f == null) {
                f = (IFunction1d)nullSupplier.get();
            }
            if (f instanceof PiecewiseFunction1d) {
                PiecewiseFunction1d cfunc = (PiecewiseFunction1d)f;
                return new ConstFunction1d(cfunc.entries[0].y);
            }
            if (f instanceof ConstFunction1d) {
                return (ConstFunction1d)f;
            }
            assert (false);
            return null;
        });
    }

    public static String format(Function1dProp prop, IFunction1d val) {
        if (val == null) {
            return Intl.intl("&lt;mixed&gt;");
        }
        for (Function1dProp.PredefFunction predef : prop.predef) {
            if (!Function1dEditorFactory.safeEquals(predef.func, val)) continue;
            return "&lt;" + predef.shortDesc + "&gt;";
        }
        return Intl.intl("&lt;edit&gt;");
    }
}

