/*
 * Decompiled with CFR 0.152.
 */
package ventus.gui.stat;

import java.awt.FontMetrics;
import javax.swing.JEditorPane;
import javax.swing.SwingUtilities;
import thunderheadeng.gui.GridBagHelper;
import thunderheadeng.gui.guiDialog;
import thunderheadeng.units.UnitDouble;
import thunderheadeng.units.UnitDoubleVR;
import thunderheadeng.util.stat.IDistributedVal;
import ventus.Intl;
import ventus.gui.guiUtil;
import ventus.gui.stat.VerboseDistributedValEditor;
import ventus.gui.stat.guiCurveUtil;
import ventus.gui.value.APopupValEditor;
import ventus.unitsystem.SIUS;

public class CompactCurvePnl
extends APopupValEditor<IDistributedVal<UnitDouble>> {
    private static final long serialVersionUID = 1L;
    private final String d_name;
    private final JEditorPane d_editor;
    private final int d_unit;
    private final UnitDoubleVR d_range;
    private boolean d_modified = false;

    public CompactCurvePnl(String name, int unit) {
        this(name, unit, UnitDoubleVR.above(0.0, SIUS.unit(unit), true));
    }

    public CompactCurvePnl(String name, int unit, UnitDoubleVR range) {
        super(IDistributedVal.class);
        this.d_unit = unit;
        this.d_name = name;
        this.d_range = range;
        this.d_editor = thunderheadeng.gui.guiUtil.getHtmlLabel("", e -> this.editValue());
        GridBagHelper gb = new GridBagHelper(this, false);
        this.add(gb);
        gb.finalizeRows();
        this.loadValue((IDistributedVal)this.getValue());
    }

    @Override
    public void add(GridBagHelper gb) {
        gb.addRow(this.d_editor);
    }

    @Override
    public void setModified(boolean modified) {
        this.d_modified = modified;
        super.setModified(modified);
    }

    @Override
    public boolean isModified() {
        return this.d_modified || super.isModified();
    }

    @Override
    public boolean editValue() {
        VerboseDistributedValEditor pnl = new VerboseDistributedValEditor(this.d_unit, true, this.d_range);
        guiDialog dlg = new guiDialog(SwingUtilities.getWindowAncestor(this), this.d_name, 9);
        this.applyButtonLabels(dlg);
        GridBagHelper bg = new GridBagHelper(dlg.getDialogPane());
        bg.addRow(pnl);
        bg.finalizeRows();
        pnl.setValue((IDistributedVal)this.getValue());
        if (dlg.doModal() == 1) {
            this.setValue((IDistributedVal)pnl.getValue());
            return true;
        }
        return false;
    }

    @Override
    public void loadValue(IDistributedVal c) {
        FontMetrics fm = this.d_editor.getFontMetrics(this.d_editor.getFont());
        String str = CompactCurvePnl.format(c);
        String shortened = guiUtil.shorten(str, 100, fm);
        String lblStr = "<html><a href=\"blank\">" + shortened + "</a></html>";
        this.d_editor.setText(lblStr);
        if (!str.equals(shortened)) {
            this.d_editor.setToolTipText(str);
        } else {
            this.d_editor.setToolTipText(null);
        }
        this.setModified(true);
        this.revalidate();
    }

    @Override
    protected IDistributedVal saveValue() {
        return (IDistributedVal)this.getValue();
    }

    public static String format(IDistributedVal curve) {
        if (curve == null) {
            return Intl.intl("[mixed]");
        }
        String desc = guiCurveUtil.format(curve);
        return desc;
    }
}

