/*
 * Decompiled with CFR 0.152.
 */
package ventus.gui;

import java.util.Set;
import java.util.function.Predicate;
import thunderheadeng.util.Predicates;
import ventus.Intl;
import ventus.data.VentusData;
import ventus.data.schematics.elevators.ElevatorRoom;
import ventus.data.schematics.geom.ISchematicRoom;
import ventus.gui.SetChooser;

public class RoomChooser
extends SetChooser<ISchematicRoom> {
    private static final long serialVersionUID = 1L;

    public RoomChooser(VentusData md) {
        this(md, Predicates.alwaysTrue(), false);
    }

    public RoomChooser(VentusData md, final Predicate<? super ISchematicRoom> filter, boolean anyAllowed) {
        super(md, Intl.intl("Rooms"), Intl.intl("none"), 1 | (anyAllowed ? 4 : 0), md.floors, ISchematicRoom.class, new Predicate<ISchematicRoom>(){

            @Override
            public boolean test(ISchematicRoom o) {
                return !(o instanceof ElevatorRoom) && filter.test(o);
            }
        });
    }

    @Override
    public void setFilter(Predicate<? super ISchematicRoom> filter) {
        super.setFilter(filter);
    }

    public void setRooms(Set<ISchematicRoom> elevators) {
        this.setObjs(elevators);
    }

    public Set<ISchematicRoom> getRooms() {
        return this.getObjs();
    }
}

