/*
 * Decompiled with CFR 0.152.
 */
package ventus.gui;

import java.io.File;
import java.util.Optional;
import thunderheadeng.gui.ImageBtn;
import thunderheadeng.gui.guiJFXFileChooser;
import thunderheadeng.image.IImage;
import thunderheadeng.scene3d.gui.materialdlg.IImageBtnListener;
import ventus.MerlinPrefs;
import ventus.VentusApp;
import ventus.data.material.MaterialDB;

public class ImageBtnListener
implements IImageBtnListener {
    public static final ImageBtnListener INSTANCE = new ImageBtnListener();
    private String d_lastChoice;

    @Override
    public void setDefaultFile(File dir) {
        this.d_lastChoice = dir.getAbsolutePath();
    }

    @Override
    public boolean chooseNewImage(ImageBtn btn, String name) {
        Optional<Object> startingDir = Optional.empty();
        if (btn.getImage() != null) {
            startingDir = Optional.of(btn.getImage().getFilename());
        } else if (this.d_lastChoice != null) {
            startingDir = Optional.of(this.d_lastChoice);
        }
        guiJFXFileChooser chooser = new guiJFXFileChooser((String)startingDir.orElse(null), MerlinPrefs.get(MerlinPrefs.OPEN_DIR_PREF), null, (Boolean)true, (Boolean)true, (Boolean)false, VentusApp.getApp().getData().materials.getFileFilters());
        File f = chooser.showOpenDialog();
        if (f == null) {
            return false;
        }
        this.d_lastChoice = f.getAbsolutePath();
        IImage img = MaterialDB.loadImage(f.getAbsolutePath());
        if (img == null) {
            return false;
        }
        if (img != btn.getImage()) {
            btn.setImage(img);
            btn.setModified(true);
        }
        return true;
    }
}

