/*
 * Decompiled with CFR 0.152.
 */
package ventus.feature.windprofiles;

import thunderheadeng.util.WarningReport;
import ventus.data.ICompElement;
import ventus.data.VentusData;
import ventus.feature.windprofiles.WindProfile;
import ventus.feature.windprofiles.WindProfileRoot;
import ventus.io.IInputStreamFeatureHandler;
import ventus.io.VentusIO;
import ventus.io.VentusOIS;

public class WindProfileOISHandler
implements IInputStreamFeatureHandler {
    @Override
    public boolean applyVersionUpdates(int updateVer, int streamVer, VentusOIS.DecisionMaker responseHandler, VentusOIS.ChangeTracker changes, WarningReport warns, VentusData vd) {
        WindProfileRoot windRoot = (WindProfileRoot)vd.getComponentData("WindProfile.data");
        if (updateVer == 204 && streamVer < 204) {
            VentusOIS.findAndReplaceComposites(windRoot, name -> new WindProfileRoot.WindProfileNode((String)name));
        }
        if (updateVer == 205 && streamVer < 205 && changes.changeObjs.containsKey(204)) {
            for (ICompElement obj : changes.changeObjs.get(204)) {
                if (!(obj instanceof WindProfile)) continue;
                windRoot.add(obj);
            }
        }
        return false;
    }

    @Override
    public boolean isResolveObject(int vntsFileVersion, Object obj) {
        boolean updateWpTypesEnum = vntsFileVersion < VentusIO.Version.VER_209.num && WindProfile.Types.class.isInstance(obj);
        return updateWpTypesEnum;
    }

    @Override
    public Object getResolveObject(Object obj) {
        if (obj instanceof WindProfile.Types) {
            WindProfile.Types lwpt = (WindProfile.Types)((Object)obj);
            return lwpt.resolveAs;
        }
        return obj;
    }
}

