/*
 * Decompiled with CFR 0.152.
 */
package ventus.feature.windprofiles;

import java.awt.Component;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Locale;
import java.util.Set;
import javax.swing.Action;
import javax.swing.JFrame;
import javax.swing.JOptionPane;
import net.miginfocom.swing.MigLayout;
import thunderheadeng.gui.guiAction;
import thunderheadeng.gui.guiDialog;
import thunderheadeng.gui.guiLabel;
import thunderheadeng.gui.guiPanel;
import thunderheadeng.gui.guiTextField;
import ventus.Intl;
import ventus.VentusApp;
import ventus.actions.Delete;
import ventus.data.VentusData;
import ventus.feature.windprofiles.WindProfile;
import ventus.feature.windprofiles.WindProfileEditor;
import ventus.feature.windprofiles.WindProfileFeature;
import ventus.feature.windprofiles.WindProfileManager;
import ventus.feature.windprofiles.WindProfileRoot;
import ventus.gui.LibraryDlg;
import ventus.gui.ManagerDlg;

public class WindProfileMgrDlg
extends ManagerDlg<WindProfile, WindProfileManager> {
    private static final long serialVersionUID = 1L;
    private final JFrame d_owner;
    private final WindProfileEditor d_editor;
    private WindProfileManager d_manager;

    public WindProfileMgrDlg(JFrame owner) {
        super(owner, Intl.intl("Edit Wind Profiles"), WindProfile.class);
        this.d_owner = owner;
        this.d_editor = new WindProfileEditor();
        this.d_actions = new Action[]{this.newAction(Intl.intl("New..."), this::createNew), new WindLibraryAction(), this.newAction(Intl.intl("Rename..."), this::renameSelected), this.newAction(Intl.intl("Delete..."), this::deleteSelected)};
        this.updateActions();
    }

    public void init(VentusData data, WindProfileManager manager, WindProfile node) {
        super.init(data, manager, this.d_editor, this.d_actions);
        this.d_manager = manager;
        this.updateActions();
        this.getList().select(node);
        ManagerDlg.defaultInit(this.d_editor, node, obj -> {});
    }

    private boolean nameExists(String name) {
        return this.d_manager.getSorted().stream().filter(n -> n.getName().toLowerCase(Locale.ROOT).equals(name.toLowerCase(Locale.ROOT))).findFirst().orElse(null) != null;
    }

    public void createNew(ActionEvent event) {
        this.preSave();
        WindProfileRoot root = this.d_manager.getRoot();
        final guiTextField nameField = new guiTextField(root.getSuggestedName());
        guiPanel namePanel = new guiPanel(new MigLayout("fill, insets 0")){
            private static final long serialVersionUID = 1L;

            @Override
            public boolean validateData(boolean showWarn, boolean allowModify) {
                if (!super.validateData(showWarn, allowModify)) {
                    return false;
                }
                return WindProfileMgrDlg.this.validateName(null, nameField.getValue(), false);
            }
        };
        namePanel.add((Component)new guiLabel(Intl.intl("Name:")), "growx");
        namePanel.add((Component)nameField, "growx, wrap");
        guiDialog dlg = new guiDialog((Window)this, Intl.intl("New Wind Profile"), 9);
        dlg.setDialogComponent(namePanel);
        if (dlg.doModal() == 1) {
            root.add(new WindProfile(nameField.getValue()));
            this.getList().updateModelView(this.d_manager);
        }
    }

    public void renameSelected(ActionEvent event) {
        WindProfile node = (WindProfile)this.getList().getSelectedItem();
        String name = null;
        do {
            if ((name = (String)JOptionPane.showInputDialog(this, Intl.intl("Name:"), Intl.intl("Rename Wind Profile"), 3, WindProfileFeature.s_icon_windProfile, null, node.getName())) != null) continue;
            return;
        } while (!this.validateName(node.getName(), name, false));
        node.setName(name);
        this.getList().updateModelView(this.d_manager);
        this.d_editor.init(node);
    }

    private boolean validateName(String existing, String name, boolean allowEmpty) {
        if (!allowEmpty && (name.isEmpty() || name.isBlank())) {
            guiDialog.showInvalidEntryMessage(this, Intl.intl("Name must not be blank."));
            return false;
        }
        if (existing != null && existing.equals(name)) {
            return true;
        }
        if (this.nameExists(name)) {
            JOptionPane.showMessageDialog(this, Intl.intl("A wind profile with that name already exists.\nPlease enter a unique name."), Intl.intl("Name Already Exists"), 0);
            return false;
        }
        return true;
    }

    public void deleteSelected(ActionEvent event) {
        WindProfile node = (WindProfile)this.getList().getSelectedItem();
        int selectedIndex = this.getList().getSelectedIx();
        Delete.DelStatus status = Delete.uiDelete(VentusApp.getApp(), this.getMerlinData(), Set.of(node), true);
        if (status.equals((Object)Delete.DelStatus.SUCCESS)) {
            this.getList().updateModelView(this.d_manager);
            this.getList().select(Math.max(0, selectedIndex - 1));
            this.init(this.getMerlinData(), this.d_manager, (WindProfile)this.getList().getSelectedItem());
        }
    }

    @Override
    public void updateActions() {
        this.d_actions[0].setEnabled(this.d_manager != null);
        this.d_actions[1].setEnabled(this.d_manager != null);
        WindProfile item = (WindProfile)this.getList().getSelectedItem();
        this.d_actions[2].setEnabled(this.d_manager != null && item != null);
        this.d_actions[3].setEnabled(this.d_manager != null && item != null);
    }

    public Action newAction(String name, ActionListener listener) {
        return new guiAction(name, listener);
    }

    private class WindLibraryAction
    extends guiAction {
        private static final long serialVersionUID = -5364133990644521647L;

        public WindLibraryAction() {
            super(Intl.intl("Add From Library") + "...");
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            if (!WindProfileMgrDlg.this.preSave()) {
                return;
            }
            LibraryDlg dlg = new LibraryDlg(WindProfileMgrDlg.this.d_owner, WindProfileMgrDlg.this.getMerlinData(), () -> WindProfileMgrDlg.this.getList().updateModelView(WindProfileMgrDlg.this.d_manager), data -> (WindProfileRoot)data.getComponentData("WindProfile.data"), root -> root.flatten(WindProfile.class), new LibraryDlg.LibraryInfo(Intl.intl("Wind Profile"), "lib/windprofile", "windprofile"));
            dlg.doModal();
            WindProfileMgrDlg.this.getList().updateModelView(WindProfileMgrDlg.this.d_manager);
        }
    }
}

