/*
 * Decompiled with CFR 0.152.
 */
package ventus.feature.windprofiles;

import java.awt.Color;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Vector;
import java.util.concurrent.Semaphore;
import org.jscience.physics.units.Unit;
import org.ujmp.core.DenseMatrix;
import org.ujmp.core.Matrix;
import org.ujmp.core.doublematrix.DenseDoubleMatrix2D;
import thunderheadeng.gui.Graph;
import thunderheadeng.gui.LWSeries;
import thunderheadeng.gui.table.guiDefaultTableModel;
import thunderheadeng.units.UnitDouble;
import thunderheadeng.util.PlotData;
import ventus.Intl;
import ventus.VentusApp;
import ventus.data.property.Function1dProp;
import ventus.data.value.PiecewiseFunction1d;
import ventus.feature.windprofiles.WindProfile;
import ventus.gui.value.PiecewiseFunction1dEditor;

public class WindProfileFunction1dEditor
extends PiecewiseFunction1dEditor {
    private static final long serialVersionUID = 1L;

    public WindProfileFunction1dEditor(Function1dProp prop) {
        super(prop);
    }

    @Override
    public void loadValue(PiecewiseFunction1d var) {
        super.loadValue(var);
    }

    @Override
    public PiecewiseFunction1d saveValue() {
        return super.saveValue();
    }

    private PiecewiseFunction1d saveValueCubicSpline() {
        guiDefaultTableModel model = this.getTableModel();
        int rows = model.getRowCount();
        ArrayList<Double> xs = new ArrayList<Double>();
        ArrayList<Double> ys = new ArrayList<Double>();
        for (int row = 0; row < rows; ++row) {
            UnitDouble x = (UnitDouble)model.getValueAt(row, 0);
            UnitDouble y = (UnitDouble)model.getValueAt(row, 1);
            if (x == null || y == null) continue;
            xs.add(x.getValue(Unit.ONE));
            ys.add(y.getValue(Unit.ONE));
        }
        CubicSpline cs = new CubicSpline(xs, ys);
        double xRange = Collections.max(xs);
        double[] points = new double[(int)(Math.ceil(xRange) * 2.0)];
        int j = 0;
        for (double i = 0.0; i < (double)points.length / 2.0; i += 1.0) {
            points[j] = i;
            points[j + 1] = cs.calculateYValue(i);
            j += 2;
        }
        PlotData pd = new PlotData(Unit.ONE, Unit.ONE, false, points);
        return PiecewiseFunction1d.newFunction(pd);
    }

    private PiecewiseFunction1d saveValueTrig() {
        guiDefaultTableModel model = this.getTableModel();
        int rows = model.getRowCount();
        HashMap<Double, Double> vals = new HashMap<Double, Double>();
        for (int row = 0; row < rows; ++row) {
            UnitDouble x = (UnitDouble)model.getValueAt(row, 0);
            UnitDouble y = (UnitDouble)model.getValueAt(row, 1);
            if (x == null || y == null) continue;
            vals.put(x.getValue(Unit.ONE), y.getValue(Unit.ONE));
        }
        PlotData pd = this.calculateTrigFunction(vals);
        return PiecewiseFunction1d.newFunction(pd);
    }

    private void updateTable(PiecewiseFunction1d var, Function1dProp prop) {
        guiDefaultTableModel model = this.getTableModel();
        int count = model.getRowCount();
        for (int m = count - 1; m >= 0; --m) {
            model.removeRow(m);
        }
        if (var != null) {
            PiecewiseFunction1d.Entry[] entries = var.entries;
            for (int i = 0; i < entries.length; ++i) {
                PiecewiseFunction1d.Entry entry = entries[i];
                Unit ux = VentusApp.getApp().getUnitSystem().getUnit(prop.x.unitType);
                Unit uy = VentusApp.getApp().getUnitSystem().getUnit(prop.y.unitType);
                model.setValueAt(entry.x.convert(ux), i, 0);
                model.setValueAt(entry.y.convert(uy), i, 1);
            }
        }
    }

    private void addNewSeries(PlotData pd, Function1dProp prop, String text) {
        Graph graph = this.getGraph();
        LWSeries loadedSeries = this.getSeries();
        PiecewiseFunction1d newfunc = PiecewiseFunction1d.newFunction(pd);
        if (loadedSeries == null) {
            this.getGraph().reset();
            loadedSeries = WindProfileFunction1dEditor.toSeries(graph, prop, newfunc, Intl.intl(text), Color.BLUE);
            this.addSeries(loadedSeries);
        }
    }

    private PlotData calculateTrigFunction(Map<Double, Double> vals) {
        double[] points = new double[722];
        double p0 = vals.get(0.0);
        double p90 = vals.get(90.0);
        double p180 = vals.get(180.0);
        double p270 = vals.get(270.0);
        double p360 = vals.get(360.0);
        int j = 0;
        for (double i = 0.0; i < 361.0; i += 1.0) {
            double r = Math.toRadians(i);
            double cosR = Math.cos(r);
            double sinR = Math.sin(r);
            double term2 = i > 90.0 && i <= 270.0 ? -(p0 - p180) * Math.pow(cosR * cosR, 0.375) : (p0 - p180) * Math.pow(cosR * cosR, 0.375);
            double y = 0.5 * ((p0 + p180) * Math.pow(cosR * cosR, 0.25) + term2 + (p90 + p270) * Math.pow(sinR, 4.0) + (p90 - p270) * sinR);
            points[j] = i;
            points[j + 1] = y;
            j += 2;
        }
        return new PlotData(Unit.ONE, Unit.ONE, false, points);
    }

    public void loadValueLinear(PiecewiseFunction1d var) {
        this.loadValue(var);
        LWSeries loadedSeries = this.getSeries();
        loadedSeries.setName("Linear");
    }

    public void loadValueTrigonometric(PiecewiseFunction1d var) {
        Semaphore valLock = this.getSemaphore();
        Function1dProp prop = this.getProp();
        HashMap<Double, Double> vals = new HashMap<Double, Double>();
        if (!valLock.tryAcquire()) {
            return;
        }
        this.updateTable(var, prop);
        for (int i = 0; i < var.entries.length; ++i) {
            vals.put(var.entries[i].x.get(Unit.ONE), var.entries[i].y.get(Unit.ONE));
        }
        PlotData pd = this.calculateTrigFunction(vals);
        this.addNewSeries(pd, prop, "Trigonometric");
        this.setModified(false);
        valLock.release();
    }

    public void loadValueCubicSpline(PiecewiseFunction1d var) {
        Semaphore valLock = this.getSemaphore();
        Function1dProp prop = this.getProp();
        ArrayList<Double> xs = new ArrayList<Double>();
        ArrayList<Double> ys = new ArrayList<Double>();
        if (!valLock.tryAcquire()) {
            return;
        }
        this.updateTable(var, prop);
        for (int i = 0; i < var.entries.length; ++i) {
            xs.add(var.entries[i].x.get(Unit.ONE));
            ys.add(var.entries[i].y.get(Unit.ONE));
        }
        CubicSpline cs = new CubicSpline(xs, ys);
        double xRange = xs.get(xs.size() - 1);
        double[] points = new double[(int)(Math.ceil(xRange) * 2.0)];
        int j = 0;
        for (double i = 0.0; i < (double)points.length / 2.0; i += 1.0) {
            points[j] = i;
            points[j + 1] = cs.calculateYValue(i);
            j += 2;
        }
        PlotData pd = new PlotData(Unit.ONE, Unit.ONE, false, points);
        this.addNewSeries(pd, prop, "Cubic Spline");
        this.setModified(false);
        valLock.release();
    }

    private boolean checksForDataSet(Vector<Vector> dataset) {
        int counter = 0;
        for (Vector v : dataset) {
            if (!Arrays.stream(v.toArray()).allMatch(i -> i != null)) continue;
            ++counter;
        }
        return counter < 2;
    }

    public void updateCurve(WindProfile.CurveType type, boolean figure3) {
        Function1dProp prop = this.getProp();
        Graph graph = this.getGraph();
        PiecewiseFunction1d func = null;
        String seriesText = "";
        LWSeries loadedSeries = this.getSeries();
        if (this.checksForDataSet(this.getTableModel().getDataVector())) {
            this.removeSeries(loadedSeries);
            return;
        }
        if (type == WindProfile.CurveType.LINEAR) {
            func = this.saveValue();
            seriesText = type.desc;
        } else if (type == WindProfile.CurveType.CUBIC) {
            int numRows = this.getTableModel().getRowCount();
            if (numRows < type.minPointsReq) {
                return;
            }
            func = this.saveValueCubicSpline();
            seriesText = type.desc;
        } else if (type == WindProfile.CurveType.TRIG) {
            if (!figure3) {
                return;
            }
            func = this.saveValueTrig();
            seriesText = type.desc;
        }
        graph.reset();
        loadedSeries = WindProfileFunction1dEditor.toSeries(graph, prop, func, Intl.intl(seriesText), Color.BLUE);
        this.addSeries(loadedSeries);
        this.setSeries(loadedSeries);
    }

    private static class CubicSpline {
        private final ArrayList<Double> a = new ArrayList();
        private final ArrayList<Double> b = new ArrayList();
        private final ArrayList<Double> c = new ArrayList();
        private final ArrayList<Double> d = new ArrayList();
        private final ArrayList<Double> d_xs;
        private final ArrayList<Double> d_ys;

        public CubicSpline(ArrayList<Double> xs, ArrayList<Double> ys) {
            int i;
            int n = xs.size();
            this.d_xs = xs;
            this.d_ys = ys;
            for (int i2 = 0; i2 < n; ++i2) {
                this.a.add(ys.get(i2));
            }
            ArrayList<Double> h = this.diff(xs);
            Matrix A = this.calA(h, n);
            Matrix B = this.calB(ys, h, n);
            Matrix A1 = A.inv();
            Matrix m = A1.mtimes(B);
            for (i = 0; i < n - 1; ++i) {
                this.c.add(m.getAsDouble(i, 0L) / 2.0);
            }
            for (i = 0; i < n - 1; ++i) {
                this.b.add((ys.get(i + 1) - ys.get(i)) / h.get(i) - h.get(i) / 2.0 * m.getAsDouble(i, 0L) - h.get(i) / 6.0 * (m.getAsDouble(i + 1, 0L) - m.getAsDouble(i, 0L)));
                this.d.add((m.getAsDouble(i + 1, 0L) - m.getAsDouble(i, 0L)) / (6.0 * h.get(i)));
            }
        }

        private ArrayList<Double> diff(ArrayList<Double> x) {
            ArrayList<Double> h = new ArrayList<Double>();
            for (int i = 0; i < x.size() - 1; ++i) {
                h.add(x.get(i + 1) - x.get(i));
            }
            return h;
        }

        private Matrix calA(ArrayList<Double> h, int n) {
            DenseDoubleMatrix2D A = DenseMatrix.Factory.zeros((long)n, (long)n);
            A.setAsDouble(1.0, 0L, 0L);
            A.setAsDouble(1.0, n - 1, n - 1);
            for (int i = 1; i < n - 1; ++i) {
                A.setAsDouble(2.0 * (h.get(i - 1) + h.get(i)), i, i);
                A.setAsDouble(h.get(i - 1), i, i - 1);
                A.setAsDouble(h.get(i), i, i + 1);
            }
            return A;
        }

        private Matrix calB(ArrayList<Double> y, ArrayList<Double> h, int n) {
            DenseDoubleMatrix2D B = DenseMatrix.Factory.zeros((long)n, 1L);
            for (int i = 1; i < n - 1; ++i) {
                double x = 6.0 * ((y.get(i + 1) - y.get(i)) / h.get(i) - (y.get(i) - y.get(i - 1)) / h.get(i - 1));
                B.setAsDouble(x, i, 0L);
            }
            return B;
        }

        public double calculateYValue(double x) {
            int index = 0;
            for (int i = 0; i < this.d_xs.size() - 1; ++i) {
                if (!(this.d_xs.get(i) <= x) || !(x <= this.d_xs.get(i + 1))) continue;
                index = i;
            }
            double y = this.a.get(index) + this.b.get(index) * (x - this.d_xs.get(index)) + this.c.get(index) * (x - this.d_xs.get(index)) * (x - this.d_xs.get(index)) + this.d.get(index) * (x - this.d_xs.get(index)) * (x - this.d_xs.get(index)) * (x - this.d_xs.get(index));
            return y;
        }
    }
}

