/*
 * Decompiled with CFR 0.152.
 */
package ventus.feature.tags;

import java.awt.Window;
import java.util.Collection;
import java.util.Collections;
import java.util.Set;
import java.util.stream.Collectors;
import thunderheadeng.gui.dialogs.ShowTaggedObjsDialog;
import thunderheadeng.util.Events;
import thunderheadeng.util.GroupedSequence;
import thunderheadeng.util.IEventObserver;
import thunderheadeng.util.IFilteredCollection;
import thunderheadeng.util.LinkedIdentityHashSet;
import thunderheadeng.util.theUtil;
import ventus.Intl;
import ventus.VentusApp;
import ventus.actions.AMerlinOp;
import ventus.actions.CompElementActions;
import ventus.actions.SelectionObserver;
import ventus.actions.Shortcut;
import ventus.actions.ShortcutInfo;
import ventus.actions.UIHook;
import ventus.actions.Undo;
import ventus.data.ICompElement;
import ventus.data.IMerlinObj;
import ventus.data.NamedMerlinObj;
import ventus.data.VentusData;
import ventus.feature.comps.IContextMenuItem;
import ventus.feature.comps.IHotkey;
import ventus.feature.tags.StringTagsUtil;
import ventus.feature.tags.Tag;
import ventus.gui.ShowObjectsDlg;

class ShowTaggedObjects
implements IContextMenuItem,
IEventObserver,
IHotkey<UIHook> {
    private final UIHook hook = new UIHook(new ShowTagged(), Intl.intl("Show Tagged Objects..."));
    private final Shortcut<UIHook> shortcut = new Shortcut<UIHook>(new ShortcutInfo("showTaggedObjects", ShortcutInfo.Category.SELECTION), this.hook);

    @Override
    public void addContextMenuItem(GroupedSequence root) {
        root.getNode("enable-select").add(this.hook);
    }

    @Override
    public Shortcut<UIHook> getKeyboardShortcut() {
        return this.shortcut;
    }

    @Override
    public boolean isHeadless() {
        return true;
    }

    @Override
    public void update(Events events) {
        if (SelectionObserver.isSelectionEvent(events)) {
            VentusData md = VentusApp.getApp().getData();
            this.hook.setEnabled(!md.selection.isDeepEmpty(Tag.class));
        }
    }

    public static ShowTaggedObjsDialog.ICallback<ICompElement, Tag> getDialogCallback(final VentusData vd) {
        return new ShowTaggedObjsDialog.ICallback<ICompElement, Tag>(){

            @Override
            public Collection<? extends ICompElement> getAllTaggable() {
                IFilteredCollection<ICompElement> compObjs = theUtil.filter(vd.getChildren(), ICompElement.class);
                return CompElementActions.flattenToLocallyDefined(VentusData.TAGS, compObjs);
            }

            @Override
            public Set<? extends Tag> getTags(ICompElement obj) {
                return obj.getProp(VentusData.TAGS).orElse(Collections.emptySet());
            }
        };
    }

    static LinkedIdentityHashSet<? extends IMerlinObj> getObjsAny(VentusData md, Set<Tag> selectedTags) {
        return ShowTaggedObjsDialog.getObjsAny(ShowTaggedObjects.getDialogCallback(md), selectedTags);
    }

    static LinkedIdentityHashSet<? extends IMerlinObj> getObjsAll(VentusData md, Set<Tag> selectedTags) {
        return ShowTaggedObjsDialog.getObjsAll(ShowTaggedObjects.getDialogCallback(md), selectedTags);
    }

    static LinkedIdentityHashSet<? extends IMerlinObj> getObjsOnly(VentusData md, Set<Tag> selectedTags) {
        return ShowTaggedObjsDialog.getObjsOnly(ShowTaggedObjects.getDialogCallback(md), selectedTags);
    }

    static LinkedIdentityHashSet<? extends IMerlinObj> getObjsExact(VentusData md, Set<Tag> selectedTags) {
        return ShowTaggedObjsDialog.getObjsExact(ShowTaggedObjects.getDialogCallback(md), selectedTags);
    }

    public static void showTaggedObjects(Window parent, String title, VentusData md, Collection<? extends IMerlinObj> objs) {
        ShowObjectsDlg dlg = new ShowObjectsDlg(parent, md, title, Intl.intl("Select Tagged Objects"), objs);
        dlg.doModeless();
    }

    private static class ShowTagged
    extends AMerlinOp {
        private ShowTaggedObjsDialog d_optionsDlg = null;

        private ShowTagged() {
        }

        @Override
        public void run(VentusApp app, VentusData md) {
            if (this.d_optionsDlg == null) {
                this.d_optionsDlg = new ShowTaggedObjsDialog((Window)app.getActiveFrame());
            }
            IFilteredCollection<Tag> selectedTags = md.selection.flatten(Tag.class);
            this.d_optionsDlg.setTags(selectedTags, NamedMerlinObj::getName);
            if (this.d_optionsDlg.doModal() != 1) {
                return;
            }
            Set<ICompElement> objs = this.d_optionsDlg.getTaggedObjs(ShowTaggedObjects.getDialogCallback(md), selectedTags);
            switch (this.d_optionsDlg.getShowMode()) {
                case SELECT: {
                    try (VentusData.WriteLock lock = md.lockWrite();){
                        Undo.begin(Intl.intl("Select Tagged Objects"));
                        Undo.insertUndoEntry_restoreSelection(md);
                        md.selection.clear();
                        md.selection.selectAll(objs);
                        Undo.end(md);
                        break;
                    }
                }
                case LIST: {
                    String title = this.generateTitle(md, this.d_optionsDlg.getTagsCombine().desc);
                    ShowTaggedObjects.showTaggedObjects(app.getActiveFrame(), title, md, objs);
                }
            }
        }

        private String generateTitle(VentusData md, String prefix) {
            Set<String> tags = md.selection.flatten(Tag.class).stream().map(tag -> tag.getName()).collect(Collectors.toSet());
            String joinedTags = StringTagsUtil.format(tags);
            return String.format(Intl.intl("Tagged Objects: %1$s %2$s"), prefix, joinedTags);
        }
    }
}

