/*
 * Decompiled with CFR 0.152.
 */
package ventus.feature.species;

import java.util.ArrayList;
import java.util.Collection;
import javax.swing.ImageIcon;
import org.jscience.physics.units.Unit;
import thunderheadeng.util.GroupedSequence;
import ventus.EntryPointFactory;
import ventus.EntryPointHelper;
import ventus.Intl;
import ventus.data.VentusData;
import ventus.data.schematics.SimError;
import ventus.feature.comps.FeatureUtil;
import ventus.feature.comps.IDataModel;
import ventus.feature.species.Species;
import ventus.feature.species.SpeciesRoot;
import ventus.gui.guiUtil;

public class SpeciesData
implements IDataModel {
    public static final String GUID = "Species.data";
    public static final int SEQ_IX = 33;
    public static final ImageIcon ICON = guiUtil.loadIconSvg(FeatureUtil.getRequiredResource(Species.class, "icons/species.svg"), 16);

    @Override
    public void init(VentusData md) {
        md.setComponentData(GUID, new SpeciesRoot());
    }

    @Override
    public void reset(VentusData md) {
        ((SpeciesRoot)md.getComponentData(GUID)).reset();
    }

    private static SpeciesRoot getDataRoot(VentusData md) {
        return (SpeciesRoot)md.getComponentData(GUID);
    }

    @Override
    public void loadFrom(VentusData src, VentusData dest) {
        SpeciesRoot srcData = SpeciesData.getDataRoot(src);
        SpeciesRoot destData = SpeciesData.getDataRoot(dest);
        destData.restoreFrom(srcData);
        dest.replaceInSel(srcData, destData);
    }

    @Override
    public void addTreeRoots(VentusData md, GroupedSequence roots) {
        roots.add(33, (Object)md.getComponentData(GUID));
    }

    @Override
    public void registerEntryPointData() {
        EntryPointHelper<SpeciesRoot> rootHelper = new EntryPointHelper<SpeciesRoot>(SpeciesRoot.class);
        rootHelper.getIcon = (md, obj, unused) -> ICON;
        rootHelper.getErrors = (md, obj) -> {
            ArrayList<SimError> errors = new ArrayList<SimError>();
            Collection<Species> speciesList = obj.flatten(Species.class);
            ArrayList<Species> nonTrace = new ArrayList<Species>();
            double concentrationNonTrace = 0.0;
            for (Species spec : speciesList) {
                if (spec.get(Species.TRACE_CONTAMINANT) != Species.TraceContaminant.NON_TRACE) continue;
                nonTrace.add(spec);
                if (spec.getName().equals("H2O")) continue;
                concentrationNonTrace += spec.get(Species.DEFAULT_CONCENTRATION).get(Unit.ONE);
            }
            if (nonTrace.size() == 1) {
                errors.add(new SimError(SimError.Level.CRITICAL, Intl.intl("There must be at least two non-trace species if there are any."), Intl.intl("Delete the non-trace species or add another."), nonTrace));
            }
            if (!nonTrace.isEmpty() && concentrationNonTrace != 1.0) {
                errors.add(new SimError(SimError.Level.CRITICAL, String.format(Intl.intl("The total Default Concentration of all non-trace species, besides H2O, must be 1. (Currently %.2f)."), concentrationNonTrace), Intl.intl("Adjust default concentrations of non-trace species."), nonTrace));
            }
            return errors;
        };
        rootHelper.register();
        EntryPointHelper<SpeciesRoot.SpeciesNode> compHelper = new EntryPointHelper<SpeciesRoot.SpeciesNode>(SpeciesRoot.SpeciesNode.class);
        compHelper.getIcon = (md, obj, unused) -> ICON;
        compHelper.getType = (md, obj) -> Intl.intl("Species_Group");
        compHelper.getRootComposite = (md, obj) -> SpeciesData.getDataRoot(md);
        compHelper.getConflict = EntryPointFactory.getStandardConflictGetter(SpeciesRoot.SpeciesNode.class);
        compHelper.register();
        EntryPointHelper<Species> nodeHelper = new EntryPointHelper<Species>(Species.class);
        nodeHelper.getIcon = (md, obj, unused) -> {
            if (obj == null) {
                return ICON;
            }
            return guiUtil.loadIconSvg(Species.class.getResource("icons/species.svg"), obj.get(Species.COLOR), 16);
        };
        nodeHelper.getType = (md, obj) -> Intl.intl("Species");
        nodeHelper.getRootComposite = (md, obj) -> SpeciesData.getDataRoot(md);
        nodeHelper.getConflict = EntryPointFactory.getStandardConflictGetter(Species.class);
        nodeHelper.getNameGroup = EntryPointFactory.nameGroup(vd -> SpeciesData.getDataRoot(vd).flatten(Species.class));
        nodeHelper.register();
    }
}

