/*
 * Decompiled with CFR 0.152.
 */
package ventus.feature.species;

import java.awt.Color;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.Serializable;
import java.util.Optional;
import java.util.Set;
import org.jscience.physics.units.SI;
import org.jscience.physics.units.Unit;
import thunderheadeng.dependencies.DLink;
import thunderheadeng.dependencies.DepList;
import thunderheadeng.units.UnitDouble;
import thunderheadeng.util.ISurrogate;
import thunderheadeng.util.Nullable;
import thunderheadeng.util.PropertySet;
import thunderheadeng.util.TypedProp;
import thunderheadeng.util.theUtil;
import ventus.Intl;
import ventus.data.ICompElement;
import ventus.data.IRestorable;
import ventus.data.NamedMerlinObj;
import ventus.data.VentusData;
import ventus.feature.comps.IDirectDependent;
import ventus.feature.props.TypedPropSet;
import ventus.feature.tags.Tag;
import ventus.feature.tags.TagsUtil;

public class Species
extends NamedMerlinObj
implements Serializable,
IRestorable,
ICompElement,
ISurrogate,
IDirectDependent {
    private static final long serialVersionUID = 1L;
    public static final TypedPropSet<Species> PROP_TYPES = new TypedPropSet();
    public static final TypedProp<String> NAME = PROP_TYPES.add(NamedMerlinObj.NAME, NamedMerlinObj::getName, NamedMerlinObj::setName, new TypedPropSet.Options[0]);
    public static final TypedProp<String> DESC = PROP_TYPES.add((Object)"Species.DESC", "", new TypedPropSet.Options[0]);
    public static final TypedProp<Color> COLOR = PROP_TYPES.add((Object)"Species.COLOR", Color.BLACK, new TypedPropSet.Options[0]);
    public static final TypedProp<Set<Tag>> TAGS = PROP_TYPES.add(VentusData.TAGS, Species::getTags, Species::setTags, TypedPropSet.Options.WEAK_DEPENDENT);
    public static final TypedProp<UnitDouble> MOLAR_MASS = PROP_TYPES.add((Object)"Species.MOLAR_MASS", new UnitDouble(1.0, SI.KILOGRAM.divide(SI.KILO(SI.MOLE))), new TypedPropSet.Options[0]);
    public static final TypedProp<UnitDouble> DIFFUSION_COEFFICIENT = PROP_TYPES.add((Object)"Species.DIFFUSION_COEFFICIENT", new UnitDouble(2.0E-5, SI.METER.pow(2).divide(SI.SECOND)), new TypedPropSet.Options[0]);
    public static final TypedProp<UnitDouble> SPECIFIC_HEAT = PROP_TYPES.add((Object)"Species.SPECIFIC_HEAT", new UnitDouble(1000.0, SI.JOULE.divide(SI.KILOGRAM.multiply(SI.KELVIN))), new TypedPropSet.Options[0]);
    public static final TypedProp<UnitDouble> MEAN_DIAMETER = PROP_TYPES.add((Object)"Species.MEAN_DIAMETER", new UnitDouble(0.0, SI.METER), new TypedPropSet.Options[0]);
    public static final TypedProp<UnitDouble> EFFECTIVE_DENSITY = PROP_TYPES.add((Object)"Species.EFFECTIVE_DENSITY", new UnitDouble(0.0, SI.KILOGRAM.divide(SI.METER.pow(3))), new TypedPropSet.Options[0]);
    public static final TypedProp<UnitDouble> DECAY_RATE = PROP_TYPES.add((Object)"Species.DECAY_RATE", new UnitDouble(0.0, Unit.ONE.divide(SI.SECOND)), new TypedPropSet.Options[0]);
    public static final TypedProp<UnitDouble> UVGI_SUSCEPTIBILITY_CONSTANT = PROP_TYPES.add((Object)"Species.UVGI_SUSCEPTIBILITY_CONSTANT", new UnitDouble(0.0, SI.METER.pow(2).divide(SI.JOULE)), new TypedPropSet.Options[0]);
    public static final TypedProp<UnitDouble> DEFAULT_CONCENTRATION = PROP_TYPES.add((Object)"Species.DEFAULT_CONCENTRATION", new UnitDouble(0.0, SI.KILOGRAM.divide(SI.KILOGRAM)), new TypedPropSet.Options[0]);
    public static final TypedProp<TraceContaminant> TRACE_CONTAMINANT = PROP_TYPES.add((Object)"Species.TRACE_CONTAMINANT", TraceContaminant.TRACE, new TypedPropSet.Options[0]);
    private PropertySet d_properties = new PropertySet();
    private transient PropertySet d_transientProps = new PropertySet();

    public Species(String name) {
        this(name, theUtil.newRandomSatColor());
    }

    public Species(String name, Color color) {
        super(name);
        this.d_properties.set(COLOR, color);
    }

    private void readObject(ObjectInputStream is) throws ClassNotFoundException, IOException {
        is.defaultReadObject();
        this.d_transientProps = new PropertySet();
    }

    @Override
    public Species clone() {
        Species species = (Species)super.clone();
        species.d_properties = this.d_properties.clone();
        species.d_transientProps = this.d_transientProps.clone();
        return species;
    }

    @Override
    public Object getRestoreObj() {
        return this.clone();
    }

    @Override
    public void restoreFrom(Object obj) {
        if (obj instanceof Species) {
            Species species = (Species)obj;
            this.pauseUpdates();
            this.setName(species.getName());
            PROP_TYPES.restoreFrom(this, this.d_properties, species.d_properties, this.d_transientProps, species.d_transientProps);
            this.changedEvt(new Object[0]);
            this.resumeUpdates();
        }
    }

    @Override
    public String toString() {
        return this.getName();
    }

    @Override
    public boolean surrogateEquals(Object comparable) {
        if (comparable == this) {
            return true;
        }
        if (comparable == null || !this.getClass().equals(comparable.getClass())) {
            return false;
        }
        Species species = (Species)comparable;
        if (!this.getName().equals(species.getName())) {
            return false;
        }
        for (TypedProp<?> prop : PROP_TYPES.props()) {
            if (theUtil.equal(this.get(prop), species.get(prop))) continue;
            return false;
        }
        return true;
    }

    public Set<Tag> getTags() {
        return this.d_properties.get(VentusData.TAGS);
    }

    public void setTags(Set<Tag> tags) {
        PROP_TYPES.compareAndSetDirect(this, this.d_properties, this.d_transientProps, VentusData.TAGS, tags);
    }

    @Override
    public Set<Object> getPropTypes(int options) {
        return PROP_TYPES.keys();
    }

    public <T> T get(TypedProp<T> prop) {
        Optional<Nullable<Nullable>> val = PROP_TYPES.getValue(this, this.d_properties, this.d_transientProps, prop);
        return val.map(tNullable -> tNullable.val).orElse(null);
    }

    public <T> void set(TypedProp<T> prop, T value) {
        PROP_TYPES.setValue(this, this.d_properties, this.d_transientProps, prop, value);
    }

    @Override
    public <T> void setProperty(Object key, T value) {
        if (key.equals(VentusData.TAGS)) {
            this.setTags((Set)value);
            return;
        }
        TypedProp<T> prop = PROP_TYPES.getStrict(key, value);
        if (prop == null) {
            return;
        }
        this.set(prop, value);
    }

    @Override
    public Object getProperty(Object key) {
        TypedProp<?> prop = PROP_TYPES.get(key);
        if (prop == null) {
            return NOT_SUPPORTED;
        }
        return this.get(prop);
    }

    @Override
    public void takeDepSnapshot(DepList deps) {
        deps.add(DLink.WEAK, this.getTags());
        PROP_TYPES.takeDepSnapshot(this, this.d_properties, this.d_transientProps, deps);
    }

    @Override
    public void replaceDependency(VentusData md, Object old, Object replacement) {
        TagsUtil.replaceDependency(this, old, replacement);
        PROP_TYPES.replaceDependency(this, this.d_properties, this.d_transientProps, old, replacement);
    }

    public static enum TraceContaminant {
        NON_TRACE(Intl.intl("Non-Trace"), Intl.intl("The species is considered a component of the air.")),
        TRACE(Intl.intl("Trace"), Intl.intl("The species is considered separate from the air."));

        public final String name;
        public final String desc;

        private TraceContaminant(String name, String desc) {
            this.name = name;
            this.desc = desc;
        }

        public String toString() {
            return this.name;
        }
    }
}

