/*
 * Decompiled with CFR 0.152.
 */
package ventus.feature.sourcesink;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import thunderheadeng.util.NameGenerator;
import ventus.Intl;
import ventus.data.Composite;
import ventus.data.schematics.ISchematicObj;
import ventus.feature.sourcesink.SourceSink;

public class SourceSinkRoot
extends Composite<SourceSink> {
    private static final long serialVersionUID = 1L;
    private NameGenerator d_nameGen = new NameGenerator(Intl.intl("SourceSink"));

    public SourceSinkRoot() {
        super(Intl.intl("Source/Sinks"));
    }

    public void reset() {
        this.clear();
        this.d_nameGen.reset();
    }

    @Override
    public void restoreFrom(Object obj) {
        super.restoreFrom(obj);
        if (obj instanceof SourceSinkRoot) {
            SourceSinkRoot root = (SourceSinkRoot)obj;
            this.d_nameGen = root.d_nameGen;
        }
    }

    public String nextName() {
        String name = this.d_nameGen.generateName();
        this.d_nameGen.registerName(name);
        return name;
    }

    @Override
    public Composite<SourceSink> newGroup(String name) {
        return new SourceSinkNode(name);
    }

    @Override
    public String getNewGroupName() {
        return Intl.intl("Source/Sink Group");
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        in.defaultReadObject();
        for (ISchematicObj obj : this.getDeepMembers(ISchematicObj.class)) {
            obj.readTopology(in);
        }
    }

    private void writeObject(ObjectOutputStream out) throws IOException {
        out.defaultWriteObject();
        for (ISchematicObj obj : this.getDeepMembers(ISchematicObj.class)) {
            obj.writeTopology(out);
        }
    }

    static class SourceSinkNode
    extends Composite<SourceSink> {
        public SourceSinkNode(String name) {
            super(name);
        }

        @Override
        public Composite<SourceSink> newGroup(String name) {
            return new SourceSinkNode(name);
        }

        @Override
        public String getNewGroupName() {
            return Intl.intl("Source/Sink Group");
        }

        private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
            in.defaultReadObject();
            for (ISchematicObj obj : this.getDeepMembers(ISchematicObj.class)) {
                obj.readTopology(in);
            }
        }

        private void writeObject(ObjectOutputStream out) throws IOException {
            out.defaultWriteObject();
            for (ISchematicObj obj : this.getDeepMembers(ISchematicObj.class)) {
                obj.writeTopology(out);
            }
        }
    }
}

