/*
 * Decompiled with CFR 0.152.
 */
package ventus.feature.sourcesink;

import java.util.Map;
import org.jscience.physics.units.SI;
import thunderheadeng.util.TypedProp;
import ventus.VentusApp;
import ventus.data.VentusData;
import ventus.feature.comps.IPrjDataWriter;
import ventus.feature.sourcesink.SourceSinkElement;
import ventus.feature.sourcesink.SourceSinkElementRoot;
import ventus.feature.species.Species;
import ventus.io.contamx.PrjData;

public class SourceSinkElementPrjWriter
implements IPrjDataWriter {
    @Override
    public IPrjDataWriter.Order getOrder() {
        return IPrjDataWriter.Order.NORMAL;
    }

    @Override
    public void addPrjData(VentusApp app, VentusData md, Map<TypedProp, Object> scenario, PrjData prjData) {
        SourceSinkElementRoot root = (SourceSinkElementRoot)md.getComponentData("SourceSinkElement.data");
        for (SourceSinkElement in : root.flatten(SourceSinkElement.class)) {
            PrjData.SourceSinkElem out = new PrjData.SourceSinkElem(in);
            prjData.sourceSinkElementList.add(out);
            out.nr = prjData.ncse = prjData.sourceSinkElementList.size();
            out.spcs = in.get(SourceSinkElement.SPECIES).getName();
            out.ctype = in.get(SourceSinkElement.MODEL).type;
            out.name = in.getName();
            out.desc = in.get(SourceSinkElement.DESC);
            if (in.get(SourceSinkElement.MODEL) != SourceSinkElement.SourceSinkModel.CONSTANT_COEFFICIENT) continue;
            PrjData.SourceSinkTypeCsCcf outConstCoefficient = new PrjData.SourceSinkTypeCsCcf();
            prjData.csCcfMap.put(out.nr, outConstCoefficient);
            SourceSinkElement.GenRateUnit unit = in.get(SourceSinkElement.GEN_RATE_UNIT);
            switch (unit) {
                case MASS_RATE: {
                    outConstCoefficient.G = in.get(SourceSinkElement.GENERATION_RATE).get(SI.KILOGRAM.divide(SI.SECOND));
                    outConstCoefficient.D = in.get(SourceSinkElement.REMOVAL_RATE).get(SI.KILOGRAM.divide(SI.SECOND));
                    outConstCoefficient.u_G = 0;
                    outConstCoefficient.u_D = 0;
                    break;
                }
                case VOLUME_RATE: {
                    double volumeToMass = 0.041580041580041575;
                    double molarMass = in.get(SourceSinkElement.SPECIES).get(Species.MOLAR_MASS).get(SI.GRAM.divide(SI.MOLE));
                    outConstCoefficient.G = in.get(SourceSinkElement.GENERATION_RATE).get(SI.METER.pow(3).divide(SI.SECOND)) * molarMass * 0.041580041580041575;
                    outConstCoefficient.D = in.get(SourceSinkElement.REMOVAL_RATE).get(SI.METER.pow(3).divide(SI.SECOND)) * molarMass * 0.041580041580041575;
                    outConstCoefficient.u_G = 8;
                    outConstCoefficient.u_D = 8;
                }
            }
        }
    }
}

