/*
 * Decompiled with CFR 0.152.
 */
package ventus.feature.sourcesink;

import java.util.ArrayList;
import javax.swing.ImageIcon;
import thunderheadeng.util.GroupedSequence;
import ventus.EntryPointFactory;
import ventus.EntryPointHelper;
import ventus.Intl;
import ventus.data.IMerlinObj;
import ventus.data.VentusData;
import ventus.data.schematics.SimError;
import ventus.feature.comps.FeatureUtil;
import ventus.feature.comps.IDataModel;
import ventus.feature.sourcesink.SourceSinkElement;
import ventus.feature.sourcesink.SourceSinkElementRoot;
import ventus.gui.guiUtil;

public class SourceSinkElementData
implements IDataModel {
    public static final String GUID = "SourceSinkElement.data";
    public static final int SEQ_IX = 53;
    public static final ImageIcon ICON = guiUtil.loadIconSvg(FeatureUtil.getRequiredResource(SourceSinkElement.class, "icons/source-sink-element.svg"), 16);

    @Override
    public void init(VentusData md) {
        md.setComponentData(GUID, new SourceSinkElementRoot());
    }

    @Override
    public void reset(VentusData md) {
        ((SourceSinkElementRoot)md.getComponentData(GUID)).reset();
    }

    private static SourceSinkElementRoot getDataRoot(VentusData md) {
        return (SourceSinkElementRoot)md.getComponentData(GUID);
    }

    @Override
    public void loadFrom(VentusData src, VentusData dest) {
        SourceSinkElementRoot srcData = SourceSinkElementData.getDataRoot(src);
        SourceSinkElementRoot destData = SourceSinkElementData.getDataRoot(dest);
        destData.restoreFrom(srcData);
        dest.replaceInSel(srcData, destData);
    }

    @Override
    public void addTreeRoots(VentusData md, GroupedSequence roots) {
        roots.add(53, (Object)md.getComponentData(GUID));
    }

    @Override
    public void registerEntryPointData() {
        EntryPointHelper<SourceSinkElementRoot> rootHelper = new EntryPointHelper<SourceSinkElementRoot>(SourceSinkElementRoot.class);
        rootHelper.getIcon = (md, obj, unused) -> ICON;
        rootHelper.register();
        EntryPointHelper<SourceSinkElementRoot.SourceSinkElementNode> compHelper = new EntryPointHelper<SourceSinkElementRoot.SourceSinkElementNode>(SourceSinkElementRoot.SourceSinkElementNode.class);
        compHelper.getIcon = (md, obj, unused) -> ICON;
        compHelper.getType = (md, obj) -> Intl.intl("Source_Sink_Element_Group");
        compHelper.getRootComposite = (md, obj) -> SourceSinkElementData.getDataRoot(md);
        compHelper.getConflict = EntryPointFactory.getStandardConflictGetter(SourceSinkElementRoot.SourceSinkElementNode.class);
        compHelper.register();
        EntryPointHelper<SourceSinkElement> nodeHelper = new EntryPointHelper<SourceSinkElement>(SourceSinkElement.class);
        nodeHelper.getIcon = (md, obj, unused) -> {
            if (obj == null) {
                return ICON;
            }
            return guiUtil.loadIconSvg(SourceSinkElement.class.getResource("icons/source-sink-element.svg"), obj.get(SourceSinkElement.COLOR), 16);
        };
        nodeHelper.getType = (md, obj) -> Intl.intl("Source_Sink_Element");
        nodeHelper.getRootComposite = (md, obj) -> SourceSinkElementData.getDataRoot(md);
        nodeHelper.getConflict = EntryPointFactory.getStandardConflictGetter(SourceSinkElement.class);
        nodeHelper.getErrors = (vd, obj) -> {
            ArrayList<SimError> errors = new ArrayList<SimError>();
            if (obj.get(SourceSinkElement.SPECIES) == null) {
                errors.add(new SimError(SimError.Level.CRITICAL, String.format(Intl.intl("%s does not have a Species."), obj.getName()), Intl.intl("Delete Source/Sink Element or set its Species."), (IMerlinObj)obj));
            }
            return errors;
        };
        nodeHelper.register();
    }
}

