/*
 * Decompiled with CFR 0.152.
 */
package ventus.feature.sourcesink;

import java.awt.Color;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.Serializable;
import java.util.Optional;
import java.util.Set;
import org.jscience.physics.units.SI;
import org.jscience.physics.units.Unit;
import thunderheadeng.dependencies.DLink;
import thunderheadeng.dependencies.DepList;
import thunderheadeng.units.UnitDouble;
import thunderheadeng.util.IObservable;
import thunderheadeng.util.IObserver;
import thunderheadeng.util.ISurrogate;
import thunderheadeng.util.LinkedIdentityHashSet;
import thunderheadeng.util.Nullable;
import thunderheadeng.util.PropertySet;
import thunderheadeng.util.TypedProp;
import thunderheadeng.util.theUtil;
import ventus.Intl;
import ventus.data.ICompElement;
import ventus.data.IRestorable;
import ventus.data.NamedMerlinObj;
import ventus.data.VentusData;
import ventus.feature.comps.IDirectDependent;
import ventus.feature.props.TypedPropSet;
import ventus.feature.species.Species;
import ventus.feature.tags.Tag;
import ventus.feature.tags.TagsUtil;

public class SourceSinkElement
extends NamedMerlinObj
implements Serializable,
IRestorable,
ICompElement,
ISurrogate,
IDirectDependent,
IObservable {
    private static final long serialVersionUID = 1L;
    public static final TypedPropSet<SourceSinkElement> PROP_TYPES = new TypedPropSet();
    public static final TypedProp<String> NAME = PROP_TYPES.add(NamedMerlinObj.NAME, NamedMerlinObj::getName, NamedMerlinObj::setName, new TypedPropSet.Options[0]);
    public static final TypedProp<String> DESC = PROP_TYPES.add((Object)"SourceSinkElement.DESC", "", new TypedPropSet.Options[0]);
    public static final TypedProp<Color> COLOR = PROP_TYPES.add((Object)"SourceSinkElement.COLOR", Color.BLACK, new TypedPropSet.Options[0]);
    public static final TypedProp<Set<Tag>> TAGS = PROP_TYPES.add(VentusData.TAGS, SourceSinkElement::getTags, SourceSinkElement::setTags, TypedPropSet.Options.WEAK_DEPENDENT);
    public static final TypedProp<Species> SPECIES = PROP_TYPES.add(new TypedProp<Species>((Object)"SourceSinkElement.Species", Species.class), TypedPropSet.Options.STRONG_DEPENDENT);
    public static final TypedProp<SourceSinkModel> MODEL = PROP_TYPES.add((Object)"SourceSinkElement.MODEL", SourceSinkModel.CONSTANT_COEFFICIENT, new TypedPropSet.Options[0]);
    public static final TypedProp<GenRateUnit> GEN_RATE_UNIT = PROP_TYPES.add((Object)"SourceSinkElement.GEN_RATE_UNIT", GenRateUnit.MASS_RATE, new TypedPropSet.Options[0]);
    public static final TypedProp<UnitDouble> GENERATION_RATE = PROP_TYPES.add((Object)"SourceSinkElement.GENERATION_RATE", new UnitDouble(0.0, SI.KILOGRAM.divide(SI.SECOND)), new TypedPropSet.Options[0]);
    public static final TypedProp<UnitDouble> REMOVAL_RATE = PROP_TYPES.add((Object)"SourceSinkElement.REMOVAL_RATE", new UnitDouble(0.0, SI.KILOGRAM.divide(SI.SECOND)), new TypedPropSet.Options[0]);
    private PropertySet d_properties = new PropertySet();
    private transient PropertySet d_transientProps = new PropertySet();
    private transient LinkedIdentityHashSet<IObserver> d_observers = new LinkedIdentityHashSet();

    public SourceSinkElement(String name, Species species) {
        this(name, species, theUtil.newRandomSatColor());
    }

    public SourceSinkElement(String name, Species species, Color color) {
        super(name);
        this.set(SPECIES, species);
        this.set(COLOR, color);
    }

    private void readObject(ObjectInputStream is) throws ClassNotFoundException, IOException {
        is.defaultReadObject();
        this.d_transientProps = new PropertySet();
        this.d_observers = new LinkedIdentityHashSet();
    }

    @Override
    public SourceSinkElement clone() {
        SourceSinkElement element = (SourceSinkElement)super.clone();
        element.d_properties = this.d_properties.clone();
        element.d_transientProps = this.d_transientProps.clone();
        element.d_observers = new LinkedIdentityHashSet();
        return element;
    }

    @Override
    public Object getRestoreObj() {
        return this.clone();
    }

    @Override
    public void restoreFrom(Object obj) {
        if (obj instanceof SourceSinkElement) {
            SourceSinkElement element = (SourceSinkElement)obj;
            this.pauseUpdates();
            this.setName(element.getName());
            PROP_TYPES.restoreFrom(this, this.d_properties, element.d_properties, this.d_transientProps, element.d_transientProps);
            this.changedEvt(new Object[0]);
            this.resumeUpdates();
        }
    }

    @Override
    public void takeDepSnapshot(DepList deps) {
        deps.add(DLink.WEAK, this.getTags());
        PROP_TYPES.takeDepSnapshot(this, this.d_properties, this.d_transientProps, deps);
    }

    @Override
    public void replaceDependency(VentusData md, Object old, Object replacement) {
        TagsUtil.replaceDependency(this, old, replacement);
        PROP_TYPES.replaceDependency(this, this.d_properties, this.d_transientProps, old, replacement);
    }

    @Override
    public boolean changedEvt(Object ... changes) {
        this.d_observers.forEach(o -> o.update(this, changes));
        return super.changedEvt(changes);
    }

    @Override
    public void addObserver(IObserver observer, boolean weakRef) {
        this.d_observers.add(observer);
    }

    @Override
    public void deleteObserver(IObserver observer) {
        this.d_observers.remove(observer);
    }

    @Override
    public String toString() {
        return this.getName();
    }

    @Override
    public boolean surrogateEquals(Object comparable) {
        if (comparable == this) {
            return true;
        }
        if (comparable == null || !this.getClass().equals(comparable.getClass())) {
            return false;
        }
        SourceSinkElement element = (SourceSinkElement)comparable;
        if (!this.getName().equals(element.getName())) {
            return false;
        }
        for (TypedProp<?> prop : PROP_TYPES.props()) {
            if (theUtil.equal(this.get(prop), element.get(prop))) continue;
            return false;
        }
        return true;
    }

    public Set<Tag> getTags() {
        return this.d_properties.get(VentusData.TAGS);
    }

    public void setTags(Set<Tag> tags) {
        PROP_TYPES.compareAndSetDirect(this, this.d_properties, this.d_transientProps, VentusData.TAGS, tags);
    }

    @Override
    public Set<Object> getPropTypes(int options) {
        return PROP_TYPES.keys();
    }

    public <T> T get(TypedProp<T> prop) {
        Optional<Nullable<Nullable>> val = PROP_TYPES.getValue(this, this.d_properties, this.d_transientProps, prop);
        return val.map(tNullable -> tNullable.val).orElse(null);
    }

    public <T> void set(TypedProp<T> prop, T value) {
        GenRateUnit genRateUnit;
        if (prop == GEN_RATE_UNIT && value instanceof GenRateUnit && (genRateUnit = (GenRateUnit)((Object)value)) != this.get(GEN_RATE_UNIT)) {
            this.set(GENERATION_RATE, new UnitDouble(0.0, genRateUnit.defaultUnit));
            this.set(REMOVAL_RATE, new UnitDouble(0.0, genRateUnit.defaultUnit));
        }
        PROP_TYPES.setValue(this, this.d_properties, this.d_transientProps, prop, value);
    }

    @Override
    public <T> void setProperty(Object key, T value) {
        if (key.equals(VentusData.TAGS)) {
            this.setTags((Set)value);
            return;
        }
        TypedProp<T> prop = PROP_TYPES.getStrict(key, value);
        if (prop == null) {
            return;
        }
        this.set(prop, value);
    }

    @Override
    public Object getProperty(Object key) {
        TypedProp<?> prop = PROP_TYPES.get(key);
        if (prop == null) {
            return NOT_SUPPORTED;
        }
        return this.get(prop);
    }

    public static enum GenRateUnit {
        MASS_RATE(Intl.intl("Mass"), Intl.intl("Rates by unit mass per unit time."), SI.KILOGRAM.divide(SI.SECOND)),
        VOLUME_RATE(Intl.intl("Volume"), Intl.intl("Rates by unit volume per unit time.\nDepends on Species Molar Mass.\nNOTE: For simulation, this rate will be converted\nto a Mass rate at standard temperature and pressure."), SI.METER.pow(3).divide(SI.SECOND));

        public final String name;
        public final String desc;
        public final Unit defaultUnit;

        private GenRateUnit(String name, String desc, Unit defaultUnit) {
            this.name = name;
            this.desc = desc;
            this.defaultUnit = defaultUnit;
        }

        public String toString() {
            return this.name;
        }
    }

    public static enum SourceSinkModel {
        CONSTANT_COEFFICIENT(Intl.intl("Constant Coefficient"), Intl.intl("Contaminant generation and removal rates are constant."), "ccf");

        public final String name;
        public final String desc;
        public final String type;

        private SourceSinkModel(String name, String desc, String type) {
            this.name = name;
            this.desc = desc;
            this.type = type;
        }

        public String toString() {
            return this.name;
        }
    }
}

