/*
 * Decompiled with CFR 0.152.
 */
package ventus.feature.sourcesink;

import java.awt.Color;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Optional;
import java.util.Set;
import java.util.function.BiPredicate;
import java.util.function.Consumer;
import javax.vecmath.Point3d;
import javax.vecmath.Vector3d;
import org.jscience.physics.units.Unit;
import thunderheadeng.dependencies.DLink;
import thunderheadeng.dependencies.DepList;
import thunderheadeng.geometry.GeomConstants;
import thunderheadeng.geometry.manip.IHandle;
import thunderheadeng.geometry.objs.IGeom;
import thunderheadeng.geometry.objs.node.GeomNodeUtil;
import thunderheadeng.geometry.objs.node.IGeomNode;
import thunderheadeng.scene3d.geom.DisplayGeom;
import thunderheadeng.scene3d.geom.IDisplayProps;
import thunderheadeng.scene3d.geom.IPrimProps;
import thunderheadeng.scene3d.geom.PropsBuilder;
import thunderheadeng.scene3d.navtools.SnapMode;
import thunderheadeng.scene3d.picking.DefaultFilter;
import thunderheadeng.scene3d.picking.IIsectFilter;
import thunderheadeng.scene3d.picking.ISnapConstraint;
import thunderheadeng.units.UnitDouble;
import thunderheadeng.util.EventChannel;
import thunderheadeng.util.ICyclicSurrogate;
import thunderheadeng.util.IObservable;
import thunderheadeng.util.IObserver;
import thunderheadeng.util.Nullable;
import thunderheadeng.util.Pair;
import thunderheadeng.util.PropertySet;
import thunderheadeng.util.TypedProp;
import thunderheadeng.util.UnorderedPair;
import thunderheadeng.util.theUtil;
import ventus.data.NamedMerlinObj;
import ventus.data.VentusData;
import ventus.data.schematics.ISchematicObj;
import ventus.data.schematics.geom.ISchematicRoom;
import ventus.data.value.Schedule;
import ventus.feature.ahs.AHSPoint;
import ventus.feature.comps.IDirectDependent;
import ventus.feature.props.TypedPropSet;
import ventus.feature.sourcesink.SourceSinkElement;
import ventus.feature.tags.Tag;
import ventus.feature.tags.TagsUtil;
import ventus.geom.GeomUtil;
import ventus.geom.PointEntityGeom;
import ventus.mv.tools.RoomSnapConstraint;

public class SourceSink
extends NamedMerlinObj
implements Serializable,
ISchematicObj,
IDirectDependent,
ICyclicSurrogate,
IObserver {
    private static final long serialVersionUID = 1L;
    public static final TypedPropSet<SourceSink> PROP_TYPES = new TypedPropSet();
    public static final TypedProp<String> NAME = PROP_TYPES.add(NamedMerlinObj.NAME, NamedMerlinObj::getName, NamedMerlinObj::setName, new TypedPropSet.Options[0]);
    public static final TypedProp<Boolean> VISIBILITY = PROP_TYPES.add(VentusData.VISIBILITY, SourceSink::isVisible, SourceSink::setVisible, new TypedPropSet.Options[0]);
    public static final TypedProp<Boolean> ENABLED = PROP_TYPES.add(VentusData.ENABLED, SourceSink::isEnabled, SourceSink::setEnabled, new TypedPropSet.Options[0]);
    public static final TypedProp<Set<Tag>> TAGS = PROP_TYPES.add(VentusData.TAGS, SourceSink::getTags, SourceSink::setTags, TypedPropSet.Options.WEAK_DEPENDENT);
    public static final TypedProp<ISchematicRoom> ROOM = PROP_TYPES.add(new TypedProp<ISchematicRoom>((Object)"SourceSink.ROOM", ISchematicRoom.class), TypedPropSet.Options.NO_RESTORE, TypedPropSet.Options.TRANSIENT, TypedPropSet.Options.WEAK_DEPENDENT);
    public static final TypedProp<Point3d> LOCATION = PROP_TYPES.add((Object)"SourceSink.LOCATION", new Point3d(0.0, 0.0, 0.0), new TypedPropSet.Options[0]);
    public static final TypedProp<Vector3d> ROOM_NORMAL = PROP_TYPES.add((Object)"SourceSink.ROOM_NORMAL", new Vector3d(0.0, 0.0, 1.0), new TypedPropSet.Options[0]);
    public static final TypedProp<Schedule> MULTIPLIER = PROP_TYPES.add(new TypedProp<Schedule>((Object)"SourceSink.MULTIPLIER", Schedule.newConstant(new UnitDouble(1.0, Unit.ONE))), new TypedPropSet.Options[0]);
    public static final TypedProp<SourceSinkElement> ELEMENT = PROP_TYPES.add(new TypedProp<SourceSinkElement>((Object)"SourceSink.ELEMENT", SourceSinkElement.class), SourceSink::getElement, SourceSink::setElement, TypedPropSet.Options.STRONG_DEPENDENT);
    private PropertySet d_properties = new PropertySet();
    private transient PropertySet d_transientProps = new PropertySet();

    public SourceSink(String name) {
        super(name);
    }

    private void readObject(ObjectInputStream is) throws ClassNotFoundException, IOException {
        is.defaultReadObject();
        this.d_transientProps = new PropertySet();
        if (this.d_properties.isDefined(ROOM)) {
            this.d_transientProps.setIfNotDefault(ROOM, this.d_properties.get(ROOM));
            this.d_properties.remove(ROOM);
        }
        this.observe(this.getElement());
    }

    @Override
    public void writeTopology(ObjectOutputStream oos) throws IOException {
        oos.writeObject(this.get(ROOM));
    }

    @Override
    public void readTopology(ObjectInputStream ois) throws IOException, ClassNotFoundException {
        this.set(ROOM, (ISchematicRoom)ois.readObject());
    }

    @Override
    public SourceSink clone() {
        SourceSink source = (SourceSink)super.clone();
        source.d_properties = this.d_properties.clone();
        source.d_transientProps = this.d_transientProps.clone();
        source.observe(this.getElement());
        return source;
    }

    @Override
    public Object getRestoreObj() {
        return this.clone();
    }

    @Override
    public void restoreFrom(Object obj) {
        if (obj instanceof SourceSink) {
            SourceSink source = (SourceSink)obj;
            this.pauseUpdates();
            this.setName(source.getName());
            PROP_TYPES.restoreFrom(this, this.d_properties, source.d_properties, this.d_transientProps, source.d_transientProps);
            this.observe(this.getElement());
            this.changedEvt(VentusData.TOPOLOGY);
            this.changedEvt(new Object[0]);
            this.resumeUpdates();
        }
    }

    @Override
    public String toString() {
        return this.getName();
    }

    @Override
    public boolean cyclicEquals(Object comparable, HashSet<UnorderedPair<Object, Object>> comparedSet) {
        if (comparable == this) {
            return true;
        }
        if (comparable == null || !this.getClass().equals(comparable.getClass())) {
            return false;
        }
        SourceSink source = (SourceSink)comparable;
        if (!this.getName().equals(source.getName())) {
            return false;
        }
        for (TypedProp<?> prop : PROP_TYPES.props()) {
            if (theUtil.equal(this.get(prop), source.get(prop), comparedSet)) continue;
            return false;
        }
        return true;
    }

    public Set<Tag> getTags() {
        return this.d_properties.get(VentusData.TAGS);
    }

    public void setTags(Set<Tag> tags) {
        PROP_TYPES.compareAndSetDirect(this, this.d_properties, this.d_transientProps, VentusData.TAGS, tags);
    }

    @Override
    public Set<Object> getPropTypes(int options) {
        return PROP_TYPES.keys();
    }

    public <T> T get(TypedProp<T> prop) {
        Optional<Nullable<Nullable>> val = PROP_TYPES.getValue(this, this.d_properties, this.d_transientProps, prop);
        return val.map(tNullable -> tNullable.val).orElse(null);
    }

    public <T> void set(TypedProp<T> prop, T value) {
        PROP_TYPES.setValue(this, this.d_properties, this.d_transientProps, prop, value);
    }

    protected <T> boolean setToPropertySet(TypedProp<T> prop, T value) {
        return PROP_TYPES.compareAndSetDirect(this, this.d_properties, this.d_transientProps, prop, value);
    }

    @Override
    public <T> void setProperty(Object key, T value) {
        if (key.equals(VentusData.TAGS)) {
            this.setTags((Set)value);
            return;
        }
        TypedProp<T> prop = PROP_TYPES.getStrict(key, value);
        if (prop == null) {
            return;
        }
        this.set(prop, value);
    }

    @Override
    public Object getProperty(Object key) {
        TypedProp<?> prop = PROP_TYPES.get(key);
        if (prop == null) {
            return NOT_SUPPORTED;
        }
        return this.get(prop);
    }

    public SourceSinkElement getElement() {
        return this.d_properties.get(ELEMENT);
    }

    protected void setElement(SourceSinkElement newElement) {
        SourceSinkElement oldElement = this.get(ELEMENT);
        if (oldElement == newElement) {
            return;
        }
        this.ignore(oldElement);
        this.observe(newElement);
        this.pauseUpdates();
        this.setToPropertySet(ELEMENT, newElement);
        this.resumeUpdates();
    }

    private void observe(SourceSinkElement element) {
        if (element != null) {
            element.addObserver(this, false);
        }
    }

    private void ignore(SourceSinkElement element) {
        if (element != null) {
            element.deleteObserver(this);
        }
    }

    public boolean isEnabled() {
        return this.d_properties.get(ENABLED);
    }

    public void setEnabled(boolean enabled) {
        this.pauseUpdates();
        if (this.setToPropertySet(ENABLED, enabled)) {
            this.changedEvt(VentusData.VISIBILITY, EventChannel.EVT_GENERAL, VentusData.TOPOLOGY);
        }
        this.resumeUpdates();
    }

    @Override
    public boolean isVisible() {
        return this.d_properties.get(VISIBILITY) != false && this.get(ENABLED) != false;
    }

    @Override
    public void setVisible(boolean visible) {
        this.setToPropertySet(VISIBILITY, visible);
    }

    @Override
    public Collection<? extends ISchematicObj> getConnections() {
        return this.get(ROOM) != null ? Collections.singleton(this.get(ROOM)) : Collections.emptyList();
    }

    @Override
    public boolean hasOpenSpots(Class<? extends ISchematicObj> type) {
        return this.get(ROOM) == null;
    }

    @Override
    public void disconnectFrom(ISchematicObj conn) {
        if (conn == this.get(ROOM)) {
            this.set(ROOM, null);
            this.pauseUpdates();
            this.set(ROOM_NORMAL, GeomConstants.VEC3D_ZPOS);
            this.changedEvt(new Object[0]);
            this.resumeUpdates();
        }
    }

    @Override
    public void connectTo(ISchematicObj conn) {
    }

    @Override
    public boolean updateTopo() {
        Point3d location = this.get(LOCATION);
        GeomUtil.FindResult room = GeomUtil.findRoom((VentusData)this.getDomain(), new Point3d(location.x, location.y, location.z + 1.0E-6), new Point3d(location.x, location.y, location.z - 1.0E-6), 1, SourceSink.getRoomFilter());
        if (room != null) {
            this.pauseUpdates();
            this.set(ROOM, room.room);
            this.set(ROOM_NORMAL, room.faceNormal);
            this.set(LOCATION, room.p);
            this.resumeUpdates();
        }
        return true;
    }

    @Override
    public void update(IObservable source, Object event) {
        if (!source.equals(this.get(ELEMENT))) {
            return;
        }
        this.changedEvt(ELEMENT);
    }

    public static BiPredicate<? super ISchematicRoom, ? super ISchematicRoom.IComponent> getRoomFilter() {
        return (room, comp) -> room.getType() == ISchematicRoom.Type.ZONE && !(comp instanceof ISchematicRoom.IWallComponent);
    }

    @Override
    public IGeomNode getGeom() {
        return GeomNodeUtil.newNode(this.getPointGeom());
    }

    @Override
    public void setGeom(IGeomNode geom) {
        this.setGeom(geom.flatten().getLocalGeom());
    }

    public void setGeom(IGeom geom) {
        if (geom instanceof PointEntityGeom) {
            PointEntityGeom pointGeom = (PointEntityGeom)geom;
            this.set(LOCATION, pointGeom.location);
        }
        this.changedEvt(VentusData.TOPOLOGY);
    }

    @Override
    public DisplayGeom getDisplayGeom(IDisplayProps props) {
        IGeomNode geom = this.getGeom();
        PropsBuilder pb = new PropsBuilder();
        SourceSinkElement sourceSinkElement = this.get(ELEMENT);
        if (sourceSinkElement instanceof SourceSinkElement) {
            SourceSinkElement elem = sourceSinkElement;
            pb.add(new IPrimProps.Face(elem.get(SourceSinkElement.COLOR), null, 0), 12);
        } else {
            pb.add(new IPrimProps.Face(Color.RED, null, 0), 12);
        }
        pb.add(new IPrimProps.Edge(Color.BLACK, 2.0, IPrimProps.DEF_STIPPLE, 0), 18);
        return new DisplayGeom(geom, pb);
    }

    private SourceSinkGeom getPointGeom() {
        return new SourceSinkGeom((VentusData)this.getDomain(), this.get(LOCATION));
    }

    @Override
    public void takeDepSnapshot(DepList deps) {
        deps.add(DLink.WEAK, this.getTags());
        PROP_TYPES.takeDepSnapshot(this, this.d_properties, this.d_transientProps, deps);
    }

    @Override
    public void replaceDependency(VentusData md, Object old, Object replacement) {
        TagsUtil.replaceDependency(this, old, replacement);
        PROP_TYPES.replaceDependency(this, this.d_properties, this.d_transientProps, old, replacement);
    }

    private static class SourceSinkGeom
    extends PointEntityGeom {
        private static final long serialVersionUID = 1L;
        private final VentusData vd;

        public SourceSinkGeom(VentusData vd, Point3d loc) {
            super(loc, 0.6);
            this.vd = vd;
        }

        @Override
        public PointEntityGeom newPoint(Point3d loc) {
            return new SourceSinkGeom(this.vd, loc);
        }

        @Override
        public void generateManipHandles(Consumer<? super IHandle> handles) {
            handles.accept(new Handle());
        }

        public class Handle
        extends PointEntityGeom.Handle {
            public Handle() {
                super(SourceSinkGeom.this);
            }

            @Override
            public Pair<SnapMode, IIsectFilter> getPickFilter() {
                return new Pair<SnapMode, IIsectFilter>(SnapMode.FILTERED_TWO_PASS, new DefaultFilter());
            }

            @Override
            public ISnapConstraint getConstraint(Point3d handleLoc) {
                return new RoomSnapConstraint(SourceSinkGeom.this.vd, null, AHSPoint.getRoomFilter());
            }
        }
    }
}

