/*
 * Decompiled with CFR 0.152.
 */
package ventus.feature.simparams;

import org.jscience.physics.units.NonSI;
import org.jscience.physics.units.SI;
import thunderheadeng.units.UnitDouble;
import thunderheadeng.util.TypedProp;
import ventus.Intl;

public class SimParamsProps {
    public static final TypedProp<Boolean> runSteady = new TypedProp<Boolean>((Object)"runSteady", true);
    public static final TypedProp<Boolean> varyDensity = new TypedProp<Boolean>((Object)"varyDensity", false);
    public static final TypedProp<Integer> maxIteration = new TypedProp<Integer>((Object)"maxIteration", 20);
    public static final TypedProp<UnitDouble> defaultZoneTemp = new TypedProp<UnitDouble>((Object)"defaultZoneTemp", new UnitDouble(20.0, SI.CELSIUS));
    public static final TypedProp<AirflowSimMethod> airflowSimMethod = new TypedProp<AirflowSimMethod>((Object)"airflowSimMethod", AirflowSimMethod.STEADY);
    public static final TypedProp<ContaminantSimMethod> contaminantSimMethod = new TypedProp<ContaminantSimMethod>((Object)"contaminantSimMethod", ContaminantSimMethod.STEADY);
    public static final TypedProp<UnitDouble> simulationTime = new TypedProp<UnitDouble>((Object)"simulationTime", new UnitDouble(20.0, NonSI.MINUTE));
    public static final TypedProp<UnitDouble> simulationTimestep = new TypedProp<UnitDouble>((Object)"simulationTimestep", new UnitDouble(1.0, SI.SECOND));

    public static enum AirflowSimMethod {
        STEADY(Intl.intl("Steady"), Intl.intl("Calculate a single set of airflows.")),
        TRANSIENT(Intl.intl("Transient"), Intl.intl("Calculate airflows that vary over time."));

        public final String name;
        public final String desc;

        private AirflowSimMethod(String name, String desc) {
            this.name = name;
            this.desc = desc;
        }
    }

    public static enum ContaminantSimMethod {
        STEADY(Intl.intl("Steady"), Intl.intl("Calculate a single set of contaminant concentrations.")),
        TRANSIENT(Intl.intl("Transient"), Intl.intl("Calculate contaminant concentrations that vary over time."));

        public final String name;
        public final String desc;

        private ContaminantSimMethod(String name, String desc) {
            this.name = name;
            this.desc = desc;
        }
    }
}

