/*
 * Decompiled with CFR 0.152.
 */
package ventus.feature.results;

import java.awt.Component;
import java.awt.Dimension;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.TreeSet;
import java.util.Vector;
import java.util.regex.PatternSyntaxException;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JToggleButton;
import javax.swing.RowFilter;
import javax.swing.SwingUtilities;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.table.TableRowSorter;
import net.miginfocom.swing.MigLayout;
import org.apache.commons.lang3.ArrayUtils;
import org.jscience.physics.units.SI;
import org.jscience.physics.units.Unit;
import thunderheadeng.animate.IAnimSession;
import thunderheadeng.animate.IAnimator;
import thunderheadeng.gui.AbstractCommand;
import thunderheadeng.gui.guiLabel;
import thunderheadeng.gui.guiTextField;
import thunderheadeng.gui.table.ToolTipTableHeader;
import thunderheadeng.gui.table.guiDefaultTableModel;
import thunderheadeng.gui.table.leanGuiTable;
import thunderheadeng.gui.table.leanGuiTableEditor;
import thunderheadeng.units.UnitDouble;
import thunderheadeng.util.EventChannel;
import thunderheadeng.util.Events;
import thunderheadeng.util.GroupedSequence;
import thunderheadeng.util.Pair;
import thunderheadeng.util.RepeatedList;
import ventus.Intl;
import ventus.VentusApp;
import ventus.actions.Undo;
import ventus.data.MerlinSelectionModel;
import ventus.data.VentusData;
import ventus.data.schematics.geom.SchematicRoom;
import ventus.feature.comps.IFeatureAnimator;
import ventus.feature.comps.ISelectionTab;
import ventus.feature.results.DataNode;
import ventus.feature.results.ResultsDataComp;
import ventus.feature.results.ResultsFeature;
import ventus.feature.results.SelectionResultsTableUtil;
import ventus.mv.gui.SelectionEditorPanel;
import ventus.unitsystem.UnitSystem;

public class ZoneSelectionResultsTable
implements ISelectionTab,
IFeatureAnimator {
    private final ZoneSelectionResultsEditorPanel d_panel = new ZoneSelectionResultsEditorPanel();

    protected ZoneSelectionResultsTable() {
    }

    @Override
    public boolean isEnabled(Set<Object> shared, Set<Object> unshared) {
        return true;
    }

    @Override
    public Collection<SelectionEditorPanel.EditorPanel> getSections() {
        return Collections.singleton(this.d_panel);
    }

    @Override
    public Pair<Double, Double> getTimeRange() {
        return this.d_panel.getTimeRange();
    }

    @Override
    public boolean update(IAnimSession session) {
        return this.d_panel.update(session);
    }

    @Override
    public void addToTabbedPane(GroupedSequence root) {
        root.add(20, (Object)this);
    }

    protected static class ZoneSelectionResultsEditorPanel
    extends SelectionEditorPanel.EditorPanel
    implements IAnimator {
        static final long serialVersionUID = 1L;
        private static final int SET_IX = 0;
        private static final int TIME_IX = 1;
        private static final int NAME_IX = 2;
        private static final int TEMPERATURE_IX = 3;
        private static final int PRESSURE_IX = 4;
        private static final int DENSITY_IX = 5;
        private final leanGuiTableEditor d_editor;
        private final leanGuiTable d_table;
        private final SelectionResultsTableUtil.UnitSensObjectBackedTableModel<DataNode.ZoneVisLeaf> d_tableModel = new SelectionResultsTableUtil.UnitSensObjectBackedTableModel(0);
        private final TableRowSorter<guiDefaultTableModel> d_tableFilters;
        private final guiTextField d_regexField;
        private final SelectionResultsTableUtil.SimRootCombobox d_resultsGroupCombo;
        private final JButton d_editFiltersBtn;
        private final JButton d_clearFiltersBtn;
        private final JToggleButton d_followTimeToggle;
        private final JToggleButton d_followSelectionToggle;
        private ActiveZoneSelectionFilter d_followSelectionFilter;
        private SelectionResultsTableUtil.TimeFilter d_timeFilter;
        private RowFilter<guiDefaultTableModel, Integer> d_regexOrFilter;
        private RowFilter<guiDefaultTableModel, Integer> d_regexNameFilter;
        private RowFilter<guiDefaultTableModel, Integer> d_regexTagFilter;
        private RowFilter<guiDefaultTableModel, Integer> d_groupFilter;
        private Unit d_timeUnit;
        private List<SelectionResultsTableUtil.LogicColumnFilterControl<DataNode.ZoneVisLeaf>> d_columnControls;

        public ZoneSelectionResultsEditorPanel() {
            super(Intl.intl("Zone Data"));
            this.d_table = new leanGuiTable(this.d_tableModel, 16);
            this.d_editor = new leanGuiTableEditor(this.d_table, 0);
            this.d_table.setPreferredScrollableViewportSize(new Dimension(this.d_editor.getPreferredSize().width, 2160));
            this.d_timeUnit = SI.SECOND;
            this.d_timeFilter = new SelectionResultsTableUtil.TimeFilter(1);
            this.d_tableFilters = new TableRowSorter<guiDefaultTableModel>((guiDefaultTableModel)this.d_table.getModel());
            this.d_table.setRowSorter(this.d_tableFilters);
            this.d_tableFilters.setSortsOnUpdates(true);
            this.updateTableAndModel(Collections.emptySet());
            this.d_followTimeToggle = new JToggleButton(ResultsFeature.icon_resultsFollowTime, true);
            this.d_followTimeToggle.addItemListener(e -> this.updateFilters());
            this.d_followTimeToggle.setToolTipText(Intl.intl("Filter to Current Time"));
            this.d_followSelectionToggle = new JToggleButton(ResultsFeature.icon_resultsFollow, false);
            this.d_followSelectionToggle.addItemListener(e -> {
                this.d_followSelectionFilter = new ActiveZoneSelectionFilter(VentusApp.getAppData().selection, (DataNode.ResultsRoot)VentusApp.getAppData().getComponentData(ResultsDataComp.GUID));
                this.updateFilters();
            });
            this.d_followSelectionToggle.setToolTipText(Intl.intl("Filter by Selection"));
            this.d_regexField = new guiTextField();
            this.d_regexField.getDocument().addDocumentListener(new DocumentListener(){

                @Override
                public void insertUpdate(DocumentEvent e) {
                    this.updateRegexFilters(true);
                }

                @Override
                public void removeUpdate(DocumentEvent e) {
                    this.updateRegexFilters(true);
                }

                @Override
                public void changedUpdate(DocumentEvent e) {
                    this.updateRegexFilters(true);
                }
            });
            this.d_regexField.setToolTipText(Intl.intl("Filter by Name or Tag"));
            this.d_resultsGroupCombo = new SelectionResultsTableUtil.SimRootCombobox();
            this.d_resultsGroupCombo.setNullString(Intl.intl("<All>"));
            this.d_resultsGroupCombo.addItemListener(e -> this.updateSimRootFilter(true));
            this.d_resultsGroupCombo.setToolTipText(Intl.intl("Filter by data set"));
            this.d_followSelectionFilter = null;
            this.d_editFiltersBtn = new JButton(ResultsFeature.icon_resultsFilterEdit);
            this.d_editFiltersBtn.addActionListener(e -> {
                SelectionResultsTableUtil.SetNumericFilterWindow editor = new SelectionResultsTableUtil.SetNumericFilterWindow(SwingUtilities.getWindowAncestor(this), this.d_columnControls);
                editor.loadFilters();
                if (editor.doModal() == 1) {
                    editor.updateFilters();
                    this.updateFilters();
                }
            });
            this.d_editFiltersBtn.setToolTipText(Intl.intl("More Filters..."));
            this.d_clearFiltersBtn = new JButton(ResultsFeature.icon_resultsFilterClear);
            this.d_clearFiltersBtn.addActionListener(e -> this.clearFilters());
            this.d_clearFiltersBtn.setToolTipText(Intl.intl("Clear Filters"));
            JLabel filterStatusLbl = new JLabel("");
            this.d_tableModel.addTableModelListener(e -> filterStatusLbl.setText(this.getFilterInfoDescription()));
            this.d_tableFilters.addRowSorterListener(e -> filterStatusLbl.setText(this.getFilterInfoDescription()));
            filterStatusLbl.setText(this.getFilterInfoDescription());
            this.setLayout(new MigLayout("fill", "[][][grow][][][][][]", "[]12[grow]"));
            this.add(new guiLabel(Intl.intl("Filter:")));
            this.add(this.d_resultsGroupCombo);
            this.add((Component)this.d_regexField, "grow");
            this.add(new JLabel(ResultsFeature.icon_resultsFind));
            this.add(this.d_followTimeToggle);
            this.add(this.d_followSelectionToggle);
            this.add(this.d_editFiltersBtn);
            this.add((Component)this.d_clearFiltersBtn, "wrap");
            this.add((Component)filterStatusLbl, "span 2, wrap");
            this.add((Component)this.d_editor, "span 8, grow");
        }

        private Vector<String> generateColHeaders() {
            Vector<String> colHeaders = new Vector<String>(List.of(Intl.intl("Data Set"), Intl.intl("Time (s)"), Intl.intl("Name")));
            colHeaders.addAll(this.d_columnControls.stream().map(SelectionResultsTableUtil.LogicColumnFilterControl::getColHeader).toList());
            return colHeaders;
        }

        private void updateTableAndModel(Set<String> concentrations) {
            this.d_tableModel.clearData();
            this.d_table.clearRows();
            this.d_columnControls = new ArrayList<SelectionResultsTableUtil.LogicColumnFilterControl<DataNode.ZoneVisLeaf>>();
            this.d_columnControls.add(new SelectionResultsTableUtil.LogicColumnFilterControl(3, control -> leaf -> Arrays.stream(leaf.getTemperatures()).map(val -> UnitDouble.convert(val, SI.KELVIN, control.getUnit())).boxed().collect(Collectors.toList()), SI.CELSIUS, UnitSystem::getTemperature, unit -> String.format(Intl.intl("T (%s)"), unit.toString()), Intl.intl("Temperature"), Intl.intl("Sort by Temperature"), Intl.intl("Filter by Temperature:")));
            this.d_columnControls.add(new SelectionResultsTableUtil.LogicColumnFilterControl(4, control -> leaf -> Arrays.stream(leaf.getPressures()).map(val -> UnitDouble.convert(val, SI.PASCAL, control.getUnit())).boxed().collect(Collectors.toList()), SI.PASCAL, UnitSystem::getPressure, unit -> String.format(Intl.intl("P (%s)"), unit.toString()), Intl.intl("Pressure"), Intl.intl("Sort by Pressure"), Intl.intl("Filter by Pressure:")));
            this.d_columnControls.add(new SelectionResultsTableUtil.LogicColumnFilterControl(5, control -> leaf -> Arrays.stream(leaf.getDensities()).map(val -> UnitDouble.convert(val, SI.KILOGRAM.divide(SI.METER.pow(3)), control.getUnit())).boxed().collect(Collectors.toList()), SI.KILOGRAM.divide(SI.METER.pow(3)), UnitSystem::getDensity, unit -> String.format(Intl.intl("D (%s)"), unit.toString()), Intl.intl("Density"), Intl.intl("Sort by Density"), Intl.intl("Filter by Density:")));
            int index = 6;
            for (String concentration : concentrations) {
                this.d_columnControls.add(new SelectionResultsTableUtil.LogicColumnFilterControl(index, control -> leaf -> Arrays.stream(leaf.getConcentrations(concentration)).boxed().collect(Collectors.toList()), SI.KILOGRAM.divide(SI.KILOGRAM), usys -> usys.getUnit(25), unit -> String.format(Intl.intl("%1$s (%2$s)"), concentration, unit.toString()), String.format(Intl.intl("%s Concentration"), concentration), String.format(Intl.intl("Sort by %s"), concentration), String.format(Intl.intl("Filter by %s:"), concentration)));
                ++index;
            }
            Vector<String> colHeaders = this.generateColHeaders();
            ArrayList<Class<String>> colClasses = new ArrayList<Class<String>>(List.of(String.class, Double.class, String.class));
            colClasses.addAll(this.d_columnControls.stream().map(SelectionResultsTableUtil.LogicColumnFilterControl::getColClass).toList());
            this.d_tableModel.setColumnCount(colHeaders.size());
            this.d_tableModel.setColumnIdentifiers(colHeaders);
            for (int i = 0; i < colClasses.size(); ++i) {
                this.d_tableModel.setColumnClass(i, (Class)colClasses.get(i));
            }
            this.d_tableModel.clearColumnMappers();
            this.d_tableModel.setColumnMapper(0, leaf -> new RepeatedList<String>(Collections.singletonList(leaf.getSimulationName()), leaf.getTimes().length));
            this.d_tableModel.setColumnMapper(1, leaf -> Arrays.stream(leaf.getTimes()).boxed().collect(Collectors.toList()));
            this.d_tableModel.setColumnMapper(2, leaf -> new RepeatedList<String>(Collections.singletonList(leaf.getName()), leaf.getTimes().length));
            for (SelectionResultsTableUtil.LogicColumnFilterControl<DataNode.ZoneVisLeaf> control2 : this.d_columnControls) {
                control2.addColumnMapper(this.d_tableModel);
            }
            this.d_tableModel.setUnitForCol(1, this.d_timeUnit);
            for (SelectionResultsTableUtil.LogicColumnFilterControl<DataNode.ZoneVisLeaf> control2 : this.d_columnControls) {
                this.d_tableModel.setUnitForCol(control2.getColIx(), control2.getUnit());
            }
            for (int i = 0; i < colHeaders.size(); ++i) {
                this.d_table.setColumnEditable(i, false);
            }
            ArrayList<String> colTooltips = new ArrayList<String>(List.of(Intl.intl("Result ID"), Intl.intl("Simulation Timestep"), Intl.intl("Flowpath ID")));
            colTooltips.addAll(this.d_columnControls.stream().map(SelectionResultsTableUtil.LogicColumnFilterControl::getColTooltip).toList());
            this.d_table.setTableHeader(new ToolTipTableHeader(this.d_table.getColumnModel(), colTooltips.toArray(new String[0])));
            this.d_table.clearContextActions();
            this.d_table.addContextAction(new SetModelSelectionToTableZoneSelection(this.d_table, this.d_tableModel));
            this.d_table.addContextAction(new SelectionResultsTableUtil.SetModelSelectionToResultSelection<DataNode.ZoneVisLeaf>(this.d_table, this.d_tableModel));
            this.d_table.addContextAction(new SelectionResultsTableUtil.ClearSortComand(this.d_tableFilters));
            this.d_table.addContextAction(new SelectionResultsTableUtil.SortByColumnCommand(this.d_tableFilters, 2, Intl.intl("Sort by Name")));
            this.d_table.addContextAction(new SelectionResultsTableUtil.SortByColumnCommand(this.d_tableFilters, 1, Intl.intl("Sort by Time")));
            for (SelectionResultsTableUtil.LogicColumnFilterControl<DataNode.ZoneVisLeaf> control3 : this.d_columnControls) {
                this.d_table.addContextAction(control3.buildSortCommand(this.d_tableFilters));
            }
        }

        @Override
        public void update(Events events) {
            super.update(events);
            VentusApp app = VentusApp.getApp();
            if (events.getEvents(DataNode.VisRoot.class, new Class[0]).hasAddedObjs() || events.getEvents(DataNode.VisRoot.class, new Class[0]).hasRemovedObjs()) {
                this.updateData((DataNode.ResultsRoot)app.getData().getComponentData(ResultsDataComp.GUID));
                this.updateUnits(app.getUnitSystem());
            }
            for (EventChannel<VentusData> eventChannel : events.getAffectedChannels(VentusData.class, new Class[0])) {
                if (eventChannel.hasChangedObjs(VentusData.MODEL_LOADED, VentusData.MODEL_RESET)) {
                    this.clearFilters();
                    if (this.d_followSelectionFilter != null) {
                        this.d_followSelectionFilter.updateVentusData(app.getData().selection, (DataNode.ResultsRoot)app.getData().getComponentData(ResultsDataComp.GUID));
                    }
                }
                if (!eventChannel.hasChangedObjs(VentusData.UNITSYSTEM_CHANGED)) continue;
                this.updateUnits(app.getUnitSystem());
            }
            for (EventChannel<VentusData> eventChannel : events.getChannels()) {
                if (!eventChannel.containsChange(VentusData.SELECTION_CHANGED) || this.d_followSelectionFilter == null || !this.d_followSelectionToggle.isSelected()) continue;
                this.d_tableFilters.sort();
            }
        }

        public Pair<Double, Double> getTimeRange() {
            return this.d_timeFilter.getTimeRange();
        }

        @Override
        public boolean update(IAnimSession session) {
            this.updateTimeFilter(session.get(IAnimSession.TIME), true);
            return true;
        }

        private String getFilterInfoDescription() {
            int displayedRows = this.d_table.getRowCount();
            int modelRows = this.d_tableModel.getUnfilteredModelCount();
            return String.format(Intl.intl("Showing %s of %s rows."), displayedRows, modelRows);
        }

        private void updateData(DataNode.ResultsRoot dataRoot) {
            this.d_resultsGroupCombo.setItems(dataRoot.flatten(DataNode.SimulationRoot.class));
            this.d_tableFilters.setRowFilter(null);
            Collection<DataNode.ZoneVisLeaf> dataToDisplay = dataRoot.flatten(DataNode.ZoneVisLeaf.class);
            this.d_table.clearRows();
            this.d_tableModel.clearData();
            this.d_tableModel.setNumRows(0);
            HashSet<Double> timesteps = new HashSet<Double>();
            TreeSet<String> concentrations = new TreeSet<String>();
            for (DataNode.ZoneVisLeaf leaf : dataToDisplay) {
                timesteps.addAll(Arrays.asList(ArrayUtils.toObject(leaf.getTimes())));
                concentrations.addAll(leaf.getConcentrationKeys());
            }
            this.updateTableAndModel(concentrations);
            this.d_tableModel.setDataObjects(dataToDisplay);
            this.d_timeFilter.setTimesteps(timesteps);
            this.updateFilters();
        }

        private void updateUnits(UnitSystem units) {
            this.d_timeUnit = units.getTime();
            this.d_tableModel.setUnitForCol(1, this.d_timeUnit);
            for (SelectionResultsTableUtil.LogicColumnFilterControl<DataNode.ZoneVisLeaf> control : this.d_columnControls) {
                control.updateUnit(units, this.d_tableModel, this.d_table);
            }
            this.d_tableModel.setColumnIdentifiers(this.generateColHeaders());
            this.d_tableModel.update();
            this.updateFilters();
        }

        public void clearFilters() {
            this.d_regexField.setValue("");
            this.updateRegexFilters(false);
            this.updateTimeFilter(0.0, false);
            for (SelectionResultsTableUtil.LogicColumnFilterControl<DataNode.ZoneVisLeaf> control : this.d_columnControls) {
                control.resetFilter();
            }
            this.d_followSelectionToggle.setSelected(false);
            this.d_resultsGroupCombo.setSelectedItem(null);
            this.updateSimRootFilter(false);
            this.updateFilters();
        }

        private void updateRegexFilters(boolean shouldUpdateAndFilter) {
            String sanitized = this.d_regexField.getText().trim();
            this.updateNameFilter(sanitized);
            this.updateTagFilter(sanitized);
            Set regexSet = Stream.of(this.d_regexNameFilter, this.d_regexTagFilter).filter(regFilter -> regFilter != null).collect(Collectors.toSet());
            this.d_regexOrFilter = regexSet.size() > 0 ? RowFilter.orFilter(regexSet) : null;
            if (shouldUpdateAndFilter) {
                this.updateFilters();
            }
        }

        private void updateNameFilter(String regexText) {
            RowFilter rf = null;
            try {
                rf = RowFilter.regexFilter(regexText, 2);
            }
            catch (PatternSyntaxException e) {
                System.err.println(e);
            }
            this.d_regexNameFilter = rf;
        }

        private void updateTagFilter(String regexText) {
            SelectionResultsTableUtil.TagFilter<DataNode.ZoneVisLeaf> rf = null;
            try {
                rf = new SelectionResultsTableUtil.TagFilter<DataNode.ZoneVisLeaf>(regexText, leaf -> {
                    Set<Object> set;
                    Object patt0$temp = leaf.getCorrespondingRoom();
                    if (patt0$temp instanceof SchematicRoom) {
                        SchematicRoom room = (SchematicRoom)patt0$temp;
                        set = room.getTags();
                    } else {
                        set = Collections.emptySet();
                    }
                    return set;
                });
            }
            catch (PatternSyntaxException e) {
                System.err.println(e);
            }
            this.d_regexTagFilter = rf;
        }

        private void updateSimRootFilter(boolean shouldUpdateAndFilter) {
            RowFilter rf = null;
            try {
                DataNode.SimulationRoot visibleGroup = (DataNode.SimulationRoot)this.d_resultsGroupCombo.getSelectedItem();
                if (visibleGroup != null) {
                    rf = RowFilter.regexFilter(visibleGroup.getName(), 0);
                }
            }
            catch (PatternSyntaxException e) {
                System.err.println(e);
            }
            this.d_groupFilter = rf;
            if (shouldUpdateAndFilter) {
                this.updateFilters();
            }
        }

        private void updateTimeFilter(double timestep, boolean shouldUpdateAndFilter) {
            if (this.d_timeFilter.setTimestep(timestep) && shouldUpdateAndFilter) {
                this.updateFilters();
            }
        }

        private void updateFilters() {
            ArrayList<RowFilter<guiDefaultTableModel, Integer>> filters = new ArrayList<RowFilter<guiDefaultTableModel, Integer>>();
            if (this.d_followTimeToggle.isSelected()) {
                filters.add(this.d_timeFilter);
            }
            if (this.d_regexOrFilter != null) {
                filters.add(this.d_regexOrFilter);
            }
            if (this.d_groupFilter != null) {
                filters.add(this.d_groupFilter);
            }
            for (SelectionResultsTableUtil.LogicColumnFilterControl<DataNode.ZoneVisLeaf> control : this.d_columnControls) {
                filters.add(control.buildFilter());
            }
            if (this.d_followSelectionToggle.isSelected()) {
                filters.add(this.d_followSelectionFilter);
            }
            this.d_tableFilters.setRowFilter(RowFilter.andFilter(filters));
            this.d_table.updateRowHeaders();
        }
    }

    private static class SetModelSelectionToTableZoneSelection
    extends AbstractCommand {
        private final leanGuiTable d_table;
        private final SelectionResultsTableUtil.ObjectBackedTableModel<DataNode.ZoneVisLeaf> d_model;

        public SetModelSelectionToTableZoneSelection(leanGuiTable table, SelectionResultsTableUtil.ObjectBackedTableModel<DataNode.ZoneVisLeaf> model) {
            super(Intl.intl("Select Highlighted Zones"), null);
            this.d_table = table;
            this.d_model = model;
        }

        @Override
        public void execute() {
            if (!this.isEnabled()) {
                return;
            }
            DataNode.ResultsRoot root = (DataNode.ResultsRoot)VentusApp.getApp().getData().getComponentData(ResultsDataComp.GUID);
            if (root == null) {
                return;
            }
            HashSet<Object> toSelect = new HashSet<Object>();
            for (int i : this.d_table.getSelectedRows()) {
                int modelIx = this.d_table.convertRowIndexToModel(i);
                DataNode.ZoneVisLeaf leafForRow = this.d_model.getSelectionAtModelIx(modelIx);
                Object potentialZone = root.getZoneForVisleaf(leafForRow);
                if (potentialZone == null) continue;
                toSelect.add(potentialZone);
            }
            Undo.begin(Intl.intl("Select Highlighted Zones"));
            VentusData vd = VentusApp.getAppData();
            Undo.insertUndoEntry_restoreSelection(vd);
            vd.selection.clear();
            vd.selection.selectAll(toSelect);
            Undo.end(vd);
        }
    }

    private static class ActiveZoneSelectionFilter
    extends RowFilter<guiDefaultTableModel, Integer> {
        private MerlinSelectionModel d_selection;
        private DataNode.ResultsRoot d_results;
        private HashMap<Object, Set<DataNode.ZoneVisLeaf>> d_zoneToLeaves;

        public ActiveZoneSelectionFilter(MerlinSelectionModel selection, DataNode.ResultsRoot resultsRoot) {
            this.d_selection = selection;
            this.d_results = resultsRoot;
        }

        public void updateVentusData(MerlinSelectionModel select, DataNode.ResultsRoot results) {
            this.d_selection = select;
            this.d_results = results;
            this.markDirty();
        }

        @Override
        public boolean include(RowFilter.Entry<? extends guiDefaultTableModel, ? extends Integer> value) {
            int rowIx = value.getIdentifier();
            SelectionResultsTableUtil.ObjectBackedTableModel model = (SelectionResultsTableUtil.ObjectBackedTableModel)value.getModel();
            DataNode.ZoneVisLeaf leaf = (DataNode.ZoneVisLeaf)model.getSelectionAtModelIx(rowIx);
            boolean explicitSelection = this.d_selection.getSelected(DataNode.ZoneVisLeaf.class).contains(leaf);
            return explicitSelection || this.getLeavesForPaths(this.d_selection.getSelected(SchematicRoom.class)).contains(leaf);
        }

        public void markDirty() {
            this.d_zoneToLeaves = null;
        }

        public Set<DataNode.ZoneVisLeaf> getLeavesForPaths(Collection<SchematicRoom> rooms) {
            return rooms.stream().flatMap(room -> this.getConnectedLeaves((SchematicRoom)room).stream()).collect(Collectors.toSet());
        }

        public Set<DataNode.ZoneVisLeaf> getConnectedLeaves(SchematicRoom room) {
            if (this.d_zoneToLeaves == null) {
                this.d_zoneToLeaves = new HashMap();
            }
            if (!this.d_zoneToLeaves.containsKey(room)) {
                this.d_zoneToLeaves.putIfAbsent(room, new HashSet());
                this.d_zoneToLeaves.get(room).addAll(this.d_results.getLeavesForZone(room));
            }
            return this.d_zoneToLeaves.get(room);
        }
    }
}

