/*
 * Decompiled with CFR 0.152.
 */
package ventus.feature.results;

import java.awt.Component;
import java.awt.Window;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.NavigableSet;
import java.util.Objects;
import java.util.Set;
import java.util.TreeSet;
import java.util.Vector;
import java.util.function.BiFunction;
import java.util.function.Function;
import javax.swing.AbstractButton;
import javax.swing.DefaultListCellRenderer;
import javax.swing.JList;
import javax.swing.RowFilter;
import javax.swing.RowSorter;
import javax.swing.SortOrder;
import javax.swing.table.TableModel;
import javax.swing.table.TableRowSorter;
import net.miginfocom.swing.MigLayout;
import org.jscience.physics.units.Unit;
import thunderheadeng.gui.AbstractCommand;
import thunderheadeng.gui.LinkStatus;
import thunderheadeng.gui.ValueField;
import thunderheadeng.gui.ValueFields;
import thunderheadeng.gui.guiCheckBox;
import thunderheadeng.gui.guiComboBox;
import thunderheadeng.gui.guiDialog;
import thunderheadeng.gui.table.guiDefaultTableModel;
import thunderheadeng.gui.table.leanGuiTable;
import thunderheadeng.units.UnitDouble;
import thunderheadeng.util.DoubleVR;
import thunderheadeng.util.Pair;
import ventus.Intl;
import ventus.VentusApp;
import ventus.actions.Undo;
import ventus.data.VentusData;
import ventus.feature.results.DataNode;
import ventus.feature.tags.Tag;
import ventus.feature.tags.TagsUtil;
import ventus.unitsystem.UnitSystem;

public abstract class SelectionResultsTableUtil {

    public static class SimRootCombobox
    extends guiComboBox<DataNode.SimulationRoot> {
        private static final long serialVersionUID = 1L;
        private String nullString = "";
        private boolean includeNull = false;

        public SimRootCombobox() {
            this.setRenderer(new DefaultListCellRenderer(){
                private static final long serialVersionUID = 1L;

                @Override
                public Component getListCellRendererComponent(JList<?> list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
                    super.getListCellRendererComponent(list, value, index, isSelected, cellHasFocus);
                    if (value == null) {
                        this.setText(nullString);
                    }
                    return this;
                }
            });
        }

        public void setNullString(String nullString) {
            this.nullString = nullString;
            this.includeNull = true;
            this.repaint();
        }

        @Override
        public void setItems(Vector<? extends DataNode.SimulationRoot> items) {
            if (this.includeNull && !items.contains(null)) {
                items.add(0, null);
            }
            super.setItems(items);
        }
    }

    public static class ObjectBackedTableModel<T>
    extends guiDefaultTableModel {
        static final long serialVersionUID = 1L;
        private final ArrayList<T> d_data = new ArrayList();
        private final ArrayList<T> d_dataExapnded = new ArrayList();
        private final Map<Integer, Function<T, List<Object>>> d_columnDataLoaders = new HashMap<Integer, Function<T, List<Object>>>();

        public ObjectBackedTableModel(int numCols) {
            super(0, numCols, true, Integer.MAX_VALUE, false, numCols);
        }

        public void clearColumnMappers() {
            this.d_columnDataLoaders.clear();
        }

        public void setColumnMapper(int col, Function<T, List<Object>> mapper) {
            this.d_columnDataLoaders.put(col, mapper);
        }

        public void clearData() {
            this.d_data.clear();
            this.d_dataExapnded.clear();
        }

        public void setDataObjects(Collection<T> objects) {
            int numCols = this.d_columnDataLoaders.size();
            int rowsPerObj = objects.isEmpty() ? 1 : this.d_columnDataLoaders.values().iterator().next().apply(objects.iterator().next()).size();
            int numRows = rowsPerObj * objects.size();
            Vector dataVector = new Vector(numRows);
            for (int i = 0; i < numRows; ++i) {
                Vector<Object> row = new Vector<Object>(numCols);
                for (int j = 0; j < numCols; ++j) {
                    row.add(null);
                }
                dataVector.add(row);
            }
            this.d_data.clear();
            this.d_data.addAll(objects);
            this.d_dataExapnded.clear();
            this.d_dataExapnded.ensureCapacity(numRows);
            for (T obj : objects) {
                int objStartRow;
                int objEndRow = objStartRow = this.d_dataExapnded.size();
                for (Map.Entry<Integer, Function<T, List<Object>>> kvPair : this.d_columnDataLoaders.entrySet()) {
                    List<Object> expandedCol = kvPair.getValue().apply(obj);
                    int row = objStartRow;
                    for (Object val : expandedCol) {
                        ((Vector)dataVector.get(row)).set(kvPair.getKey(), val);
                        ++row;
                    }
                    objEndRow = Math.max(row, objEndRow);
                }
                for (int i = objStartRow; i < objEndRow; ++i) {
                    this.d_dataExapnded.add(obj);
                }
            }
            Vector<String> columns = new Vector<String>(this.d_columnDataLoaders.size());
            for (int i = 0; i < this.d_columnDataLoaders.size(); ++i) {
                columns.add(this.getColumnName(i));
            }
            this.setDataVector(dataVector, columns);
        }

        public T getSelectionAtModelIx(int ix) {
            return this.d_dataExapnded.get(ix);
        }

        public int getUnfilteredModelCount() {
            return this.d_dataExapnded.size();
        }

        public void update() {
            ArrayList<T> data = new ArrayList<T>(this.d_data);
            this.d_data.clear();
            this.d_dataExapnded.clear();
            this.setDataObjects(data);
        }
    }

    public static interface UnitSensitiveTableModel
    extends TableModel {
        public Unit getUnitForCol(int var1);

        default public Object getUnitSystemSensitiveAt(Object rawVal, int col) {
            if (this.getColumnClass(col).equals(UnitDouble.class)) {
                return ((UnitDouble)rawVal).convert(this.getUnitForCol(col));
            }
            return rawVal;
        }
    }

    public static class UnitSensObjectBackedTableModel<T>
    extends ObjectBackedTableModel<T>
    implements UnitSensitiveTableModel {
        private static final long serialVersionUID = 1L;
        private final Map<Integer, Unit> d_currentColUnits = new HashMap<Integer, Unit>();

        public UnitSensObjectBackedTableModel(int numCols) {
            super(numCols);
        }

        public void setUnitForCol(int col, Unit newUnit) {
            this.d_currentColUnits.put(col, newUnit);
        }

        @Override
        public Unit getUnitForCol(int col) {
            return this.d_currentColUnits.get(col);
        }

        @Override
        public Object getValueAt(int row, int col) {
            Object rawObj = super.getValueAt(row, col);
            return this.getUnitSystemSensitiveAt(rawObj, col);
        }
    }

    public static class SortByColumnCommand
    extends AbstractCommand {
        public final int column;
        private final TableRowSorter<guiDefaultTableModel> sorter;

        public SortByColumnCommand(TableRowSorter<guiDefaultTableModel> sorter, int column, String desc) {
            super(desc, null);
            this.sorter = sorter;
            this.column = column;
        }

        @Override
        public void execute() {
            if (!this.isEnabled()) {
                return;
            }
            SortOrder oldOrder = this.sorter.getSortKeys().stream().filter(key -> key.getColumn() == this.column).map(key -> key.getSortOrder()).findFirst().orElse(SortOrder.UNSORTED);
            SortOrder newOrder = SortOrder.UNSORTED;
            if (oldOrder == SortOrder.DESCENDING) {
                newOrder = SortOrder.ASCENDING;
            } else if (oldOrder == SortOrder.ASCENDING) {
                newOrder = SortOrder.DESCENDING;
            } else if (oldOrder == SortOrder.UNSORTED) {
                newOrder = SortOrder.ASCENDING;
            }
            this.sorter.setSortKeys(Arrays.asList(new RowSorter.SortKey(this.column, newOrder)));
        }
    }

    public static class SetModelSelectionToResultSelection<T>
    extends AbstractCommand {
        private final leanGuiTable d_table;
        private final ObjectBackedTableModel<T> d_model;

        public SetModelSelectionToResultSelection(leanGuiTable table, ObjectBackedTableModel<T> model) {
            super(Intl.intl("Select Highlighted Results"), null);
            this.d_table = table;
            this.d_model = model;
        }

        @Override
        public void execute() {
            if (!this.isEnabled()) {
                return;
            }
            HashSet<T> toSelect = new HashSet<T>();
            for (int i : this.d_table.getSelectedRows()) {
                int modelIx = this.d_table.convertRowIndexToModel(i);
                T leafForRow = this.d_model.getSelectionAtModelIx(modelIx);
                toSelect.add(leafForRow);
            }
            Undo.begin(Intl.intl("Select Highlighted Results"));
            VentusData vd = VentusApp.getAppData();
            Undo.insertUndoEntry_restoreSelection(vd);
            vd.selection.clear();
            vd.selection.selectAll(toSelect);
            Undo.end(vd);
        }
    }

    public static class ClearSortComand
    extends AbstractCommand {
        private final TableRowSorter<guiDefaultTableModel> sorter;

        public ClearSortComand(TableRowSorter<guiDefaultTableModel> sorter) {
            super(Intl.intl("Reset Sort"), null);
            this.sorter = sorter;
        }

        @Override
        public void execute() {
            if (!this.isEnabled()) {
                return;
            }
            this.sorter.setSortKeys(new ArrayList());
        }
    }

    public static class TimeFilter
    extends RowFilter<guiDefaultTableModel, Integer> {
        private final int d_timeColumn;
        private final NavigableSet<Double> d_timesteps = new TreeSet<Double>();
        private Double d_currentTimestep = 0.0;

        public TimeFilter(int timeColumn) {
            this.d_timeColumn = timeColumn;
        }

        public boolean setTimestep(double timestep) {
            Double target = this.d_timesteps.floor(timestep);
            if (target == null && !this.d_timesteps.isEmpty()) {
                target = (Double)this.d_timesteps.getFirst();
            }
            if (!Objects.equals(this.d_currentTimestep, target)) {
                this.d_currentTimestep = target;
                return true;
            }
            return false;
        }

        public void setTimesteps(Set<Double> timesteps) {
            this.d_timesteps.clear();
            if (!timesteps.isEmpty()) {
                this.d_timesteps.addAll(timesteps);
            } else {
                this.d_timesteps.add(0.0);
            }
            this.d_currentTimestep = this.d_currentTimestep != null ? this.d_timesteps.floor(this.d_currentTimestep) : (Double)this.d_timesteps.getFirst();
        }

        public Pair<Double, Double> getTimeRange() {
            return new Pair<Double, Double>((Double)this.d_timesteps.getFirst(), (Double)this.d_timesteps.getLast());
        }

        @Override
        public boolean include(RowFilter.Entry<? extends guiDefaultTableModel, ? extends Integer> value) {
            try {
                int count = value.getValueCount();
                if (this.d_timeColumn < count && Objects.equals(value.getValue(this.d_timeColumn), this.d_currentTimestep)) {
                    return true;
                }
            }
            catch (Exception e) {
                return false;
            }
            return false;
        }
    }

    public static class SetNumericFilterWindow<T>
    extends guiDialog {
        private static final long serialVersionUID = 1L;
        private final List<LogicColumnFilterControl<T>> d_controls;
        private final List<guiCheckBox> d_enableCBs;
        private final List<guiComboBox<LogicOp>> d_filterLogicChoosers;
        private final List<ValueField<UnitDouble>> d_filterValueFields;

        public SetNumericFilterWindow(Window parent, List<LogicColumnFilterControl<T>> controls) {
            super(parent, Intl.intl("Edit Filters"), 9);
            this.getDialogPane().setLayout(new MigLayout(""));
            this.d_controls = controls;
            this.d_enableCBs = new ArrayList<guiCheckBox>(controls.size());
            this.d_filterLogicChoosers = new ArrayList<guiComboBox<LogicOp>>(controls.size());
            this.d_filterValueFields = new ArrayList<ValueField<UnitDouble>>(controls.size());
            for (LogicColumnFilterControl<T> control : controls) {
                guiCheckBox enableCB = new guiCheckBox(control.d_filterFieldPrefix);
                guiComboBox<LogicOp> logicOpChooser = new guiComboBox<LogicOp>(LogicOp.greaterThan, LogicOp.greaterThanEqual, LogicOp.lessThan, LogicOp.lessThanEqual);
                ValueField<UnitDouble> valueField = ValueFields.udFld(DoubleVR.UNBOUNDED, control.d_unit);
                LinkStatus.link((AbstractButton)enableCB, logicOpChooser, valueField);
                this.d_enableCBs.add(enableCB);
                this.d_filterLogicChoosers.add(logicOpChooser);
                this.d_filterValueFields.add(valueField);
                this.getDialogPane().add(enableCB);
                this.getDialogPane().add(logicOpChooser, "grow");
                this.getDialogPane().add(valueField, "wrap");
            }
        }

        public void loadFilters() {
            for (int i = 0; i < this.d_controls.size(); ++i) {
                LogicColumnFilterControl<T> control = this.d_controls.get(i);
                this.d_enableCBs.get(i).setSelected(!control.d_logicOp.equals((Object)LogicOp.noOp));
                this.d_filterLogicChoosers.get(i).setSelectedItem((Object)control.d_logicOp);
                if (!control.d_logicOp.equals((Object)LogicOp.noOp)) {
                    this.d_filterValueFields.get(i).setValue(new UnitDouble(0.0, control.d_unit));
                    continue;
                }
                this.d_filterValueFields.get(i).setValue(control.d_filterValue);
            }
        }

        public void updateFilters() {
            for (int i = 0; i < this.d_controls.size(); ++i) {
                LogicColumnFilterControl<T> control = this.d_controls.get(i);
                if (this.d_enableCBs.get(i).isSelected()) {
                    control.updateFilter(this.d_filterLogicChoosers.get(i).getSelectedItem(), (UnitDouble)this.d_filterValueFields.get(i).getValue());
                    continue;
                }
                control.resetFilter();
            }
        }
    }

    public static class LogicColumnFilterControl<T> {
        private final int d_columnIndex;
        private final Function<T, List<Object>> d_columnMapper;
        private final Function<Unit, String> d_getHeader;
        private final String d_columnTooltip;
        private final String d_sortCommandName;
        private final String d_filterFieldPrefix;
        private Unit d_unit;
        private final Function<UnitSystem, Unit> d_getUnit;
        private UnitDouble d_filterValue;
        private LogicOp d_logicOp;

        public LogicColumnFilterControl(int columnIndex, Function<LogicColumnFilterControl<T>, Function<T, List<Object>>> columnMapper, Unit defaultUnit, Function<UnitSystem, Unit> getUnit, Function<Unit, String> getHeader, String tooltip, String sortCommand, String filterFieldPrefix) {
            this.d_columnIndex = columnIndex;
            this.d_getHeader = getHeader;
            this.d_columnTooltip = tooltip;
            this.d_sortCommandName = sortCommand;
            this.d_filterFieldPrefix = filterFieldPrefix;
            this.d_unit = defaultUnit;
            this.d_getUnit = getUnit;
            this.d_filterValue = new UnitDouble(0.0, this.d_unit);
            this.d_logicOp = LogicOp.noOp;
            this.d_columnMapper = columnMapper.apply(this);
        }

        public int getColIx() {
            return this.d_columnIndex;
        }

        public String getColHeader() {
            return this.d_getHeader.apply(this.d_unit);
        }

        public String getColTooltip() {
            return this.d_columnTooltip;
        }

        public Class getColClass() {
            return Double.class;
        }

        public Unit getUnit() {
            return this.d_unit;
        }

        public void addColumnMapper(UnitSensObjectBackedTableModel<T> model) {
            model.setColumnMapper(this.d_columnIndex, this.d_columnMapper);
            model.setUnitForCol(this.d_columnIndex, this.d_unit);
        }

        public void updateFilter(LogicOp op, UnitDouble value) {
            this.d_logicOp = op;
            this.d_filterValue = value;
        }

        public void resetFilter() {
            this.d_logicOp = LogicOp.noOp;
        }

        public RowFilter<guiDefaultTableModel, Integer> buildFilter() {
            try {
                return new LogicCompareFilter(this.d_filterValue.get(this.d_unit), this.d_logicOp.compare, this.d_columnIndex);
            }
            catch (Exception e) {
                System.err.println(e);
                return null;
            }
        }

        public SortByColumnCommand buildSortCommand(TableRowSorter<guiDefaultTableModel> sorter) {
            return new SortByColumnCommand(sorter, this.d_columnIndex, this.d_sortCommandName);
        }

        public void updateUnit(UnitSystem usys, UnitSensObjectBackedTableModel<T> model, leanGuiTable table) {
            this.d_unit = this.d_getUnit.apply(usys);
            model.setUnitForCol(this.d_columnIndex, this.d_unit);
        }
    }

    public static class LogicCompareFilter
    extends RowFilter<guiDefaultTableModel, Integer> {
        private final int[] columns;
        private final Double testAgainstVal;
        private final BiFunction<Double, Double, Boolean> logicTest;

        public LogicCompareFilter(Double testAgainstVal, BiFunction<Double, Double, Boolean> logicTest, int ... columnIxs) {
            this.columns = columnIxs;
            this.testAgainstVal = testAgainstVal;
            this.logicTest = logicTest;
        }

        @Override
        public boolean include(RowFilter.Entry<? extends guiDefaultTableModel, ? extends Integer> value) {
            int count = value.getValueCount();
            if (this.columns.length > 0) {
                for (int i = this.columns.length - 1; i >= 0; --i) {
                    int index = this.columns[i];
                    if (index >= count || !this.include(value, index)) continue;
                    return true;
                }
            } else {
                while (--count >= 0) {
                    if (!this.include(value, count)) continue;
                    return true;
                }
            }
            return false;
        }

        protected boolean include(RowFilter.Entry<? extends guiDefaultTableModel, ? extends Integer> value, int index) {
            try {
                Double testVal = (Double)value.getValue(index);
                return this.logicTest.apply(testVal, this.testAgainstVal);
            }
            catch (Exception e) {
                return false;
            }
        }
    }

    public static class TagFilter<T>
    extends RowFilter<guiDefaultTableModel, Integer> {
        private final String[] searchTokens;
        private final Function<T, Set<Tag>> getTags;

        public TagFilter(String userInput, Function<T, Set<Tag>> getTags) {
            this.searchTokens = userInput.toLowerCase().split(" ");
            this.getTags = getTags;
        }

        @Override
        public boolean include(RowFilter.Entry<? extends guiDefaultTableModel, ? extends Integer> entry) {
            int rowIx = entry.getIdentifier();
            ObjectBackedTableModel model = (ObjectBackedTableModel)entry.getModel();
            Object leaf = model.getSelectionAtModelIx(rowIx);
            String tags = TagsUtil.formatTags(this.getTags.apply(leaf));
            return Arrays.stream(this.searchTokens).anyMatch(specifiedTag -> tags.contains((CharSequence)specifiedTag));
        }
    }

    public static enum LogicOp {
        greaterThan(">", (doesThisMeetCondition, comparedToThis) -> doesThisMeetCondition > comparedToThis),
        lessThan("<", (doesThisMeetCondition, comparedToThis) -> doesThisMeetCondition < comparedToThis),
        greaterThanEqual(">=", (doesThisMeetCondition, comparedToThis) -> doesThisMeetCondition >= comparedToThis),
        lessThanEqual("<=", (doesThisMeetCondition, comparedToThis) -> doesThisMeetCondition <= comparedToThis),
        equal("=", (doesThisMeetCondition, comparedToThis) -> doesThisMeetCondition == comparedToThis),
        noOp("No op", (o1, o2) -> true);

        public final String dispName;
        public final BiFunction<Double, Double, Boolean> compare;

        private LogicOp(String name, BiFunction<Double, Double, Boolean> op) {
            this.dispName = name;
            this.compare = op;
        }

        public String toString() {
            return this.dispName;
        }
    }
}

