/*
 * Decompiled with CFR 0.152.
 */
package ventus.feature.results;

import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import thunderheadeng.gui.IDomainObject;
import thunderheadeng.util.Events;
import thunderheadeng.util.IEventObserver;
import thunderheadeng.util.IEventRecord;
import ventus.VentusApp;
import ventus.actions.AMerlinOp;
import ventus.actions.UIHook;
import ventus.data.IMerlinObj;
import ventus.data.VentusData;
import ventus.feature.VentusEvents;
import ventus.feature.results.DataNode;
import ventus.feature.results.DataNodeAnimator;
import ventus.feature.results.ResultsDataComp;

public class ResultsModelChangeObserver
implements IEventObserver {
    private static final Collection<Object> s_ignoreFilters = new HashSet<Object>();

    @Override
    public void update(Events events) {
        boolean isStale;
        IEventRecord<IDomainObject> domainRecord = events.getEvents(IDomainObject.class, new Class[0]);
        if (domainRecord.containsChange(VentusData.MODEL_RESET) || domainRecord.containsChange(VentusData.MODEL_LOADED) || domainRecord.containsChange(VentusData.MODEL_SAVED)) {
            return;
        }
        boolean canIgnore = domainRecord.areChangesExclusiveTo(s_ignoreFilters.toArray());
        if (canIgnore) {
            return;
        }
        IEventRecord<IMerlinObj> eventRecord = events.getEvents(IMerlinObj.class, DataNode.class);
        if (eventRecord.containsChange(VentusEvents.SimulationComplete.class)) {
            return;
        }
        boolean bl = isStale = eventRecord.hasChangedObjs() || eventRecord.hasAddedObjs() || eventRecord.hasRemovedObjs();
        if (isStale) {
            MarkStaleOp op = new MarkStaleOp(true);
            UIHook.run(null, op.getName(), op, 4);
        }
    }

    static {
        s_ignoreFilters.addAll(Arrays.asList(VentusData.SELECTION_CHANGED, VentusData.PREFS_CHANGED, VentusData.VISIBILITY, DataNodeAnimator.ANIMATION_CHANGED));
    }

    private static class MarkStaleOp
    extends AMerlinOp {
        private final boolean stale;

        public MarkStaleOp(boolean stale) {
            this.stale = stale;
        }

        public String getName() {
            return String.valueOf(this.getClass()) + "::" + (this.stale ? "stale" : "fresh");
        }

        @Override
        public void run(VentusApp ventusApp, VentusData ventusData) {
            DataNode.ResultsRoot root = (DataNode.ResultsRoot)ventusData.getComponentData(ResultsDataComp.GUID);
            Collection<DataNode.VisLeaf> visLeaves = root.flatten(DataNode.VisLeaf.class);
            for (DataNode.VisLeaf visLeaf : visLeaves) {
                visLeaf.setStale(this.stale);
            }
        }
    }
}

