/*
 * Decompiled with CFR 0.152.
 */
package ventus.feature.props;

import java.util.EnumSet;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.logging.Level;
import java.util.logging.Logger;
import thunderheadeng.dependencies.DLink;
import thunderheadeng.dependencies.DepList;
import thunderheadeng.util.IPropertySet;
import thunderheadeng.util.LinkedIdentityHashMap;
import thunderheadeng.util.Nullable;
import thunderheadeng.util.TypedProp;
import thunderheadeng.util.theUtil;
import ventus.data.IMerlinObj;

public class TypedPropSet<ObjT extends IMerlinObj> {
    private static final Logger LOGGER = Logger.getLogger(TypedPropSet.class.getSimpleName());
    private final Map<TypedProp<?>, PropInfo<ObjT, ?>> d_props = new LinkedIdentityHashMap();

    public void addFrom(Class<?> owner) {
        theUtil.getAllDeclaredPublicStaticMembers(owner, TypedProp.class).forEach((? super T x$0) -> this.add((TypedProp)x$0, new Options[0]));
    }

    public <T> TypedProp<T> add(Object key, T defVal, Options ... options) {
        return this.add(new TypedProp<T>(key, defVal), options);
    }

    public <T> TypedProp<T> add(Object key, Class<T> type, Options ... options) {
        return this.add(new TypedProp<T>(key, type), options);
    }

    public <T> TypedProp<T> add(TypedProp<T> prop, Options ... options) {
        return this.add(prop, (Function<ObjT, T>)null, (BiConsumer<ObjT, T>)null, options);
    }

    public <T> TypedProp<T> add(TypedProp<T> prop, Function<ObjT, T> getter, Options ... options) {
        return this.add(prop, getter, (BiConsumer<ObjT, T>)null, options);
    }

    public <T> TypedProp<T> add(TypedProp<T> prop, BiConsumer<ObjT, T> setter, Options ... options) {
        return this.add(prop, null, setter, options);
    }

    public <T> TypedProp<T> add(TypedProp<T> prop, Function<ObjT, T> getter, BiConsumer<ObjT, T> setter, Options ... options) {
        return this.add(prop, getter, setter, theUtil.toEnumSet(Options.class, (Enum[])options));
    }

    public <T> TypedProp<T> add(TypedProp<T> prop, Function<ObjT, T> getter, BiConsumer<ObjT, T> setter, EnumSet<Options> options) {
        if (getter == null && setter == null && IMerlinObj.class.isAssignableFrom(prop.type) && options.stream().noneMatch(o -> o.link != null)) {
            LOGGER.log(Level.WARNING, () -> String.format("High-level object property added to %s without specifying a dependency option. Double-check options. Property: id=%s, type=%s", this.getClass().getSimpleName(), prop.key, prop.type.getSimpleName()));
        }
        this.d_props.put(prop, new PropInfo<ObjT, T>(getter, setter, options));
        return prop;
    }

    public <T> TypedProp<T> add(Object key, T defValue, PropInfo<ObjT, T> info) {
        return this.add(new TypedProp<T>(key, defValue), info);
    }

    public <T> TypedProp<T> add(Object key, Class<T> valType, PropInfo<ObjT, T> info) {
        return this.add(new TypedProp<T>(key, valType), info);
    }

    public <T> TypedProp<T> add(TypedProp<T> prop, PropInfo<ObjT, T> info) {
        this.d_props.put(prop, info);
        return prop;
    }

    public <T> boolean has(Object key) {
        return this.d_props.containsKey(key);
    }

    public TypedProp<?> get(Object key) {
        if (!this.has(key)) {
            return null;
        }
        return (TypedProp)key;
    }

    public <T> TypedProp<T> getStrict(Object key, T type) {
        TypedProp<?> prop = this.get(key);
        if (prop == null) {
            return null;
        }
        if (type != null && !prop.type.isAssignableFrom(type.getClass())) {
            return null;
        }
        return prop;
    }

    public Set<Object> keys() {
        return theUtil.map(this.d_props.keySet(), o -> o);
    }

    public Set<TypedProp<?>> props() {
        return this.d_props.keySet();
    }

    public <T> boolean setValue(ObjT obj, IPropertySet serializedProps, IPropertySet transientProps, TypedProp<T> prop, T value) {
        IPropertySet props;
        PropInfo<ObjT, ?> info = this.d_props.get(prop);
        if (info == null) {
            return false;
        }
        if (info.setter != null) {
            info.setter.accept(obj, value);
            return true;
        }
        IPropertySet iPropertySet = props = !info.test(Options.TRANSIENT) ? serializedProps : transientProps;
        if (props == null) {
            return false;
        }
        TypedPropSet.compareAndSet(obj, props, prop, value);
        return true;
    }

    public <T> Optional<Nullable<T>> getValue(ObjT obj, IPropertySet serializedProps, IPropertySet transientProps, TypedProp<T> prop) {
        IPropertySet props;
        PropInfo<ObjT, ?> info = this.d_props.get(prop);
        if (info == null) {
            return Optional.empty();
        }
        if (info.getter != null) {
            return Optional.of(Nullable.of(info.getter.apply(obj)));
        }
        IPropertySet iPropertySet = props = !info.test(Options.TRANSIENT) ? serializedProps : transientProps;
        if (props == null) {
            return Optional.empty();
        }
        return Optional.of(Nullable.of(props.get(prop)));
    }

    public <T> Optional<BiConsumer<ObjT, T>> setter(Object prop) {
        Optional<PropInfo<ObjT, T>> info = this.getInfo(prop);
        if (info.isEmpty()) {
            return Optional.empty();
        }
        return Optional.ofNullable(info.get().setter);
    }

    public <T> Optional<Function<ObjT, T>> getter(Object prop) {
        Optional<PropInfo<ObjT, T>> info = this.getInfo(prop);
        if (info.isEmpty()) {
            return Optional.empty();
        }
        return Optional.ofNullable(info.get().getter);
    }

    public <T> Optional<Boolean> isSerialized(Object prop) {
        Optional<PropInfo<ObjT, PropInfo>> info = this.getInfo(prop);
        return info.map(pi -> !pi.test(Options.TRANSIENT));
    }

    public <T> Optional<PropInfo<ObjT, T>> getInfo(Object prop) {
        TypedProp<?> tprop = this.get(prop);
        if (tprop == null) {
            return Optional.empty();
        }
        PropInfo<ObjT, ?> info = this.d_props.get(tprop);
        return Optional.ofNullable(info);
    }

    public void forEach(Consumer<? super TypedProp<?>> consumer) {
        this.d_props.keySet().forEach(consumer);
    }

    private static <T> boolean compareAndSet(IMerlinObj obj, IPropertySet props, TypedProp<T> prop, T value) {
        T existing = props.get(prop);
        if (!Objects.equals(existing, value)) {
            props.setIfNotDefault(prop, value);
            obj.changedEvt(prop);
            return true;
        }
        return false;
    }

    public <T> boolean compareAndSetDirect(IMerlinObj obj, IPropertySet serializedProps, IPropertySet transientProps, TypedProp<T> prop, T value) {
        IPropertySet props;
        PropInfo<ObjT, ?> info = this.d_props.get(prop);
        if (info == null) {
            return false;
        }
        IPropertySet iPropertySet = props = !info.test(Options.TRANSIENT) ? serializedProps : transientProps;
        assert (props != null);
        return TypedPropSet.compareAndSet(obj, props, prop, value);
    }

    public void restoreFrom(IMerlinObj obj, IPropertySet serializedTo, IPropertySet serializedFrom, IPropertySet transientTo, IPropertySet transientFrom) {
        BiConsumer<IPropertySet, IPropertySet> restore = (to, from) -> this.d_props.entrySet().stream().filter(e -> !((PropInfo)e.getValue()).test(Options.NO_RESTORE)).map(e -> (TypedProp)e.getKey()).filter(e -> to.isDefined(e) || from.isDefined(e)).forEach((? super T e) -> TypedPropSet.compareAndSet(obj, to, e, from.get(e)));
        obj.pauseUpdates();
        restore.accept(serializedTo, serializedFrom);
        if (transientTo != null && transientFrom != null) {
            restore.accept(transientTo, transientFrom);
        }
        obj.resumeUpdates();
    }

    public void takeDepSnapshot(ObjT obj, IPropertySet serializedProps, IPropertySet transientProps, DepList deps) {
        this.d_props.entrySet().stream().filter(e -> ((PropInfo)e.getValue()).getLink().isPresent()).forEach((? super T e) -> {
            DLink link = ((PropInfo)e.getValue()).getLink().get();
            Optional val = this.getValue(obj, serializedProps, transientProps, (TypedProp)e.getKey());
            if (val.isPresent()) {
                deps.add(link, val.get().val);
            }
        });
    }

    public void replaceDependency(ObjT obj, IPropertySet serializedProps, IPropertySet transientProps, Object old, Object replacement) {
        this.d_props.entrySet().stream().filter(e -> ((PropInfo)e.getValue()).getLink().isPresent()).map(e -> (TypedProp)e.getKey()).filter(prop -> {
            Optional oval = this.getValue(obj, serializedProps, transientProps, (TypedProp)prop);
            return oval.isPresent() && oval.get().val == old && (replacement == null || prop.type.isInstance(replacement));
        }).forEach((? super T prop) -> this.setValue(obj, serializedProps, transientProps, (TypedProp)prop, prop.type.cast(replacement)));
    }

    public static enum Options {
        TRANSIENT(null),
        NO_RESTORE(null),
        REQUIRED_DEPENDENT(DLink.REQUIRED),
        STRONG_DEPENDENT(DLink.STRONG),
        WEAK_DEPENDENT(DLink.WEAK);

        public final DLink link;

        private Options(DLink link) {
            this.link = link;
        }
    }

    public static class PropInfo<ParentType, PropType> {
        public final BiConsumer<ParentType, PropType> setter;
        public final Function<ParentType, PropType> getter;
        public final EnumSet<Options> options;

        public PropInfo(Function<ParentType, PropType> getter, BiConsumer<ParentType, PropType> setter, EnumSet<Options> options) {
            this.setter = setter;
            this.getter = getter;
            this.options = options;
        }

        public Optional<DLink> getLink() {
            return this.options.stream().filter(o -> o.link != null).findFirst().map(o -> o.link);
        }

        public boolean test(Options option) {
            return this.options.contains((Object)option);
        }

        public String toString() {
            StringBuilder sb = new StringBuilder();
            if (this.getter != null) {
                sb.append("getter");
            }
            if (this.setter != null) {
                if (sb.length() != 0) {
                    sb.append("\\");
                }
                sb.append("setter");
            }
            if (sb.length() == 0) {
                return "none";
            }
            return sb.toString();
        }
    }
}

